/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.mobility.antext.preprocessor.PreprocessorException;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.mobility.editor.ConfigurationHighlightsLayerFactory;
import org.netbeans.modules.mobility.editor.hints.DisableHint;
import org.netbeans.modules.mobility.editor.hints.InlineIncludeHint;
import org.netbeans.modules.mobility.editor.hints.ReplaceOldSyntaxHint;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.bridge.J2MEProjectUtilitiesProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentPreprocessor
implements PropertyChangeListener {
    public static final String PREPROCESSOR_LINE_LIST = "preprocessor.line.list";
    static final long serialVersionUID = 4863325941230276217L;
    static final Pattern BLOCK_HEADER_PATTERN = Pattern.compile("^\\s*/((/#)|(\\*[\\$#]))\\S");
    DocumentListener dl;
    Timer timer = new Timer();
    TimerTask timerTask = null;

    public DocumentPreprocessor() {
        this.dl = new DL();
        JTextComponent jTextComponent = EditorRegistry.focusedComponent();
        if (jTextComponent != null) {
            DocumentPreprocessor.updateBlockChain((NbEditorDocument)jTextComponent.getDocument());
            final NbEditorDocument nbEditorDocument = (NbEditorDocument)jTextComponent.getDocument();
            nbEditorDocument.addDocumentListener(this.dl);
            nbEditorDocument.getDocumentProperties().put("TEXT_SWITCH_SUPPORT", new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    DocumentPreprocessor.updateBlockChain(nbEditorDocument);
                }
            });
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent;
        JTextComponent jTextComponent2 = EditorRegistry.lastFocusedComponent();
        if (jTextComponent2 != null) {
            jTextComponent = (NbEditorDocument)jTextComponent2.getDocument();
            jTextComponent.getDocumentProperties().remove("TEXT_SWITCH_SUPPORT");
            jTextComponent.removeDocumentListener(this.dl);
        }
        if ((jTextComponent = EditorRegistry.focusedComponent()) != null) {
            NbEditorDocument nbEditorDocument = (NbEditorDocument)jTextComponent.getDocument();
            nbEditorDocument.addDocumentListener(this.dl);
            nbEditorDocument.getDocumentProperties().put("TEXT_SWITCH_SUPPORT", new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    DocumentPreprocessor.this.restartTimer();
                }
            });
            this.restartTimer();
        }
    }

    static final void setLineList(NbEditorDocument nbEditorDocument, ArrayList<PPLine> arrayList) {
        ConfigurationHighlightsLayerFactory.Highlighting highlighting;
        nbEditorDocument.putProperty((Object)PREPROCESSOR_LINE_LIST, arrayList);
        ConfigurationHighlightsLayerFactory.Highlighting highlighting2 = (ConfigurationHighlightsLayerFactory.Highlighting)nbEditorDocument.getProperty((Object)ConfigurationHighlightsLayerFactory.PROP_HIGLIGHT_HEADER_LAYER);
        if (highlighting2 != null) {
            highlighting2.updateBags();
        }
        if ((highlighting = (ConfigurationHighlightsLayerFactory.Highlighting)nbEditorDocument.getProperty((Object)ConfigurationHighlightsLayerFactory.PROP_HIGLIGHT_BLOCKS_LAYER)) != null) {
            highlighting.updateBags();
        }
        DocumentPreprocessor.processAnnotations(nbEditorDocument, arrayList);
    }

    void restartTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new TimerTask(){

            public void run() {
                JTextComponent jTextComponent = EditorRegistry.focusedComponent();
                if (jTextComponent != null) {
                    DocumentPreprocessor.updateBlockChain((NbEditorDocument)jTextComponent.getDocument());
                }
            }
        };
        this.timer.schedule(this.timerTask, 200L);
    }

    public static final void updateBlockChain(NbEditorDocument nbEditorDocument) {
        if (nbEditorDocument == null) {
            return;
        }
        Project project = J2MEProjectUtils.getProjectForDocument((Document)nbEditorDocument);
        if (project != null && project instanceof J2MEProject) {
            ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
            if (projectConfigurationsHelper == null || !projectConfigurationsHelper.isPreprocessorOn()) {
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(projectConfigurationsHelper.getActiveAbilities());
            hashMap.put(projectConfigurationsHelper.getActiveConfiguration().getDisplayName(), null);
            try {
                J2MEProjectUtilitiesProvider j2MEProjectUtilitiesProvider = (J2MEProjectUtilitiesProvider)Lookup.getDefault().lookup(J2MEProjectUtilitiesProvider.class);
                if (j2MEProjectUtilitiesProvider == null) {
                    return;
                }
                CommentingPreProcessor commentingPreProcessor = new CommentingPreProcessor(j2MEProjectUtilitiesProvider.createPPDocumentSource((StyledDocument)nbEditorDocument), null, hashMap);
                commentingPreProcessor.run();
                DocumentPreprocessor.setLineList(nbEditorDocument, commentingPreProcessor.getLines());
            }
            catch (PreprocessorException preprocessorException) {
                ErrorManager.getDefault().notify((Throwable)preprocessorException);
            }
        }
    }

    static String prefixPropertyName(String string, String string2) {
        return "configs." + string + '.' + string2;
    }

    static void processAnnotations(NbEditorDocument nbEditorDocument, ArrayList<PPLine> arrayList) {
        ArrayList<ErrorDescription> arrayList2 = new ArrayList<ErrorDescription>();
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)nbEditorDocument);
        FileObject fileObject = dataObject == null ? null : dataObject.getPrimaryFile();
        for (PPLine pPLine : arrayList) {
            PPToken pPToken;
            for (PPLine.Error error : pPLine.getErrors()) {
                pPToken = error.token;
                int n = pPToken.getType() == 257 || pPToken.getType() == 258 || pPToken.getType() == 300 ? Math.max(1, pPToken.getPadding().length()) : 0;
                int n2 = NbDocument.findLineOffset((StyledDocument)nbEditorDocument, (int)(pPLine.getLineNumber() - 1));
                arrayList2.add(ErrorDescriptionFactory.createErrorDescription((Severity)(error.warning ? Severity.WARNING : Severity.ERROR), (String)error.message, (FileObject)fileObject, (int)(n2 + pPToken.getColumn() - n), (int)(n2 + pPToken.getColumn() + pPToken.getText().length())));
            }
            ArrayList arrayList3 = new ArrayList();
            int n = Utilities.getRowStartFromLineOffset((BaseDocument)nbEditorDocument, (int)(pPLine.getLineNumber() - 1));
            if (pPLine.getTokens().size() > 1 && "//#include".equals(((PPToken)pPLine.getTokens().get(0)).getText())) {
                arrayList3.add(new InlineIncludeHint((BaseDocument)nbEditorDocument, n, ((PPToken)pPLine.getTokens().get(1)).getText()));
            } else if (pPLine.getType() == 13 || pPLine.getType() == 14) {
                for (pPToken = pPLine.getBlock(); pPToken != null && pPToken.getType() != 13; pPToken = pPToken.getParent()) {
                }
                if (pPToken != null) {
                    arrayList3.add(new ReplaceOldSyntaxHint((Document)nbEditorDocument, arrayList, (PPBlockInfo)pPToken));
                }
            }
            if (pPLine.getType() == -1) {
                arrayList3.add(new DisableHint((BaseDocument)nbEditorDocument, n));
            }
            if (arrayList3.size() <= 0) continue;
            arrayList2.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)NbBundle.getMessage(DocumentPreprocessor.class, (String)"LBL_PreprocessorHint"), (List)arrayList3, (Document)nbEditorDocument, (int)pPLine.getLineNumber()));
        }
        HintsController.setErrors((Document)nbEditorDocument, (String)"preprocessor-errors", arrayList2);
    }

    class DL
    implements DocumentListener {
        DL() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DocumentPreprocessor.this.restartTimer();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DocumentPreprocessor.this.restartTimer();
        }
    }
}

