/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsToggleButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class UIUtils {
    private static final float ALTERNATE_ROW_DARKER_FACTOR = 0.96f;
    private static final float BRDER_LINE_DARKER_FACTOR = 0.65f;
    private static Color unfocusedSelBg;
    private static Color unfocusedSelFg;
    public static final Color TABLE_VERTICAL_GRID_COLOR;
    public static final Color TABLE_SELECTION_BACKGROUND_COLOR;
    public static final Color TABLE_SELECTION_FOREGROUND_COLOR;

    private UIUtils() {
    }

    static Color getProfilerResultsBackground() {
        return Color.WHITE;
    }

    public static Color getDarker(Color color) {
        if (color.equals(Color.WHITE)) {
            return new Color(244, 244, 244);
        }
        return UIUtils.getDarker(color, 0.96f);
    }

    public static Color getDarker(Color color, float f) {
        return UIUtils.getSafeColor((int)((float)color.getRed() * f), (int)((float)color.getGreen() * f), (int)((float)color.getBlue() * f));
    }

    public static Color getDarkerLine(Color color) {
        return UIUtils.getSafeColor((int)((float)color.getRed() * 0.65f), (int)((float)color.getGreen() * 0.65f), (int)((float)color.getBlue() * 0.65f));
    }

    public static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!Color.WHITE.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    public static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    public static Color getSafeColor(int n, int n2, int n3) {
        n = Math.max(n, 0);
        n = Math.min(n, 255);
        n2 = Math.max(n2, 0);
        n2 = Math.min(n2, 255);
        n3 = Math.max(n3, 0);
        n3 = Math.min(n3, 255);
        return new Color(n, n2, n3);
    }

    public static void runInEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static void fixButtonUI(AbstractButton abstractButton) {
        if (abstractButton.getUI() instanceof WindowsButtonUI) {
            abstractButton.setUI((ButtonUI)new WindowsButtonUI(){

                protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
                    return new BasicButtonListener(abstractButton);
                }

                protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
                    int n = abstractButton.getWidth();
                    int n2 = abstractButton.getHeight();
                    graphics.setColor(this.getFocusColor());
                    BasicGraphicsUtils.drawDashedRect(graphics, this.dashedRectGapX, this.dashedRectGapY, n - this.dashedRectGapWidth, n2 - this.dashedRectGapHeight);
                }
            });
        } else if (abstractButton.getUI() instanceof WindowsToggleButtonUI) {
            abstractButton.setUI((ButtonUI)new WindowsToggleButtonUI(){

                protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
                    return new BasicButtonListener(abstractButton);
                }

                protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
                    int n = abstractButton.getWidth();
                    int n2 = abstractButton.getHeight();
                    graphics.setColor(this.getFocusColor());
                    BasicGraphicsUtils.drawDashedRect(graphics, dashedRectGapX, dashedRectGapY, n - dashedRectGapWidth, n2 - dashedRectGapHeight);
                }
            });
        }
    }

    public static boolean isGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("GTK");
    }

    public static boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Nimbus");
    }

    public static boolean isMotifLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Motif");
    }

    static {
        TABLE_VERTICAL_GRID_COLOR = new Color(214, 223, 247);
        TABLE_SELECTION_BACKGROUND_COLOR = new Color(193, 210, 238);
        TABLE_SELECTION_FOREGROUND_COLOR = Color.BLACK;
    }
}

