/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.support.DataModelSchemeProvider;
import org.netbeans.modules.dlight.api.visualizer.TableBasedVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.impl.TreeTableVisualizerConfigurationAccessor;
import org.netbeans.spi.viewmodel.NodeActionsProvider;

public class TreeTableVisualizerConfiguration
implements TableBasedVisualizerConfiguration {
    private DataTableMetadata dataTableMetadata;
    private DataTableMetadata.Column treeColumn;
    private DataTableMetadata.Column[] tableColumns;
    private boolean isPlainTable = false;
    private ColumnsUIMapping columnsUIMapping;
    private NodeActionsProvider nodeActionsProvider;

    private TreeTableVisualizerConfiguration(String string, DataTableMetadata.Column column, DataTableMetadata.Column[] columnArray) {
        this.treeColumn = column;
        this.tableColumns = columnArray;
        List<DataTableMetadata.Column> list = Arrays.asList(column);
        list.addAll(Arrays.asList(columnArray));
        this.dataTableMetadata = new DataTableMetadata(string, list, null);
    }

    public TreeTableVisualizerConfiguration(DataTableMetadata dataTableMetadata, String string) {
        this(dataTableMetadata, string, false);
    }

    public TreeTableVisualizerConfiguration(DataTableMetadata dataTableMetadata, String string, boolean bl) {
        this.setDataTableMetadata(dataTableMetadata, string);
        this.isPlainTable = bl;
    }

    protected TreeTableVisualizerConfiguration() {
    }

    private void setDataTableMetadata(DataTableMetadata dataTableMetadata, String string) {
        this.dataTableMetadata = dataTableMetadata;
        this.treeColumn = dataTableMetadata.getColumnByName(string);
        List list = dataTableMetadata.getColumns();
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>();
        for (DataTableMetadata.Column column : list) {
            if (column.getColumnName().equals(string)) continue;
            arrayList.add(column);
        }
        this.tableColumns = arrayList.toArray(new DataTableMetadata.Column[0]);
    }

    boolean isTableView() {
        return this.isPlainTable;
    }

    DataTableMetadata.Column[] getTableColumns() {
        return this.tableColumns;
    }

    DataTableMetadata.Column getTreeColumn() {
        return this.treeColumn;
    }

    NodeActionsProvider getNodeActionsProvider() {
        return this.nodeActionsProvider;
    }

    public void setNodeActionProvider(NodeActionsProvider nodeActionsProvider) {
        this.nodeActionsProvider = nodeActionsProvider;
    }

    public final void setColumnsUIMapping(ColumnsUIMapping columnsUIMapping) {
        this.columnsUIMapping = columnsUIMapping;
    }

    public DataTableMetadata getMetadata() {
        return this.dataTableMetadata;
    }

    public DataModelScheme getSupportedDataScheme() {
        return DataModelSchemeProvider.getInstance().getScheme("model:tree:table");
    }

    public String getID() {
        return "treeTable";
    }

    static {
        TreeTableVisualizerConfigurationAccessor.setDefault(new TreeTableVisualizerConfigurationAccessorImpl());
    }

    private static final class TreeTableVisualizerConfigurationAccessorImpl
    extends TreeTableVisualizerConfigurationAccessor {
        private TreeTableVisualizerConfigurationAccessorImpl() {
        }

        public DataTableMetadata.Column[] getTableColumns(TreeTableVisualizerConfiguration treeTableVisualizerConfiguration) {
            return treeTableVisualizerConfiguration.getTableColumns();
        }

        public DataTableMetadata.Column getTreeColumn(TreeTableVisualizerConfiguration treeTableVisualizerConfiguration) {
            return treeTableVisualizerConfiguration.getTreeColumn();
        }

        public boolean isTableView(TreeTableVisualizerConfiguration treeTableVisualizerConfiguration) {
            return treeTableVisualizerConfiguration.isTableView();
        }

        public NodeActionsProvider getNodesActionProvider(TreeTableVisualizerConfiguration treeTableVisualizerConfiguration) {
            return treeTableVisualizerConfiguration.getNodeActionsProvider();
        }

        public ColumnsUIMapping getColumnsUIMapping(TreeTableVisualizerConfiguration treeTableVisualizerConfiguration) {
            return treeTableVisualizerConfiguration.columnsUIMapping;
        }
    }
}

