/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SftpSupport {
    private static final java.util.logging.Logger LOG = Logger.getInstance();
    private static final Object instancesLock = new Object();
    private static Map<ExecutionEnvironment, SftpSupport> instances = new HashMap<ExecutionEnvironment, SftpSupport>();
    private final ExecutionEnvironment execEnv;
    private final RequestProcessor requestProcessor;
    private ChannelSftp channel;
    private final Object channelLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SftpSupport getInstance(ExecutionEnvironment executionEnvironment) {
        SftpSupport sftpSupport = null;
        Object object = instancesLock;
        synchronized (object) {
            sftpSupport = instances.get(executionEnvironment);
            if (sftpSupport == null) {
                sftpSupport = new SftpSupport(executionEnvironment);
                instances.put(executionEnvironment, sftpSupport);
            }
        }
        return sftpSupport;
    }

    static Future<Integer> uploadFile(String string, ExecutionEnvironment executionEnvironment, String string2, int n, Writer writer) {
        return SftpSupport.getInstance(executionEnvironment).uploadFile(string, string2, n, writer);
    }

    static Future<Integer> downloadFile(String string, ExecutionEnvironment executionEnvironment, String string2, Writer writer) {
        return SftpSupport.getInstance(executionEnvironment).downloadFile(string, string2, writer);
    }

    private SftpSupport(ExecutionEnvironment executionEnvironment) {
        this.execEnv = executionEnvironment;
        this.requestProcessor = new RequestProcessor("SFTP request processor for " + executionEnvironment, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelSftp getChannel() throws IOException, CancellationException, JSchException {
        Object object = this.channelLock;
        synchronized (object) {
            if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                this.channel = null;
                ConnectionManager.getInstance().connectTo(this.execEnv);
            }
            if (this.channel != null && !this.channel.isConnected()) {
                this.channel = null;
            }
            if (this.channel == null) {
                Session session = ConnectionManagerAccessor.getDefault().getConnectionSession(ConnectionManager.getInstance(), this.execEnv, true);
                this.channel = (ChannelSftp)session.openChannel("sftp");
                this.channel.connect();
            }
        }
        return this.channel;
    }

    private Future<Integer> uploadFile(String string, String string2, int n, Writer writer) {
        Uploader uploader = new Uploader(string, this.execEnv, string2, n, writer);
        FutureTask<Integer> futureTask = new FutureTask<Integer>(uploader);
        this.requestProcessor.post(futureTask);
        LOG.fine(uploader.getTraceName() + " schedulled");
        return futureTask;
    }

    private Future<Integer> downloadFile(String string, String string2, Writer writer) {
        Downloader downloader = new Downloader(string, this.execEnv, string2, writer);
        FutureTask<Integer> futureTask = new FutureTask<Integer>(downloader);
        this.requestProcessor.post(futureTask);
        LOG.fine(downloader.getTraceName() + " schedulled");
        return futureTask;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Downloader
    extends Worker
    implements Callable<Integer> {
        public Downloader(String string, ExecutionEnvironment executionEnvironment, String string2, Writer writer) {
            super(string, executionEnvironment, string2, writer);
        }

        @Override
        protected void work() throws IOException, CancellationException, JSchException, SftpException {
            ChannelSftp channelSftp = SftpSupport.this.getChannel();
            channelSftp.get(this.srcFileName, this.dstFileName);
        }

        @Override
        protected String getTraceName() {
            return "Downloading " + this.execEnv + ":" + this.srcFileName + " to " + this.dstFileName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Uploader
    extends Worker
    implements Callable<Integer> {
        private final int mask;

        public Uploader(String string, ExecutionEnvironment executionEnvironment, String string2, int n, Writer writer) {
            super(string, executionEnvironment, string2, writer);
            this.mask = n;
        }

        @Override
        protected void work() throws IOException, CancellationException, JSchException, SftpException {
            ChannelSftp channelSftp = SftpSupport.this.getChannel();
            channelSftp.put(this.srcFileName, this.dstFileName);
            channelSftp.chmod(this.mask, this.dstFileName);
        }

        @Override
        protected String getTraceName() {
            return "Uploading " + this.srcFileName + " to " + this.execEnv + ":" + this.dstFileName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Worker
    implements Callable<Integer> {
        protected final String srcFileName;
        protected final ExecutionEnvironment execEnv;
        protected final String dstFileName;
        protected final Writer error;

        public Worker(String string, ExecutionEnvironment executionEnvironment, String string2, Writer writer) {
            this.srcFileName = string;
            this.execEnv = executionEnvironment;
            this.dstFileName = string2;
            this.error = writer;
        }

        protected abstract void work() throws JSchException, SftpException, IOException, CancellationException;

        protected abstract String getTraceName();

        @Override
        public Integer call() throws Exception {
            int n = -1;
            try {
                LOG.fine(this.getTraceName() + " started");
                this.work();
                n = 0;
            }
            catch (JSchException jSchException) {
                jSchException.printStackTrace();
                n = 1;
            }
            catch (SftpException sftpException) {
                sftpException.printStackTrace();
                n = 2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                n = 3;
            }
            catch (CancellationException cancellationException) {
                n = 4;
            }
            LOG.fine(this.getTraceName() + (n == 0 ? " OK" : " FAILED"));
            return n;
        }
    }
}

