/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.InstructionWriter;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableSizeUpdater;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class CodeAttributeEditor
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final boolean DEBUG = false;
    private boolean updateFrameSizes;
    private int codeLength;
    private boolean modified;
    private boolean simple;
    public Instruction[] preInsertions = new Instruction[1024];
    public Instruction[] replacements = new Instruction[1024];
    public Instruction[] postInsertions = new Instruction[1024];
    public boolean[] deleted = new boolean[1024];
    private int[] instructionOffsetMap = new int[1024];
    private int newOffset;
    private boolean lengthIncreased;
    private int expectedStackMapFrameOffset;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private final VariableSizeUpdater variableSizeUpdater = new VariableSizeUpdater();
    private final InstructionWriter instructionWriter = new InstructionWriter();

    public CodeAttributeEditor() {
        this(true);
    }

    public CodeAttributeEditor(boolean bl) {
        this.updateFrameSizes = bl;
    }

    public void reset(int n) {
        this.codeLength = n;
        if (this.preInsertions.length < n) {
            this.preInsertions = new Instruction[n];
            this.replacements = new Instruction[n];
            this.postInsertions = new Instruction[n];
            this.deleted = new boolean[n];
        } else {
            for (int i = 0; i < n; ++i) {
                this.preInsertions[i] = null;
                this.replacements[i] = null;
                this.postInsertions[i] = null;
                this.deleted[i] = false;
            }
        }
        this.modified = false;
        this.simple = true;
    }

    public void insertBeforeInstruction(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.preInsertions[n] = instruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertBeforeInstruction(int n, Instruction[] instructionArray) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.preInsertions[n] = new CompositeInstruction(instructionArray);
        this.modified = true;
        this.simple = false;
    }

    public void replaceInstruction(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.replacements[n] = instruction;
        this.modified = true;
    }

    public void replaceInstruction(int n, Instruction[] instructionArray) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.replacements[n] = new CompositeInstruction(instructionArray);
        this.modified = true;
    }

    public void insertAfterInstruction(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.postInsertions[n] = instruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertAfterInstruction(int n, Instruction[] instructionArray) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.postInsertions[n] = new CompositeInstruction(instructionArray);
        this.modified = true;
        this.simple = false;
    }

    public void deleteInstruction(int n) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.deleted[n] = true;
        this.modified = true;
        this.simple = false;
    }

    public void undeleteInstruction(int n) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.deleted[n] = false;
    }

    public boolean isModified(int n) {
        return this.preInsertions[n] != null || this.replacements[n] != null || this.postInsertions[n] != null || this.deleted[n];
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while editing code:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            throw runtimeException;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.modified) {
            return;
        }
        if (this.canPerformSimpleReplacements(codeAttribute)) {
            this.performSimpleReplacements(codeAttribute);
            this.updateFrameSizes(clazz, method, codeAttribute);
        } else {
            codeAttribute.u4codeLength = this.updateInstructions(clazz, method, codeAttribute);
            codeAttribute.exceptionsAccept(clazz, method, this);
            codeAttribute.u2exceptionTableLength = this.removeEmptyExceptions(codeAttribute.exceptionTable, codeAttribute.u2exceptionTableLength);
            this.updateFrameSizes(clazz, method, codeAttribute);
            codeAttribute.attributesAccept(clazz, method, this);
            this.instructionWriter.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private void updateFrameSizes(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.updateFrameSizes) {
            this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
            this.variableSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.expectedStackMapFrameOffset = -1;
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.expectedStackMapFrameOffset = 0;
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        lineNumberTableAttribute.u2lineNumberTableLength = this.removeEmptyLineNumbers(lineNumberTableAttribute.lineNumberTable, lineNumberTableAttribute.u2lineNumberTableLength, codeAttribute.u4codeLength);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTableAttribute.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
    }

    private boolean canPerformSimpleReplacements(CodeAttribute codeAttribute) {
        if (!this.simple) {
            return false;
        }
        byte[] byArray = codeAttribute.code;
        int n = codeAttribute.u4codeLength;
        for (int i = 0; i < n; ++i) {
            Instruction instruction = this.replacements[i];
            if (instruction == null || instruction.length(i) == InstructionFactory.create(byArray, i).length(i)) continue;
            return false;
        }
        return true;
    }

    private void performSimpleReplacements(CodeAttribute codeAttribute) {
        int n = codeAttribute.u4codeLength;
        for (int i = 0; i < n; ++i) {
            Instruction instruction = this.replacements[i];
            if (instruction == null) continue;
            instruction.write(codeAttribute, i);
        }
    }

    private int updateInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        byte[] byArray = codeAttribute.code;
        int n = codeAttribute.u4codeLength;
        if (this.instructionOffsetMap.length < n + 1) {
            this.instructionOffsetMap = new int[n + 1];
        }
        int n2 = this.mapInstructions(byArray, n);
        if (this.lengthIncreased) {
            codeAttribute.code = new byte[n2];
        }
        this.instructionWriter.reset(n2);
        this.moveInstructions(clazz, method, codeAttribute, byArray, n);
        return n2;
    }

    private int mapInstructions(byte[] byArray, int n) {
        this.newOffset = 0;
        this.lengthIncreased = false;
        int n2 = 0;
        do {
            Instruction instruction = InstructionFactory.create(byArray, n2);
            this.mapInstruction(n2, instruction);
            n2 += instruction.length(n2);
            if (this.newOffset <= n2) continue;
            this.lengthIncreased = true;
        } while (n2 < n);
        this.instructionOffsetMap[n2] = this.newOffset;
        return this.newOffset;
    }

    private void mapInstruction(int n, Instruction instruction) {
        Instruction instruction2;
        this.instructionOffsetMap[n] = this.newOffset;
        Instruction instruction3 = this.preInsertions[n];
        if (instruction3 != null) {
            this.newOffset += instruction3.length(this.newOffset);
        }
        if ((instruction2 = this.replacements[n]) != null) {
            this.newOffset += instruction2.length(this.newOffset);
        } else if (!this.deleted[n]) {
            this.newOffset += instruction.length(this.newOffset);
        }
        Instruction instruction4 = this.postInsertions[n];
        if (instruction4 != null) {
            this.newOffset += instruction4.length(this.newOffset);
        }
    }

    private void moveInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute, byte[] byArray, int n) {
        Instruction instruction;
        this.newOffset = 0;
        int n2 = 0;
        do {
            instruction = InstructionFactory.create(byArray, n2);
            this.moveInstruction(clazz, method, codeAttribute, n2, instruction);
        } while ((n2 += instruction.length(n2)) < n);
    }

    private void moveInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        Instruction instruction2;
        Instruction instruction3 = this.preInsertions[n];
        if (instruction3 != null) {
            instruction3.accept(clazz, method, codeAttribute, n, this);
        }
        if ((instruction2 = this.replacements[n]) != null) {
            instruction2.accept(clazz, method, codeAttribute, n, this);
        } else if (!this.deleted[n]) {
            instruction.accept(clazz, method, codeAttribute, n, this);
        }
        Instruction instruction4 = this.postInsertions[n];
        if (instruction4 != null) {
            instruction4.accept(clazz, method, codeAttribute, n, this);
        }
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        this.instructionWriter.visitSimpleInstruction(clazz, method, codeAttribute, this.newOffset, simpleInstruction);
        this.newOffset += simpleInstruction.length(this.newOffset);
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        this.instructionWriter.visitConstantInstruction(clazz, method, codeAttribute, this.newOffset, constantInstruction);
        this.newOffset += constantInstruction.length(this.newOffset);
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        this.instructionWriter.visitVariableInstruction(clazz, method, codeAttribute, this.newOffset, variableInstruction);
        this.newOffset += variableInstruction.length(this.newOffset);
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        branchInstruction.branchOffset = this.remapBranchOffset(n, branchInstruction.branchOffset);
        this.instructionWriter.visitBranchInstruction(clazz, method, codeAttribute, this.newOffset, branchInstruction);
        this.newOffset += branchInstruction.length(this.newOffset);
    }

    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
        tableSwitchInstruction.defaultOffset = this.remapBranchOffset(n, tableSwitchInstruction.defaultOffset);
        this.remapJumpOffsets(n, tableSwitchInstruction.jumpOffsets);
        this.instructionWriter.visitTableSwitchInstruction(clazz, method, codeAttribute, this.newOffset, tableSwitchInstruction);
        this.newOffset += tableSwitchInstruction.length(this.newOffset);
    }

    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        lookUpSwitchInstruction.defaultOffset = this.remapBranchOffset(n, lookUpSwitchInstruction.defaultOffset);
        this.remapJumpOffsets(n, lookUpSwitchInstruction.jumpOffsets);
        this.instructionWriter.visitLookUpSwitchInstruction(clazz, method, codeAttribute, this.newOffset, lookUpSwitchInstruction);
        this.newOffset += lookUpSwitchInstruction.length(this.newOffset);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startPC = this.remapInstructionOffset(exceptionInfo.u2startPC);
        exceptionInfo.u2endPC = this.remapInstructionOffset(exceptionInfo.u2endPC);
        exceptionInfo.u2handlerPC = this.remapInstructionOffset(exceptionInfo.u2handlerPC);
    }

    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrame stackMapFrame) {
        int n2;
        int n3 = n2 = this.remapInstructionOffset(n);
        if (this.expectedStackMapFrameOffset >= 0) {
            n3 -= this.expectedStackMapFrameOffset;
            this.expectedStackMapFrameOffset = n2 + 1;
        }
        stackMapFrame.u2offsetDelta = n3;
    }

    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, sameOneFrame);
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, moreZeroFrame);
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, fullFrame);
        fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
    }

    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.remapInstructionOffset(uninitializedType.u2newInstructionOffset);
    }

    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.remapInstructionOffset(lineNumberInfo.u2startPC);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2length = this.remapBranchOffset(localVariableInfo.u2startPC, localVariableInfo.u2length);
        localVariableInfo.u2startPC = this.remapInstructionOffset(localVariableInfo.u2startPC);
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2length = this.remapBranchOffset(localVariableTypeInfo.u2startPC, localVariableTypeInfo.u2length);
        localVariableTypeInfo.u2startPC = this.remapInstructionOffset(localVariableTypeInfo.u2startPC);
    }

    private void remapJumpOffsets(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.remapBranchOffset(n, nArray[i]);
        }
    }

    private int remapBranchOffset(int n, int n2) {
        return this.remapInstructionOffset(n + n2) - this.newOffset;
    }

    private int remapInstructionOffset(int n) {
        if (n < 0 || n > this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        return this.instructionOffsetMap[n];
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfoArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ExceptionInfo exceptionInfo = exceptionInfoArray[i];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfoArray[n2++] = exceptionInfo;
        }
        return n2;
    }

    private int removeEmptyLineNumbers(LineNumberInfo[] lineNumberInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LineNumberInfo lineNumberInfo = lineNumberInfoArray[i];
            int n4 = lineNumberInfo.u2startPC;
            if (n4 >= n2 || i != 0 && n4 <= lineNumberInfoArray[i - 1].u2startPC) continue;
            lineNumberInfoArray[n3++] = lineNumberInfo;
        }
        return n3;
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableInfo localVariableInfo = localVariableInfoArray[i];
            if (localVariableInfo.u2length <= 0 || localVariableInfo.u2index >= n2) continue;
            localVariableInfoArray[n3++] = localVariableInfo;
        }
        return n3;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfoArray[i];
            if (localVariableTypeInfo.u2length <= 0 || localVariableTypeInfo.u2index >= n2) continue;
            localVariableTypeInfoArray[n3++] = localVariableTypeInfo;
        }
        return n3;
    }

    private class CompositeInstruction
    extends Instruction {
        private Instruction[] instructions;

        private CompositeInstruction(Instruction[] instructionArray) {
            this.instructions = instructionArray;
        }

        public Instruction shrink() {
            for (int i = 0; i < this.instructions.length; ++i) {
                this.instructions[i] = this.instructions[i].shrink();
            }
            return this;
        }

        public void write(byte[] byArray, int n) {
            for (int i = 0; i < this.instructions.length; ++i) {
                Instruction instruction = this.instructions[i];
                instruction.write(byArray, n);
                n += instruction.length(n);
            }
        }

        protected void readInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't read composite instruction");
        }

        protected void writeInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't write composite instruction");
        }

        public int length(int n) {
            int n2 = n;
            for (int i = 0; i < this.instructions.length; ++i) {
                n2 += this.instructions[i].length(n2);
            }
            return n2 - n;
        }

        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
            if (instructionVisitor != CodeAttributeEditor.this) {
                throw new UnsupportedOperationException("Unexpected visitor [" + instructionVisitor + "]");
            }
            for (int i = 0; i < this.instructions.length; ++i) {
                Instruction instruction = this.instructions[i];
                instruction.accept(clazz, method, codeAttribute, n, CodeAttributeEditor.this);
                n += instruction.length(n);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.instructions.length; ++i) {
                stringBuffer.append(this.instructions[i].toString()).append("; ");
            }
            return stringBuffer.toString();
        }
    }
}

