/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.plugins;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.ruby.DiffElement;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.refactoring.ruby.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.ruby.plugins.RubyRefactoringPlugin;
import org.netbeans.modules.refactoring.ruby.plugins.SearchVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyStructureAnalyzer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameRefactoringPlugin
extends RubyRefactoringPlugin {
    private RubyElementCtx treePathHandle;
    private final Collection<IndexedMethod> overriddenByMethods = new ArrayList<IndexedMethod>();
    private final Collection<IndexedMethod> overridesMethods = new ArrayList<IndexedMethod>();
    private RenameRefactoring refactoring;
    private RubyBaseProject project;
    private Set<RubyElementCtx> allMethods;

    public RenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        Source source;
        this.refactoring = renameRefactoring;
        RubyElementCtx rubyElementCtx = (RubyElementCtx)renameRefactoring.getRefactoringSource().lookup(RubyElementCtx.class);
        if (rubyElementCtx != null) {
            this.treePathHandle = rubyElementCtx;
        } else {
            source = Source.create((FileObject)((FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class)));
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        RubyStructureAnalyzer.AnalysisResult analysisResult;
                        List list;
                        RubyParseResult rubyParseResult;
                        Node node;
                        if (resultIterator.getSnapshot().getMimeType().equals("text/x-ruby") && (node = (rubyParseResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult())).getRootNode()) != null && (list = (analysisResult = rubyParseResult.getStructure()).getElements()).size() > 0) {
                            AstElement astElement = (AstElement)list.get(0);
                            Node node2 = astElement.getNode();
                            RenameRefactoringPlugin.this.treePathHandle = new RubyElementCtx(node, node2, (Element)astElement, RubyUtils.getFileObject((Parser.Result)rubyParseResult), (ParserResult)rubyParseResult);
                            RenameRefactoringPlugin.this.refactoring.getContext().add((Object)resultIterator);
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                Logger.getLogger(RenameRefactoringPlugin.class.getName()).log(Level.WARNING, null, parseException);
            }
        }
        if (this.treePathHandle != null && (source = FileOwnerQuery.getOwner((FileObject)this.treePathHandle.getFileObject())) instanceof RubyBaseProject) {
            this.project = (RubyBaseProject)source;
        }
    }

    public Problem fastCheckParameters() {
        boolean bl;
        Problem problem = null;
        ElementKind elementKind = this.treePathHandle.getKind();
        String string = this.refactoring.getNewName();
        String string2 = this.treePathHandle.getSimpleName();
        if (string2 == null) {
            return new Problem(true, "Cannot determine target name. Please file a bug with detailed information on how to reproduce (preferably including the current source file and the cursor position)");
        }
        if (string2.equals(string) && (bl = true)) {
            problem = RenameRefactoringPlugin.createProblem(problem, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            return problem;
        }
        if (elementKind == ElementKind.CLASS && !RubyUtils.isValidConstantFQN((String)string)) {
            String string3 = RenameRefactoringPlugin.getString("ERR_InvalidClassName");
            String string4 = new MessageFormat(string3).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, string4);
            return problem;
        }
        if (elementKind == ElementKind.METHOD && !RubyUtils.isValidRubyMethodName((String)string)) {
            String string5 = RenameRefactoringPlugin.getString("ERR_InvalidMethodName");
            String string6 = new MessageFormat(string5).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, string6);
            return problem;
        }
        if (!RubyUtils.isValidRubyIdentifier((String)string)) {
            String string7 = RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String string8 = new MessageFormat(string7).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, string8);
            return problem;
        }
        String string9 = this.getWarningMsg(elementKind, string);
        if (string9 != null) {
            problem = RenameRefactoringPlugin.createProblem(problem, false, string9);
        }
        return problem;
    }

    private Set<String> asNames(Collection<? extends IndexedElement> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (IndexedElement indexedElement : collection) {
            hashSet.add(indexedElement.getName());
        }
        return hashSet;
    }

    public Problem checkParameters() {
        Problem problem = null;
        int n = 0;
        if (AstUtilities.isCall((Node)this.treePathHandle.getNode()) || this.treePathHandle.getKind() == ElementKind.METHOD) {
            RubyIndex rubyIndex = RubyIndex.get((Parser.Result)this.treePathHandle.getInfo());
            String string = this.treePathHandle.getDefClass();
            String string2 = AstUtilities.getName((Node)this.treePathHandle.getNode());
            Set set = rubyIndex.getAllOverridingMethodsInHierachy(string2, string);
            this.overridesMethods.addAll(set);
            if (this.overridesMethods.size() > 1) {
                Set<String> set2 = this.asNames(rubyIndex.getSuperClasses(string));
                boolean bl = false;
                boolean bl2 = false;
                for (IndexedMethod indexedMethod : this.overridesMethods) {
                    if (!this.isUnderSourceRoot(indexedMethod.getFileObject())) {
                        problem = RenameRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_Overrides_Method", (Object)(indexedMethod.getIn() + "#" + indexedMethod.getName()), (Object)indexedMethod.getFileObject().getPath()));
                    } else if (!indexedMethod.getFileObject().equals(this.treePathHandle.getFileObject())) {
                        bl = true;
                    }
                    if (bl2 || string.equals(indexedMethod.getIn()) || set2.contains(indexedMethod.getIn())) continue;
                    bl2 = true;
                }
                if (bl) {
                    problem = RenameRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_Overrides"));
                }
                if (bl2) {
                    problem = RenameRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_Overrides_tree"));
                }
            }
        }
        n += this.overriddenByMethods.size();
        this.fireProgressListenerStart(2, 8 + 3 * (n += this.overridesMethods.size()));
        this.fireProgressListenerStep();
        this.fireProgressListenerStep();
        this.fireProgressListenerStop();
        return problem;
    }

    private boolean isUnderSourceRoot(FileObject fileObject) {
        if (this.project == null) {
            return false;
        }
        for (FileObject fileObject2 : this.project.getSourceRootFiles()) {
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return true;
        }
        for (FileObject fileObject2 : this.project.getTestSourceRootFiles()) {
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return true;
        }
        return false;
    }

    public Problem preCheck() {
        if (this.treePathHandle == null || this.treePathHandle.getFileObject() == null || !this.treePathHandle.getFileObject().isValid()) {
            return new Problem(true, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        if (this.treePathHandle.getKind() == ElementKind.VARIABLE || this.treePathHandle.getKind() == ElementKind.PARAMETER) {
            return Collections.singleton(this.treePathHandle.getFileObject());
        }
        return RetoucheUtils.getRubyFilesInProject(this.treePathHandle.getFileObject());
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Object object;
        if (this.treePathHandle == null) {
            return null;
        }
        Problem problem = null;
        Set<FileObject> set = this.getRelevantFiles();
        this.fireProgressListenerStart(1, set.size());
        if (!set.isEmpty()) {
            object = new RubyRefactoringPlugin.TransformTask(){

                @Override
                protected Collection<ModificationResult> process(ParserResult parserResult) {
                    RenameTransformer renameTransformer = new RenameTransformer(RenameRefactoringPlugin.this.refactoring.getNewName(), RenameRefactoringPlugin.this.allMethods);
                    renameTransformer.setWorkingCopy(parserResult);
                    renameTransformer.scan();
                    ModificationResult modificationResult = new ModificationResult();
                    modificationResult.addDifferences(parserResult.getSnapshot().getSource().getFileObject(), renameTransformer.diffs);
                    return Collections.singleton(modificationResult);
                }
            };
            Collection<ModificationResult> collection = this.processFiles(set, (RubyRefactoringPlugin.TransformTask)((Object)object));
            refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(collection));
            for (ModificationResult modificationResult : collection) {
                for (FileObject fileObject : modificationResult.getModifiedFileObjects()) {
                    for (ModificationResult.Difference difference : modificationResult.getDifferences(fileObject)) {
                        String string = difference.getOldText();
                        if (string == null) continue;
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
                    }
                }
            }
        }
        if (this.refactoring.getRefactoringSource().lookup(FileObject.class) != null) {
            object = RubyUtils.camelToUnderlinedName((String)this.refactoring.getNewName());
            this.refactoring.setNewName((String)object);
        }
        this.fireProgressListenerStop();
        return problem;
    }

    private static final String getString(String string) {
        return NbBundle.getMessage(RenameRefactoringPlugin.class, (String)string);
    }

    private String getWarningMsg(ElementKind elementKind, String string) {
        String string2 = null;
        if (ElementKind.CLASS == elementKind) {
            String string3;
            String[] stringArray = string.split("::");
            int n = stringArray.length;
            for (int i = 0; i < n && (string2 = RubyUtils.getIdentifierWarning((String)(string3 = stringArray[i]), (int)0)) == null; ++i) {
            }
        } else {
            string2 = RubyUtils.getIdentifierWarning((String)string, (int)0);
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RenameTransformer
    extends SearchVisitor {
        private final Set<RubyElementCtx> allMethods;
        private final String newName;
        private final String oldName;
        private CloneableEditorSupport ces;
        private List<ModificationResult.Difference> diffs;

        @Override
        public void setWorkingCopy(ParserResult parserResult) {
            this.ces = null;
            this.diffs = null;
            super.setWorkingCopy(parserResult);
        }

        public RenameTransformer(String string, Set<RubyElementCtx> set) {
            this.newName = string;
            this.oldName = RenameRefactoringPlugin.this.treePathHandle.getSimpleName();
            this.allMethods = set;
        }

        @Override
        public void scan() {
            RubyElementCtx rubyElementCtx;
            Node node;
            Object object;
            this.diffs = new ArrayList<ModificationResult.Difference>();
            RubyElementCtx rubyElementCtx2 = RenameRefactoringPlugin.this.treePathHandle;
            Error error = null;
            Node node2 = AstUtilities.getRoot((Parser.Result)this.workingCopy);
            FileObject fileObject = RubyUtils.getFileObject((Parser.Result)this.workingCopy);
            if (node2 != null) {
                AstPath astPath;
                object = AstElement.create((ParserResult)this.workingCopy, (Node)node2);
                node = rubyElementCtx2.getNode();
                rubyElementCtx = new RubyElementCtx(node2, node, (Element)object, fileObject, this.workingCopy);
                Node node3 = null;
                if (node instanceof ArgumentNode) {
                    astPath = rubyElementCtx2.getPath();
                    assert (astPath.leaf() == node);
                    Node node4 = astPath.leafParent();
                    if (!(node4 instanceof MethodDefNode)) {
                        node3 = AstUtilities.findLocalScope((Node)node, (AstPath)astPath);
                    }
                } else if (node instanceof LocalVarNode || node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof DVarNode) {
                    astPath = rubyElementCtx2.getPath();
                    node3 = AstUtilities.findLocalScope((Node)node, (AstPath)astPath);
                }
                if (node3 != null) {
                    this.findLocal(rubyElementCtx2, rubyElementCtx, node3, this.oldName);
                } else {
                    astPath = new AstPath();
                    astPath.descend(node2);
                    this.find(astPath, rubyElementCtx2, rubyElementCtx, node2, this.oldName, Character.isUpperCase(this.oldName.charAt(0)));
                    astPath.ascend();
                }
            } else {
                object = ((Object)this.workingCopy.getSnapshot().getText()).toString();
                if (((String)object).indexOf(this.oldName) != -1) {
                    Error error2;
                    Object object2;
                    if (this.ces == null) {
                        this.ces = RetoucheUtils.findCloneableEditorSupport(this.workingCopy);
                    }
                    int n = 0;
                    int n2 = 0;
                    String string = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ParseErrorFile", (Object)this.oldName);
                    List list = this.workingCopy.getDiagnostics();
                    if (list.size() > 0) {
                        object2 = list.iterator();
                        while (object2.hasNext()) {
                            error2 = (Error)object2.next();
                            if (error2.getSeverity() != Severity.ERROR) continue;
                            error = error2;
                            break;
                        }
                        if (error == null) {
                            error = (Error)list.get(0);
                        }
                        if (((String)(object2 = error.getDisplayName())).length() > 80) {
                            object2 = ((String)object2).substring(0, 77) + "...";
                        }
                        string = string + "; " + (String)object2;
                        n = error.getStartPosition();
                        if ((n = LexUtilities.getLexerOffset((Parser.Result)this.workingCopy, (int)n)) == -1) {
                            n = 0;
                        }
                        n2 = n;
                    }
                    object2 = this.ces.createPositionRef(n, Position.Bias.Forward);
                    error2 = this.ces.createPositionRef(n2, Position.Bias.Forward);
                    ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, (PositionRef)object2, (PositionRef)error2, "", "", string);
                    this.diffs.add(difference);
                }
            }
            if (error == null && RenameRefactoringPlugin.this.refactoring.isSearchInComments() && (object = RetoucheUtils.getDocument(this.workingCopy, RubyUtils.getFileObject((Parser.Result)this.workingCopy))) != null) {
                node = TokenHierarchy.get((Document)object);
                rubyElementCtx = node.tokenSequence();
                rubyElementCtx.move(0);
                this.searchTokenSequence((TokenSequence<?>)rubyElementCtx);
            }
            this.ces = null;
        }

        private void searchTokenSequence(TokenSequence<?> tokenSequence) {
            if (tokenSequence.moveNext()) {
                do {
                    CharSequence charSequence;
                    Token token;
                    TokenId tokenId;
                    String string;
                    if ("comment".equals(string = (tokenId = (token = tokenSequence.token()).id()).primaryCategory()) || "block-comment".equals(string)) {
                        int n;
                        charSequence = token.text();
                        if (charSequence == null || this.oldName == null || (n = TokenUtilities.indexOf((CharSequence)charSequence, (CharSequence)this.oldName)) == -1) continue;
                        String string2 = ((Object)charSequence).toString();
                        if (n != 0 && Character.isLetterOrDigit(string2.charAt(n - 1)) || n + this.oldName.length() < string2.length() && Character.isLetterOrDigit(string2.charAt(n + this.oldName.length()))) continue;
                        int n2 = tokenSequence.offset() + n;
                        int n3 = n2 + this.oldName.length();
                        if (this.ces == null) {
                            this.ces = RetoucheUtils.findCloneableEditorSupport(this.workingCopy);
                        }
                        PositionRef positionRef = this.ces.createPositionRef(n2, Position.Bias.Forward);
                        PositionRef positionRef2 = this.ces.createPositionRef(n3, Position.Bias.Forward);
                        String string3 = RenameRefactoringPlugin.getString("ChangeComment");
                        ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, positionRef, positionRef2, this.oldName, this.newName, string3);
                        this.diffs.add(difference);
                        continue;
                    }
                    charSequence = tokenSequence.embedded();
                    if (charSequence == null) continue;
                    this.searchTokenSequence((TokenSequence<?>)charSequence);
                } while (tokenSequence.moveNext());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rename(Node node, String string, String string2, String string3) {
            Object object;
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)node);
            assert (offsetRange != OffsetRange.NONE);
            int n = offsetRange.getStart();
            if (string3 == null) {
                string3 = node instanceof MethodDefNode ? RenameRefactoringPlugin.getString("UpdateMethodDef") : (AstUtilities.isCall((Node)node) ? RenameRefactoringPlugin.getString("UpdateCall") : (node instanceof SymbolNode ? RenameRefactoringPlugin.getString("UpdateSymbol") : (node instanceof ClassNode || node instanceof SClassNode ? RenameRefactoringPlugin.getString("UpdateClassDef") : (node instanceof ModuleNode ? RenameRefactoringPlugin.getString("UpdateModule") : (node instanceof LocalVarNode || node instanceof LocalAsgnNode || node instanceof DVarNode || node instanceof DAsgnNode ? RenameRefactoringPlugin.getString("UpdateLocalvar") : (node instanceof GlobalVarNode || node instanceof GlobalAsgnNode ? RenameRefactoringPlugin.getString("UpdateGlobal") : (node instanceof InstVarNode || node instanceof InstAsgnNode ? RenameRefactoringPlugin.getString("UpdateInstance") : (node instanceof ClassVarNode || node instanceof ClassVarDeclNode || node instanceof ClassVarAsgnNode ? RenameRefactoringPlugin.getString("UpdateClassvar") : NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"UpdateRef", (Object)string)))))))));
            }
            if (this.ces == null) {
                this.ces = RetoucheUtils.findCloneableEditorSupport(this.workingCopy);
            }
            if ((n = LexUtilities.getLexerOffset((Parser.Result)this.workingCopy, (int)n)) == -1) {
                return;
            }
            int n2 = n;
            int n3 = n + string.length();
            BaseDocument baseDocument = null;
            try {
                baseDocument = (BaseDocument)this.ces.openDocument();
                baseDocument.readLock();
                if (n2 > baseDocument.getLength()) {
                    n2 = n3 = baseDocument.getLength();
                }
                if (n3 > baseDocument.getLength()) {
                    n3 = baseDocument.getLength();
                }
                if (!string.equals(baseDocument.getText(n2, n3 - n2))) {
                    int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                    int n5 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2) + 1;
                    if (n4 == -1 || n5 == -1) {
                        System.out.println("Empty line entry in " + FileUtil.getFileDisplayName((FileObject)RubyUtils.getFileObject((Parser.Result)this.workingCopy)) + "; no match for " + string + " in line " + n2 + " referenced by node " + node + " of type " + node.getClass().getName());
                        return;
                    }
                    if (n4 < 0 || n5 - n4 < 0) {
                        return;
                    }
                    object = baseDocument.getText(n4, n5 - n4);
                    if (((String)object).indexOf(string) == -1) {
                        System.out.println("Skipping entry in " + FileUtil.getFileDisplayName((FileObject)RubyUtils.getFileObject((Parser.Result)this.workingCopy)) + "; no match for " + string + " in line " + (String)object + " referenced by node " + node + " of type " + node.getClass().getName());
                    } else {
                        int n6 = n2 - n4;
                        int n7 = -1;
                        for (int i = 1; i < ((String)object).length(); ++i) {
                            if (n6 + i + string.length() <= ((String)object).length() && string.equals(((String)object).substring(n6 + i, n6 + i + string.length()))) {
                                n7 = n6 + i;
                                break;
                            }
                            if (n6 - i < 0 || n6 - i + string.length() > ((String)object).length() || !string.equals(((String)object).substring(n6 - i, n6 - i + string.length()))) continue;
                            n7 = n6 - i;
                            break;
                        }
                        if (n7 != -1) {
                            n2 = n7 + n4;
                            n3 = n2 + string.length();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                if (baseDocument != null) {
                    baseDocument.readUnlock();
                }
            }
            if (string2 == null) {
                string2 = RenameRefactoringPlugin.this.refactoring.getNewName();
            }
            PositionRef positionRef = this.ces.createPositionRef(n2, Position.Bias.Forward);
            PositionRef positionRef2 = this.ces.createPositionRef(n3, Position.Bias.Forward);
            object = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, positionRef, positionRef2, string, string2, string3);
            this.diffs.add((ModificationResult.Difference)object);
        }

        private void findLocal(RubyElementCtx rubyElementCtx, RubyElementCtx rubyElementCtx2, Node node, String string) {
            switch (node.getNodeType()) {
                case ARGUMENTNODE: {
                    if (!((ArgumentNode)node).getName().equals(string)) break;
                    this.rename(node, string, null, RenameRefactoringPlugin.getString("RenameParam"));
                    break;
                }
                case LOCALVARNODE: 
                case LOCALASGNNODE: {
                    if (!((INameNode)node).getName().equals(string)) break;
                    this.rename(node, string, null, RenameRefactoringPlugin.getString("UpdateLocalvar"));
                    break;
                }
                case DVARNODE: 
                case DASGNNODE: {
                    if (!((INameNode)node).getName().equals(string)) break;
                    this.rename(node, string, null, RenameRefactoringPlugin.getString("UpdateDynvar"));
                    break;
                }
                case SYMBOLNODE: {
                    if (!((SymbolNode)node).getName().equals(string)) break;
                    this.rename(node, string, null, RenameRefactoringPlugin.getString("UpdateSymbol"));
                }
            }
            List list = node.childNodes();
            for (Node node2 : list) {
                if (node2.isInvisible()) continue;
                this.findLocal(rubyElementCtx, rubyElementCtx2, node2, string);
            }
        }

        private void find(AstPath astPath, RubyElementCtx rubyElementCtx, RubyElementCtx rubyElementCtx2, Node node, String string, boolean bl) {
            block20: {
                block19: {
                    if (bl) break block19;
                    switch (node.getNodeType()) {
                        case DEFNNODE: 
                        case DEFSNODE: {
                            if (!((MethodDefNode)node).getName().equals(string)) break;
                            boolean bl2 = false;
                            Object object = AstUtilities.getFqnName((AstPath)astPath);
                            if (object == null || ((String)object).length() == 0) {
                                object = "Object";
                            }
                            if (!((String)object).equals(rubyElementCtx.getDefClass())) {
                                int n = 0;
                                for (IndexedMethod object2 : RenameRefactoringPlugin.this.overridesMethods) {
                                    if (!object2.getIn().equals(object)) continue;
                                    n = 1;
                                    break;
                                }
                                boolean bl3 = bl2 = n == 0;
                            }
                            if (!bl2 && AstUtilities.isCall((Node)rubyElementCtx.getNode()) && !AstUtilities.isCallFor((Node)rubyElementCtx.getNode(), (Arity)rubyElementCtx.getArity(), (Node)node)) {
                                bl2 = true;
                            }
                            if (!bl2) {
                                node = AstUtilities.getDefNameNode((MethodDefNode)((MethodDefNode)node));
                                this.rename(node, string, null, RenameRefactoringPlugin.getString("UpdateMethodDef"));
                                break;
                            }
                            break block20;
                        }
                        case FCALLNODE: {
                            if (AstUtilities.isAttr((Node)node)) {
                                SymbolNode[] symbolNodeArray = AstUtilities.getAttrSymbols((Node)node);
                                for (SymbolNode symbolNode : symbolNodeArray) {
                                    if (!symbolNode.getName().equals(string)) continue;
                                    this.rename(node, string, null, null);
                                }
                            }
                        }
                        case VCALLNODE: 
                        case CALLNODE: {
                            if (!((INameNode)node).getName().equals(string)) break;
                            this.rename(node, string, null, null);
                            break;
                        }
                        case SYMBOLNODE: {
                            if (!((SymbolNode)node).getName().equals(string)) break;
                            this.rename(node, string, null, null);
                            break;
                        }
                        case GLOBALVARNODE: 
                        case GLOBALASGNNODE: 
                        case INSTVARNODE: 
                        case INSTASGNNODE: 
                        case CLASSVARNODE: 
                        case CLASSVARASGNNODE: 
                        case CLASSVARDECLNODE: {
                            if (!((INameNode)node).getName().equals(string)) break;
                            this.rename(node, string, null, null);
                        }
                    }
                    break block20;
                }
                switch (node.getNodeType()) {
                    case COLON2NODE: {
                        Colon2Node colon2Node = (Colon2Node)node;
                        if (!colon2Node.getName().equals(string)) break;
                        this.rename(node, string, null, null);
                        break;
                    }
                    case CONSTNODE: 
                    case CONSTDECLNODE: {
                        if (!((INameNode)node).getName().equals(string)) break;
                        this.rename(node, string, null, null);
                    }
                }
            }
            List list = node.childNodes();
            for (Node node2 : list) {
                if (node2.isInvisible()) continue;
                astPath.descend(node2);
                this.find(astPath, rubyElementCtx, rubyElementCtx2, node2, string, bl);
                astPath.ascend();
            }
        }
    }
}

