/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.svnclientadapter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;

public class SvnClientAdapterFactory {
    private Logger LOG = Logger.getLogger("org.netbeans.libs.svnclientadapter");
    private static SvnClientAdapterFactory instance;
    private Client client;

    private SvnClientAdapterFactory() {
    }

    public static SvnClientAdapterFactory getInstance() {
        if (instance == null) {
            instance = new SvnClientAdapterFactory();
        }
        return instance;
    }

    private static boolean isSupportedJavahlVersion(String string) {
        boolean bl = false;
        if (string != null && ((string = string.toLowerCase()).startsWith("1.6") || string.contains("version 1.6"))) {
            bl = true;
        }
        return bl;
    }

    public boolean setup(Client client) throws SVNClientException {
        this.client = client;
        switch (client) {
            case javahl: {
                try {
                    JhlClientAdapterFactory.setup();
                }
                catch (Throwable throwable) {
                    String string = JhlClientAdapterFactory.getLibraryLoadErrors();
                    this.LOG.log(Level.INFO, throwable.getMessage());
                    this.LOG.warning(string + "\n");
                    return false;
                }
                return JhlClientAdapterFactory.isAvailable();
            }
            case svnkit: {
                SvnKitClientAdapterFactory.setup();
                return SvnKitClientAdapterFactory.isAvailable();
            }
        }
        return false;
    }

    public ISVNClientAdapter createClient() {
        switch (this.client) {
            case javahl: {
                return JhlClientAdapterFactory.createSVNClient("javahl");
            }
            case svnkit: {
                return SvnKitClientAdapterFactory.createSVNClient("svnkit");
            }
        }
        return null;
    }

    public boolean isSupportedJavahlVersion() {
        ISVNClientAdapter iSVNClientAdapter;
        boolean bl = false;
        if (Client.javahl.equals((Object)this.client) && (iSVNClientAdapter = JhlClientAdapterFactory.createSVNClient("javahl")) != null && iSVNClientAdapter instanceof JhlClientAdapter) {
            JhlClientAdapter jhlClientAdapter = (JhlClientAdapter)iSVNClientAdapter;
            String string = jhlClientAdapter.getNativeLibraryVersionString();
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "isSupportedJavahlVersion: version {0}", string);
            }
            bl = SvnClientAdapterFactory.isSupportedJavahlVersion(string);
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Client {
        javahl,
        svnkit;

    }
}

