/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.api.support.ClientCreator;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.core.CreatorProvider;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.client.wizard.WebServiceClientWizardDescriptor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceClientWizardIterator
implements TemplateWizard.Iterator {
    private int index = 0;
    private WizardDescriptor.Panel[] panels;
    private TemplateWizard wiz;
    private Project project;

    public static WebServiceClientWizardIterator create() {
        return new WebServiceClientWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new WebServiceClientWizardDescriptor()};
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wiz = templateWizard;
        this.project = Templates.getProject((WizardDescriptor)this.wiz);
        this.index = 0;
        this.panels = this.createPanels();
        Object object = this.wiz.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = JaxWsUtils.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            assert (component instanceof JComponent);
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wiz = null;
        this.panels = null;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)templateWizard);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        ClientCreator clientCreator = CreatorProvider.getClientCreator(this.project, (WizardDescriptor)templateWizard);
        if (clientCreator != null) {
            clientCreator.createClient();
        }
        Object[] objectArray = new Object[5];
        boolean bl = "JAX-WS Style".equals(templateWizard.getProperty("jaxVersion"));
        objectArray[0] = bl ? "JAX-WS" : "JAX-RPC";
        objectArray[1] = this.project.getClass().getName();
        J2eeModule j2eeModule = JaxWsUtils.getJ2eeModule(this.project);
        objectArray[2] = j2eeModule == null ? "J2SE" : j2eeModule.getModuleVersion() + "(" + JaxWsUtils.getModuleType(this.project) + ")";
        objectArray[3] = (Boolean)templateWizard.getProperty("useDispatch") != false ? "DISPATCH" : "WS CLIENTL";
        int n = (Integer)templateWizard.getProperty("wsdlSource");
        switch (n) {
            case 0: {
                objectArray[4] = "FROM PROJECT";
                break;
            }
            case 1: {
                objectArray[4] = "FROM FILE";
                break;
            }
            default: {
                objectArray[4] = "FROM URL";
            }
        }
        LogUtils.logWsWizard((Object[])objectArray);
        return Collections.singleton(dataObject);
    }

    public String name() {
        return NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"LBL_WebServiceClient");
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void previousPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

