/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.parsing.impl.indexing.lucene.util.Evictable;
import org.netbeans.modules.parsing.impl.indexing.lucene.util.EvictionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LRUCache<K, V extends Evictable> {
    private final LinkedHashMap<K, V> cache;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public LRUCache(final EvictionPolicy<? super K, ? super V> evictionPolicy) {
        this.cache = new LinkedHashMap<K, V>(10, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                boolean bl = evictionPolicy.shouldEvict(this.size(), entry.getKey(), (Evictable)entry.getValue());
                if (bl) {
                    ((Evictable)entry.getValue()).evicted();
                }
                return bl;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k, V v) {
        assert (k != null);
        assert (v != null);
        this.lock.writeLock().lock();
        try {
            this.cache.put(k, v);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K k) {
        assert (k != null);
        this.lock.readLock().lock();
        try {
            Evictable evictable = (Evictable)this.cache.get(k);
            return (V)evictable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K k) {
        assert (k != null);
        this.lock.writeLock().lock();
        try {
            Evictable evictable = (Evictable)this.cache.remove(k);
            return (V)evictable;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.cache.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

