/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.awt;

import com.sun.perseus.awt.ComponentEventDispatcher;
import com.sun.perseus.builder.ModelBuilder;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.Anchor;
import com.sun.perseus.model.CanvasManager;
import com.sun.perseus.model.CanvasUpdateListener;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.util.RunnableQueue;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class SVGComponent
extends Component
implements RunnableQueue.RunnableHandler,
CanvasUpdateListener {
    protected CanvasManager canvasManager;
    protected Thread loadingThread;
    protected DocumentNode documentNode;
    protected ComponentEventDispatcher dispatcher;
    protected boolean needRepaint = true;
    protected BufferedImage offscreen;
    protected RenderGraphics rg;
    protected static final AffineTransform IDENTITY = new AffineTransform();
    protected String svgURI;
    protected RunnableQueue updateQueue = null;
    protected EventListener anchorListener = null;
    protected CursorChanger cursorChanger = null;
    protected int width;
    protected int height;
    protected float[] currentTranslate = new float[]{0.0f, 0.0f};
    protected float currentScale = 1.0f;
    protected boolean ignoreCanvasUpdate = false;

    public SVGComponent(EventListener anchorListener) {
        this.updateQueue = RunnableQueue.getDefault();
        this.anchorListener = anchorListener == null ? new DefaultAnchorListener() : anchorListener;
        this.cursorChanger = new CursorChanger();
        AWTListener l = new AWTListener();
        this.addMouseListener(l);
        this.addMouseMotionListener(l);
        this.addKeyListener(l);
    }

    public CursorChanger getCursorChanger() {
        return this.cursorChanger;
    }

    public RunnableQueue getUpdateQueue() {
        return this.updateQueue;
    }

    public void setURI(String uri) {
        if (this.loadingThread != null) {
            this.loadingThread.interrupt();
            this.loadingThread = null;
        }
        this.updateQueue.empty();
        if (this.canvasManager != null) {
            this.updateQueue.unschedule(this.canvasManager.getSampler());
        }
        Rectangle bounds = this.getBounds();
        this.width = bounds.width;
        this.height = bounds.height;
        if (bounds.width == 0) {
            this.width = 1;
        }
        if (bounds.height == 0) {
            this.height = 1;
        }
        this.cursorChanger.setCursorType(0);
        final DocumentNode newDocumentNode = new DocumentNode();
        newDocumentNode.setLoaded(false);
        newDocumentNode.setSize(this.width, this.height);
        this.checkOffscreen();
        CanvasManager newCanvasManager = new CanvasManager(this.rg, newDocumentNode, this);
        newDocumentNode.setUpdateQueue(this.updateQueue);
        newDocumentNode.setRunnableHandler(this);
        ComponentEventDispatcher newDispatcher = new ComponentEventDispatcher(newDocumentNode);
        if (this.documentNode != null) {
            this.documentNode.dispose();
        }
        this.documentNode = newDocumentNode;
        this.dispatcher = newDispatcher;
        this.canvasManager = newCanvasManager;
        this.documentNode.addEventListener("click", this.anchorListener, false);
        this.documentNode.addEventListener("mouseover", this.anchorListener, false);
        this.documentNode.addEventListener("mouseout", this.anchorListener, false);
        this.svgURI = uri;
        if (uri != null) {
            this.loadingThread = new Thread("loadingThread"){

                public void run() {
                    ModelBuilder.loadDocument(null, newDocumentNode, null);
                }
            };
            newDocumentNode.setDocumentURI(uri);
            this.loadingThread.start();
        } else {
            this.canvasManager.updateCanvas();
        }
        this.setZoomPan(1.0f, 0.0f, 0.0f);
    }

    public DocumentNode getDocumentNode() {
        return this.documentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g2d) {
        this.checkOffscreen();
        Object object = this.canvasManager.lock;
        synchronized (object) {
            ((Graphics2D)g2d).setComposite(AlphaComposite.Src);
            g2d.drawImage(this.offscreen, 0, 0, this);
            this.canvasManager.consume();
        }
    }

    public void update(Graphics g) {
    }

    protected void checkOffscreen() {
        if (this.offscreen == null) {
            this.buildOffscreen();
        } else if (this.width > 0 && this.width != this.offscreen.getWidth(null) || this.height > 0 && this.height != this.offscreen.getHeight(null)) {
            this.buildOffscreen();
        }
    }

    protected void buildOffscreen() {
        this.offscreen = this.width > 0 && this.height > 0 ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.width, this.height, 1) : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1, 1);
        this.rg = new RenderGraphics(this.offscreen);
        if (this.canvasManager != null) {
            try {
                this.updateQueue.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = SVGComponent.this.canvasManager.lock;
                        synchronized (object) {
                            SVGComponent.this.documentNode.setSize(SVGComponent.this.width, SVGComponent.this.height);
                            SVGComponent.this.canvasManager.setRenderGraphics(SVGComponent.this.rg);
                            SVGComponent.this.canvasManager.consume();
                        }
                        SVGComponent.this.ignoreCanvasUpdate = true;
                        SVGComponent.this.canvasManager.updateCanvas();
                        SVGComponent.this.ignoreCanvasUpdate = false;
                    }
                }, null);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        } else {
            Graphics2D g = (Graphics2D)this.offscreen.getGraphics();
            g.setPaint(this.getBackground());
            g.fillRect(0, 0, this.offscreen.getWidth(null), this.offscreen.getHeight(null));
        }
    }

    public void setZoomPan(final float s, final float tx, final float ty) {
        this.updateQueue.invokeLater(new Runnable(){

            public void run() {
                Transform txf = new Transform(null);
                txf.mScale(s, s);
                txf.mTranslate(tx, ty);
                SVGComponent.this.documentNode.setTransform(txf);
                SVGComponent.this.currentTranslate[0] = tx;
                SVGComponent.this.currentTranslate[1] = ty;
                SVGComponent.this.currentScale = s;
            }

            public String toString() {
                return "setZoomPan(" + s + ", " + tx + ", " + ty + ")";
            }
        }, this);
    }

    public float[] getZoomPan() {
        final float[] zp = new float[3];
        try {
            this.updateQueue.invokeAndWait(new Runnable(){

                public void run() {
                    zp[0] = SVGComponent.this.currentScale;
                    zp[1] = SVGComponent.this.currentTranslate[0];
                    zp[2] = SVGComponent.this.currentTranslate[1];
                }
            }, this);
        }
        catch (InterruptedException ie) {
            throw new Error();
        }
        return zp;
    }

    public void addZoomPan(final float s, final float dx, final float dy) {
        this.updateQueue.invokeLater(new Runnable(){

            public void run() {
                float so = SVGComponent.this.currentScale;
                float[] curTranslate = new float[]{SVGComponent.this.currentTranslate[0], SVGComponent.this.currentTranslate[1]};
                float tnx = dx * s;
                float tny = dy * s;
                float tox = curTranslate[0] * so;
                float toy = curTranslate[1] * so;
                SVGComponent.this.currentScale = so * s;
                SVGComponent.this.currentTranslate[0] = (so * tnx + tox) / (so * s);
                SVGComponent.this.currentTranslate[1] = (so * tny + toy) / (so * s);
                Transform txf = new Transform(null);
                txf.mScale(SVGComponent.this.currentScale, SVGComponent.this.currentScale);
                txf.mTranslate(SVGComponent.this.currentTranslate[0], SVGComponent.this.currentTranslate[1]);
                SVGComponent.this.documentNode.setTransform(txf);
            }

            public String toString() {
                return "addZoomPan(" + s + ", " + dx + ", " + dy + ")";
            }
        }, this.canvasManager);
    }

    public void setBounds(int x, int y, final int w, final int h) {
        super.setBounds(x, y, w, h);
        if (this.updateQueue != null && this.updateQueue.getQueueState().equals("Running")) {
            this.updateQueue.invokeLater(new Runnable(){

                public void run() {
                    SVGComponent.this.setDocumentSize(w, h);
                }
            }, this.canvasManager);
        } else {
            this.setDocumentSize(w, h);
        }
    }

    void setDocumentSize(int w, int h) {
        this.width = w;
        this.height = h;
        if (this.documentNode != null) {
            this.documentNode.setSize(this.width, this.height);
        }
    }

    public void updateComplete(Object canvasManager) {
        if (!this.ignoreCanvasUpdate) {
            this.repaint();
        }
    }

    public void initialLoadComplete(Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void runnableInvoked(RunnableQueue rq, Runnable r) {
        if (this.isVisible() && this.canvasManager != null) {
            this.canvasManager.runnableInvoked(rq, r);
        }
    }

    public class AWTListener
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        public void mouseClicked(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void dispatchMouseEvent(final MouseEvent e) {
            if (SVGComponent.this.documentNode != null) {
                SVGComponent.this.updateQueue.invokeLater(new Runnable(){

                    public void run() {
                        ((AWTListener)AWTListener.this).SVGComponent.this.dispatcher.dispatchMouseEvent(e);
                    }

                    public String toString() {
                        return "dispatchMouseEvent";
                    }
                }, SVGComponent.this.canvasManager);
            }
        }

        public void dispatchKeyEvent(final KeyEvent e) {
            if (SVGComponent.this.documentNode != null) {
                SVGComponent.this.updateQueue.invokeLater(new Runnable(){

                    public void run() {
                        ((AWTListener)AWTListener.this).SVGComponent.this.dispatcher.dispatchKeyEvent(e);
                    }

                    public String toString() {
                        return "dispatchKeyEvent";
                    }
                }, SVGComponent.this.canvasManager);
            }
        }

        public void mousePressed(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void keyPressed(KeyEvent e) {
            this.dispatchKeyEvent(e);
        }

        public void keyReleased(KeyEvent e) {
            this.dispatchKeyEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            this.dispatchKeyEvent(e);
        }
    }

    public class CursorChanger
    implements Runnable {
        protected int cursorType;
        protected boolean pending = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CursorChanger cursorChanger = this;
            synchronized (cursorChanger) {
                SVGComponent.this.setCursor(Cursor.getPredefinedCursor(this.cursorType));
                this.pending = false;
            }
        }

        public synchronized void setCursorType(int cursorType) {
            this.cursorType = cursorType;
            if (!this.pending) {
                this.pending = true;
                EventQueue.invokeLater(this);
            }
        }
    }

    public class DefaultAnchorListener
    implements EventListener {
        public void handleEvent(Event evt) {
            String href;
            Anchor a = ((ModelEvent)evt).getAnchor();
            String type = evt.getType();
            if (a != null && (href = a.getHref()) != null) {
                if ("click".equals(type)) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            SVGComponent.this.setURI(href);
                        }
                    });
                } else if ("mouseout".equals(type)) {
                    SVGComponent.this.cursorChanger.setCursorType(0);
                } else if ("mouseover".equals(type)) {
                    SVGComponent.this.cursorChanger.setCursorType(12);
                }
            }
        }
    }
}

