/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.io.File;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public final class ConfigureUtils {
    private static final String PREDEFINED_FLAGS_GNU = "\"-g3 -gdwarf-2\"";
    private static final String PREDEFINED_FLAGS_SUN = "-g";

    private ConfigureUtils() {
    }

    public static String findConfigureScript(String string) {
        String[] stringArray = new String[]{"configure"};
        File file = new File(string);
        if (!(file.isDirectory() && file.canRead() && file.canWrite())) {
            return null;
        }
        for (String string2 : stringArray) {
            file = new File(string + File.separator + string2);
            if (!ConfigureUtils.isRunnable(file)) continue;
            return file.getAbsolutePath();
        }
        String string3 = ConfigureUtils.detectQTProject(new File(string));
        if (string3 != null) {
            return string3;
        }
        String string4 = ConfigureUtils.detectCMake(string);
        if (string4 != null) {
            return string4;
        }
        return null;
    }

    private static String detectQTProject(File file) {
        for (File file2 : file.listFiles()) {
            if (!file2.getAbsolutePath().endsWith(".pro")) continue;
            if (AbstractExecutorRunAction.findTools((String)"qmake") == null) break;
            return file2.getAbsolutePath();
        }
        return null;
    }

    private static String detectCMake(String string) {
        File file = new File(string + File.separator + "CMakeLists.txt");
        if (file.exists() && AbstractExecutorRunAction.findTools((String)"cmake") != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static boolean isRunnable(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            DataObject dataObject;
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null || !fileObject.isValid()) {
                return false;
            }
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return false;
            }
            if (dataObject == null) {
                return false;
            }
            Node node = dataObject.getNodeDelegate();
            if (node == null) {
                return false;
            }
            ShellExecSupport shellExecSupport = (ShellExecSupport)node.getCookie(ShellExecSupport.class);
            if (shellExecSupport != null) {
                return true;
            }
            if (file.getAbsolutePath().endsWith("CMakeLists.txt")) {
                return AbstractExecutorRunAction.findTools((String)"cmake") != null;
            }
            if (file.getAbsolutePath().endsWith(".pro")) {
                return AbstractExecutorRunAction.findTools((String)"qmake") != null;
            }
        }
        return false;
    }

    public static String findMakefile(String string) {
        String[] stringArray = new String[]{"GNUmakefile", "makefile", "Makefile"};
        File file = new File(string);
        if (!(file.isDirectory() && file.canRead() && file.canWrite())) {
            return null;
        }
        for (String string2 : stringArray) {
            file = new File(string + File.separator + string2);
            if (!file.exists() || !file.isFile() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    public static String getConfigureArguments(String string, String string2) {
        String string3 = ConfigureUtils.getDefaultC();
        String string4 = ConfigureUtils.getDefaultCpp();
        StringBuilder stringBuilder = new StringBuilder(string2);
        String string5 = ConfigureUtils.getCompilerFlags();
        String string6 = ConfigureUtils.getCompilerFlags();
        if (string.endsWith("CMakeLists.txt")) {
            ConfigureUtils.appendIfNeed("-G ", string2, stringBuilder, "\"Unix Makefiles\"");
            ConfigureUtils.appendIfNeed("-DCMAKE_BUILD_TYPE=", string2, stringBuilder, "Debug");
            ConfigureUtils.appendIfNeed("-DCMAKE_C_COMPILER=", string2, stringBuilder, string3);
            ConfigureUtils.appendIfNeed("-DCMAKE_CXX_COMPILER=", string2, stringBuilder, string4);
            ConfigureUtils.appendIfNeed("-DCMAKE_C_FLAGS_DEBUG=", string2, stringBuilder, string5);
            ConfigureUtils.appendIfNeed("-DCMAKE_CXX_FLAGS_DEBUG=", string2, stringBuilder, string6);
        } else if (string.endsWith(".pro")) {
            if (ConfigureUtils.isSunStodio() && Utilities.getOperatingSystem() == 8) {
                ConfigureUtils.appendIfNeed("-spec ", string2, stringBuilder, "solaris-cc");
            }
            ConfigureUtils.appendIfNeed("QMAKE_CC=", string2, stringBuilder, string3);
            ConfigureUtils.appendIfNeed("QMAKE_CXX=", string2, stringBuilder, string4);
            ConfigureUtils.appendIfNeed("QMAKE_CFLAGS=", string2, stringBuilder, string5);
            ConfigureUtils.appendIfNeed("QMAKE_CXXFLAGS=", string2, stringBuilder, string6);
        } else {
            ConfigureUtils.appendIfNeed("CC=", string2, stringBuilder, string3);
            ConfigureUtils.appendIfNeed("CXX=", string2, stringBuilder, string4);
            ConfigureUtils.appendIfNeed("CFLAGS=", string2, stringBuilder, string5);
            ConfigureUtils.appendIfNeed("CXXFLAGS=", string2, stringBuilder, string6);
        }
        return stringBuilder.toString();
    }

    private static void appendIfNeed(String string, String string2, StringBuilder stringBuilder, String string3) {
        if (string2.indexOf(string) < 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string + string3);
        }
    }

    private static boolean isSunStodio() {
        CompilerSet.CompilerFlavor compilerFlavor;
        CompilerSet compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)CompilerSetManager.getDefaultExecutionEnvironment()).getDefaultCompilerSet();
        return compilerSet != null && (compilerFlavor = compilerSet.getCompilerFlavor()).isSunStudioCompiler();
    }

    private static String getDefaultC() {
        CompilerSet.CompilerFlavor compilerFlavor;
        CompilerSet compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)CompilerSetManager.getDefaultExecutionEnvironment()).getDefaultCompilerSet();
        String string = ConfigureUtils.getToolPath(compilerSet, 0);
        if (string != null) {
            return string;
        }
        string = "gcc";
        if (compilerSet != null && (compilerFlavor = compilerSet.getCompilerFlavor()).isSunStudioCompiler()) {
            string = "cc";
        }
        return string;
    }

    private static String getDefaultCpp() {
        CompilerSet.CompilerFlavor compilerFlavor;
        CompilerSet compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)CompilerSetManager.getDefaultExecutionEnvironment()).getDefaultCompilerSet();
        String string = ConfigureUtils.getToolPath(compilerSet, 1);
        if (string != null) {
            return string;
        }
        string = "g++";
        if (compilerSet != null && (compilerFlavor = compilerSet.getCompilerFlavor()).isSunStudioCompiler()) {
            string = "CC";
        }
        return string;
    }

    private static String getToolPath(CompilerSet compilerSet, int n) {
        if (compilerSet == null) {
            return null;
        }
        Tool tool = compilerSet.findTool(n);
        if (tool == null) {
            return null;
        }
        return ConfigureUtils.escapeFlags(tool.getPath());
    }

    private static String escapeFlags(String string) {
        if (!(string.indexOf(32) <= 0 && string.indexOf(61) <= 0 || string.startsWith("\""))) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    private static String getCompilerFlags() {
        CompilerSet.CompilerFlavor compilerFlavor;
        CompilerSet compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)CompilerSetManager.getDefaultExecutionEnvironment()).getDefaultCompilerSet();
        if (compilerSet != null && (compilerFlavor = compilerSet.getCompilerFlavor()).isSunStudioCompiler()) {
            return PREDEFINED_FLAGS_SUN;
        }
        return PREDEFINED_FLAGS_GNU;
    }
}

