/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListEditorPanel<E>
extends JPanel {
    private JList targetList = null;
    protected Vector<E> listData = new Vector();
    private boolean allowedToRemoveAll = true;
    protected JButton[] extraButtons;
    private boolean isChanged = false;
    private JButton addButton;
    private JPanel controlsPanel;
    private JButton copyButton;
    private JPanel dataPanel;
    private JButton defaultButton;
    private JButton downButton;
    private JLabel listLabel;
    private JButton removeButton;
    private JButton renameButton;
    private JScrollPane scrollPane;
    private JButton upButton;

    public ListEditorPanel(List<E> list) {
        this(list, null);
    }

    public ListEditorPanel(List<E> list, JButton[] jButtonArray) {
        int n;
        this.initComponents();
        this.extraButtons = jButtonArray;
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.listLabel.setText(this.getListLabelText());
        this.listLabel.setDisplayedMnemonic(this.getListLabelMnemonic());
        this.addButton.setText(this.getAddButtonText());
        this.addButton.setMnemonic(this.getAddButtonMnemonics());
        this.addButton.getAccessibleContext().setAccessibleDescription(this.getAddButtonAD());
        this.copyButton.setText(this.getCopyButtonText());
        this.copyButton.setMnemonic(this.getCopyButtonMnemonics());
        this.copyButton.getAccessibleContext().setAccessibleDescription(this.getCopyButtonAD());
        this.renameButton.setText(this.getRenameButtonText());
        this.renameButton.setMnemonic(this.getRenameButtonMnemonics());
        this.renameButton.getAccessibleContext().setAccessibleDescription(this.getRenameButtonAD());
        this.removeButton.setText(this.getRemoveButtonText());
        this.removeButton.setMnemonic(this.getRemoveButtonMnemonics());
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getRemoveButtonAD());
        this.upButton.setText(this.getUpButtonText());
        this.upButton.setMnemonic(this.getUpButtonMnemonics());
        this.upButton.getAccessibleContext().setAccessibleDescription(this.getUpButtonAD());
        this.downButton.setText(this.getDownButtonText());
        this.downButton.setMnemonic(this.getDownButtonMnemonics());
        this.downButton.getAccessibleContext().setAccessibleDescription(this.getDownButtonAD());
        this.defaultButton.setText(this.getDefaultButtonText());
        this.defaultButton.setMnemonic(this.getDefaultButtonMnemonics());
        this.defaultButton.getAccessibleContext().setAccessibleDescription(this.getDefaultButtonAD());
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                this.listData.add(list.get(n));
            }
        }
        this.targetList = new JList();
        this.targetList.setVisibleRowCount(6);
        this.targetList.setListData(this.listData);
        this.targetList.addListSelectionListener(new TargetSelectionListener());
        this.targetList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object[] objectArray = ListEditorPanel.this.targetList.getSelectedValues();
                if (objectArray.length != 1) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2) {
                    mouseEvent.consume();
                    ListEditorPanel.this.editObjectAction();
                }
            }
        });
        this.targetList.getSelectionModel().setSelectionMode(0);
        this.scrollPane.setViewportView(this.getViewComponent());
        this.listLabel.setLabelFor(this.targetList);
        this.initAccessibility();
        if (this.targetList.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.targetList.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
        if (jButtonArray != null) {
            n = 1;
            for (int i = 0; i < jButtonArray.length; ++i) {
                this.addExtraButton(jButtonArray[i], n++);
            }
        }
        this.checkSelection();
    }

    public void addExtraButton(JButton jButton, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add(jButton, gridBagConstraints, n);
    }

    public void setAllowedToRemoveAll(boolean bl) {
        this.allowedToRemoveAll = bl;
        this.checkSelection();
    }

    public boolean getAllowedToRemoveAll() {
        return this.allowedToRemoveAll;
    }

    public JLabel getListLabel() {
        return this.listLabel;
    }

    public String getListLabelText() {
        return ListEditorPanel.getString("TARGET_EDITOR_LIST_LBL");
    }

    public char getListLabelMnemonic() {
        return ListEditorPanel.getString("TARGET_EDITOR_LIST_MNEMONIC").toCharArray()[0];
    }

    public String getAddButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_ADD_BUTTON_LBL");
    }

    public char getAddButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_ADD_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getAddButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_ADD_BUTTON_AD");
    }

    public String getCopyButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_COPY_BUTTON_LBL");
    }

    public char getCopyButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_COPY_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getCopyButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_COPY_BUTTON_AD");
    }

    public String getRenameButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_RENAME_BUTTON_LBL");
    }

    public char getRenameButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_RENAME_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getRenameButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_RENAME_BUTTON_AD");
    }

    public String getRemoveButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_REMOVE_BUTTON_LBL");
    }

    public char getRemoveButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_REMOVE_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getRemoveButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_REMOVE_BUTTON_AD");
    }

    public String getUpButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_UP_BUTTON_LBL");
    }

    public char getUpButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_UP_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getUpButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_UP_BUTTON_AD");
    }

    public String getDownButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_DOWN_BUTTON_LBL");
    }

    public char getDownButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_DOWN_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getDownButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_DOWN_BUTTON_AD");
    }

    public String getDefaultButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_DEFAULT_BUTTON_LBL");
    }

    public char getDefaultButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_DEFAULT_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getDefaultButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_DEFAULT_BUTTON_AD");
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getCopyButton() {
        return this.copyButton;
    }

    public JButton getEditButton() {
        return this.renameButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.listLabel.setEnabled(bl);
        this.targetList.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.copyButton.setEnabled(bl);
        this.renameButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
        this.defaultButton.setEnabled(bl);
    }

    private void initAccessibility() {
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_EDITOR"));
        accessibleContext.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_EDITOR"));
        accessibleContext = this.targetList.getAccessibleContext();
        accessibleContext.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        accessibleContext.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
        accessibleContext = this.scrollPane.getAccessibleContext();
        accessibleContext.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        accessibleContext.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
        accessibleContext = this.scrollPane.getHorizontalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        accessibleContext.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
        accessibleContext = this.scrollPane.getVerticalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        accessibleContext.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.listLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.controlsPanel = new JPanel();
        this.addButton = new JButton();
        this.copyButton = new JButton();
        this.renameButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.defaultButton = new JButton();
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        this.dataPanel.setRequestFocusEnabled(false);
        this.dataPanel.setLayout(new GridBagLayout());
        this.listLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("TARGET_EDITOR_LIST_MNEMONIC").charAt(0));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle");
        this.listLabel.setText(resourceBundle.getString("TARGET_EDITOR_LIST_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.dataPanel.add((Component)this.listLabel, gridBagConstraints);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.dataPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.controlsPanel.setOpaque(false);
        this.controlsPanel.setRequestFocusEnabled(false);
        this.controlsPanel.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("TARGET_EDITOR_ADD_BUTTON_MNEMONIC").charAt(0));
        this.addButton.setText(resourceBundle.getString("TARGET_EDITOR_ADD_BUTTON_LBL"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add((Component)this.addButton, gridBagConstraints);
        this.copyButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("TARGET_EDITOR_COPY_BUTTON_MNEMONIC").charAt(0));
        this.copyButton.setText(resourceBundle.getString("TARGET_EDITOR_COPY_BUTTON_LBL"));
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorPanel.this.copyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.controlsPanel.add((Component)this.copyButton, gridBagConstraints);
        this.renameButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("TARGET_EDITOR_RENAME_BUTTON_MNEMONIC").charAt(0));
        this.renameButton.setText(resourceBundle.getString("TARGET_EDITOR_RENAME_BUTTON_LBL"));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorPanel.this.renameButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add((Component)this.renameButton, gridBagConstraints);
        this.removeButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("TARGET_EDITOR_REMOVE_BUTTON_MNEMONIC").charAt(0));
        this.removeButton.setText(resourceBundle.getString("TARGET_EDITOR_REMOVE_BUTTON_LBL"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.controlsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.upButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("TARGET_EDITOR_UP_BUTTON_MNEMONIC").charAt(0));
        this.upButton.setText(resourceBundle.getString("TARGET_EDITOR_UP_BUTTON_LBL"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorPanel.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("TARGET_EDITOR_DOWN_BUTTON_MNEMONIC").charAt(0));
        this.downButton.setText(resourceBundle.getString("TARGET_EDITOR_DOWN_BUTTON_LBL"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorPanel.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.controlsPanel.add((Component)this.downButton, gridBagConstraints);
        this.defaultButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("TARGET_EDITOR_DEFAULT_BUTTON_MNEMONIC").charAt(0));
        this.defaultButton.setText(resourceBundle.getString("TARGET_EDITOR_DEFAULT_BUTTON_LBL"));
        this.defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorPanel.this.defaultButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.controlsPanel.add((Component)this.defaultButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.dataPanel.add((Component)this.controlsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.dataPanel, gridBagConstraints);
    }

    public void defaultAction(E e) {
    }

    private void defaultObjectAction() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (n >= this.listData.size()) {
            return;
        }
        this.defaultAction(this.listData.elementAt(n));
        this.isChanged = true;
        this.setData(this.listData);
        this.setSelectedIndex(n);
        this.defaultButton.requestFocus();
        this.checkSelection();
        this.defaultButton.requestFocus();
    }

    private void defaultButtonActionPerformed(ActionEvent actionEvent) {
        this.defaultObjectAction();
    }

    public void editAction(E e) {
    }

    private void editObjectAction() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (n >= this.listData.size()) {
            return;
        }
        this.editAction(this.listData.elementAt(n));
        this.isChanged = true;
        this.setData(this.listData);
        this.setSelectedIndex(n);
        this.renameButton.requestFocus();
        this.checkSelection();
        this.renameButton.requestFocus();
    }

    private void renameButtonActionPerformed(ActionEvent actionEvent) {
        this.editObjectAction();
    }

    public E copyAction(E e) {
        return null;
    }

    private void copyObjectAction() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (n >= this.listData.size()) {
            return;
        }
        E e = this.copyAction(this.listData.elementAt(n));
        if (e == null) {
            return;
        }
        this.isChanged = true;
        int n2 = this.listData.size();
        this.listData.add(n2, e);
        this.setData(this.listData);
        this.setSelectedIndex(n2);
        this.copyButton.requestFocus();
        this.checkSelection();
        this.copyButton.requestFocus();
    }

    private void copyButtonActionPerformed(ActionEvent actionEvent) {
        this.copyObjectAction();
    }

    private void downAction() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (n >= this.listData.size() - 1) {
            return;
        }
        this.isChanged = true;
        E e = this.listData.elementAt(n);
        this.listData.removeElementAt(n);
        this.listData.add(++n, e);
        this.setData(this.listData);
        if (n >= 0) {
            this.ensureIndexIsVisible(n);
            this.checkSelection(n);
            this.setSelectedIndex(n);
        } else {
            this.checkSelection();
        }
        if (this.downButton.isEnabled()) {
            this.downButton.requestFocus();
        } else {
            this.upButton.requestFocus();
        }
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        this.downAction();
    }

    private void upAction() {
        int n = this.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        this.isChanged = true;
        E e = this.listData.elementAt(n);
        this.listData.removeElementAt(n);
        this.listData.add(--n, e);
        this.setData(this.listData);
        if (n >= 0) {
            this.ensureIndexIsVisible(n);
            this.checkSelection(n);
            this.setSelectedIndex(n);
        } else {
            this.checkSelection();
        }
        if (this.upButton.isEnabled()) {
            this.upButton.requestFocus();
        } else {
            this.downButton.requestFocus();
        }
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        this.upAction();
    }

    public void removeAction(E e) {
    }

    private void removeObjectAction() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.removeAction(this.listData.elementAt(n));
        this.isChanged = true;
        this.listData.removeElementAt(n);
        this.setData(this.listData);
        int n2 = n = n >= this.listData.size() ? n - 1 : n;
        if (n >= 0) {
            this.ensureIndexIsVisible(n);
            this.checkSelection(n);
            this.setSelectedIndex(n);
        } else {
            this.checkSelection();
        }
        if (this.removeButton.isEnabled()) {
            this.removeButton.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.removeObjectAction();
    }

    public E addAction() {
        return null;
    }

    private void addObjectAction() {
        this.addObjectAction(this.addAction());
    }

    public void addObjectAction(E e) {
        if (e == null) {
            return;
        }
        ArrayList<E> arrayList = new ArrayList<E>();
        arrayList.add(e);
        this.addObjectsAction(arrayList);
    }

    public void addObjectsAction(List<E> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        this.isChanged = true;
        int n = this.listData.size();
        Vector<E> vector = new Vector<E>();
        vector.addAll(this.listData);
        vector.addAll(list);
        this.listData = vector;
        this.setData(this.listData);
        this.setSelectedIndex(n);
        this.ensureIndexIsVisible(n);
        this.checkSelection();
        this.addButton.requestFocus();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.addObjectAction();
    }

    public JPanel getDataPanel() {
        return this.dataPanel;
    }

    protected void checkSelection() {
        this.checkSelection(this.getSelectedIndex());
    }

    protected void checkSelection(int n) {
        if (n >= 0 && this.listData.size() > 0) {
            this.addButton.setEnabled(true);
            this.copyButton.setEnabled(true);
            this.renameButton.setEnabled(true);
            if (this.allowedToRemoveAll) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(this.listData.size() > 1);
            }
            this.upButton.setEnabled(n != 0);
            this.downButton.setEnabled(n < this.listData.size() - 1);
            this.defaultButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(true);
            this.copyButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.defaultButton.setEnabled(false);
        }
    }

    public Vector<E> getListData() {
        return this.listData;
    }

    public void setListData(List<E> list) {
        this.listData.removeAllElements();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.listData.add(list.get(i));
            }
        }
        this.setData(this.listData);
        if (this.listData.size() > 0) {
            this.setSelectedIndex(0);
        }
        this.addButton.requestFocus();
        this.checkSelection();
        this.addButton.requestFocus();
    }

    public int getSelectedIndex() {
        int n = this.targetList.getSelectedIndex();
        if (n >= 0 && n < this.listData.size()) {
            return n;
        }
        return 0;
    }

    protected void setSelectedIndex(int n) {
        this.targetList.setSelectedIndex(n);
    }

    protected void setData(Vector vector) {
        this.targetList.setListData(vector);
    }

    protected void ensureIndexIsVisible(int n) {
        this.targetList.ensureIndexIsVisible(n);
    }

    protected Component getViewComponent() {
        return this.targetList;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ListEditorPanel.class, (String)string);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isDataValid() {
        return true;
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListEditorPanel.this.checkSelection();
        }
    }
}

