/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManagerEvents;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configurations {
    public static final String PROP_ACTIVE_CONFIGURATION = "activeconfiguration";
    private final PropertyChangeSupport pcs;
    private final List<Configuration> configurations = new ArrayList<Configuration>();
    private final ReadWriteLock configurationsLock = new ReentrantReadWriteLock();
    private final List<Runnable> tasks = new ArrayList<Runnable>();

    public Configurations() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configurations init(Configuration[] configurationArray, int n) {
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        Configuration configuration = null;
        this.configurationsLock.writeLock().lock();
        try {
            this.configurations.clear();
            if (configurationArray != null) {
                int n2 = 0;
                for (int i = 0; i < configurationArray.length; ++i) {
                    if (configurationArray[i] != null) {
                        this.configurations.add(configurationArray[i]);
                        if (n2 == n) {
                            configurationArray[i].setDefault(true);
                            configuration = configurationArray[i];
                        } else {
                            configurationArray[i].setDefault(false);
                        }
                        ++n2;
                        continue;
                    }
                    new Exception("Configuration[" + i + "]==null").printStackTrace();
                }
                if (configuration != null) {
                    arrayList.addAll(this.tasks);
                    this.tasks.clear();
                }
            }
        }
        finally {
            this.configurationsLock.writeLock().unlock();
        }
        for (Runnable runnable : arrayList) {
            this.runOnCodeModelReadiness(runnable, false);
        }
        return this;
    }

    public void runOnCodeModelReadiness(Runnable runnable) {
        this.runOnCodeModelReadiness(runnable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnCodeModelReadiness(Runnable runnable, boolean bl) {
        MakeConfiguration makeConfiguration = null;
        this.configurationsLock.writeLock().lock();
        try {
            makeConfiguration = (MakeConfiguration)this.getActive();
            if (makeConfiguration == null && bl) {
                this.tasks.add(runnable);
            }
        }
        finally {
            this.configurationsLock.writeLock().unlock();
        }
        if (makeConfiguration != null) {
            DevelopmentHostConfiguration developmentHostConfiguration = makeConfiguration.getDevelopmentHost();
            CompilerSetManagerEvents.get((ExecutionEnvironment)developmentHostConfiguration.getExecutionEnvironment()).runOnCodeModelReadiness(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.configurationsLock.readLock().lock();
        try {
            int n = this.configurations.size();
            return n;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration[] getConfs() {
        this.configurationsLock.readLock().lock();
        try {
            Configuration[] configurationArray = this.configurations.toArray(new Configuration[this.size()]);
            return configurationArray;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Configuration> getConfigurtions() {
        this.configurationsLock.readLock().lock();
        try {
            ArrayList<Configuration> arrayList = new ArrayList<Configuration>(this.configurations);
            return arrayList;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Configuration> getConfsAsCollection() {
        LinkedHashSet<Configuration> linkedHashSet = new LinkedHashSet<Configuration>();
        this.configurationsLock.readLock().lock();
        try {
            linkedHashSet.addAll(this.configurations);
            LinkedHashSet<Configuration> linkedHashSet2 = linkedHashSet;
            return linkedHashSet2;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration[] getClonedConfs() {
        this.configurationsLock.readLock().lock();
        try {
            Configuration[] configurationArray = new Configuration[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                Configuration configuration = this.configurations.get(i);
                configurationArray[i] = configuration.cloneConf();
            }
            Configuration[] configurationArray2 = configurationArray;
            return configurationArray2;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConfsAsDisplayNames() {
        this.configurationsLock.readLock().lock();
        try {
            String[] stringArray = new String[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                Configuration configuration = this.configurations.get(i);
                stringArray[i] = configuration.toString();
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConfsAsNames() {
        this.configurationsLock.readLock().lock();
        try {
            String[] stringArray = new String[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                Configuration configuration = this.configurations.get(i);
                stringArray[i] = configuration.getName();
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConf(int n) {
        this.configurationsLock.readLock().lock();
        try {
            if (this.checkValidIndex(n)) {
                Configuration configuration = this.configurations.get(n);
                return configuration;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfByDisplayName(String string) {
        Configuration configuration = null;
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration configuration2 : this.configurations) {
                if (!configuration2.getDisplayName().equals(string)) continue;
                configuration = configuration2;
                break;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConf(String string) {
        Configuration configuration = null;
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration configuration2 : this.configurations) {
                if (!configuration2.getName().equals(string)) continue;
                configuration = configuration2;
                break;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(Configuration configuration) {
        Configuration configuration2;
        if (configuration == null) {
            return;
        }
        boolean bl = false;
        this.configurationsLock.readLock().lock();
        try {
            configuration2 = this.getActive();
            if (configuration == configuration2) {
                return;
            }
            for (Configuration configuration3 : this.configurations) {
                configuration3.setDefault(false);
                if (configuration3 != configuration) continue;
                configuration.setDefault(true);
                bl = true;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        if (bl) {
            this.pcs.firePropertyChange(PROP_ACTIVE_CONFIGURATION, configuration2, configuration);
        }
    }

    public void setActive(String string) {
        this.setActive(this.getConf(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(int n) {
        Configuration configuration;
        Configuration configuration2;
        if (n < 0) {
            return;
        }
        this.configurationsLock.readLock().lock();
        try {
            configuration2 = this.getActive();
            if (!this.checkValidIndex(n)) {
                return;
            }
            configuration = this.configurations.get(n);
            if (configuration != null) {
                for (Configuration configuration3 : this.configurations) {
                    configuration3.setDefault(false);
                }
                configuration.setDefault(true);
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        this.pcs.firePropertyChange(PROP_ACTIVE_CONFIGURATION, configuration2, configuration);
    }

    public void fireChangedActiveConfiguration(Configuration configuration, Configuration configuration2) {
        this.pcs.firePropertyChange(PROP_ACTIVE_CONFIGURATION, configuration, configuration2);
    }

    public String getActiveDisplayName() {
        String string = null;
        Configuration configuration = this.getActive();
        if (configuration != null) {
            string = configuration.getDisplayName();
        }
        return string;
    }

    public Configuration getDefault() {
        return this.getActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getActive() {
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration configuration : this.configurations) {
                if (!configuration.isDefault()) continue;
                Configuration configuration2 = configuration;
                return configuration2;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveAsIndex() {
        this.configurationsLock.readLock().lock();
        try {
            int n = -1;
            for (Configuration configuration : this.configurations) {
                ++n;
                if (!configuration.isDefault()) continue;
                int n2 = n;
                return n2;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return -1;
    }

    private boolean checkValidIndex(int n) {
        if (n < 0 || n >= this.size()) {
            new ArrayIndexOutOfBoundsException(n).printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configurations cloneConfs() {
        Configurations configurations = new Configurations();
        this.configurationsLock.readLock().lock();
        try {
            configurations.init(this.getClonedConfs(), this.getActiveAsIndex());
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return configurations;
    }
}

