/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.PlatformConvertor;
import org.netbeans.modules.mobility.cldcplatform.UEIEmulatorConfiguratorImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class J2MEPlatform
extends JavaPlatform {
    public static final String SPECIFICATION_NAME = "j2me";
    private static final String URL_SEPARATOR = ",";
    private static final String PATH_SEPARATOR = ":";
    public static final String PLATFORM_STRING_PREFIX = "${platform.home}/";
    private ClassPath bootstrapLibs;
    private ClassPath standardLibs;
    private Specification spec;
    private String name;
    private final String type;
    private String preverifyCmd;
    private String runCmd;
    private String debugCmd;
    private Device[] devices;
    private final File homeFile;
    private FileObject home;
    private String displayName;
    private List<URL> javadocs;
    private ClassPath sources;

    public J2MEPlatform(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Device[] deviceArray) {
        assert (string != null);
        this.name = string;
        assert (string2 != null);
        this.homeFile = FileUtil.normalizeFile((File)new File(string2));
        this.home = FileUtil.toFileObject((File)this.homeFile);
        assert (string3 != null);
        this.type = string3;
        this.displayName = string4 == null ? string : string4;
        this.preverifyCmd = string7;
        this.runCmd = string8;
        this.debugCmd = string9;
        assert (deviceArray != null);
        assert (deviceArray.length > 0);
        this.devices = deviceArray;
        this.sources = ClassPathSupport.createClassPath((FileObject[])this.resolveRelativePathToFileObjects(string5).toArray(new FileObject[0]));
        this.javadocs = this.resolveRelativePathToURLs(string6);
    }

    public Device[] getDevices() {
        return this.devices == null ? null : (Device[])this.devices.clone();
    }

    public synchronized void setDevices(Device[] deviceArray) {
        this.devices = deviceArray;
        this.spec = null;
        this.bootstrapLibs = ClassPathSupport.createClassPath((FileObject[])this.getAllLibraries());
        this.firePropertyChange("devices", null, null);
        this.firePropertyChange("bootstrapLibraries", null, null);
    }

    private List<URL> resolveRelativePathToURLs(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (string == null) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, URL_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            URL uRL = this.resolveRelativePathToURL(stringTokenizer.nextToken().trim());
            if (uRL == null) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }

    private URL getURL(String string) throws MalformedURLException {
        try {
            URL uRL = new URL(string);
            if (string.equals(uRL.toExternalForm())) {
                return uRL;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return (string.startsWith(PLATFORM_STRING_PREFIX) ? new File(this.homeFile, string.substring(PLATFORM_STRING_PREFIX.length())) : new File(string)).toURI().toURL();
    }

    public URL resolveRelativePathToURL(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        try {
            URL uRL = this.getURL(string);
            if (!FileUtil.isArchiveFile((URL)uRL)) {
                String string2 = uRL.toExternalForm();
                if (string2.endsWith("/")) {
                    return uRL;
                }
                return new URL(string2 + '/');
            }
            return FileUtil.getArchiveRoot((URL)uRL);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static URL localfilepath2url(String string) {
        try {
            return new File(string).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static URL localfilepath2url(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    private List<FileObject> resolveRelativePathToFileObjects(String string) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (string == null) {
            return new ArrayList<FileObject>();
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string);
        for (int i = 0; i < stringArray.length; ++i) {
            FileObject fileObject = this.resolveRelativePathToFileObject(stringArray[i].trim());
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public FileObject resolveRelativePathToFileObject(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        File file = string.startsWith(PLATFORM_STRING_PREFIX) ? new File(this.homeFile, string.substring(PLATFORM_STRING_PREFIX.length())) : new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
        if (fileObject == null || !FileUtil.isArchiveFile((FileObject)fileObject)) {
            return fileObject;
        }
        return FileUtil.getArchiveRoot((FileObject)fileObject);
    }

    public static String getFilePath(FileObject fileObject) {
        File file;
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = FileUtil.getArchiveFile((FileObject)fileObject);
        if (fileObject2 == null) {
            fileObject2 = fileObject;
        }
        return (file = FileUtil.toFile((FileObject)fileObject2)) != null ? file.getAbsolutePath() : null;
    }

    public String getAllLibrariesString() {
        FileObject[] fileObjectArray = this.getAllLibraries();
        if (fileObjectArray == null || fileObjectArray.length <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string = J2MEPlatform.getFilePath(fileObjectArray[i]);
            if (string == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(':');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public ClassPath getStandardLibraries() {
        if (this.standardLibs == null) {
            this.standardLibs = ClassPathSupport.createClassPath(new ArrayList());
        }
        return this.standardLibs;
    }

    public ClassPath getBootstrapLibraries() {
        if (this.bootstrapLibs == null) {
            this.bootstrapLibs = ClassPathSupport.createClassPath((FileObject[])this.getAllLibraries());
        }
        return this.bootstrapLibs;
    }

    private FileObject[] getAllLibraries() {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (int i = 0; i < this.devices.length; ++i) {
            J2MEProfile[] j2MEProfileArray = this.devices[i].getProfiles();
            for (int j = 0; j < j2MEProfileArray.length; ++j) {
                hashSet.addAll(this.resolveRelativePathToFileObjects(j2MEProfileArray[j].getClassPath()));
            }
        }
        return hashSet.toArray(new FileObject[hashSet.size()]);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getVendor() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPreverifyCmd() {
        return this.preverifyCmd;
    }

    public String getRunCmd() {
        return this.runCmd;
    }

    public String getDebugCmd() {
        return this.debugCmd;
    }

    public String getHomePath() {
        return this.homeFile.getAbsolutePath();
    }

    public Collection<FileObject> getInstallFolders() {
        if (this.home == null) {
            this.home = FileUtil.toFileObject((File)this.homeFile);
        }
        return this.home != null && this.home.isValid() && this.home.isFolder() ? Collections.singleton(this.home) : Collections.EMPTY_SET;
    }

    public List<URL> getJavadocFolders() {
        return Collections.unmodifiableList(this.javadocs);
    }

    public void setJavadocFolders(List<URL> list) {
        this.javadocs = new ArrayList<URL>(list);
        this.firePropertyChange("javadocFolders", null, null);
    }

    private String toRelativePaths(List<? extends Object> list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.homeFile.getAbsolutePath();
        if (Utilities.isWindows()) {
            string = "/" + string.toLowerCase().replace('\\', '/');
        }
        for (Object object : list) {
            Object object2;
            Object object3;
            if (object instanceof FileObject) {
                object3 = FileUtil.getArchiveFile((FileObject)((FileObject)object));
                if (object3 == null) {
                    object3 = (FileObject)object;
                }
                if (this.home != null && FileUtil.isParentOf((FileObject)this.home, (FileObject)object3)) {
                    object2 = FileUtil.getRelativePath((FileObject)this.home, (FileObject)object3);
                    if (object2 == null) continue;
                    if (((String)object2).startsWith("\\") || ((String)object2).startsWith("/")) {
                        object2 = ((String)object2).substring(1);
                    }
                    stringBuffer.append(PLATFORM_STRING_PREFIX).append((String)object2).append(PATH_SEPARATOR);
                    continue;
                }
                object2 = FileUtil.toFile((FileObject)object3);
                if (object2 == null) continue;
                stringBuffer.append(((File)object2).getAbsolutePath()).append(PATH_SEPARATOR);
                continue;
            }
            if (!(object instanceof URL)) continue;
            object3 = (URL)object;
            try {
                object2 = URLMapper.findFileObject((URL)object3);
                if (object2 != null && this.home != null && FileUtil.isParentOf((FileObject)this.home, (FileObject)object2)) {
                    String string2 = FileUtil.getRelativePath((FileObject)this.home, (FileObject)object2);
                    if (string2 == null) continue;
                    if (string2.startsWith("\\") || string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                    stringBuffer.append(PLATFORM_STRING_PREFIX).append(string2).append(URL_SEPARATOR);
                    continue;
                }
                stringBuffer.append(((URL)object3).toString()).append(URL_SEPARATOR);
            }
            catch (Exception exception) {}
        }
        return stringBuffer.toString();
    }

    public String getJavadocPath() {
        return this.toRelativePaths(this.javadocs);
    }

    public ClassPath getSourceFolders() {
        return this.sources;
    }

    public void setSourceFolders(List<FileObject> list) {
        this.sources = ClassPathSupport.createClassPath((FileObject[])list.toArray(new FileObject[list.size()]));
        this.firePropertyChange("sourceFolders", null, null);
    }

    public String getSourcePath() {
        return this.toRelativePaths(Arrays.asList(this.sources.getRoots()));
    }

    public Map<String, String> getProperties() {
        return Collections.singletonMap("platform.ant.name", this.getName());
    }

    public synchronized Specification getSpecification() {
        if (this.spec == null) {
            HashSet<J2MEProfile> hashSet = new HashSet<J2MEProfile>();
            for (int i = 0; i < this.devices.length; ++i) {
                J2MEProfile[] j2MEProfileArray = this.devices[i].getProfiles();
                for (int j = 0; j < j2MEProfileArray.length; ++j) {
                    hashSet.add(j2MEProfileArray[j]);
                }
            }
            this.spec = new Specification(SPECIFICATION_NAME, null, hashSet.toArray(new Profile[hashSet.size()]));
        }
        return this.spec;
    }

    public boolean isValid() {
        if (this.getInstallFolders().size() == 0 || this.devices == null) {
            return false;
        }
        for (int i = 0; i < this.devices.length; ++i) {
            if (!this.devices[i].isValid()) continue;
            return true;
        }
        return false;
    }

    public static FileObject getSubFileObject(FileObject fileObject, String string) {
        if (fileObject == null || string == null) {
            return null;
        }
        if (Utilities.isWindows()) {
            string = string + ".exe";
            FileObject[] fileObjectArray = fileObject.getChildren();
            if (fileObjectArray != null) {
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (!string.equalsIgnoreCase(fileObjectArray[i].getNameExt())) continue;
                    return fileObjectArray[i];
                }
            }
            return null;
        }
        return fileObject.getFileObject(string);
    }

    public static FileObject findTool(String string, Collection<FileObject> collection) {
        assert (string != null);
        for (FileObject fileObject : collection) {
            FileObject fileObject2;
            FileObject fileObject3 = fileObject.getFileObject("bin");
            if (fileObject3 == null || (fileObject2 = J2MEPlatform.getSubFileObject(fileObject3, string)) == null) continue;
            return fileObject2;
        }
        return null;
    }

    public FileObject findTool(String string) {
        return J2MEPlatform.findTool(string, this.getInstallFolders());
    }

    public static DataObject createPlatform(String string) throws IOException {
        J2MEPlatform j2MEPlatform = new UEIEmulatorConfiguratorImpl(string).getPlatform();
        return j2MEPlatform == null ? null : J2MEPlatform.createPlatform(j2MEPlatform);
    }

    public static DataObject createPlatform(J2MEPlatform j2MEPlatform) throws IOException {
        String string = j2MEPlatform.getName();
        FileObject fileObject = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        if (fileObject.getFileObject(string, "xml") != null) {
            return null;
        }
        return PlatformConvertor.create(j2MEPlatform, DataFolder.findFolder((FileObject)fileObject), string);
    }

    public static String computeUniqueName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public void setRunCmd(String string) {
        String string2 = this.runCmd;
        this.runCmd = string;
        this.firePropertyChange("runCmd", string2, string);
    }

    public void setPreverifyCmd(String string) {
        String string2 = this.preverifyCmd;
        this.preverifyCmd = string;
        this.firePropertyChange("preverifyCmd", string2, string);
    }

    public void setDebugCmd(String string) {
        String string2 = this.debugCmd;
        this.debugCmd = string;
        this.firePropertyChange("debugCmd", string2, string);
    }

    public static final class J2MEProfile
    extends Profile
    implements Comparable {
        public static final String TYPE_CONFIGURATION = "configuration";
        public static final String TYPE_PROFILE = "profile";
        public static final String TYPE_OPTIONAL = "optional";
        private static final MessageFormat DISPLAY_NAME_WITH_VERSION_FORMAT = new MessageFormat(NbBundle.getMessage(J2MEPlatform.class, (String)"FMT_J2MEPlatform_J2MEProfile_DisplayNameWithVersion"));
        private final String displayName;
        private final String displayNameWithVersion;
        private final String type;
        private final String dependencies;
        private final String classPath;
        private final boolean def;
        boolean realyOptional;

        public J2MEProfile(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
            this(string, new SpecificationVersion(string2), string3, string4, string5, string6, bl);
        }

        J2MEProfile(String string, SpecificationVersion specificationVersion, String string2, String string3, String string4, String string5, boolean bl) {
            super(string, specificationVersion);
            assert (string != null);
            assert (specificationVersion != null);
            this.displayName = string2 == null ? string : string2;
            this.displayNameWithVersion = "IMP-NG".equalsIgnoreCase(this.getName()) ? this.getDisplayName() : DISPLAY_NAME_WITH_VERSION_FORMAT.format(new Object[]{this.getDisplayName(), this.getVersion().toString()}, new StringBuffer(), (FieldPosition)null).toString();
            assert (string3 != null);
            this.type = string3;
            this.dependencies = string4 != null ? string4 : "";
            this.classPath = string5 == null ? "" : string5;
            this.def = bl;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDisplayNameWithVersion() {
            return this.displayNameWithVersion;
        }

        public String getType() {
            return this.type;
        }

        public String getDependencies() {
            return this.dependencies;
        }

        public String getClassPath() {
            assert (this.classPath != null);
            return this.classPath;
        }

        public boolean isDefault() {
            return this.def;
        }

        public boolean isRealyOptional() {
            return this.realyOptional;
        }

        public boolean isNameIsJarFileName() {
            return this.classPath.equals(J2MEPlatform.PLATFORM_STRING_PREFIX + this.displayName);
        }

        public String toString() {
            return this.isNameIsJarFileName() || "IMP-NG".equalsIgnoreCase(this.getName()) ? this.getName() : this.getName() + '-' + this.getVersion().toString();
        }

        public int compareTo(Object object) {
            Profile profile = (Profile)object;
            int n = this.getName().compareTo(profile.getName());
            if (n != 0) {
                return n;
            }
            if (this.getVersion() == null) {
                return profile.getVersion() == null ? 0 : -1;
            }
            return profile.getVersion() == null ? 1 : this.getVersion().compareTo((Object)profile.getVersion());
        }
    }

    public static final class Screen {
        private final Integer width;
        private final Integer height;
        private final Integer bitDepth;
        private final Boolean color;
        private final Boolean touch;

        public Screen(String string, String string2, String string3, String string4, String string5) {
            Constable constable;
            try {
                constable = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                constable = null;
            }
            this.width = constable;
            try {
                constable = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                constable = null;
            }
            this.height = constable;
            try {
                constable = new Integer(string3);
            }
            catch (NumberFormatException numberFormatException) {
                constable = null;
            }
            this.bitDepth = constable;
            try {
                constable = new Boolean(string4);
            }
            catch (NumberFormatException numberFormatException) {
                constable = null;
            }
            this.color = (Boolean)constable;
            try {
                constable = new Boolean(string5);
            }
            catch (NumberFormatException numberFormatException) {
                constable = null;
            }
            this.touch = (Boolean)constable;
        }

        public Integer getBitDepth() {
            return this.bitDepth;
        }

        public Boolean getColor() {
            return this.color;
        }

        public Integer getHeight() {
            return this.height;
        }

        public Boolean getTouch() {
            return this.touch;
        }

        public Integer getWidth() {
            return this.width;
        }

        public boolean equals(Object object) {
            if (object instanceof Screen) {
                Integer n = ((Screen)object).getWidth();
                Integer n2 = ((Screen)object).getHeight();
                Integer n3 = ((Screen)object).getBitDepth();
                Boolean bl = ((Screen)object).getColor();
                Boolean bl2 = ((Screen)object).getTouch();
                boolean bl3 = true;
                bl3 &= n != null ? n.equals(this.width) : false;
                bl3 &= n2 != null ? n2.equals(this.height) : false;
                bl3 &= n3 != null ? n3.equals(this.bitDepth) : false;
                bl3 &= bl != null ? bl.equals(this.color) : false;
                return bl3 &= bl2 != null ? bl2.equals(this.touch) : false;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Device {
        private final String name;
        private final String description;
        private final String[] securityDomains;
        private final J2MEProfile[] profiles;
        private final Screen screen;
        private final String[] pathOrder;

        public Device(String string, String string2, String[] stringArray, J2MEProfile[] j2MEProfileArray, Screen screen) {
            Object object;
            int n;
            this.screen = screen;
            assert (string != null);
            this.name = string;
            this.description = string2 == null ? string : string2;
            this.securityDomains = stringArray;
            assert (j2MEProfileArray != null);
            this.profiles = j2MEProfileArray;
            Set[] setArray = new Set[j2MEProfileArray.length];
            HashMap<String, HashMap<String, SpecificationVersion>> hashMap = new HashMap<String, HashMap<String, SpecificationVersion>>();
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < setArray.length; ++n) {
                setArray[n] = new HashSet();
                object = PropertyUtils.tokenizePath((String)j2MEProfileArray[n].getClassPath());
                for (int i = 0; i < ((String[])object).length; ++i) {
                    setArray[n].add(object[i]);
                    HashMap<String, Object> hashMap2 = hashMap.get(object[i]);
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap();
                        hashMap.put(object[i], hashMap2);
                    } else {
                        hashSet.add(object[i]);
                    }
                    hashMap2.put(j2MEProfileArray[n].getName(), j2MEProfileArray[n].getVersion());
                }
            }
            for (n = 0; n < setArray.length; ++n) {
                j2MEProfileArray[n].realyOptional = setArray[n].retainAll(hashSet);
            }
            this.pathOrder = new String[hashMap.size()];
            for (n = 0; n < this.pathOrder.length; ++n) {
                this.pathOrder[n] = object = this.findFirst(hashMap);
                hashMap.remove(object);
            }
        }

        public String sortClasspath(String string) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(PropertyUtils.tokenizePath((String)string)));
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.pathOrder.length; ++i) {
                if (!hashSet.remove(this.pathOrder[i])) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(':');
                }
                stringBuffer.append(this.pathOrder[i]);
            }
            for (String string2 : hashSet) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(':');
                }
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getSecurityDomains() {
            return this.securityDomains == null ? null : (String[])this.securityDomains.clone();
        }

        public J2MEProfile[] getProfiles() {
            return this.profiles == null ? null : (J2MEProfile[])this.profiles.clone();
        }

        public Screen getScreen() {
            return this.screen;
        }

        public boolean isValid() {
            if (this.profiles == null) {
                return false;
            }
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < this.profiles.length; ++i) {
                bl = bl || this.profiles[i].getType().equals("configuration");
                bl2 = bl2 || this.profiles[i].getType().equals("profile");
            }
            return bl && bl2;
        }

        private String findFirst(HashMap<String, HashMap<String, SpecificationVersion>> hashMap) {
            Map.Entry<String, HashMap<String, SpecificationVersion>> entry = null;
            for (Map.Entry<String, HashMap<String, SpecificationVersion>> entry2 : hashMap.entrySet()) {
                Map map = entry2.getValue();
                if (!map.containsKey("CLDC") && !map.containsKey("MIDP") && this.canBeFirst(map, hashMap)) {
                    return entry2.getKey();
                }
                entry = entry2;
            }
            for (Map.Entry<String, HashMap<String, SpecificationVersion>> entry2 : hashMap.entrySet()) {
                if (this.canBeFirst((Map<String, SpecificationVersion>)entry2.getValue(), hashMap)) {
                    return entry2.getKey();
                }
                entry = entry2;
            }
            return (String)entry.getKey();
        }

        private boolean canBeFirst(Map<String, SpecificationVersion> map, HashMap<String, HashMap<String, SpecificationVersion>> hashMap) {
            for (HashMap<String, SpecificationVersion> hashMap2 : hashMap.values()) {
                if (this.isValidOrder(map, hashMap2)) continue;
                return false;
            }
            return true;
        }

        private boolean isValidOrder(Map<String, SpecificationVersion> map, HashMap<String, SpecificationVersion> hashMap) {
            HashSet<String> hashSet = new HashSet<String>(map.keySet());
            hashSet.retainAll(hashMap.keySet());
            if (hashSet.isEmpty()) {
                return true;
            }
            for (String string : hashSet) {
                if (map.get(string).compareTo((Object)hashMap.get(string)) < 0) continue;
                return true;
            }
            return false;
        }
    }
}

