/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.java.JavaKit;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

abstract class AbstractCamelCasePosition
extends BaseAction {
    private Action originalAction;

    public AbstractCamelCasePosition(String string, Action action) {
        super(string, 2);
        Object object;
        if (action != null && (object = action.getValue("Name")) instanceof String) {
            this.putValue("Name", object);
            this.originalAction = action;
        }
        if ((object = this.getShortDescription()) != null) {
            this.putValue("ShortDescription", object);
        }
    }

    public final void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            if (this.originalAction != null && !this.isUsingCamelCase()) {
                if (this.originalAction instanceof BaseAction) {
                    ((BaseAction)this.originalAction).actionPerformed(actionEvent, jTextComponent);
                } else {
                    this.originalAction.actionPerformed(actionEvent);
                }
            } else {
                final BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                if (baseDocument != null) {
                    baseDocument.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                            try {
                                int n = AbstractCamelCasePosition.this.newOffset(jTextComponent);
                                if (n != -1) {
                                    AbstractCamelCasePosition.this.moveToNewOffset(jTextComponent, n);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                jTextComponent.getToolkit().beep();
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                            }
                        }
                    });
                } else {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    protected abstract int newOffset(JTextComponent var1) throws BadLocationException;

    protected abstract void moveToNewOffset(JTextComponent var1, int var2) throws BadLocationException;

    public String getShortDescription() {
        String string;
        String string2 = (String)this.getValue("Name");
        if (string2 == null) {
            return null;
        }
        try {
            string = NbBundle.getBundle(JavaKit.class).getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            string = string2;
        }
        return string;
    }

    private boolean isUsingCamelCase() {
        Preferences preferences = NbPreferences.forModule(AbstractCamelCasePosition.class);
        return preferences.getBoolean("useCamelCaseStyleNavigation", true);
    }
}

