/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;

public abstract class CndAbstractDataLoader
extends UniFileLoader {
    static final long serialVersionUID = 6801389470714975682L;

    protected CndAbstractDataLoader(String string) {
        super(string);
    }

    protected abstract String getMimeType();

    protected final void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(this.getMimeType());
    }

    protected String actionsContext() {
        return "Loaders/text/x-cnd-sourcefile/Actions/";
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new CndFormat(multiDataObject, fileObject);
    }

    protected static boolean setTemplate(FileObject fileObject, boolean bl) throws IOException {
        boolean bl2 = false;
        Object object = fileObject.getAttribute("template");
        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
            bl2 = true;
        }
        if (bl2 == bl) {
            return false;
        }
        fileObject.setAttribute("template", (Object)(bl ? Boolean.TRUE : null));
        return true;
    }

    static class CndFormat
    extends FileEntry.Format {
        public CndFormat(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            int n;
            Properties properties = ((CppSettings)CppSettings.findObject(CppSettings.class, (boolean)true)).getReplaceableStringsProps();
            String string3 = fileObject.getPath().replace('/', '_');
            if (!string3.equals("")) {
                string3 = string3 + "_";
            }
            properties.put("PACKAGE_AND_NAME", string3 + string);
            properties.put("NAME", string);
            properties.put("EXTENSION", string2);
            String string4 = string + "_" + string2;
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < string4.length(); ++n) {
                char c = string4.charAt(n);
                stringBuilder.append(Character.isJavaIdentifierPart(c) ? (char)Character.toUpperCase(c) : (char)'_');
            }
            properties.put("GUARD_NAME", stringBuilder.toString());
            n = string.lastIndexOf(95);
            if (n != -1) {
                string = string.substring(0, n);
            }
            properties.put("CROPPEDNAME", string);
            properties.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
            properties.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
            String string5 = null;
            File file = InstalledFileLocator.getDefault().locate("lib", null, false);
            if (file != null) {
                string5 = file.getParent();
            }
            if (string5 == null) {
                string5 = "";
            }
            properties.put("NBDIR", string5);
            properties.put("QUOTES", "\"");
            for (CreateFromTemplateAttributesProvider createFromTemplateAttributesProvider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
                Object v;
                Map map = createFromTemplateAttributesProvider.attributesFor((DataObject)this.getDataObject(), DataFolder.findFolder((FileObject)fileObject), string);
                if (map == null || !((v = map.get("user")) instanceof String)) continue;
                properties.put("USER", (String)v);
                break;
            }
            MapFormat mapFormat = new MapFormat((Map)properties);
            mapFormat.setLeftBrace("%<%");
            mapFormat.setRightBrace("%>%");
            return mapFormat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            String string2 = this.getFile().getExt();
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
            }
            FileObject fileObject2 = fileObject.createData(string, string2);
            Format format = this.createFormat(fileObject, string, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFile().getInputStream(), FileEncodingQuery.getEncoding((FileObject)this.getFile())));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject2);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock), charset));
                    try {
                        String string3;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            bufferedWriter.write(format.format(string3));
                            bufferedWriter.newLine();
                        }
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            finally {
                bufferedReader.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            CndAbstractDataLoader.setTemplate(fileObject2, false);
            return fileObject2;
        }
    }
}

