/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.module.dlight.threads.api.Datarace;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadInfo;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataraceImpl
implements Datarace {
    private final int id;
    private final long address;
    private String stringAddress;
    private final List<ThreadDump> dumps;
    private static final Pattern RACE_PATTERN = Pattern.compile("Race\\s+#(\\d+),\\s+Vaddr:\\s+(0x(.+)|\\(Multiple\\s+Addresses\\)|Multiple\\s+addresses)");
    private static final Pattern DUMP_PATTERN = Pattern.compile("\\s+Trace\\s+\\d+");
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile(" *Access +\\d+: +(Read|Write) *");

    public DataraceImpl(int n, long l, List<ThreadDump> list) {
        this.id = n;
        this.address = l;
        this.dumps = list;
    }

    void setStringAddress(String string) {
        this.stringAddress = string;
    }

    public long getAddress() {
        return this.address;
    }

    public String stringAddress() {
        return this.stringAddress;
    }

    public List<ThreadDump> getThreadDumps() {
        return this.dumps;
    }

    public String toString() {
        return "Datarace #" + this.id;
    }

    public static List<DataraceImpl> fromErprint(String[] stringArray) {
        ArrayList<DataraceImpl> arrayList = new ArrayList<DataraceImpl>();
        ListIterator<String> listIterator = Arrays.asList(stringArray).listIterator();
        while (listIterator.hasNext()) {
            Matcher matcher = RACE_PATTERN.matcher(listIterator.next());
            if (!matcher.matches()) continue;
            arrayList.add(DataraceImpl.parseDatarace(listIterator, matcher));
        }
        return arrayList;
    }

    private static DataraceImpl parseDatarace(ListIterator<String> listIterator, Matcher matcher) {
        Object object;
        int n = -1;
        try {
            n = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        long l = -1L;
        String string = matcher.group(2);
        if (matcher.group(3) != null) {
            try {
                l = Long.parseLong(matcher.group(3), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ArrayList<ThreadDump> arrayList = new ArrayList<ThreadDump>();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            Matcher matcher2 = DUMP_PATTERN.matcher((CharSequence)object);
            if (matcher2.matches()) {
                arrayList.add(DataraceImpl.parseThreadDump(listIterator, matcher2));
                continue;
            }
            if (arrayList.isEmpty()) continue;
            break;
        }
        object = new DataraceImpl(n, l, arrayList);
        ((DataraceImpl)object).setStringAddress(string);
        return object;
    }

    private static ThreadDump parseThreadDump(ListIterator<String> listIterator, Matcher matcher) {
        ArrayList<ThreadSnapshot> arrayList = new ArrayList<ThreadSnapshot>();
        while (listIterator.hasNext()) {
            String string = listIterator.next();
            Matcher matcher2 = SNAPSHOT_PATTERN.matcher(string);
            if (matcher2.matches()) {
                arrayList.add(DataraceImpl.parseThreadSnapshot(listIterator, matcher2));
                continue;
            }
            listIterator.previous();
            break;
        }
        return new ThreadDumpImpl(arrayList);
    }

    private static ThreadSnapshot parseThreadSnapshot(ListIterator<String> listIterator, Matcher matcher) {
        ThreadSnapshot.MemoryAccessType memoryAccessType = ThreadSnapshot.MemoryAccessType.valueOf((String)matcher.group(1).toUpperCase());
        List<FunctionCall> list = FunctionCallImpl.parseStack(listIterator);
        return new ThreadSnapshotImpl(list, null, memoryAccessType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadSnapshotImpl
    implements ThreadSnapshot {
        private final List<FunctionCall> stack;
        private final ThreadInfo threadInfo;
        private final ThreadSnapshot.MemoryAccessType memoryAccessType;

        public ThreadSnapshotImpl(List<FunctionCall> list, ThreadInfo threadInfo, ThreadSnapshot.MemoryAccessType memoryAccessType) {
            this.stack = list;
            this.threadInfo = threadInfo;
            this.memoryAccessType = memoryAccessType;
        }

        public List<FunctionCall> getStack() {
            return this.stack;
        }

        public ThreadInfo getThreadInfo() {
            return this.threadInfo;
        }

        public ThreadState.MSAState getState() {
            return ThreadState.MSAState.Running;
        }

        public ThreadSnapshot.MemoryAccessType getMemoryAccessType() {
            return this.memoryAccessType;
        }

        public long getTimestamp() {
            return 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadDumpImpl
    implements ThreadDump {
        private final List<ThreadSnapshot> threads;

        public ThreadDumpImpl(List<ThreadSnapshot> list) {
            this.threads = list;
        }

        public long getTimestamp() {
            return -1L;
        }

        public List<ThreadSnapshot> getThreadStates() {
            return this.threads;
        }
    }
}

