/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.perfan.dataprovider.SSMetrics;
import org.netbeans.modules.dlight.perfan.impl.SunStudioDCConfigurationAccessor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SunStudioDCConfiguration
implements DataCollectorConfiguration,
IndicatorDataProviderConfiguration {
    private static final String CPU_TABLE_NAME = "SunStudioCPUDetailedData";
    private static final String SYNC_TABLE_NAME = "SunStudioSyncDetailedData";
    private static final String MEM_TABLE_NAME = "SunStudioMemDetailedData";
    private static final String DATARACE_TABLE_NAME = "SunStudioDataRacesDetailedData";
    private static final String DEADLOCKS_TABLE_NAME = "SunStudioDeadlocksDetailedData";
    public static final DataTableMetadata.Column c_name = new DataTableMetadata.Column("name", String.class, SunStudioDCConfiguration.loc("SSDataCollector.ColumnName.name", new String[0]), null);
    public static final DataTableMetadata.Column c_address = new DataTableMetadata.Column("address", String.class, SunStudioDCConfiguration.loc("SSDataCollector.ColumnName.address", new String[0]), null);
    public static final DataTableMetadata.Column c_eUser = new DataTableMetadata.Column(SSMetrics.TimeMetric.UserFuncTimeExclusive.getMetricID(), SSMetrics.TimeMetric.UserFuncTimeExclusive.getMetricValueClass(), SSMetrics.TimeMetric.UserFuncTimeExclusive.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_iUser = new DataTableMetadata.Column(SSMetrics.TimeMetric.UserFuncTimeInclusive.getMetricID(), SSMetrics.TimeMetric.UserFuncTimeInclusive.getMetricValueClass(), SSMetrics.TimeMetric.UserFuncTimeInclusive.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_iSync = new DataTableMetadata.Column(SSMetrics.TimeMetric.SyncWaitTimeInclusive.getMetricID(), SSMetrics.TimeMetric.SyncWaitTimeInclusive.getMetricValueClass(), SSMetrics.TimeMetric.SyncWaitTimeInclusive.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_iSyncn = new DataTableMetadata.Column(SSMetrics.TimeMetric.SyncWaitCallInclusive.getMetricID(), SSMetrics.TimeMetric.SyncWaitCallInclusive.getMetricValueClass(), SSMetrics.TimeMetric.SyncWaitCallInclusive.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_eSync = new DataTableMetadata.Column(SSMetrics.TimeMetric.SyncWaitTimeExclusive.getMetricID(), SSMetrics.TimeMetric.SyncWaitTimeExclusive.getMetricValueClass(), SSMetrics.TimeMetric.SyncWaitTimeExclusive.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_eSyncn = new DataTableMetadata.Column(SSMetrics.TimeMetric.SyncWaitCallExclusive.getMetricID(), SSMetrics.TimeMetric.SyncWaitCallExclusive.getMetricValueClass(), SSMetrics.TimeMetric.SyncWaitCallExclusive.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_leakCount = new DataTableMetadata.Column(SSMetrics.MemoryMetric.LeaksCountMetric.getMetricID(), SSMetrics.MemoryMetric.LeaksCountMetric.getMetricValueClass(), SSMetrics.MemoryMetric.LeaksCountMetric.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_leakSize = new DataTableMetadata.Column(SSMetrics.MemoryMetric.LeakBytesMetric.getMetricID(), SSMetrics.MemoryMetric.LeakBytesMetric.getMetricValueClass(), SSMetrics.MemoryMetric.LeakBytesMetric.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_Deadlocks = new DataTableMetadata.Column(SSMetrics.THAMetric.DeadlockMetric.getMetricID(), SSMetrics.THAMetric.DeadlockMetric.getMetricValueClass(), SSMetrics.THAMetric.DeadlockMetric.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_Datarace = new DataTableMetadata.Column(SSMetrics.THAMetric.RaceMetric.getMetricID(), SSMetrics.THAMetric.RaceMetric.getMetricValueClass(), SSMetrics.THAMetric.RaceMetric.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_iOMPWait = new DataTableMetadata.Column(SSMetrics.TimeMetric.OMPWaitTimeInclusive.getMetricID(), SSMetrics.TimeMetric.OMPWaitTimeInclusive.getMetricValueClass(), SSMetrics.TimeMetric.OMPWaitTimeInclusive.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_iOMPWork = new DataTableMetadata.Column(SSMetrics.TimeMetric.OMPWorkTimeInclusive.getMetricID(), SSMetrics.TimeMetric.OMPWorkTimeInclusive.getMetricValueClass(), SSMetrics.TimeMetric.OMPWorkTimeInclusive.getMetricDisplayedName(), null);
    public static final DataTableMetadata.Column c_ulockSummary = new DataTableMetadata.Column("user_lock", Long.class, SunStudioDCConfiguration.loc("SSDataCollector.ColumnName.user_lock", new String[0]), null);
    public static final DataTableMetadata.Column c_threadsCount = new DataTableMetadata.Column("ss_threads", Long.class, SunStudioDCConfiguration.loc("SSDataCollector.ColumnName.threads", new String[0]), null);
    private final Set<CollectedInfo> collectedInfo = EnumSet.noneOf(CollectedInfo.class);

    public SunStudioDCConfiguration(CollectedInfo collectedInfo) {
        this.collectedInfo.add(collectedInfo);
    }

    public static final DataTableMetadata getSyncTableMetadata(DataTableMetadata.Column ... columnArray) {
        return SunStudioDCConfiguration.getTableMetadata(SYNC_TABLE_NAME, columnArray, Arrays.asList(c_iSync, c_iSyncn, c_eSync, c_eSyncn));
    }

    public static final DataTableMetadata getCPUTableMetadata(DataTableMetadata.Column ... columnArray) {
        return SunStudioDCConfiguration.getTableMetadata(CPU_TABLE_NAME, columnArray, Arrays.asList(c_iUser, c_eUser));
    }

    public static final DataTableMetadata getMemTableMetadata(DataTableMetadata.Column ... columnArray) {
        return SunStudioDCConfiguration.getTableMetadata(MEM_TABLE_NAME, columnArray, Arrays.asList(c_leakCount, c_leakSize));
    }

    public static final DataTableMetadata getDataRaceTableMetadata(DataTableMetadata.Column ... columnArray) {
        return SunStudioDCConfiguration.getTableMetadata(DATARACE_TABLE_NAME, columnArray, Arrays.asList(c_Datarace));
    }

    public static final DataTableMetadata getDeadlockTableMetadata(DataTableMetadata.Column ... columnArray) {
        return SunStudioDCConfiguration.getTableMetadata(DEADLOCKS_TABLE_NAME, columnArray, Arrays.asList(c_Deadlocks));
    }

    private static DataTableMetadata getTableMetadata(String string, DataTableMetadata.Column[] columnArray, List<DataTableMetadata.Column> list) {
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>();
        for (DataTableMetadata.Column column : columnArray) {
            if (column == c_name) continue;
            if (list.contains(column)) {
                arrayList.add(column);
                continue;
            }
            throw new IllegalArgumentException("An attempt to create DataTableMetadata " + string + " with column " + column.getColumnName() + " which is not related to it");
        }
        arrayList.add(c_name);
        return new DataTableMetadata(string, arrayList, null);
    }

    public static final String getFunctionNameColumnName() {
        return "name";
    }

    public String getID() {
        return "SunStudioDataCollectorID";
    }

    Set<CollectedInfo> getCollectedInfo() {
        return this.collectedInfo;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(SunStudioDCConfiguration.class, (String)string, (Object[])stringArray);
    }

    static {
        SunStudioDCConfigurationAccessor.setDefault(new SunStudioDCConfigurationAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SunStudioDCConfigurationAccessorImpl
    extends SunStudioDCConfigurationAccessor {
        private SunStudioDCConfigurationAccessorImpl() {
        }

        @Override
        public Set<CollectedInfo> getCollectedInfo(SunStudioDCConfiguration sunStudioDCConfiguration) {
            return sunStudioDCConfiguration.getCollectedInfo();
        }

        @Override
        public String getCPUTableName() {
            return SunStudioDCConfiguration.CPU_TABLE_NAME;
        }

        @Override
        public String getSyncTableName() {
            return SunStudioDCConfiguration.SYNC_TABLE_NAME;
        }

        @Override
        public String getMemTableName() {
            return SunStudioDCConfiguration.MEM_TABLE_NAME;
        }

        @Override
        public String getDeadlockTableName() {
            return SunStudioDCConfiguration.DEADLOCKS_TABLE_NAME;
        }

        @Override
        public String getDataraceTableName() {
            return SunStudioDCConfiguration.DATARACE_TABLE_NAME;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CollectedInfo {
        FUNCTIONS_LIST,
        SYNCHRONIZATION,
        MEMORY,
        SYNCSUMMARY,
        MEMSUMMARY,
        DATARACES,
        DEADLOCKS;

    }
}

