/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Union2;

public abstract class NbModuleOwnerSupport {
    public static String NB_BUGZILLA_CONFIG = ".nbbugzilla-components";
    private static NbModuleOwnerSupport instance;

    protected NbModuleOwnerSupport() {
    }

    public static NbModuleOwnerSupport getInstance() {
        if (instance == null && (instance = (NbModuleOwnerSupport)Lookup.getDefault().lookup(NbModuleOwnerSupport.class)) == null) {
            instance = new DefaultImpl();
        }
        return instance;
    }

    public final String getOwner(String string, File file) {
        OwnerInfo ownerInfo = this.getOwnerInfo(string, file);
        return ownerInfo != null ? ownerInfo.getOwner() : null;
    }

    public final OwnerInfo getOwnerInfo(String string, File file) {
        this.checkConfigFileName(string);
        this.checkPath(file);
        try {
            return this.getOwnerImpl(string, file);
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(16, throwable);
            return null;
        }
    }

    public OwnerInfo getOwnerInfo(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        return this.getOwnerInfo(fileObject);
    }

    public OwnerInfo getOwnerInfo(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        return NbModuleOwnerSupport.getInstance().getOwnerInfo(NB_BUGZILLA_CONFIG, file);
    }

    public OwnerInfo getOwnerInfo(Node node) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        if (project != null) {
            return this.getOwnerInfo(project);
        }
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        if (dataObject != null) {
            return this.getOwnerInfo(dataObject);
        }
        return null;
    }

    private OwnerInfo getOwnerInfo(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            return this.getOwnerInfo(project);
        }
        return this.getOwnerInfo(fileObject);
    }

    private void checkConfigFileName(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("configFileName is <null>");
        }
        if (string.length() == 0 || string.equals(".") || string.equals("..") || string.lastIndexOf(File.separatorChar) != -1) {
            throw new IllegalArgumentException("Illegal name of configuration file: \"" + string + '\"');
        }
    }

    private void checkPath(File file) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("path is <null>");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Absolute path is required - was: " + file);
        }
    }

    protected abstract OwnerInfo getOwnerImpl(String var1, File var2);

    protected abstract ConfigData getData(File var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BufferedReaderIterator
    implements Iterable<String>,
    Iterator<String> {
        private final BufferedReader bufReader;
        private String nextLine;
        private boolean nextLinePrepared;

        BufferedReaderIterator(BufferedReader bufferedReader) {
            this.bufReader = bufferedReader;
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (!this.nextLinePrepared) {
                this.nextLine = null;
                try {
                    this.nextLine = this.bufReader.readLine();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.nextLinePrepared = true;
                    if (this.nextLine == null) {
                        try {
                            this.bufReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return this.nextLine != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextLinePrepared = false;
            return this.nextLine;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OwnerInfo {
        private final String owner;
        private final List<String> extraData;

        static OwnerInfo parseSpec(CharSequence charSequence) {
            String string;
            char c;
            int n;
            if (charSequence.length() == 0) {
                return null;
            }
            String string2 = null;
            ArrayList<String> arrayList = null;
            int n2 = charSequence.length();
            for (n = 0; n < n2 && ((c = charSequence.charAt(n)) == ' ' || c == '\t'); ++n) {
            }
            if (n == n2) {
                return null;
            }
            StringBuilder stringBuilder = null;
            int n3 = n;
            boolean bl = false;
            while (n < n2) {
                char c2 = charSequence.charAt(n);
                if (bl) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(20);
                        stringBuilder.append(charSequence, n3, n - 1);
                    }
                    stringBuilder.append(c2);
                    bl = false;
                } else if (c2 == '\\') {
                    bl = true;
                } else if (c2 == '/') {
                    String string3;
                    String string4 = string3 = stringBuilder != null ? stringBuilder.toString() : ((Object)charSequence.subSequence(n3, n)).toString();
                    if (string2 == null) {
                        string2 = string3;
                    } else {
                        if (arrayList == null) {
                            arrayList = new ArrayList(4);
                        }
                        arrayList.add(string3);
                    }
                    n3 = n + 1;
                    stringBuilder = null;
                } else if (stringBuilder != null) {
                    stringBuilder.append(c2);
                }
                ++n;
            }
            String string5 = string = stringBuilder != null ? stringBuilder.toString() : ((Object)charSequence.subSequence(n3, n2)).toString();
            if (string2 == null) {
                string2 = string;
            } else {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(4);
                }
                arrayList.add(string);
            }
            if (arrayList != null) {
                return new OwnerInfo(string2, arrayList);
            }
            return new OwnerInfo(string2);
        }

        public OwnerInfo(String string) {
            this(string, (String[])null);
        }

        public OwnerInfo(String string, String ... stringArray) {
            this.checkOwner(string);
            this.owner = string;
            if (stringArray == null || stringArray.length == 0) {
                this.extraData = null;
            } else if (stringArray.length == 1) {
                this.extraData = Collections.singletonList(stringArray[0]);
            } else {
                this.extraData = new ArrayList<String>(stringArray.length);
                for (String string2 : stringArray) {
                    this.extraData.add(string2);
                }
            }
        }

        public OwnerInfo(String string, List<String> list) {
            this.checkOwner(string);
            this.owner = string;
            this.extraData = list == null || list.isEmpty() ? null : (list.size() == 1 ? Collections.singletonList(list.get(0)) : new ArrayList<String>(list));
        }

        private void checkOwner(String string) throws IllegalArgumentException {
            if (string == null) {
                throw new IllegalArgumentException("owner must not be null");
            }
        }

        public String getOwner() {
            return this.owner;
        }

        public List<String> getExtraData() {
            return this.extraData != null ? this.extraData : Collections.emptyList();
        }

        public int hashCode() {
            int n = 7;
            n = 79 * n + this.owner.hashCode();
            n = 79 * n + (this.extraData != null ? ((Object)this.extraData).hashCode() : 0);
            return n;
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass() == OwnerInfo.class) {
                OwnerInfo ownerInfo = (OwnerInfo)object;
                return OwnerInfo.equal(this.owner, ownerInfo.owner) && OwnerInfo.equal(this.extraData, ownerInfo.extraData);
            }
            return false;
        }

        private static boolean equal(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }

        public String toString() {
            return super.toString() + this.paramString();
        }

        public String paramString() {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("[component=").append(this.owner).append(",extraData=").append(this.getExtraDataString()).append(']');
            return stringBuilder.toString();
        }

        private String getExtraDataString() {
            if (this.extraData == null || this.extraData.isEmpty()) {
                return "()";
            }
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append('(');
            boolean bl = true;
            for (String string : this.extraData) {
                if (!bl) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string != null ? string : "null");
                bl = false;
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigData {
        private static final Logger LOG = Logger.getLogger(ConfigData.class.getCanonicalName());
        private static final int TOP_NODES_COUNT = 26;
        private final Union2<List<Node>, Node[]>[] topNodes = new Union2[26];

        public static ConfigData load(File file) {
            if (file == null) {
                throw new IllegalArgumentException("dataFile is <null>");
            }
            ConfigData configData = new ConfigData();
            try {
                configData.loadData(file);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
            return configData;
        }

        protected ConfigData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void loadData(File file) throws IOException {
            this.cleanData();
            PatternParser patternParser = new PatternParser();
            int n = 0;
            try {
                for (String string : this.getConfigFileLines(file)) {
                    this.processPatternFileLine(file, string, ++n, patternParser);
                }
            }
            finally {
                this.processNodes();
                patternParser.reset();
            }
        }

        private void cleanData() {
            Arrays.fill(this.topNodes, null);
        }

        protected Iterable<String> getConfigFileLines(File file) throws IOException {
            return new BufferedReaderIterator(new BufferedReader(new InputStreamReader(new FileInputStream(file))));
        }

        private void processPatternFileLine(File file, String string, int n, PatternParser patternParser) {
            if (string.length() == 0) {
                return;
            }
            if (string.charAt(0) == '#') {
                return;
            }
            List list = patternParser.parsePattern(string);
            if (list == null) {
                ParsingFailure parsingFailure = patternParser.getFailure();
                if (parsingFailure != ParsingFailure.EMPTY_LINE && LOG.isLoggable(Level.INFO)) {
                    int n2;
                    StringBuilder stringBuilder = new StringBuilder(100);
                    stringBuilder.append("syntax error in mapping file ").append(file).append(" at line ").append(n).append(": ").append(parsingFailure.getDescription());
                    if (parsingFailure == ParsingFailure.SYNTAX_ERROR && (n2 = patternParser.getSyntaxErrorPosition()) != -1) {
                        stringBuilder.append(" at column ").append(n2);
                    }
                    LOG.info(stringBuilder.toString());
                }
                return;
            }
            String string2 = string.substring(patternParser.getSeparatorPosition() + 1);
            OwnerInfo ownerInfo = OwnerInfo.parseSpec(string2);
            if (ownerInfo == null) {
                LOG.log(Level.INFO, "syntax error in mapping file {0} at line {1} (no Bugzilla component specified)", new Object[]{file, n});
                return;
            }
            this.processPatternData(list, ownerInfo);
        }

        private void processPatternData(List<String> list, OwnerInfo ownerInfo) {
            String string = list.get(0);
            if (string.equals("*")) {
                for (int i = 0; i < 26; ++i) {
                    this.processPatternData(i, list, ownerInfo);
                }
            } else {
                int n = ConfigData.getTopNodeIndex(string);
                this.processPatternData(n, list, ownerInfo);
            }
        }

        private void processPatternData(int n, List<String> list, OwnerInfo ownerInfo) {
            Union2<List<Node>, Node[]> union2 = this.topNodes[n];
            if (union2 == null) {
                ArrayList<Node> arrayList = new ArrayList<Node>(10);
                this.topNodes[n] = Union2.createFirst(arrayList);
                arrayList.add(this.createNode(list, 0, ownerInfo));
            } else {
                this.findNode((List)union2.first(), list, 0, ownerInfo);
            }
        }

        private Node findNode(List<Node> list, List<String> list2, int n, OwnerInfo ownerInfo) {
            boolean bl = ConfigData.isPrefixPattern(list2.get(n));
            return bl ? this.findPrefixNode(list, list2, n, ownerInfo) : this.findNonPrefixNode(list, list2, n, ownerInfo);
        }

        private Node findPrefixNode(List<Node> list, List<String> list2, int n, OwnerInfo ownerInfo) {
            ListIterator<Node> listIterator = list.listIterator();
            Node node = listIterator.next();
            while (!node.isPrefix) {
                if (!listIterator.hasNext()) {
                    node = this.createNode(list2, n, ownerInfo);
                    list.add(node);
                    return node;
                }
                node = listIterator.next();
            }
            String string = list2.get(n);
            int n2 = string.length();
            while (node.name.length() > n2) {
                if (!listIterator.hasNext()) {
                    node = this.createNode(list2, n, ownerInfo);
                    list.add(node);
                    return node;
                }
                node = listIterator.next();
            }
            String string2 = string.substring(0, n2 - 1);
            while (node.name.length() == n2) {
                if (node.name.equals(string2)) {
                    Node node2;
                    if (n == list2.size() - 1) {
                        return node;
                    }
                    Union2 union2 = node.children;
                    if (union2 != null) {
                        List list3 = (List)union2.first();
                        node2 = this.findNode(list3, list2, n + 1, ownerInfo);
                    } else {
                        node2 = this.createNode(list2, n + 1, ownerInfo);
                        node.addChild(node2);
                    }
                    return node2;
                }
                if (!listIterator.hasNext()) {
                    node = this.createNode(list2, n, ownerInfo);
                    list.add(node);
                    return node;
                }
                node = listIterator.next();
            }
            node = this.createNode(list2, n, ownerInfo);
            list.add(listIterator.previousIndex(), node);
            return node;
        }

        private Node findNonPrefixNode(List<Node> list, List<String> list2, int n, OwnerInfo ownerInfo) {
            String string = list2.get(n);
            int n2 = string.length();
            ListIterator<Node> listIterator = list.listIterator();
            Node node = listIterator.next();
            while (!node.isPrefix && node.name.length() < n2) {
                if (!listIterator.hasNext()) {
                    node = this.createNode(list2, n, ownerInfo);
                    list.add(node);
                    return node;
                }
                node = listIterator.next();
            }
            while (!node.isPrefix && node.name.length() == n2) {
                if (node.name.equals(string)) {
                    Node node2;
                    if (n == list2.size() - 1) {
                        return node;
                    }
                    Union2 union2 = node.children;
                    if (union2 != null) {
                        List list3 = (List)union2.first();
                        node2 = this.findNode(list3, list2, n + 1, ownerInfo);
                    } else {
                        node2 = this.createNode(list2, n + 1, ownerInfo);
                        node.addChild(node2);
                    }
                    return node2;
                }
                if (!listIterator.hasNext()) {
                    node = this.createNode(list2, n, ownerInfo);
                    list.add(node);
                    return node;
                }
                node = listIterator.next();
            }
            node = this.createNode(list2, n, ownerInfo);
            list.add(listIterator.previousIndex(), node);
            return node;
        }

        private Node createNode(List<String> list, int n, OwnerInfo ownerInfo) {
            Node node;
            if (n == list.size() - 1) {
                node = new Node(list.get(n), ownerInfo);
            } else {
                node = new Node(list.get(n), null);
                node.addChild(this.createNode(list, n + 1, ownerInfo));
            }
            return node;
        }

        private void processNodes() {
            ConfigData.processNodes(this.topNodes);
        }

        private static void processNodes(Union2<List<Node>, Node[]>[] union2Array) {
            for (int i = 0; i < union2Array.length; ++i) {
                Node[] nodeArray;
                Union2<List<Node>, Node[]> union2 = union2Array[i];
                if (union2 == null) continue;
                List list = (List)union2.first();
                assert (!list.isEmpty());
                for (Node node : nodeArray = ((List)union2.first()).toArray(new Node[list.size()])) {
                    node.processChildren();
                }
                union2Array[i] = Union2.createSecond((Object)nodeArray);
                assert (((Node[])union2Array[i].second()).length != 0);
            }
        }

        public OwnerInfo getMatchingInfo(String string) {
            String string2 = ConfigData.getFirstPartOfPath(string);
            int n = ConfigData.getTopNodeIndex(string2);
            Union2<List<Node>, Node[]> union2 = this.topNodes[n];
            if (union2 == null) {
                return null;
            }
            Node[] nodeArray = (Node[])union2.second();
            if (nodeArray == null) {
                assert (false);
                return null;
            }
            return this.findInfo(string, string2, nodeArray);
        }

        private OwnerInfo findInfo(String string, String string2, Node[] nodeArray) {
            OwnerInfo ownerInfo;
            int n = string2.length();
            Node node = null;
            Object object = nodeArray;
            int n2 = ((Node[])object).length;
            for (int i = 0; i < n2; ++i) {
                Node node2 = object[i];
                if (!node2.isPrefix) {
                    if (!node2.name.equals(string2)) continue;
                    node = node2;
                    break;
                }
                int n3 = node2.name.length();
                int n4 = n3 - 1;
                if (n3 > n || n3 != 0 && (node2.name.charAt(n4) != string2.charAt(n4) || !string2.startsWith(node2.name))) continue;
                node = node2;
                break;
            }
            if (node == null) {
                return null;
            }
            if (node.children != null && string.length() > n && (ownerInfo = this.findInfo((String)(object = string.substring(n + 1)), ConfigData.getFirstPartOfPath((String)object), (Node[])node.children.second())) != null) {
                return ownerInfo;
            }
            return node.info;
        }

        private static final int getTopNodeIndex(String string) {
            return ConfigData.getCharIndex(string.charAt(0)) % 26;
        }

        private static final int getCharIndex(char c) {
            return (c | 0x20) + 159 & 0xFF;
        }

        private static String getFirstPartOfPath(String string) {
            int n = string.indexOf(47);
            return n != -1 ? string.substring(0, n) : string;
        }

        private static boolean isPrefixPattern(String string) {
            return string.charAt(string.length() - 1) == '*';
        }

        private static String getPrefixPart(String string) {
            assert (ConfigData.isPrefixPattern(string));
            return string.substring(0, string.length() - 1);
        }

        private static final class Node {
            final String name;
            final boolean isPrefix;
            final OwnerInfo info;
            private Union2<List<Node>, Node[]> children;

            Node(String string, OwnerInfo ownerInfo) {
                this.isPrefix = ConfigData.isPrefixPattern(string);
                this.name = this.isPrefix ? ConfigData.getPrefixPart(string) : string;
                this.info = ownerInfo;
            }

            void addChild(Node node) {
                if (this.children == null) {
                    this.children = Union2.createFirst(new ArrayList(4));
                }
                ((List)this.children.first()).add(node);
            }

            private void processChildren() {
                if (this.children == null) {
                    return;
                }
                List list = (List)this.children.first();
                assert (!list.isEmpty());
                Node[] nodeArray = ((List)this.children.first()).toArray(new Node[list.size()]);
                this.children = Union2.createSecond((Object)nodeArray);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class PatternParser {
            private static final int INIT = 0;
            private static final int NAME = 1;
            private static final int STAR = 2;
            private String patternBeingParsed;
            private int state;
            private int begin;
            private String firstString;
            private List<String> result;
            private int separatorPosition;
            private ParsingFailure failure;
            private int syntaxErrorPosition;

            PatternParser() {
                this.reset();
            }

            private void reset() {
                this.patternBeingParsed = null;
                this.firstString = null;
                this.result = null;
                this.separatorPosition = -1;
                this.failure = null;
                this.syntaxErrorPosition = -1;
                this.begin = -1;
                this.state = 0;
            }

            ParsingFailure getFailure() {
                return this.failure;
            }

            int getSyntaxErrorPosition() {
                return this.syntaxErrorPosition;
            }

            int getSeparatorPosition() {
                return this.separatorPosition;
            }

            private List<String> parsePattern(String string) {
                int n;
                int n2;
                this.reset();
                this.patternBeingParsed = string;
                int n3 = string.length();
                for (n2 = 0; n2 < n3 && ((n = string.charAt(n2)) == 32 || n == 9); ++n2) {
                }
                if (n2 == n3) {
                    this.failure = ParsingFailure.EMPTY_LINE;
                    return null;
                }
                if (string.charAt(n2) == '=') {
                    this.failure = ParsingFailure.EMPTY_PATH;
                    return null;
                }
                n = n2;
                boolean bl = false;
                boolean bl2 = false;
                int n4 = n2;
                block10: while (n2 < n3) {
                    char c = string.charAt(n2);
                    switch (this.state) {
                        case 0: {
                            assert (!bl);
                            if (c == '*') {
                                this.storePatternPart("*");
                                this.state = 2;
                                break;
                            }
                            if (c == '=') {
                                this.separatorPosition = n2;
                                break block10;
                            }
                            if (c == '/') {
                                this.failure = n2 == n ? ParsingFailure.ABSOLUTE_PATH : ParsingFailure.SYNTAX_ERROR;
                                break block10;
                            }
                            if (c == '\\') {
                                bl = true;
                                bl2 = true;
                            }
                            if (c != ' ' && c != '\t') {
                                n4 = n2;
                            }
                            this.begin = n2;
                            this.state = 1;
                            break;
                        }
                        case 1: {
                            if (bl) {
                                bl = false;
                                n4 = n2;
                                break;
                            }
                            if (c == '*') {
                                this.storePatternPart(n2 + 1, bl2);
                                bl2 = false;
                                this.state = 2;
                                break;
                            }
                            if (c == '/') {
                                this.storePatternPart(n2, bl2);
                                bl2 = false;
                                this.state = 0;
                                break;
                            }
                            if (c == '=') {
                                this.separatorPosition = n2;
                                break block10;
                            }
                            if (c == '\\') {
                                bl = true;
                                bl2 = true;
                            }
                            if (c == ' ' || c == '\t') break;
                            n4 = n2;
                            break;
                        }
                        case 2: {
                            assert (!bl);
                            if (c == '*') {
                                this.failure = ParsingFailure.SYNTAX_ERROR;
                                break block10;
                            }
                            if (c == '/') {
                                this.state = 0;
                                break;
                            }
                            if (c == '=') {
                                this.separatorPosition = n2;
                                break block10;
                            }
                            this.failure = ParsingFailure.SYNTAX_ERROR;
                            break block10;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    ++n2;
                }
                if (this.failure != null) {
                    this.syntaxErrorPosition = n2;
                    return null;
                }
                if (this.separatorPosition == -1) {
                    this.failure = ParsingFailure.NO_SEPARATOR;
                    return null;
                }
                switch (this.state) {
                    case 0: {
                        this.storePatternPart("*");
                        break;
                    }
                    case 1: {
                        if (n4 >= this.begin) {
                            this.storePatternPart(n4 + 1, bl2);
                            bl2 = false;
                            break;
                        }
                        this.storePatternPart("*");
                    }
                }
                return this.makeFinalResult();
            }

            private void storePatternPart(int n, boolean bl) {
                String string;
                assert (this.begin >= 0);
                assert (n > this.begin);
                if (!bl) {
                    string = this.patternBeingParsed.substring(this.begin, n);
                } else {
                    StringBuilder stringBuilder = new StringBuilder(n - this.begin - 1);
                    for (int i = this.begin; i < n; ++i) {
                        char c = this.patternBeingParsed.charAt(i);
                        if (c == '\\') continue;
                        stringBuilder.append(c);
                    }
                    assert (stringBuilder.length() < n - this.begin);
                    string = stringBuilder.toString();
                }
                this.storePatternPart(string);
            }

            private void storePatternPart(String string) {
                if (this.firstString == null) {
                    this.firstString = string;
                } else {
                    if (this.result == null) {
                        this.result = new ArrayList<String>(4);
                        this.result.add(this.firstString);
                    }
                    this.result.add(string);
                }
                this.begin = -1;
            }

            private List<String> makeFinalResult() {
                if (this.result != null) {
                    return this.result;
                }
                if (this.firstString != null) {
                    return Collections.singletonList(this.firstString);
                }
                return Collections.emptyList();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum ParsingFailure {
            EMPTY_LINE("empty line"),
            EMPTY_PATH("empty path"),
            ABSOLUTE_PATH("not a relative path"),
            NO_SEPARATOR("missing '='"),
            SYNTAX_ERROR("syntax error");

            private final String description;

            private ParsingFailure(String string2) {
                this.description = string2;
            }

            String getDescription() {
                return this.description;
            }
        }
    }

    private static class DefaultImpl
    extends NbModuleOwnerSupport {
        private final Object cacheLock = new Object();
        private final ConfigFileCache dataCache = new ConfigFileCache();

        private DefaultImpl() {
        }

        protected OwnerInfo getOwnerImpl(String string, File file) {
            Object object;
            String string2;
            File file2 = null;
            String string3 = file.getName();
            if (string3.equals(string) && file.isFile()) {
                file2 = file;
                string2 = string;
            } else {
                Comparable<File> comparable;
                File file3;
                object = new ArrayList(15);
                File file4 = file;
                while ((file3 = file4.getParentFile()) != null) {
                    comparable = new File(file3, string);
                    if (((File)comparable).isFile()) {
                        file2 = comparable;
                        break;
                    }
                    object.add(file3.getName());
                    file4 = file3;
                }
                if (file2 == null) {
                    return null;
                }
                if (object.isEmpty()) {
                    string2 = string3;
                } else {
                    comparable = new StringBuilder(100);
                    for (int i = object.size() - 1; i >= 0; --i) {
                        ((StringBuilder)comparable).append((String)object.get(i)).append('/');
                    }
                    ((StringBuilder)comparable).append(string3);
                    string2 = ((StringBuilder)comparable).toString();
                }
            }
            object = this.getData(file2);
            if (object == null) {
                return null;
            }
            return ((ConfigData)object).getMatchingInfo(string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ConfigData getData(File file) {
            Object object = this.cacheLock;
            synchronized (object) {
                ConfigData configData;
                Reference reference = (Reference)this.dataCache.get(file);
                ConfigData configData2 = configData = reference != null ? (ConfigData)reference.get() : null;
                if (configData == null) {
                    configData = ConfigData.load(file);
                    this.dataCache.put(file, new SoftReference<ConfigData>(configData));
                }
                return configData;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ConfigFileCache
        extends LinkedHashMap<File, Reference<ConfigData>> {
            private static final int MAX_SIZE = 10;

            ConfigFileCache() {
                super(16, 0.75f, true);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<File, Reference<ConfigData>> entry) {
                return this.size() > 10;
            }
        }
    }
}

