/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GemFilesParser {
    private static final String DOT_GEM_SPEC = ".gemspec";
    private static final Pattern PATTERN = Pattern.compile("([\\w-]+)\\-([\\d.]+)");
    private static final Logger LOGGER = Logger.getLogger(GemFilesParser.class.getName());
    private final File[] specFiles;
    private Map<String, List<GemInfo>> resultMap;

    public GemFilesParser(File ... fileArray) {
        Parameters.notNull((CharSequence)"files", (Object)fileArray);
        this.specFiles = fileArray;
    }

    public void parseGems() {
        this.resultMap = new HashMap<String, List<GemInfo>>();
        for (File file : this.specFiles) {
            String string = file.getName();
            if (!string.endsWith(DOT_GEM_SPEC)) continue;
            String[] stringArray = GemFilesParser.parseNameAndVersion(string = string.substring(0, string.length() - DOT_GEM_SPEC.length()));
            if (stringArray == null) {
                LOGGER.fine("Could not resolve the name and version for " + string);
                continue;
            }
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            List<GemInfo> list = this.resultMap.get(string2);
            if (list == null) {
                list = new ArrayList<GemInfo>();
                this.resultMap.put(string2, list);
            }
            list.add(new GemInfo(string2, string3, file));
        }
        this.sortVersions();
    }

    private void sortVersions() {
        for (String string : this.resultMap.keySet()) {
            List<GemInfo> list = this.resultMap.get(string);
            Collections.sort(list);
        }
    }

    private void checkInitialiazed() {
        if (this.resultMap == null) {
            throw new IllegalStateException("Not initialized, you must run the chooseGems method first");
        }
    }

    public static Map<String, List<GemInfo>> getGemInfos(File[] fileArray) {
        GemFilesParser gemFilesParser = new GemFilesParser(fileArray);
        gemFilesParser.parseGems();
        return gemFilesParser.getGemInfos();
    }

    Map<String, List<GemInfo>> getGemInfos() {
        this.checkInitialiazed();
        return this.resultMap;
    }

    public File[] getFiles(boolean bl) {
        this.checkInitialiazed();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : this.resultMap.keySet()) {
            List<GemInfo> list = this.resultMap.get(string);
            if (bl) {
                arrayList.add(list.get(0).getSpecFile());
                continue;
            }
            for (GemInfo gemInfo : list) {
                arrayList.add(gemInfo.getSpecFile());
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static String[] parseNameAndVersion(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (!matcher.find() || matcher.groupCount() < 2) {
            LOGGER.fine("Couldn't parse name and version for " + string);
            return null;
        }
        return new String[]{matcher.group(1), matcher.group(2)};
    }
}

