/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorState;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.HtmlPrintContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;

public class ExportHtmlAction
extends CookieAction {
    private static final String HTML_EXT = ".html";
    private static final String OPEN_HTML_HIST = "ExportHtmlAction_open_html_history";
    private static final String SHOW_LINES_HIST = "ExportHtmlAction_show_lines_history";
    private static final String SELECTION_HIST = "ExportHtmlAction_selection_history";
    private static final String FOLDER_NAME_HIST = "ExportHtmlAction_folder_name_history";
    private static final String CHARSET = "UTF-8";
    private Dialog dlg;

    protected final int mode() {
        return 8;
    }

    protected final Class[] cookieClasses() {
        return new Class[]{EditorCookie.class};
    }

    protected final void performAction(Node[] nodeArray) {
        EditorCookie editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return;
        }
        StyledDocument styledDocument = null;
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (styledDocument instanceof BaseDocument) {
            Object object;
            final BaseDocument baseDocument = (BaseDocument)styledDocument;
            final JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            Presenter presenter = new Presenter();
            String string = (String)EditorState.get((Object)FOLDER_NAME_HIST);
            if (string == null) {
                string = System.getProperty("user.home");
            }
            presenter.setFileName(string + File.separatorChar + ((DataObject)baseDocument.getProperty((Object)"stream")).getPrimaryFile().getName() + HTML_EXT);
            MimePath mimePath = jTextComponent == null ? MimePath.EMPTY : MimePath.parse((String)DocumentUtilities.getMimeType((JTextComponent)jTextComponent));
            Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
            Boolean bl = (Boolean)EditorState.get((Object)SHOW_LINES_HIST);
            boolean bl2 = bl != null ? bl.booleanValue() : preferences.getBoolean("line-number-visible", true);
            presenter.setShowLines(bl2);
            presenter.setSelectionActive(jTextComponent != null && jTextComponent.getSelectionStart() != jTextComponent.getSelectionEnd());
            bl = (Boolean)EditorState.get((Object)SELECTION_HIST);
            boolean bl3 = jTextComponent != null && jTextComponent.getSelectionStart() != jTextComponent.getSelectionEnd() && (bl == null || bl != false);
            presenter.setSelection(bl3);
            bl = (Boolean)EditorState.get((Object)OPEN_HTML_HIST);
            boolean bl4 = bl != null ? bl : false;
            presenter.setOpenHtml(bl4);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)presenter, NbBundle.getMessage(ExportHtmlAction.class, (String)"CTL_ExportHtml"));
            boolean bl5 = true;
            this.dlg = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            do {
                this.dlg.setVisible(true);
                bl5 = true;
                if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION || !new File(presenter.getFileName()).exists()) continue;
                object = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportHtmlAction.class, (String)"MSG_FileExists", (Object)presenter.getFileName()), 0, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                if (object.getValue() == NotifyDescriptor.YES_OPTION) continue;
                bl5 = false;
            } while (!bl5);
            this.dlg.dispose();
            this.dlg = null;
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                boolean bl6;
                boolean bl7;
                int n;
                if (bl3 != presenter.isSelection()) {
                    bl3 = presenter.isSelection();
                    EditorState.put((Object)SELECTION_HIST, (Object)(bl3 ? Boolean.TRUE : Boolean.FALSE));
                }
                if ((n = ((String)(object = presenter.getFileName())).lastIndexOf(File.separatorChar)) != -1) {
                    EditorState.put((Object)FOLDER_NAME_HIST, (Object)((String)object).substring(0, n));
                }
                if (bl2 != (bl7 = presenter.isShowLines())) {
                    EditorState.put((Object)SHOW_LINES_HIST, (Object)(bl7 ? Boolean.TRUE : Boolean.FALSE));
                }
                if (bl4 != (bl6 = presenter.isOpenHtml())) {
                    EditorState.put((Object)OPEN_HTML_HIST, (Object)(bl6 ? Boolean.TRUE : Boolean.FALSE));
                }
                int n2 = bl3 ? jTextComponent.getSelectionStart() : 0;
                int n3 = bl3 ? jTextComponent.getSelectionEnd() : baseDocument.getLength();
                RequestProcessor.getDefault().post(new Runnable((String)object, bl7, n2, n3, bl6){
                    final /* synthetic */ String val$file;
                    final /* synthetic */ boolean val$lineNumbers;
                    final /* synthetic */ int val$selectionStart;
                    final /* synthetic */ int val$selectionEnd;
                    final /* synthetic */ boolean val$open;
                    {
                        this.val$file = string;
                        this.val$lineNumbers = bl;
                        this.val$selectionStart = n;
                        this.val$selectionEnd = n2;
                        this.val$open = bl2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            if (jTextComponent != null) {
                                this.setCursor(Cursor.getPredefinedCursor(3));
                            }
                            ExportHtmlAction.this.export(baseDocument, this.val$file, this.val$lineNumbers, this.val$selectionStart, this.val$selectionEnd);
                            if (this.val$open) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(new File(this.val$file).toURI().toURL());
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                        }
                        catch (IOException iOException) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportHtmlAction.class, (String)"ERR_IOError", (Object[])new Object[]{((DataObject)baseDocument.getProperty((Object)"stream")).getPrimaryFile().getNameExt() + ExportHtmlAction.HTML_EXT, this.val$file}), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            return;
                        }
                        finally {
                            if (jTextComponent != null) {
                                this.setCursor(null);
                            }
                        }
                    }

                    private void setCursor(final Cursor cursor) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                jTextComponent.setCursor(cursor);
                            }
                        });
                    }
                });
            }
        } else {
            Logger.getLogger("global").log(Level.FINE, NbBundle.getMessage(ExportHtmlAction.class, (String)"MSG_DocError"));
        }
    }

    public final String getName() {
        return NbBundle.getMessage(ExportHtmlAction.class, (String)"CTL_ExportHtmlAction");
    }

    public final HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected final boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(BaseDocument baseDocument, String string, boolean bl, int n, int n2) throws IOException {
        MimePath mimePath = MimePath.parse((String)((String)baseDocument.getProperty((Object)"mimeType")));
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)mimePath).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors("default");
        Coloring coloring = Coloring.fromAttributeSet((AttributeSet)attributeSet);
        Color color = coloring.getBackColor();
        Color color2 = coloring.getForeColor();
        Font font = coloring.getFont();
        AttributeSet attributeSet2 = fontColorSettings.getFontColors("line-number");
        Coloring coloring2 = Coloring.fromAttributeSet((AttributeSet)attributeSet2);
        Color color3 = coloring2.getBackColor();
        Color color4 = coloring2.getForeColor();
        FileObject fileObject = ((DataObject)baseDocument.getProperty((Object)"stream")).getPrimaryFile();
        HtmlPrintContainer htmlPrintContainer = new HtmlPrintContainer();
        htmlPrintContainer.begin(fileObject, font, color2, color, color4, color3, mimePath, CHARSET);
        baseDocument.print((PrintContainer)htmlPrintContainer, false, Boolean.valueOf(bl), n, n2);
        String string2 = htmlPrintContainer.end();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), CHARSET));
            printWriter.print(string2);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private class Presenter
    extends JPanel {
        private JTextField fileName;
        private JCheckBox showLineNumbers;
        private JCheckBox openHtml;
        private JCheckBox selection;

        public Presenter() {
            this.initGUI();
        }

        public final String getFileName() {
            return this.fileName.getText();
        }

        public final void setFileName(String string) {
            this.fileName.setText(string);
        }

        public final boolean isShowLines() {
            return this.showLineNumbers.isSelected();
        }

        public final void setShowLines(boolean bl) {
            this.showLineNumbers.setSelected(bl);
        }

        public final boolean isSelection() {
            return this.selection.isSelected();
        }

        public final void setSelection(boolean bl) {
            this.selection.setSelected(bl);
        }

        public final boolean isOpenHtml() {
            return this.openHtml.isSelected();
        }

        public final void setOpenHtml(boolean bl) {
            this.openHtml.setSelected(bl);
        }

        public final void setSelectionActive(boolean bl) {
            this.selection.setEnabled(bl);
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportHtmlAction.class, (String)"ACSN_ExportToHTML"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportHtmlAction.class, (String)"ACSD_ExportToHTML"));
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(ExportHtmlAction.class, (String)"CTL_OutputDir"));
            jLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportHtmlAction.class, (String)"AN_OutputDir"));
            jLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportHtmlAction.class, (String)"AD_OutputDir"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 12, 6, 6);
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.fileName = new JTextField();
            this.fileName.setColumns(25);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 6, 6, 6);
            gridBagConstraints.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.fileName, gridBagConstraints);
            this.add(this.fileName);
            jLabel.setLabelFor(this.fileName);
            JButton jButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(ExportHtmlAction.class, (String)"CTL_Select"));
            jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportHtmlAction.class, (String)"AN_Select"));
            jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportHtmlAction.class, (String)"AD_Select"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Presenter.this.selectFile();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 6, 6, 12);
            ((GridBagLayout)this.getLayout()).setConstraints(jButton, gridBagConstraints);
            this.add(jButton);
            this.selection = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.selection, (String)NbBundle.getMessage(ExportHtmlAction.class, (String)"CTL_Selection"));
            this.selection.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportHtmlAction.class, (String)"AN_Selection"));
            this.selection.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportHtmlAction.class, (String)"AD_Selection"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 6, 12);
            gridBagConstraints.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.selection, gridBagConstraints);
            this.add(this.selection);
            this.showLineNumbers = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.showLineNumbers, (String)NbBundle.getMessage(ExportHtmlAction.class, (String)"CTL_ShowLineNumbers"));
            this.showLineNumbers.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportHtmlAction.class, (String)"AN_ShowLineNumbers"));
            this.showLineNumbers.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportHtmlAction.class, (String)"AD_ShowLineNumbers"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 6, 12);
            gridBagConstraints.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.showLineNumbers, gridBagConstraints);
            this.add(this.showLineNumbers);
            this.openHtml = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.openHtml, (String)NbBundle.getMessage(ExportHtmlAction.class, (String)"CTL_OpenHTML"));
            this.openHtml.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportHtmlAction.class, (String)"AN_OpenHTML"));
            this.openHtml.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportHtmlAction.class, (String)"AD_OpenHTML"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 12, 12);
            gridBagConstraints.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.openHtml, gridBagConstraints);
            this.add(this.openHtml);
        }

        private void selectFile() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(NbBundle.getMessage(ExportHtmlAction.class, (String)"CTL_Browse_Dialog_Title"));
            jFileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportHtmlAction.class, (String)"ACD_Browse_Dialog"));
            jFileChooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportHtmlAction.class, (String)"ACN_Browse_Dialog"));
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(ExportHtmlAction.HTML_EXT) || file.isDirectory();
                }

                public String getDescription() {
                    return NbBundle.getMessage(ExportHtmlAction.class, (String)"TXT_HTMLFileType");
                }
            });
            jFileChooser.setSelectedFile(new File(this.fileName.getText()));
            if (jFileChooser.showDialog(ExportHtmlAction.this.dlg, NbBundle.getMessage(ExportHtmlAction.class, (String)"CTL_Approve_Label")) == 0) {
                this.fileName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

