/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpointImpl;
import org.netbeans.spi.debugger.ContextProvider;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private final GdbDebugger debugger;
    private final Map<Breakpoint, BreakpointImpl<?>> breakpointToImpl = new HashMap();
    private static final Logger log = Logger.getLogger("gdb.breakpoints.logger");

    public BreakpointsEngineListener(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        this.debugger.addPropertyChangeListener(this);
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener(this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("state")) {
            if (propertyChangeEvent.getNewValue() == GdbDebugger.State.LOADING) {
                int n = this.createBreakpointImpls();
                DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
                if (n == 0) {
                    this.debugger.setReady();
                }
            }
        } else if (string.equals("sharedLibLoaded")) {
            assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
            this.sharedLibLoaded();
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.createBreakpointImpl(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.removeBreakpointImpl(breakpoint);
    }

    private int createBreakpointImpls() {
        int n = 0;
        for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(breakpoint instanceof CndBreakpoint)) continue;
            this.createBreakpointImpl(breakpoint);
            ++n;
        }
        return n;
    }

    private void createBreakpointImpl(Breakpoint breakpoint) {
        if (this.breakpointToImpl.containsKey(breakpoint)) {
            return;
        }
        BreakpointImpl breakpointImpl = null;
        if (breakpoint instanceof LineBreakpoint) {
            breakpointImpl = new LineBreakpointImpl((LineBreakpoint)breakpoint, this.debugger);
        } else if (breakpoint instanceof FunctionBreakpoint) {
            breakpointImpl = new FunctionBreakpointImpl((FunctionBreakpoint)breakpoint, this.debugger);
        } else if (breakpoint instanceof AddressBreakpoint) {
            breakpointImpl = new AddressBreakpointImpl((AddressBreakpoint)breakpoint, this.debugger);
        }
        if (breakpointImpl != null) {
            this.breakpointToImpl.put(breakpoint, breakpointImpl);
        }
        log.finer("BreakpointsEngineListener: created impl " + breakpointImpl + " for " + breakpoint);
    }

    private void removeBreakpointImpls() {
        for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(breakpoint instanceof CndBreakpoint)) continue;
            this.removeBreakpointImpl(breakpoint);
        }
    }

    private void removeBreakpointImpl(Breakpoint breakpoint) {
        BreakpointImpl<?> breakpointImpl = this.breakpointToImpl.remove(breakpoint);
        if (breakpointImpl != null) {
            breakpointImpl.remove();
            log.finer("BreakpointsEngineListener: removed impl " + breakpointImpl + " for " + breakpoint);
        }
    }

    private void sharedLibLoaded() {
        for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            BreakpointImpl<?> breakpointImpl;
            if (breakpoint.getValidity() != Breakpoint.VALIDITY.INVALID || (breakpointImpl = this.breakpointToImpl.get(breakpoint)) == null) continue;
            breakpointImpl.revalidate();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }
}

