/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.FormalParameterInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Program;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionDeclarationInfo
extends ASTNodeInfo<FunctionDeclaration> {
    Map<String, List<QualifiedName>> paramDocTypes = Collections.emptyMap();

    protected FunctionDeclarationInfo(Program program, FunctionDeclaration functionDeclaration) {
        super(functionDeclaration);
        if (program != null) {
            this.paramDocTypes = VariousUtils.getParamTypesFromPHPDoc(program, functionDeclaration);
        }
    }

    public static FunctionDeclarationInfo create(FunctionDeclaration functionDeclaration) {
        return new FunctionDeclarationInfo(null, functionDeclaration);
    }

    public static FunctionDeclarationInfo create(Program program, FunctionDeclaration functionDeclaration) {
        return new FunctionDeclarationInfo(program, functionDeclaration);
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.FUNCTION;
    }

    @Override
    public String getName() {
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)this.getOriginalNode();
        return functionDeclaration.getFunctionName().getName();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.createUnqualifiedName(this.getName());
    }

    @Override
    public OffsetRange getRange() {
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)this.getOriginalNode();
        Identifier identifier = functionDeclaration.getFunctionName();
        return new OffsetRange(identifier.getStartOffset(), identifier.getEndOffset());
    }

    public List<? extends Parameter> getParameters() {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        List<FormalParameter> list = ((FunctionDeclaration)this.getOriginalNode()).getFormalParameters();
        for (FormalParameter formalParameter : list) {
            FormalParameterInfo formalParameterInfo = FormalParameterInfo.create(formalParameter, this.paramDocTypes);
            arrayList.add(formalParameterInfo.toParameter());
        }
        return arrayList;
    }
}

