/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Struct;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Enum;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FFIUtil {
    private static final MemoryIO IO = MemoryIO.getInstance();
    private static final Map<NativeType, com.kenai.jffi.Type> typeMap = FFIUtil.buildTypeMap();

    private FFIUtil() {
    }

    private static final Map<NativeType, com.kenai.jffi.Type> buildTypeMap() {
        EnumMap<NativeType, com.kenai.jffi.Type> m = new EnumMap<NativeType, com.kenai.jffi.Type>(NativeType.class);
        m.put(NativeType.VOID, com.kenai.jffi.Type.VOID);
        m.put(NativeType.BOOL, com.kenai.jffi.Type.UINT32);
        m.put(NativeType.CHAR, com.kenai.jffi.Type.SINT8);
        m.put(NativeType.SHORT, com.kenai.jffi.Type.SINT16);
        m.put(NativeType.INT, com.kenai.jffi.Type.SINT32);
        m.put(NativeType.LONG_LONG, com.kenai.jffi.Type.SINT64);
        m.put(NativeType.UCHAR, com.kenai.jffi.Type.UINT8);
        m.put(NativeType.USHORT, com.kenai.jffi.Type.UINT16);
        m.put(NativeType.UINT, com.kenai.jffi.Type.UINT32);
        m.put(NativeType.ULONG_LONG, com.kenai.jffi.Type.UINT64);
        if (Platform.getPlatform().longSize() == 32) {
            m.put(NativeType.LONG, com.kenai.jffi.Type.SINT32);
            m.put(NativeType.ULONG, com.kenai.jffi.Type.UINT32);
        } else {
            m.put(NativeType.LONG, com.kenai.jffi.Type.SINT64);
            m.put(NativeType.ULONG, com.kenai.jffi.Type.UINT64);
        }
        m.put(NativeType.FLOAT, com.kenai.jffi.Type.FLOAT);
        m.put(NativeType.DOUBLE, com.kenai.jffi.Type.DOUBLE);
        m.put(NativeType.POINTER, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.BUFFER_IN, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.BUFFER_OUT, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.BUFFER_INOUT, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.STRING, com.kenai.jffi.Type.POINTER);
        return m;
    }

    static final com.kenai.jffi.Type getFFIType(Type type2) {
        if (type2 instanceof Type.Builtin || type2 instanceof CallbackInfo || type2 instanceof Enum) {
            return FFIUtil.getFFIType(type2.getNativeType());
        }
        if (type2 instanceof StructByValue) {
            return FFIUtil.newStruct(((StructByValue)type2).getStructLayout());
        }
        return null;
    }

    static final com.kenai.jffi.Type getFFIType(NativeType type2) {
        return typeMap.get(type2);
    }

    static final Struct newStruct(Ruby runtime2, Collection<StructLayout.Member> structMembers) {
        com.kenai.jffi.Type[] fields2 = new com.kenai.jffi.Type[structMembers.size()];
        int i = 0;
        for (StructLayout.Member m : structMembers) {
            com.kenai.jffi.Type fieldType = m instanceof StructLayout.Aggregate ? FFIUtil.newStruct(runtime2, ((StructLayout.Aggregate)((Object)m)).getMembers()) : FFIUtil.getFFIType(m.getNativeType());
            if (fieldType == null) {
                throw runtime2.newTypeError("Unsupported Struct field type " + m);
            }
            fields2[i++] = fieldType;
        }
        return new Struct(fields2);
    }

    static final Struct newStruct(StructLayout layout) {
        return FFIUtil.newStruct(layout.getRuntime(), layout.getFields());
    }

    static final IRubyObject getString(Ruby runtime2, long address2) {
        if (address2 == 0L) {
            return runtime2.getNil();
        }
        byte[] bytes2 = FFIUtil.getZeroTerminatedByteArray(address2);
        if (bytes2.length == 0) {
            return RubyString.newEmptyString(runtime2);
        }
        RubyString s = RubyString.newStringNoCopy(runtime2, bytes2);
        s.setTaint(true);
        return s;
    }

    static final byte[] getZeroTerminatedByteArray(long address2) {
        return IO.getZeroTerminatedByteArray(address2);
    }

    static final byte[] getZeroTerminatedByteArray(long address2, int maxlen) {
        return IO.getZeroTerminatedByteArray(address2, maxlen);
    }

    static final void putZeroTerminatedByteArray(long address2, byte[] bytes2, int off, int len) {
        IO.putByteArray(address2, bytes2, off, len);
        IO.putByte(address2 + (long)len, (byte)0);
    }

    static final Type resolveType(ThreadContext context, IRubyObject obj) {
        if (obj instanceof Type) {
            return (Type)obj;
        }
        RubyModule ffi2 = context.getRuntime().fastGetModule("FFI");
        IRubyObject typeDefs = ffi2.fastFetchConstant("TypeDefs");
        if (!(typeDefs instanceof RubyHash)) {
            throw context.getRuntime().newRuntimeError("invalid or corrupted FFI::TypeDefs");
        }
        IRubyObject type2 = ((RubyHash)typeDefs).fastARef(obj);
        if (type2 == null || type2.isNil()) {
            type2 = ffi2.callMethod(context, "find_type", obj);
        }
        if (!(type2 instanceof Type)) {
            throw context.getRuntime().newTypeError("Could not resolve type: " + obj);
        }
        return (Type)type2;
    }
}

