/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.struct;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.struct.Struct;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructUtil {
    private StructUtil() {
    }

    public static final MemoryIO getMemoryIO(Struct struct) {
        return struct.__info.getMemoryIO(0);
    }

    public static final MemoryIO getMemoryIO(Struct struct, int flags) {
        return struct.__info.getMemoryIO(flags);
    }

    public static final int getSize(Struct struct) {
        return struct.__info.size();
    }

    public static final int getMinimumAlignment(Struct struct) {
        return struct.__info.getMinimumAlignment();
    }

    public static final <T extends Struct> T[] newArray(Class<T> type2, int length2) {
        try {
            Struct[] array = (Struct[])Array.newInstance(type2, length2);
            for (int i = 0; i < length2; ++i) {
                array[i] = (Struct)type2.newInstance();
            }
            if (array.length > 0) {
                int align = StructUtil.getMinimumAlignment(array[0]);
                int mask = align - 1;
                int structSize = StructUtil.getSize(array[0]);
                if ((structSize & mask) != 0) {
                    structSize = (structSize & ~mask) + align;
                }
                MemoryIO memory = MemoryIO.allocateDirect(structSize * length2);
                for (int i = 0; i < array.length; ++i) {
                    array[i].useMemory(memory.slice(structSize * i, structSize));
                }
            }
            return array;
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

