/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.io.File;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ConflictResolvedAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        return "resolve";
    }

    protected int getFileEnabledStatus() {
        return 64;
    }

    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    protected void performContextAction(Node[] nodeArray) {
        final Context context = this.getContext(nodeArray);
        final File[] fileArray = context.getFiles();
        ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

            public void perform() {
                SvnClient svnClient = null;
                try {
                    svnClient = Subversion.getInstance().getClient(context, (SvnProgressSupport)this);
                }
                catch (SVNClientException sVNClientException) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
                if (svnClient == null) {
                    return;
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    if (this.isCanceled()) {
                        return;
                    }
                    File file = fileArray[i];
                    try {
                        ConflictResolvedAction.perform(file, svnClient);
                        continue;
                    }
                    catch (SVNClientException sVNClientException) {
                        this.annotate(sVNClientException);
                    }
                }
            }
        };
        progressSupport.start(this.createRequestProcessor(nodeArray));
    }

    public static void perform(final File file) throws SVNClientException {
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            protected void perform() {
                try {
                    SvnClient svnClient = Subversion.getInstance().getClient(file);
                    ConflictResolvedAction.perform(file, svnClient);
                }
                catch (SVNClientException sVNClientException) {
                    this.annotate(sVNClientException);
                }
            }
        };
        SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        svnProgressSupport.start(Subversion.getInstance().getRequestProcessor(sVNUrl), sVNUrl, NbBundle.getMessage(ConflictResolvedAction.class, (String)"LBL_ResolvingConflicts"));
    }

    private static void perform(File file, SvnClient svnClient) throws SVNClientException {
        FileObject fileObject;
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        svnClient.resolved(file);
        fileStatusCache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        File file2 = file.getParentFile();
        if (file2 != null && (fileObject = FileUtil.toFileObject((File)file2)) != null) {
            fileObject.refresh();
        }
    }
}

