/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.config.KVFile;
import org.netbeans.modules.subversion.config.SVNCredentialFile;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class PasswordFile
extends SVNCredentialFile {
    private static final KVFile.Key PASSTYPE_KEY = new KVFile.Key(0, "passtype");
    private static final KVFile.Key PASSWORD_KEY = new KVFile.Key(1, "password");
    private static final KVFile.Key REALMSTRING_KEY = new KVFile.Key(2, "svn:realmstring");
    private static final KVFile.Key USERNAME_KEY = new KVFile.Key(3, "username");
    private static final String PASSTYPE_SIMPLE = "simple";

    public PasswordFile(String string) {
        super(PasswordFile.getFile(string));
    }

    private PasswordFile(File file) {
        super(file);
    }

    public static PasswordFile findFileForUrl(SVNUrl sVNUrl) {
        String string = SvnUtils.ripUserFromHost(sVNUrl.getHost());
        String string2 = "<" + sVNUrl.getProtocol() + "://" + string + ">";
        PasswordFile passwordFile = new PasswordFile(string2);
        if (!passwordFile.getFile().exists()) {
            File file = new File(SvnConfigFiles.getUserConfigPath() + "/auth/svn.simple");
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return null;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                PasswordFile passwordFile2 = new PasswordFile(fileArray[i]);
                if (!passwordFile2.acceptSvnUrl(sVNUrl) || !passwordFile2.getPasstype().equals(PASSTYPE_SIMPLE)) continue;
                passwordFile2.setRealmString(string2);
                return passwordFile2;
            }
            passwordFile.setRealmString(string2);
            passwordFile.setPasstype(PASSTYPE_SIMPLE);
            passwordFile.setPassword("");
            passwordFile.setUsername("");
            return passwordFile;
        }
        return passwordFile;
    }

    public void store() throws IOException {
        this.store(PasswordFile.getFile(this.getRealmString()));
    }

    public String getPassword() {
        return this.getStringValue(this.getPasswordKey());
    }

    public String getUsername() {
        return this.getStringValue(this.getUsernameKey());
    }

    public void setPassword(String string) {
        this.setValue(this.getPasswordKey(), string);
    }

    public void setUsername(String string) {
        this.setValue(this.getUsernameKey(), string);
    }

    protected String getRealmString() {
        return this.getStringValue(this.getRealmstringKey());
    }

    protected void setRealmString(String string) {
        this.setValue(this.getRealmstringKey(), string.getBytes());
    }

    private void setPasstype(String string) {
        this.setValue(this.getPasstypeKey(), string);
    }

    private String getPasstype() {
        return this.getStringValue(this.getPasstypeKey());
    }

    private boolean acceptSvnUrl(SVNUrl sVNUrl) {
        if (sVNUrl == null) {
            return false;
        }
        String string = this.getRealmString();
        if (string == null || string.length() < 6) {
            return false;
        }
        String string2 = SvnUtils.ripUserFromHost(sVNUrl.getHost());
        return string.substring(1).startsWith(sVNUrl.getProtocol() + "://" + string2);
    }

    private static File getFile(String string) {
        return new File(SvnConfigFiles.getNBConfigPath() + "auth/svn.simple/" + PasswordFile.getFileName(string));
    }

    private KVFile.Key getPasstypeKey() {
        return this.getKey(PASSTYPE_KEY);
    }

    private KVFile.Key getPasswordKey() {
        return this.getKey(PASSWORD_KEY);
    }

    private KVFile.Key getRealmstringKey() {
        return this.getKey(REALMSTRING_KEY);
    }

    private KVFile.Key getUsernameKey() {
        return this.getKey(USERNAME_KEY);
    }
}

