/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.DocumentParserFactory;
import org.netbeans.modules.xml.retriever.DocumentTypeParser;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverEngine;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.impl.RetrieverTask;
import org.netbeans.modules.xml.retriever.impl.URLResourceRetriever;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieverEngineImpl
extends RetrieverEngine {
    private LinkedList<RetrieveEntry> currentRetrievalList = new LinkedList();
    private File currentSaveRootFile = null;
    private File fixedSaveRootFolder = null;
    boolean startNewThread = true;
    private boolean showErrorPopup = true;
    Thread taskThread = null;
    boolean STOP_PULL = false;
    boolean firstTime = true;
    String firstAddressParentStr = null;
    int currentPushCount = 0;
    int previousPushCount = 0;
    String opTabTitle = NbBundle.getMessage(RetrieverEngineImpl.class, (String)"TITLE_retriever_output_tab_title");
    InputOutput iop = null;
    OutputWriter ioOut;
    OutputWriter ioError;
    List<RetrieveEntry> retrievedList = new ArrayList<RetrieveEntry>();
    boolean fileOverwrite = false;
    Map<RetrieveEntry, Exception> audits;
    FileObject catalogFileObject = null;
    private boolean save2SingleFolder = false;

    public RetrieverEngineImpl(File file) {
        this.fixedSaveRootFolder = file;
        this.currentSaveRootFile = file;
    }

    public RetrieverEngineImpl(File file, boolean bl) {
        this.fixedSaveRootFolder = file;
        this.currentSaveRootFile = file;
        this.startNewThread = bl;
    }

    public boolean canShowErrorPopup() {
        return this.showErrorPopup;
    }

    public void setShowErrorPopup(boolean bl) {
        this.showErrorPopup = bl;
    }

    @Override
    public void addResourceToRetrieve(RetrieveEntry retrieveEntry) {
        this.currentRetrievalList.add(retrieveEntry);
    }

    @Override
    public void start() {
        if (this.startNewThread) {
            this.taskThread = new Thread(this);
            this.taskThread.start();
        } else {
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RetrieverEngineImpl.class, (String)"LBL_PROGRESSBAR_Retrieve_XML"), (Cancellable)new Cancellable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                RetrieverEngineImpl retrieverEngineImpl = RetrieverEngineImpl.this;
                synchronized (retrieverEngineImpl) {
                    if (!RetrieverEngineImpl.this.STOP_PULL) {
                        RetrieverEngineImpl.this.STOP_PULL = true;
                    }
                }
                return true;
            }
        }, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                RetrieverEngineImpl.this.getOPWindow().setOutputVisible(true);
                RetrieverEngineImpl.this.getOPWindow().select();
            }
        });
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        try {
            this.pullRecursively();
        }
        finally {
            progressHandle.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullRecursively() {
        Class<RetrieverEngineImpl> clazz = RetrieverEngineImpl.class;
        synchronized (RetrieverEngineImpl.class) {
            while (!this.currentRetrievalList.isEmpty() && !this.STOP_PULL) {
                RetrieveEntry retrieveEntry = this.currentRetrievalList.getFirst();
                this.currentRetrievalList.removeFirst();
                RetrieverTask retrieverTask = new RetrieverTask(retrieveEntry, this);
                if (this.firstTime) {
                    this.firstAddressParentStr = retrieveEntry.getCurrentAddress().substring(0, retrieveEntry.getCurrentAddress().lastIndexOf("/"));
                    this.firstTime = false;
                }
                this.updateDownloadingInfo(retrieveEntry);
                HashMap<String, File> hashMap = null;
                try {
                    hashMap = retrieverTask.goGetIt();
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.handleException(retrieveEntry, uRISyntaxException);
                    continue;
                }
                catch (IOException iOException) {
                    this.handleException(retrieveEntry, iOException);
                    continue;
                }
                if (!retrieveEntry.isRecursive() || hashMap == null) continue;
                String string = hashMap.keySet().iterator().next();
                File file = hashMap.get(string);
                retrieveEntry.setSaveFile(file);
                retrieveEntry.setEffectiveAddress(string);
                this.updateDownloadedInfo(retrieveEntry);
                this.createCatalogIfRequired(retrieveEntry);
                DocumentTypeParser documentTypeParser = DocumentParserFactory.getParser(retrieveEntry.getDocType());
                List<String> list = null;
                try {
                    list = documentTypeParser.getAllLocationOfReferencedEntities(file);
                }
                catch (Exception exception) {
                    continue;
                }
                for (String string2 : list) {
                    this.currentRetrievalList.addLast(new RetrieveEntry(string, string2, file, null, retrieveEntry.getDocType(), retrieveEntry.isRecursive()));
                }
                this.printList();
            }
            this.closeOPOuts();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void printList() {
        for (RetrieveEntry retrieveEntry : this.currentRetrievalList) {
        }
    }

    public File getCurrentSaveRootFile() {
        return this.currentSaveRootFile;
    }

    public void setCurrentSaveRootFile(File file) {
        this.currentSaveRootFile = file;
    }

    private String getCorrectFolderName(int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.firstAddressParentStr, "/");
        Stack<String> stack = new Stack<String>();
        while (stringTokenizer.hasMoreTokens()) {
            stack.push(stringTokenizer.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            stack.pop();
        }
        return (String)stack.pop();
    }

    public void pushDownRoot(int n) {
        File file;
        File file2 = file = new File(this.currentSaveRootFile.getParent() + File.separator + System.currentTimeMillis());
        file2.mkdirs();
        for (int i = n; i >= 2; --i) {
            file2 = new File(file2.toString() + File.separator + this.getCorrectFolderName(this.currentPushCount + i));
            file2.mkdirs();
        }
        File file3 = file2 = new File(file2.toString() + File.separator + this.getCorrectFolderName(this.currentPushCount + 1));
        while (!this.currentSaveRootFile.renameTo(file3)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (!file.renameTo(this.currentSaveRootFile)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        File file4 = this.currentSaveRootFile;
        for (int i = n; i >= 1; --i) {
            file4 = new File(file4.toString() + File.separator + this.getCorrectFolderName(this.currentPushCount + i));
        }
        this.correctAllEntriesInTheList(file4);
        this.previousPushCount = this.currentPushCount;
        this.currentPushCount += n;
    }

    public File getNewFileForOld(File file, int n) {
        File file2 = this.currentSaveRootFile;
        for (int i = n; i >= 1; --i) {
            file2 = new File(file2.toString() + File.separator + this.getCorrectFolderName(this.previousPushCount + i));
        }
        String string = file.toString();
        String string2 = new String(new StringBuffer(string).replace(0, this.currentSaveRootFile.toString().length(), file2.toString()));
        File file3 = new File(string2);
        return file3;
    }

    private void correctAllEntriesInTheList(File file) {
        File file2;
        String string;
        String string2;
        for (RetrieveEntry retrieveEntry : this.currentRetrievalList) {
            string2 = retrieveEntry.getLocalBaseFile().toString();
            string = new String(new StringBuffer(string2).replace(0, this.currentSaveRootFile.toString().length(), file.toString()));
            file2 = new File(string);
            retrieveEntry.setLocalBaseFile(file2);
        }
        for (RetrieveEntry retrieveEntry : this.retrievedList) {
            string2 = retrieveEntry.getSaveFile().toString();
            string = new String(new StringBuffer(string2).replace(0, this.currentSaveRootFile.toString().length(), file.toString()));
            file2 = new File(string);
            retrieveEntry.setSaveFile(file2);
        }
    }

    public File getFixedSaveRootFolder() {
        return this.fixedSaveRootFolder;
    }

    private void handleException(RetrieveEntry retrieveEntry, Exception exception) {
        if (this.audits == null) {
            this.audits = new HashMap<RetrieveEntry, Exception>();
        }
        this.audits.put(retrieveEntry, exception);
        if (exception instanceof UnknownHostException) {
            String string = NbBundle.getMessage(RetrieverEngineImpl.class, (String)"MSG_unknown_host_p1") + exception.getLocalizedMessage() + "\n" + NbBundle.getMessage(RetrieverEngineImpl.class, (String)"MSG_unknownhost_p2");
            this.outputError(string);
            if (this.showErrorPopup) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        if (exception instanceof URISyntaxException) {
            String string = exception.getLocalizedMessage();
            this.outputError(string);
            if (this.showErrorPopup) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        if (exception instanceof FileNotFoundException) {
            String string = NbBundle.getMessage(RetrieverEngineImpl.class, (String)"MSG_unknown_file", (Object)exception.getMessage());
            this.outputError(string);
            if (this.showErrorPopup) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        if (exception instanceof IOException) {
            String string = NbBundle.getMessage(RetrieverEngineImpl.class, (String)"EXCEPTION_CYCLIC_REFERENCE_INDICATOR");
            if (exception.getMessage().startsWith(string)) {
                this.outputMessage(exception.getMessage() + ":\n\t " + NbBundle.getMessage(RetrieverEngineImpl.class, (String)"MSG_retrieving_location_found_in", (Object)retrieveEntry.getCurrentAddress(), (Object)retrieveEntry.getBaseAddress()));
                return;
            }
            String string2 = NbBundle.getMessage(RetrieverEngineImpl.class, (String)"MSG_general_io_error", (Object)exception.getMessage());
            if (this.showErrorPopup) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            this.outputError(string2);
            return;
        }
        this.outputError(exception.getMessage());
    }

    private InputOutput getOPWindow() {
        if (this.iop == null) {
            this.iop = IOProvider.getDefault().getIO(this.opTabTitle, false);
            this.iop.setErrSeparated(true);
            this.iop.setFocusTaken(false);
            this.ioOut = this.iop.getOut();
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            this.ioOut.print("\n\n" + dateFormat.format(new Date(System.currentTimeMillis())) + " : ");
        }
        return this.iop;
    }

    private void closeOPOuts() {
        this.getErrOut().close();
        this.getOPOut().close();
    }

    private OutputWriter getOPOut() {
        if (this.ioOut == null) {
            this.ioOut = this.getOPWindow().getOut();
        }
        return this.ioOut;
    }

    private OutputWriter getErrOut() {
        if (this.ioError == null) {
            this.ioError = this.getOPWindow().getErr();
        }
        return this.ioError;
    }

    private void outputError(String string) {
        OutputWriter outputWriter = this.getErrOut();
        outputWriter.println(NbBundle.getMessage(RetrieverEngineImpl.class, (String)"MSG_Error_str", (Object)string));
        outputWriter.flush();
    }

    private void outputMessage(String string) {
        OutputWriter outputWriter = this.getOPOut();
        outputWriter.println(string);
        outputWriter.flush();
    }

    private void updateDownloadingInfo(RetrieveEntry retrieveEntry) {
        OutputWriter outputWriter = this.getOPOut();
        if (retrieveEntry.getBaseAddress() != null) {
            outputWriter.println(NbBundle.getMessage(RetrieverEngineImpl.class, (String)"MSG_retrieving_location_found_in", (Object)retrieveEntry.getCurrentAddress(), (Object)retrieveEntry.getBaseAddress()));
        } else {
            outputWriter.println(NbBundle.getMessage(RetrieverEngineImpl.class, (String)"MSG_retrieving_location", (Object)retrieveEntry.getCurrentAddress()));
        }
        outputWriter.flush();
    }

    public List<RetrieveEntry> getRetrievedList() {
        return this.retrievedList;
    }

    private void updateDownloadedInfo(RetrieveEntry retrieveEntry) {
        this.retrievedList.add(retrieveEntry);
        OutputWriter outputWriter = this.getOPOut();
        String string = "   " + retrieveEntry.getEffectiveAddress();
        outputWriter.println(NbBundle.getMessage(RetrieverEngineImpl.class, (String)"MSG_retrieved_saved_at", (Object)string, (Object)retrieveEntry.getSaveFile()));
        outputWriter.flush();
    }

    public File getSeedFileLocation() {
        if (this.retrievedList.size() > 0) {
            RetrieveEntry retrieveEntry = this.retrievedList.get(0);
            return retrieveEntry.getSaveFile();
        }
        return null;
    }

    private void createCatalogIfRequired(RetrieveEntry retrieveEntry) {
        String string;
        URI uRI = null;
        String string2 = retrieveEntry.getEffectiveAddress();
        try {
            string = URLResourceRetriever.resolveURL(retrieveEntry.getBaseAddress(), retrieveEntry.getCurrentAddress());
            if (!new URI(string).equals(new URI(string2))) {
                string2 = string;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (this.isSave2SingleFolder() && !retrieveEntry.getCurrentAddress().equals(retrieveEntry.getEffectiveAddress())) {
            string2 = retrieveEntry.getCurrentAddress();
        }
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            return;
        }
        string = null;
        try {
            string = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)retrieveEntry.getSaveFile()));
        }
        catch (Exception exception) {
            return;
        }
        if (string == null) {
            return;
        }
        CatalogWriteModel catalogWriteModel = null;
        try {
            if (this.catalogFileObject == null) {
                Project project = FileOwnerQuery.getOwner((FileObject)string);
                if (project == null) {
                    return;
                }
                catalogWriteModel = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject((FileObject)string);
            } else {
                catalogWriteModel = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForCatalogFile(this.catalogFileObject);
            }
        }
        catch (CatalogModelException catalogModelException) {
            return;
        }
        try {
            catalogWriteModel.addURI(uRI, (FileObject)string);
        }
        catch (Exception exception) {
            Exception exception2 = new Exception("Exception while writing in to catalog.", exception);
            this.handleException(retrieveEntry, exception2);
            return;
        }
    }

    @Override
    public void setFileOverwrite(boolean bl) {
        this.fileOverwrite = bl;
    }

    public boolean getFileOverwrite() {
        return this.fileOverwrite;
    }

    public Map<RetrieveEntry, Exception> getRetrievedResourceExceptionMap() {
        return this.audits;
    }

    public void setCatalogFile(FileObject fileObject) {
        this.catalogFileObject = fileObject;
    }

    public void setSave2SingleFolder(boolean bl) {
        this.save2SingleFolder = bl;
    }

    public boolean isSave2SingleFolder() {
        return this.save2SingleFolder;
    }
}

