/*
 * Decompiled with CFR 0.152.
 */
package ricoh.ant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;
import ricoh.TypesafeEnum;
import ricoh.ant.LoggingTask;

public class PropertyMerge
extends LoggingTask {
    private File file1;
    private File file2;
    private File output;
    private PreserveCommentState commentState;
    private HashMap table;
    private PrintWriter writer;
    public static final int READ_BUFFER_MAX_SIZE = 4096;

    public void initialize() {
        this.table = new HashMap();
        this.commentState = PreserveCommentState.NO_COMMENTS;
        this.setAlertLevel("info");
        this.file1 = null;
        this.file2 = null;
        this.output = null;
    }

    public void setFile1(String filepath) throws BuildException {
        this.file1 = new File(filepath);
        if (!this.file1.exists()) {
            throw new BuildException(filepath + " not found");
        }
    }

    public void setFile2(String filepath) throws BuildException {
        this.file2 = new File(filepath);
        if (!this.file2.exists()) {
            throw new BuildException(filepath + " not found");
        }
    }

    public void setOutput(String filepath) throws BuildException {
        this.output = new File(filepath);
        try {
            if (!this.output.exists()) {
                this.output.createNewFile();
            }
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(this.output, false)));
        }
        catch (IOException ioe) {
            String msg = "could not open output file " + filepath;
            ioe.printStackTrace();
            throw new BuildException(msg);
        }
        this.log("outputfile set: " + this.output.getAbsolutePath(), Level.CONFIG.intValue());
    }

    public void setPreserveComments(String target) {
        if (target.equals("file1")) {
            this.commentState = PreserveCommentState.FILE1_COMMENTS;
            this.log("Preserving comments from " + this.file1.getName());
        } else if (target.equals("file2")) {
            this.commentState = PreserveCommentState.FILE2_COMMENTS;
            this.log("Preserving comments from " + this.file2.getName());
        } else if (target.equals("both")) {
            this.commentState = PreserveCommentState.ALL_COMMENTS;
            this.log("Preserving comments from both files");
        } else if (target.equals("none")) {
            this.commentState = PreserveCommentState.NO_COMMENTS;
            this.log("Preserving no comments");
        }
    }

    public void execute() throws BuildException {
        String currentLine;
        int longestPropLength = 0;
        BufferedReader reader1 = null;
        BufferedReader reader2 = null;
        if (this.file1 == null || this.file2 == null || this.output == null) {
            throw new BuildException("file1, file2, and output are required attributes for task PropertyMerge.");
        }
        try {
            String currentValue;
            String currentKey;
            int equalsIdx;
            reader1 = new BufferedReader(new FileReader(this.file1));
            reader2 = new BufferedReader(new FileReader(this.file2));
            currentLine = reader1.readLine();
            while (currentLine != null) {
                if (!currentLine.startsWith("#") && (equalsIdx = currentLine.indexOf("=")) > 0) {
                    currentKey = currentLine.substring(0, equalsIdx).trim();
                    if (currentKey.length() > longestPropLength) {
                        longestPropLength = currentKey.length();
                    }
                    currentValue = currentLine.substring(equalsIdx + 1, currentLine.length()).trim();
                    this.table.put(currentKey, currentValue);
                }
                currentLine = reader1.readLine();
            }
            currentLine = reader2.readLine();
            while (currentLine != null) {
                if (!currentLine.startsWith("#") && (equalsIdx = currentLine.indexOf("=")) > 0 && (this.table.containsKey(currentKey = currentLine.substring(0, equalsIdx).trim()) && this.file2.lastModified() >= this.file1.lastModified() || !this.table.containsKey(currentKey))) {
                    currentValue = currentLine.substring(equalsIdx + 1, currentLine.length()).trim();
                    this.table.put(currentKey, currentValue);
                }
                currentLine = reader2.readLine();
            }
            reader1 = new BufferedReader(new FileReader(this.file1));
            reader2 = new BufferedReader(new FileReader(this.file2));
        }
        catch (IOException ioe) {
            String msg = "I/O Error while reading during first pass.";
            ioe.printStackTrace();
            throw new BuildException(msg);
        }
        try {
            boolean blankLine;
            if (this.commentState.equals(PreserveCommentState.NO_COMMENTS)) {
                Set entries = this.table.entrySet();
                Iterator i = entries.iterator();
                while (i.hasNext()) {
                    Map.Entry currentEntry = i.next();
                    this.writer.println(currentEntry.getKey() + " = " + currentEntry.getValue());
                }
            } else if (this.commentState.equals(PreserveCommentState.FILE1_COMMENTS)) {
                String readKey;
                currentLine = reader1.readLine();
                blankLine = currentLine.trim().equals("");
                while (currentLine != null) {
                    if (currentLine.trim().startsWith("#")) {
                        blankLine = false;
                        this.writer.println(currentLine);
                    } else if (currentLine.trim().equals("") && !blankLine) {
                        blankLine = true;
                        this.writer.println();
                    } else if (currentLine.contains("=")) {
                        blankLine = false;
                        readKey = currentLine.substring(0, currentLine.indexOf("=")).trim();
                        this.writer.println(readKey + this.spacerString(longestPropLength - readKey.length()) + " = " + this.table.get(readKey));
                        this.table.remove(readKey);
                    }
                    currentLine = reader1.readLine();
                }
                if (this.table.size() != 0) {
                    Set remainingKeys = this.table.keySet();
                    Iterator i = remainingKeys.iterator();
                    while (i.hasNext()) {
                        readKey = (String)i.next();
                        this.writer.println(readKey + this.spacerString(longestPropLength - readKey.length()) + " = " + this.table.get(readKey));
                    }
                }
            } else if (this.commentState.equals(PreserveCommentState.FILE2_COMMENTS)) {
                String readKey;
                currentLine = reader2.readLine();
                blankLine = currentLine.trim().equals("");
                while (currentLine != null) {
                    if (currentLine.trim().startsWith("#")) {
                        blankLine = false;
                        this.writer.println(currentLine);
                    } else if (currentLine.trim().equals("") && !blankLine) {
                        blankLine = true;
                        this.writer.println();
                    } else {
                        readKey = currentLine.substring(0, currentLine.indexOf("=")).trim();
                        this.writer.println(readKey + this.spacerString(longestPropLength - readKey.length()) + " = " + this.table.get(readKey));
                        this.table.remove(readKey);
                    }
                    currentLine = reader2.readLine();
                }
                if (this.table.size() != 0) {
                    Set remainingKeys = this.table.keySet();
                    Iterator i = remainingKeys.iterator();
                    while (i.hasNext()) {
                        readKey = (String)i.next();
                        this.writer.println(readKey + this.spacerString(longestPropLength - readKey.length()) + " = " + this.table.get(readKey));
                    }
                }
            } else if (this.commentState.equals(PreserveCommentState.ALL_COMMENTS)) {
                String readKey;
                BlockReadState blockState = BlockReadState.BEFORE_BLOCK;
                BufferedReader currentReader = reader1;
                currentLine = currentReader.readLine();
                boolean blankLine2 = currentLine.trim().equals("");
                while (reader1 != null || reader2 != null) {
                    if (currentLine.trim().startsWith("#")) {
                        blankLine2 = false;
                        if (blockState == BlockReadState.BEFORE_BLOCK || blockState == BlockReadState.IN_BLOCK) {
                            blockState = BlockReadState.IN_BLOCK;
                            this.writer.println(currentLine);
                        } else if (blockState == BlockReadState.LEAVING_BLOCK) {
                            currentReader.reset();
                            if (currentReader == reader1 && reader2 != null) {
                                currentReader = reader2;
                            } else if (reader1 != null) {
                                currentReader = reader1;
                            }
                            blockState = BlockReadState.IN_BLOCK;
                        }
                    } else if (currentLine.trim().equals("") && !blankLine2) {
                        blankLine2 = true;
                        this.writer.println();
                    } else {
                        blankLine2 = false;
                        blockState = BlockReadState.LEAVING_BLOCK;
                        readKey = currentLine.substring(0, currentLine.indexOf("=")).trim();
                        if (this.table.get(readKey) != null) {
                            this.writer.println(readKey + this.spacerString(longestPropLength - readKey.length()) + " = " + this.table.get(readKey));
                        }
                        this.table.remove(readKey);
                    }
                    currentReader.mark(4096);
                    currentLine = currentReader.readLine();
                    if (currentLine != null) continue;
                    if (currentReader == reader1) {
                        reader1 = null;
                        currentReader = reader2;
                        this.writer.println();
                        blockState = BlockReadState.IN_BLOCK;
                    } else {
                        reader2 = null;
                        currentReader = reader1;
                        this.writer.println();
                        blockState = BlockReadState.IN_BLOCK;
                    }
                    if (currentReader == null) continue;
                    currentLine = currentReader.readLine();
                }
                if (this.table.size() != 0) {
                    Set remainingKeys = this.table.keySet();
                    Iterator i = remainingKeys.iterator();
                    while (i.hasNext()) {
                        readKey = (String)i.next();
                        this.writer.println(readKey + this.spacerString(longestPropLength - readKey.length()) + " = " + this.table.get(readKey));
                    }
                }
            }
        }
        catch (IOException ioe) {
            String msg = "There was an error reading or writing.";
            ioe.printStackTrace();
            throw new BuildException(msg);
        }
        this.writer.close();
    }

    private String spacerString(int size) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private static class BlockReadState
    extends TypesafeEnum {
        public static final BlockReadState BEFORE_BLOCK = new BlockReadState("beforeBlock");
        public static final BlockReadState IN_BLOCK = new BlockReadState("inBlock");
        public static final BlockReadState LEAVING_BLOCK = new BlockReadState("leavingBlock");

        private BlockReadState(String name) {
            super(name);
        }
    }

    private static class PreserveCommentState
    extends TypesafeEnum {
        public static final PreserveCommentState FILE1_COMMENTS = new PreserveCommentState("file1");
        public static final PreserveCommentState FILE2_COMMENTS = new PreserveCommentState("file2");
        public static final PreserveCommentState ALL_COMMENTS = new PreserveCommentState("both");
        public static final PreserveCommentState NO_COMMENTS = new PreserveCommentState("none");

        private PreserveCommentState(String name) {
            super(name);
        }
    }
}

