/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;

public final class DeclarationGenerator {
    public static final String INLINE_PROPERTY = "inline_method";
    public static final String INSERT_CODE_INLINE_PROPERTY = "insert_code_inline_method";

    private DeclarationGenerator() {
    }

    public static String createGetter(CsmField csmField, String string, Kind kind) {
        StringBuilder stringBuilder = new StringBuilder();
        if (csmField.isStatic()) {
            stringBuilder.append("static ");
        }
        stringBuilder.append(csmField.getType().getText()).append(" ");
        if (kind == Kind.EXTERNAL_DEFINITION) {
            stringBuilder.append(csmField.getContainingClass().getName()).append("::");
        }
        stringBuilder.append(string).append("() const ");
        if (kind == Kind.DECLARATION) {
            stringBuilder.append(";");
        } else {
            stringBuilder.append("{ ").append("return ").append(csmField.getName()).append(";}");
        }
        return stringBuilder.toString();
    }

    public static String createSetter(CsmField csmField, String string, Kind kind) {
        StringBuilder stringBuilder = new StringBuilder();
        CharSequence charSequence = csmField.getName();
        String string2 = GeneratorUtils.stripFieldPrefix(((Object)charSequence).toString());
        stringBuilder.append("\n");
        if (csmField.isStatic()) {
            stringBuilder.append("static ");
        }
        stringBuilder.append("void ");
        if (kind == Kind.EXTERNAL_DEFINITION) {
            stringBuilder.append(csmField.getContainingClass().getName()).append("::");
        }
        stringBuilder.append(string).append("(");
        stringBuilder.append(csmField.getType().getText());
        stringBuilder.append(" ").append(string2);
        stringBuilder.append(")");
        if (kind == Kind.DECLARATION) {
            stringBuilder.append(";");
        } else {
            stringBuilder.append("{ ").append("this->").append(charSequence).append("=").append(string2).append(";}");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        INLINE_DEFINITION,
        DECLARATION,
        EXTERNAL_DEFINITION;

    }
}

