/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.gsf.CssAstElement;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssStructureScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(ParserResult parserResult) {
        SimpleNode simpleNode = ((CssParserResult)parserResult).root();
        final Snapshot snapshot = parserResult.getSnapshot();
        if (simpleNode == null) {
            return Collections.emptyList();
        }
        final ArrayList arrayList = new ArrayList();
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 20) {
                    SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetParent();
                    assert (simpleNode2.kind() == 19);
                    int n = snapshot.getOriginalOffset(simpleNode2.startOffset());
                    int n2 = snapshot.getOriginalOffset(simpleNode2.endOffset());
                    if (n2 != n) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                            SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(i);
                            if (simpleNode3.kind() != 21) continue;
                            StringBuffer stringBuffer2 = new StringBuffer();
                            for (int j = 0; j < simpleNode3.jjtGetNumChildren(); ++j) {
                                SimpleNode simpleNode4 = (SimpleNode)simpleNode3.jjtGetChild(j);
                                if (simpleNode4.kind() != 22 && simpleNode4.kind() != 16 || simpleNode4.image().trim().length() <= 0) continue;
                                try {
                                    CharSequence charSequence = snapshot.getSource().createSnapshot().getText().subSequence(snapshot.getOriginalOffset(simpleNode4.startOffset()), snapshot.getOriginalOffset(simpleNode4.endOffset()));
                                    stringBuffer2.append(charSequence);
                                    stringBuffer2.append(' ');
                                    continue;
                                }
                                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                    // empty catch block
                                }
                            }
                            if (stringBuffer2.length() <= 0) continue;
                            stringBuffer.append(stringBuffer2.substring(0, stringBuffer2.length() - 1));
                            stringBuffer.append(", ");
                        }
                        if (stringBuffer.length() > 2) {
                            if (stringBuffer.charAt(stringBuffer.length() - 2) == ',') {
                                stringBuffer.deleteCharAt(stringBuffer.length() - 2);
                            }
                            arrayList.add(new CssRuleStructureItem(stringBuffer.toString(), CssAstElement.createElement(simpleNode2), snapshot));
                        }
                    }
                }
            }
        };
        simpleNode.visitChildren(nodeVisitor);
        return arrayList;
    }

    public Map<String, List<OffsetRange>> folds(ParserResult parserResult) {
        final BaseDocument baseDocument = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false);
        if (baseDocument == null) {
            return Collections.emptyMap();
        }
        SimpleNode simpleNode = ((CssParserResult)parserResult).root();
        final Snapshot snapshot = parserResult.getSnapshot();
        if (simpleNode == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        final ArrayList arrayList = new ArrayList();
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 19) {
                    int n = snapshot.getOriginalOffset(simpleNode.startOffset());
                    int n2 = snapshot.getOriginalOffset(simpleNode.endOffset());
                    for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                        if (simpleNode2.kind() != 20) continue;
                        n = snapshot.getOriginalOffset(simpleNode2.endOffset());
                        break;
                    }
                    try {
                        if (n >= 0 && n2 >= 0 && n2 < baseDocument.getLength() && Utilities.getLineOffset((BaseDocument)baseDocument, (int)n) < Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2)) {
                            arrayList.add(new OffsetRange(n, n2));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        };
        simpleNode.visitChildren(nodeVisitor);
        hashMap.put("codeblocks", arrayList);
        return hashMap;
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(true, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CssRuleStructureItem
    implements StructureItem {
        private String name;
        private CssAstElement element;
        private int from;
        private int to;

        private static String escape(String string) {
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
            return string;
        }

        private CssRuleStructureItem(String string, CssAstElement cssAstElement, Snapshot snapshot) {
            this.name = string;
            this.element = cssAstElement;
            this.from = snapshot.getOriginalOffset(cssAstElement.node().startOffset());
            this.to = snapshot.getOriginalOffset(cssAstElement.node().endOffset());
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            return CssRuleStructureItem.escape(this.getName());
        }

        public ElementHandle getElementHandle() {
            return this.element;
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.from;
        }

        public long getEndPosition() {
            return this.to;
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }
}

