/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web.metadata;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.dd.api.web.model.FilterInfo;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.CommonAnnotationHelper;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.EjbRefHelper;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.AnnotationHelpers;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.SecurityRoles;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.WebFilter;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.WebServlet;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.FilterInfoAccessor;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.MergeEngine;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.ServletInfoAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeEngines {
    private static ServletsEngine servletsEngine = new ServletsEngine();
    private static FiltersEngine filtersEngine = new FiltersEngine();
    private static SecurityRolesEngine securityRolesEngine = new SecurityRolesEngine();
    private static ResourceRefsEngine resourceRefsEngine = new ResourceRefsEngine();
    private static ResourceEnvRefsEngine resourceEnvRefsEngine = new ResourceEnvRefsEngine();
    private static ResourceEnvEntriesEngine resourceEnvEntriesEngine = new ResourceEnvEntriesEngine();
    private static ResourceMsgDestsEngine resourceMsgDestsEngine = new ResourceMsgDestsEngine();
    private static ResourceServicesEngine resourceServicesEngine = new ResourceServicesEngine();
    private static EjbLocalRefsEngine ejbLocalRefsEngine = new EjbLocalRefsEngine();
    private static EjbRefsEngine ejbRefsEngine = new EjbRefsEngine();

    private MergeEngines() {
    }

    static MergeEngine<ServletInfo> servletsEngine() {
        return servletsEngine;
    }

    static MergeEngine<FilterInfo> filtersEngine() {
        return filtersEngine;
    }

    static MergeEngine<String> securityRolesEngine() {
        return securityRolesEngine;
    }

    static MergeEngine<ResourceRef> resourceRefsEngine() {
        return resourceRefsEngine;
    }

    static MergeEngine<ResourceEnvRef> resourceEnvRefsEngine() {
        return resourceEnvRefsEngine;
    }

    static MergeEngine<EnvEntry> resourceEnvEntriesEngine() {
        return resourceEnvEntriesEngine;
    }

    static MergeEngine<MessageDestinationRef> resourceMsgDestsEngine() {
        return resourceMsgDestsEngine;
    }

    static MergeEngine<ServiceRef> resourceServicesEngine() {
        return resourceServicesEngine;
    }

    static MergeEngine<EjbLocalRef> ejbLocalRefsEngine() {
        return ejbLocalRefsEngine;
    }

    static MergeEngine<EjbRef> ejbRefsEngine() {
        return ejbRefsEngine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EjbRefsEngine
    extends MergeEngine<EjbRef> {
        private EjbRefsEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            this.addAll(webApp.getEjbRef());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getEjbRef());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ArrayList<EjbRef> arrayList = new ArrayList<EjbRef>();
            EjbRefHelper.setEjbRefs(annotationHelpers.getHelper(), arrayList, null);
            this.res.addAll(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EjbLocalRefsEngine
    extends MergeEngine<EjbLocalRef> {
        private EjbLocalRefsEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            this.addAll(webApp.getEjbLocalRef());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getEjbLocalRef());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ArrayList<EjbLocalRef> arrayList = new ArrayList<EjbLocalRef>();
            EjbRefHelper.setEjbRefs(annotationHelpers.getHelper(), null, arrayList);
            this.res.addAll(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceServicesEngine
    extends MergeEngine<ServiceRef> {
        private ResourceServicesEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            try {
                this.addAll(webApp.getServiceRef());
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        void addItems(WebFragment webFragment) {
            try {
                this.addAll(webFragment.getServiceRef());
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ServiceRef[] serviceRefArray;
            for (ServiceRef serviceRef : serviceRefArray = CommonAnnotationHelper.getServiceRefs(annotationHelpers.getHelper())) {
                this.res.add(serviceRef);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceMsgDestsEngine
    extends MergeEngine<MessageDestinationRef> {
        private ResourceMsgDestsEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            try {
                this.addAll(webApp.getMessageDestinationRef());
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        void addItems(WebFragment webFragment) {
            try {
                this.addAll(webFragment.getMessageDestinationRef());
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            MessageDestinationRef[] messageDestinationRefArray;
            for (MessageDestinationRef messageDestinationRef : messageDestinationRefArray = CommonAnnotationHelper.getMessageDestinationRefs(annotationHelpers.getHelper())) {
                this.res.add(messageDestinationRef);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceEnvEntriesEngine
    extends MergeEngine<EnvEntry> {
        private ResourceEnvEntriesEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            this.addAll(webApp.getEnvEntry());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getEnvEntry());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            EnvEntry[] envEntryArray;
            for (EnvEntry envEntry : envEntryArray = CommonAnnotationHelper.getEnvEntries(annotationHelpers.getHelper())) {
                this.res.add(envEntry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceEnvRefsEngine
    extends MergeEngine<ResourceEnvRef> {
        private ResourceEnvRefsEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            this.addAll(webApp.getResourceEnvRef());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getResourceEnvRef());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ResourceEnvRef[] resourceEnvRefArray;
            for (ResourceEnvRef resourceEnvRef : resourceEnvRefArray = CommonAnnotationHelper.getResourceEnvRefs(annotationHelpers.getHelper())) {
                this.res.add(resourceEnvRef);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceRefsEngine
    extends MergeEngine<ResourceRef> {
        private ResourceRefsEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            this.addAll(webApp.getResourceRef());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getResourceRef());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ResourceRef[] resourceRefArray;
            for (ResourceRef resourceRef : resourceRefArray = CommonAnnotationHelper.getResourceRefs(annotationHelpers.getHelper())) {
                this.res.add(resourceRef);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SecurityRolesEngine
    extends MergeEngine<String> {
        private SecurityRolesEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            this.addRole(webApp.getSecurityRole());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addRole(webFragment.getSecurityRole());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            for (SecurityRoles securityRoles : annotationHelpers.getSecurityRolesPOM().getObjects()) {
                this.res.addAll(securityRoles.getRoles());
            }
        }

        private void addRole(SecurityRole[] securityRoleArray) {
            for (SecurityRole securityRole : securityRoleArray) {
                this.res.add(securityRole.getRoleName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FiltersEngine
    extends MergeEngine<FilterInfo> {
        private FiltersEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            this.addFilters(webApp.getFilter(), webApp.getFilterMapping());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addFilters(webFragment.getFilter(), webFragment.getFilterMapping());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            for (WebFilter webFilter : annotationHelpers.getWebFilterPOM().getObjects()) {
                this.res.add(FilterInfoAccessor.getDefault().createFilterInfo(webFilter.getName(), webFilter.getFilterClass(), webFilter.getUrlPatterns()));
            }
        }

        private void addFilters(Filter[] filterArray, FilterMapping[] filterMappingArray) {
            if (filterArray != null) {
                for (Filter filter : filterArray) {
                    String string = filter.getFilterName();
                    String string2 = filter.getFilterClass();
                    List<String> list = this.findUrlMappingsForFilter(filterMappingArray, string);
                    this.res.add(FilterInfoAccessor.getDefault().createFilterInfo(string, string2, list));
                }
            }
        }

        private List<String> findUrlMappingsForFilter(FilterMapping[] filterMappingArray, String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (filterMappingArray != null) {
                for (FilterMapping filterMapping : filterMappingArray) {
                    if (!filterMapping.getFilterName().equals(string) || filterMapping.getUrlPattern() == null) continue;
                    arrayList.add(filterMapping.getUrlPattern());
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServletsEngine
    extends MergeEngine<ServletInfo> {
        private ServletsEngine() {
        }

        @Override
        void addItems(WebApp webApp) {
            this.addServlets(webApp.getServlet(), webApp.getServletMapping());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addServlets(webFragment.getServlet(), webFragment.getServletMapping());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            for (WebServlet webServlet : annotationHelpers.getWebServletPOM().getObjects()) {
                this.res.add(ServletInfoAccessor.getDefault().createServletInfo(webServlet.getName(), webServlet.getServletClass(), webServlet.getUrlPatterns()));
            }
        }

        private void addServlets(Servlet[] servletArray, ServletMapping[] servletMappingArray) {
            if (servletArray != null) {
                for (Servlet servlet : servletArray) {
                    String string = servlet.getServletName();
                    String string2 = servlet.getServletClass();
                    List<String> list = this.findUrlMappingsForServlet(servletMappingArray, string);
                    this.res.add(ServletInfoAccessor.getDefault().createServletInfo(string, string2, list));
                }
            }
        }

        private List<String> findUrlMappingsForServlet(ServletMapping[] servletMappingArray, String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (servletMappingArray != null) {
                for (ServletMapping servletMapping : servletMappingArray) {
                    if (!servletMapping.getServletName().equals(string) || servletMapping.getUrlPattern() == null) continue;
                    arrayList.add(servletMapping.getUrlPattern());
                }
            }
            return arrayList;
        }
    }
}

