/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.impl.client.AppClientProxy;
import org.netbeans.modules.j2ee.dd.impl.client.ClientParseUtils;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final DDProvider ddProvider = new DDProvider();
    private final FCA fileChangeListener;
    private final Map<URL, WeakReference<AppClientProxy>> ddMap = new HashMap<URL, WeakReference<AppClientProxy>>(5);
    private final Map<URL, WeakReference<AppClient>> baseBeanMap = new HashMap<URL, WeakReference<AppClient>>(5);
    private final Map<URL, SAXParseException> errorMap = new HashMap<URL, SAXParseException>(5);

    private DDProvider() {
        this.fileChangeListener = new FCA();
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    public AppClient getDDRoot(File file) throws IOException, SAXException {
        return DDUtils.createAppClient(new FileInputStream(file), ClientParseUtils.getVersion(new FileInputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AppClient getDDRoot(FileObject fileObject) throws IOException {
        Object object;
        Object object2;
        AppClientProxy appClientProxy;
        block19: {
            if (fileObject == null) {
                return null;
            }
            appClientProxy = null;
            Object object3 = this.ddMap;
            synchronized (object3) {
                appClientProxy = this.getFromCache(fileObject);
                if (appClientProxy != null) {
                    return appClientProxy;
                }
            }
            fileObject.addFileChangeListener((FileChangeListener)this.fileChangeListener);
            object3 = null;
            SAXParseException sAXParseException = null;
            try {
                object2 = null;
                object = this.baseBeanMap;
                synchronized (object) {
                    object2 = this.getOriginalFromCache(fileObject);
                    if (object2 == null) {
                        object3 = ClientParseUtils.getVersion(fileObject.getInputStream());
                        sAXParseException = ClientParseUtils.parse(fileObject);
                        object2 = DDUtils.createAppClient(fileObject.getInputStream(), (String)object3);
                        this.baseBeanMap.put(fileObject.getURL(), new WeakReference<Object>(object2));
                        this.errorMap.put(fileObject.getURL(), sAXParseException);
                    } else {
                        BigDecimal bigDecimal = object2.getVersion();
                        if (bigDecimal != null) {
                            object3 = bigDecimal.toPlainString();
                        }
                        sAXParseException = this.errorMap.get(fileObject.getURL());
                    }
                }
                appClientProxy = new AppClientProxy((AppClient)object2, (String)object3);
                if (sAXParseException != null) {
                    appClientProxy.setStatus(1);
                    appClientProxy.setError(sAXParseException);
                }
            }
            catch (SAXException sAXException) {
                appClientProxy = new AppClientProxy(null, (String)object3);
                appClientProxy.setStatus(2);
                if (sAXException instanceof SAXParseException) {
                    appClientProxy.setError((SAXParseException)sAXException);
                }
                if (!(sAXException.getException() instanceof SAXParseException)) break block19;
                appClientProxy.setError((SAXParseException)sAXException.getException());
            }
        }
        object2 = this.ddMap;
        synchronized (object2) {
            object = this.getFromCache(fileObject);
            if (object != null) {
                return object;
            }
            this.ddMap.put(fileObject.getURL(), new WeakReference<AppClientProxy>(appClientProxy));
        }
        return appClientProxy;
    }

    public AppClient getDDRootCopy(FileObject fileObject) throws IOException {
        return (AppClient)this.getDDRoot(fileObject).clone();
    }

    private AppClientProxy getFromCache(FileObject fileObject) throws IOException {
        if (fileObject == null) {
            return null;
        }
        WeakReference<AppClientProxy> weakReference = this.ddMap.get(fileObject.getURL());
        if (weakReference == null) {
            return null;
        }
        AppClientProxy appClientProxy = (AppClientProxy)weakReference.get();
        if (appClientProxy == null) {
            this.ddMap.remove(fileObject.getURL());
        }
        return appClientProxy;
    }

    private AppClient getOriginalFromCache(FileObject fileObject) throws IOException {
        WeakReference<AppClient> weakReference = this.baseBeanMap.get(fileObject.getURL());
        if (weakReference == null) {
            return null;
        }
        AppClient appClient = (AppClient)weakReference.get();
        if (appClient == null) {
            this.baseBeanMap.remove(fileObject.getURL());
            this.errorMap.remove(fileObject.getURL());
        }
        return appClient;
    }

    public BaseBean getBaseBean(CommonDDBean commonDDBean) {
        Object object = commonDDBean instanceof BaseBean ? (BaseBean)commonDDBean : (commonDDBean instanceof AppClientProxy ? (BaseBean)((AppClientProxy)commonDDBean).getOriginal() : null);
        return object;
    }

    private class FCA
    extends FileChangeAdapter {
        private FCA() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            try {
                Map map = DDProvider.this.ddMap;
                synchronized (map) {
                    Map map2 = DDProvider.this.baseBeanMap;
                    synchronized (map2) {
                        AppClientProxy appClientProxy = DDProvider.this.getFromCache(fileObject);
                        AppClient appClient = DDProvider.this.getOriginalFromCache(fileObject);
                        if (appClientProxy != null) {
                            String string = null;
                            try {
                                string = ClientParseUtils.getVersion(fileObject.getInputStream());
                                SAXParseException sAXParseException = ClientParseUtils.parse(fileObject);
                                if (sAXParseException != null) {
                                    appClientProxy.setError(sAXParseException);
                                    appClientProxy.setStatus(1);
                                } else {
                                    appClientProxy.setError(null);
                                    appClientProxy.setStatus(0);
                                }
                                AppClient appClient2 = DDUtils.createAppClient(fileObject.getInputStream(), string);
                                DDProvider.this.baseBeanMap.put(fileObject.getURL(), new WeakReference<AppClient>(appClient2));
                                DDProvider.this.errorMap.put(fileObject.getURL(), appClientProxy.getError());
                                appClientProxy.merge(appClient2, 3);
                            }
                            catch (SAXException sAXException) {
                                if (sAXException instanceof SAXParseException) {
                                    appClientProxy.setError((SAXParseException)sAXException);
                                } else if (sAXException.getException() instanceof SAXParseException) {
                                    appClientProxy.setError((SAXParseException)sAXException.getException());
                                }
                                appClientProxy.setStatus(2);
                                appClientProxy.setOriginal(null);
                                appClientProxy.setProxyVersion(string);
                            }
                        } else if (appClient != null) {
                            String string = null;
                            try {
                                string = ClientParseUtils.getVersion(fileObject.getInputStream());
                                AppClient appClient3 = DDUtils.createAppClient(fileObject.getInputStream(), string);
                                if (appClient3.getClass().equals(appClient.getClass())) {
                                    appClient.merge(appClient3, 3);
                                } else {
                                    DDProvider.this.baseBeanMap.put(fileObject.getURL(), new WeakReference<AppClient>(appClient3));
                                }
                            }
                            catch (SAXException sAXException) {
                                DDProvider.this.baseBeanMap.remove(fileObject.getURL());
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

