/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.OpenCookieFactory;
import org.netbeans.modules.websvc.rest.nodes.ResourceUriProvider;
import org.netbeans.modules.websvc.rest.nodes.RestServiceChildren;
import org.netbeans.modules.websvc.rest.nodes.TestResourceUriAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class RestServiceNode
extends AbstractNode {
    private Project project;
    private String serviceName;
    private String uriTemplate;
    private String className;
    private RestServicesModel model;
    private static final Image SERVICE_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/rest/nodes/resources/restservice.png");

    public RestServiceNode(Project project, RestServicesModel restServicesModel, RestServiceDescription restServiceDescription) {
        this(project, restServicesModel, restServiceDescription, new InstanceContent());
    }

    private RestServiceNode(Project project, RestServicesModel restServicesModel, final RestServiceDescription restServiceDescription, InstanceContent instanceContent) {
        super((Children)new RestServiceChildren(project, restServicesModel, restServiceDescription.getName()), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.project = project;
        this.serviceName = restServiceDescription.getName();
        this.uriTemplate = restServiceDescription.getUriTemplate();
        this.className = restServiceDescription.getClassName();
        instanceContent.add((Object)this);
        instanceContent.add((Object)new ResourceUriProvider(){

            public String getResourceUri() {
                return restServiceDescription.getUriTemplate();
            }
        });
        instanceContent.add((Object)project);
        instanceContent.add((Object)OpenCookieFactory.create(project, this.className));
    }

    public String getDisplayName() {
        if (this.uriTemplate.length() > 0) {
            return this.serviceName + " [" + this.uriTemplate + "]";
        }
        return this.serviceName;
    }

    public String getShortDescription() {
        return "";
    }

    public static String getKey(RestServiceDescription restServiceDescription) {
        return restServiceDescription.getName() + ":" + restServiceDescription.getUriTemplate();
    }

    public Image getIcon(int n) {
        return SERVICE_BADGE;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean bl) {
        return new SystemAction[]{SystemAction.get(OpenAction.class), SystemAction.get(TestResourceUriAction.class), null, SystemAction.get(PropertiesAction.class)};
    }
}

