/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.query;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.eclipse.core.runtime.CoreException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.issuetable.QueryTableCellRenderer;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.QueryNotifyListener;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.BugzillaConnector;
import org.netbeans.modules.bugzilla.commands.BugzillaCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.BugzillaQueryCellRenderer;
import org.netbeans.modules.bugzilla.query.QueryPanel;
import org.netbeans.modules.bugzilla.query.QueryParameter;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryController
extends BugtrackingController
implements DocumentListener,
ItemListener,
ListSelectionListener,
ActionListener,
FocusListener,
KeyListener {
    protected QueryPanel panel;
    private static final String CHANGED_NOW = "Now";
    private final QueryParameter.ComboParameter summaryParameter;
    private final QueryParameter.ComboParameter commentsParameter;
    private final QueryParameter.ComboParameter whiteboardParameter;
    private final QueryParameter.ComboParameter keywordsParameter;
    private final QueryParameter.ComboParameter peopleParameter;
    private final QueryParameter.ListParameter productParameter;
    private final QueryParameter.ListParameter componentParameter;
    private final QueryParameter.ListParameter versionParameter;
    private final QueryParameter.ListParameter statusParameter;
    private final QueryParameter.ListParameter resolutionParameter;
    private final QueryParameter.ListParameter priorityParameter;
    private final QueryParameter.ListParameter changedFieldsParameter;
    private final QueryParameter.ListParameter severityParameter;
    private final QueryParameter.ListParameter issueTypeParameter;
    private final QueryParameter.ListParameter tmParameter;
    private final Map<String, QueryParameter> parameters;
    private RequestProcessor rp = new RequestProcessor("Bugzilla query", 1, true);
    private final BugzillaRepository repository;
    protected BugzillaQuery query;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private QueryTask refreshTask;
    private final IssueTable issueTable;
    private final boolean isNetbeans;

    public QueryController(BugzillaRepository bugzillaRepository, BugzillaQuery bugzillaQuery, String string, boolean bl) {
        this(bugzillaRepository, bugzillaQuery, string, false, true);
    }

    public QueryController(BugzillaRepository bugzillaRepository, BugzillaQuery bugzillaQuery, String string, boolean bl, boolean bl2) {
        this.repository = bugzillaRepository;
        this.query = bugzillaQuery;
        this.issueTable = new IssueTable((Query)bugzillaQuery, bugzillaQuery.getColumnDescriptors());
        this.setupRenderer(this.issueTable);
        this.panel = new QueryPanel(this.issueTable.getComponent(), this);
        this.isNetbeans = BugzillaUtil.isNbRepository(bugzillaRepository);
        this.panel.setNBFieldsVisible(this.isNetbeans);
        this.panel.productList.addListSelectionListener(this);
        this.panel.filterComboBox.addItemListener(this);
        this.panel.searchButton.addActionListener(this);
        this.panel.refreshCheckBox.addActionListener(this);
        this.panel.keywordsButton.addActionListener(this);
        this.panel.saveChangesButton.addActionListener(this);
        this.panel.cancelChangesButton.addActionListener(this);
        this.panel.gotoIssueButton.addActionListener(this);
        this.panel.webButton.addActionListener((ActionListener)this);
        this.panel.saveButton.addActionListener((ActionListener)this);
        this.panel.urlToggleButton.addActionListener((ActionListener)this);
        this.panel.refreshButton.addActionListener((ActionListener)this);
        this.panel.modifyButton.addActionListener((ActionListener)this);
        this.panel.seenButton.addActionListener((ActionListener)this);
        this.panel.removeButton.addActionListener((ActionListener)this);
        this.panel.refreshConfigurationButton.addActionListener((ActionListener)this);
        this.panel.findIssuesButton.addActionListener((ActionListener)this);
        this.panel.changedFromTextField.addFocusListener(this);
        this.panel.idTextField.addActionListener(this);
        this.panel.productList.addKeyListener(this);
        this.panel.componentList.addKeyListener(this);
        this.panel.versionList.addKeyListener(this);
        this.panel.statusList.addKeyListener(this);
        this.panel.resolutionList.addKeyListener(this);
        this.panel.severityList.addKeyListener(this);
        this.panel.priorityList.addKeyListener(this);
        this.panel.changedList.addKeyListener(this);
        this.panel.tmList.addKeyListener(this);
        this.panel.summaryTextField.addActionListener(this);
        this.panel.commentTextField.addActionListener(this);
        this.panel.whiteboardTextField.addActionListener(this);
        this.panel.keywordsTextField.addActionListener(this);
        this.panel.peopleTextField.addActionListener(this);
        this.panel.changedFromTextField.addActionListener(this);
        this.panel.changedToTextField.addActionListener(this);
        this.panel.changedToTextField.addActionListener(this);
        this.parameters = new LinkedHashMap<String, QueryParameter>();
        this.summaryParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.summaryComboBox, "short_desc_type");
        this.commentsParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.commentComboBox, "long_desc_type");
        this.whiteboardParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.whiteboardComboBox, "status_whiteboard_type");
        this.keywordsParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.keywordsComboBox, "keywords_type");
        this.peopleParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.peopleComboBox, "emailtype1");
        this.productParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.productList, "product");
        this.componentParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.componentList, "component");
        this.versionParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.versionList, "version");
        this.statusParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.statusList, "bug_status");
        this.resolutionParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.resolutionList, "resolution");
        this.priorityParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.priorityList, "priority");
        this.changedFieldsParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.changedList, "chfield");
        if (this.isNetbeans) {
            this.issueTypeParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.issueTypeList, "cf_bug_type");
            this.tmParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.tmList, "target_milestone");
            this.severityParameter = null;
        } else {
            this.severityParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.severityList, "bug_severity");
            this.issueTypeParameter = null;
            this.tmParameter = null;
        }
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.summaryTextField, "short_desc");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.commentTextField, "long_desc");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.whiteboardTextField, "status_whiteboard");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.keywordsTextField, "keywords");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.peopleTextField, "email1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.bugAssigneeCheckBox, "emailassigned_to1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.reporterCheckBox, "emailreporter1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.ccCheckBox, "emailcc1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.commenterCheckBox, "emaillongdesc1");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.changedFromTextField, "chfieldfrom");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.changedToTextField, "chfieldto");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.newValueTextField, "chfieldvalue");
        this.panel.filterComboBox.setModel(new DefaultComboBoxModel<Filter>(this.issueTable.getDefinedFilters()));
        if (bugzillaQuery.isSaved()) {
            this.setAsSaved();
        }
        if (bl) {
            this.panel.switchQueryFields(false);
            this.panel.urlTextField.setText(string);
        } else {
            this.postPopulate(string, false);
        }
    }

    private void setupRenderer(IssueTable issueTable) {
        BugzillaQueryCellRenderer bugzillaQueryCellRenderer = new BugzillaQueryCellRenderer(new QueryTableCellRenderer((Query)this.query));
        issueTable.setRenderer((TableCellRenderer)bugzillaQueryCellRenderer);
    }

    public void opened() {
        boolean bl = BugzillaConfig.getInstance().getQueryAutoRefresh(this.query.getDisplayName());
        if (bl) {
            this.scheduleForRefresh();
        }
        if (this.query.isSaved()) {
            this.setIssueCount(this.query.getSize());
            if (!this.query.wasRun()) {
                this.onRefresh();
            }
        }
    }

    public void closed() {
        this.onCancelChanges();
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
        if (this.query.isSaved() && !(this.query.getRepository() instanceof KenaiRepository)) {
            this.repository.stopRefreshing(this.query);
        }
    }

    protected void scheduleForRefresh() {
        if (this.query.isSaved()) {
            this.repository.scheduleForRefresh(this.query);
        }
    }

    private <T extends QueryParameter> T createQueryParameter(Class<T> clazz, Component component, String string) {
        try {
            Constructor<T> constructor = clazz.getConstructor(component.getClass(), String.class);
            QueryParameter queryParameter = (QueryParameter)constructor.newInstance(component, string);
            this.parameters.put(string, queryParameter);
            return (T)queryParameter;
        }
        catch (Exception exception) {
            Bugzilla.LOG.log(Level.SEVERE, string, exception);
            return null;
        }
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BugzillaQuery.class);
    }

    public boolean isValid() {
        return true;
    }

    public void applyChanges() {
    }

    public String getUrlParameters() {
        if (this.panel.urlPanel.isVisible()) {
            return this.panel.urlTextField.getText();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (QueryParameter queryParameter : this.parameters.values()) {
            stringBuffer.append(queryParameter.get());
        }
        return stringBuffer.toString();
    }

    protected BugzillaRepository getRepository() {
        return this.repository;
    }

    protected void postPopulate(final String string, final boolean bl) {
        this.enableFields(false);
        final RequestProcessor.Task[] taskArray = new RequestProcessor.Task[1];
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (taskArray[0] != null) {
                    return taskArray[0].cancel();
                }
                return true;
            }
        };
        String string2 = NbBundle.getMessage(QueryController.class, (String)"MSG_Populating", (Object[])new Object[]{this.repository.getDisplayName()});
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2, (Cancellable)cancellable);
        this.panel.showRetrievingProgress(true, string2, !this.query.isSaved());
        taskArray[0] = this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                progressHandle.start();
                try {
                    if (bl) {
                        QueryController.this.repository.refreshConfiguration();
                    }
                    QueryController.this.populate(string);
                    QueryController.this.enableFields(true);
                }
                catch (Throwable throwable) {
                    QueryController.this.enableFields(true);
                    progressHandle.finish();
                    QueryController.this.panel.showRetrievingProgress(false, null, !QueryController.this.query.isSaved());
                    throw throwable;
                }
                progressHandle.finish();
                QueryController.this.panel.showRetrievingProgress(false, null, !QueryController.this.query.isSaved());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populate(final String string) {
        block4: {
            if (Bugzilla.LOG.isLoggable(Level.FINE)) {
                Bugzilla.LOG.fine("Starting populate query controller" + (this.query.isSaved() ? " - " + this.query.getDisplayName() : ""));
            }
            try {
                BugzillaCommand bugzillaCommand = new BugzillaCommand(){

                    public void execute() throws CoreException, IOException, MalformedURLException {
                        BugzillaConfiguration bugzillaConfiguration = QueryController.this.repository.getConfiguration();
                        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
                            return;
                        }
                        QueryController.this.productParameter.setParameterValues(QueryController.this.toParameterValues(bugzillaConfiguration.getProducts()));
                        if (QueryController.this.panel.productList.getModel().getSize() > 0) {
                            QueryController.this.panel.productList.setSelectedIndex(0);
                            QueryController.this.populateProductDetails(new String[]{((QueryParameter.ParameterValue)QueryController.this.panel.productList.getSelectedValue()).getValue()});
                        }
                        if (QueryController.this.isNetbeans) {
                            QueryController.this.issueTypeParameter.setParameterValues(QueryController.this.toParameterValues(bugzillaConfiguration.getIssueTypes()));
                        } else {
                            QueryController.this.severityParameter.setParameterValues(QueryController.this.toParameterValues(bugzillaConfiguration.getSeverities()));
                        }
                        QueryController.this.statusParameter.setParameterValues(QueryController.this.toParameterValues(bugzillaConfiguration.getStatusValues()));
                        QueryController.this.resolutionParameter.setParameterValues(QueryController.this.toParameterValues(bugzillaConfiguration.getResolutions()));
                        QueryController.this.priorityParameter.setParameterValues(QueryController.this.toParameterValues(bugzillaConfiguration.getPriorities()));
                        QueryController.this.changedFieldsParameter.setParameterValues(QueryParameter.PV_LAST_CHANGE);
                        QueryController.this.summaryParameter.setParameterValues(QueryParameter.PV_TEXT_SEARCH_VALUES);
                        QueryController.this.commentsParameter.setParameterValues(QueryParameter.PV_TEXT_SEARCH_VALUES);
                        QueryController.this.whiteboardParameter.setParameterValues(QueryParameter.PV_TEXT_SEARCH_VALUES);
                        QueryController.this.keywordsParameter.setParameterValues(QueryParameter.PV_KEYWORDS_VALUES);
                        QueryController.this.peopleParameter.setParameterValues(QueryParameter.PV_PEOPLE_VALUES);
                        QueryController.this.panel.changedToTextField.setText(QueryController.CHANGED_NOW);
                        QueryController.this.setParameters(string != null ? string : QueryController.this.getDefaultParameters());
                        if (QueryController.this.query.isSaved()) {
                            boolean bl = BugzillaConfig.getInstance().getQueryAutoRefresh(QueryController.this.query.getDisplayName());
                            QueryController.this.panel.refreshCheckBox.setSelected(bl);
                        }
                    }
                };
                this.repository.getExecutor().execute(bugzillaCommand);
                if (!Bugzilla.LOG.isLoggable(Level.FINE)) break block4;
                Bugzilla.LOG.fine("Finnished populate query controller" + (this.query.isSaved() ? " - " + this.query.getDisplayName() : ""));
            }
            catch (Throwable throwable) {
                if (Bugzilla.LOG.isLoggable(Level.FINE)) {
                    Bugzilla.LOG.fine("Finnished populate query controller" + (this.query.isSaved() ? " - " + this.query.getDisplayName() : ""));
                }
                throw throwable;
            }
        }
    }

    private String getDefaultParameters() {
        return BugzillaUtil.isNbRepository(this.repository) ? "&bug_status=NEW&bug_status=STARTED&bug_status=REOPENED" : "&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED";
    }

    protected void enableFields(boolean bl) {
        this.panel.enableFields(bl);
        for (Map.Entry<String, QueryParameter> entry : this.parameters.entrySet()) {
            QueryParameter queryParameter = this.parameters.get(entry.getKey());
            queryParameter.setEnabled(bl);
        }
    }

    protected void disableProduct() {
        this.productParameter.setAlwaysDisabled(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireDataChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireDataChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireDataChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.fireDataChanged();
        if (itemEvent.getSource() == this.panel.filterComboBox) {
            this.onFilterChange((Filter)itemEvent.getItem());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.panel.productList) {
            this.onProductChanged(listSelectionEvent);
        }
        this.fireDataChanged();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.panel.changedFromTextField.getText().equals("")) {
            String string = BugzillaConfig.getInstance().getLastChangeFrom();
            this.panel.changedFromTextField.setText(string);
            this.panel.changedFromTextField.setSelectionStart(0);
            this.panel.changedFromTextField.setSelectionEnd(string.length());
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.searchButton) {
            this.onRefresh();
        } else if (actionEvent.getSource() == this.panel.gotoIssueButton) {
            this.onGotoIssue();
        } else if (actionEvent.getSource() == this.panel.keywordsButton) {
            this.onKeywords();
        } else if (actionEvent.getSource() == this.panel.searchButton) {
            this.onRefresh();
        } else if (actionEvent.getSource() == this.panel.saveChangesButton) {
            this.onSave(true);
        } else if (actionEvent.getSource() == this.panel.cancelChangesButton) {
            this.onCancelChanges();
        } else if (actionEvent.getSource() == this.panel.gotoIssueButton) {
            this.onGotoIssue();
        } else if (actionEvent.getSource() == this.panel.webButton) {
            this.onWeb();
        } else if (actionEvent.getSource() == this.panel.saveButton) {
            this.onSave(false);
        } else if (actionEvent.getSource() == this.panel.urlToggleButton) {
            this.onDefineAs();
        } else if (actionEvent.getSource() == this.panel.refreshButton) {
            this.onRefresh();
        } else if (actionEvent.getSource() == this.panel.modifyButton) {
            this.onModify();
        } else if (actionEvent.getSource() == this.panel.seenButton) {
            this.onMarkSeen();
        } else if (actionEvent.getSource() == this.panel.removeButton) {
            this.onRemove();
        } else if (actionEvent.getSource() == this.panel.refreshCheckBox) {
            this.onAutoRefresh();
        } else if (actionEvent.getSource() == this.panel.refreshConfigurationButton) {
            this.onRefreshConfiguration();
        } else if (actionEvent.getSource() == this.panel.findIssuesButton) {
            this.onFindIssues();
        } else if (actionEvent.getSource() == this.panel.idTextField) {
            if (!this.panel.idTextField.getText().trim().equals("")) {
                this.onGotoIssue();
            }
        } else if (actionEvent.getSource() == this.panel.idTextField || actionEvent.getSource() == this.panel.summaryTextField || actionEvent.getSource() == this.panel.commentTextField || actionEvent.getSource() == this.panel.keywordsTextField || actionEvent.getSource() == this.panel.peopleTextField || actionEvent.getSource() == this.panel.changedFromTextField || actionEvent.getSource() == this.panel.newValueTextField || actionEvent.getSource() == this.panel.changedToTextField) {
            this.onRefresh();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 10) {
            return;
        }
        if (keyEvent.getSource() == this.panel.productList || keyEvent.getSource() == this.panel.componentList || keyEvent.getSource() == this.panel.versionList || keyEvent.getSource() == this.panel.statusList || keyEvent.getSource() == this.panel.resolutionList || keyEvent.getSource() == this.panel.priorityList || keyEvent.getSource() == this.panel.changedList) {
            this.onRefresh();
        }
    }

    private void onFilterChange(Filter filter) {
        this.query.setFilter(filter);
    }

    private void onSave(final boolean bl) {
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            public void run() {
                Bugzilla.LOG.fine("on save start");
                String string = QueryController.this.query.getDisplayName();
                if (!QueryController.this.query.isSaved()) {
                    string = QueryController.this.getSaveName();
                    if (string == null) {
                        return;
                    }
                    QueryController.this.panel.queryNameTextField.setText("");
                }
                assert (string != null);
                QueryController.this.save(string);
                Bugzilla.LOG.fine("on save finnish");
                if (bl) {
                    QueryController.this.onRefresh();
                }
            }
        });
    }

    private void save(String string) {
        Bugzilla.LOG.log(Level.FINE, "saving query '{0}'", new Object[]{string});
        this.query.setName(string);
        this.repository.saveQuery(this.query);
        this.query.setSaved(true);
        this.setAsSaved();
        if (!this.query.wasRun()) {
            Bugzilla.LOG.log(Level.FINE, "refreshing query '{0}' after save", new Object[]{string});
            this.onRefresh();
        }
        Bugzilla.LOG.log(Level.FINE, "query '{0}' saved", new Object[]{string});
    }

    private String getSaveName() {
        String string = null;
        if (BugzillaUtil.show(this.panel.savePanel, NbBundle.getMessage(QueryController.class, (String)"LBL_SaveQuery"), NbBundle.getMessage(QueryController.class, (String)"LBL_Save"), new HelpCtx("org.netbeans.modules.bugzilla.query.savePanel"))) {
            Query[] queryArray;
            string = this.panel.queryNameTextField.getText();
            if (string == null || string.trim().equals("")) {
                return null;
            }
            for (Query query : queryArray = this.repository.getQueries()) {
                if (!query.getDisplayName().equals(string)) continue;
                this.panel.saveErrorLabel.setVisible(true);
                string = this.getSaveName();
                this.panel.saveErrorLabel.setVisible(false);
                break;
            }
        } else {
            return null;
        }
        return string;
    }

    private void onCancelChanges() {
        String string;
        if (this.query.getDisplayName() != null && (string = BugzillaConfig.getInstance().getUrlParams(this.repository, this.query.getDisplayName())) != null) {
            this.setParameters(string);
        }
        this.setAsSaved();
    }

    public void selectFilter(Filter filter) {
        if (filter != null) {
            this.panel.filterComboBox.setSelectedItem(filter);
            Issue[] issueArray = this.query.getIssues();
            int n = 0;
            if (issueArray != null) {
                for (Issue issue : issueArray) {
                    if (!filter.accept(issue)) continue;
                    ++n;
                }
            }
            this.setIssueCount(n);
        }
        this.issueTable.setFilter(filter);
    }

    private void setAsSaved() {
        this.panel.setSaved(this.query.getDisplayName(), this.getLastRefresh());
        this.panel.setModifyVisible(false);
        this.panel.refreshCheckBox.setVisible(true);
    }

    private String getLastRefresh() throws MissingResourceException {
        long l = this.query.getLastRefresh();
        return l > 0L ? this.dateFormat.format(new Date(l)) : NbBundle.getMessage(QueryController.class, (String)"LBL_Never");
    }

    private void onGotoIssue() {
        final String string = this.panel.idTextField.getText().trim();
        if (string == null || string.trim().equals("")) {
            return;
        }
        final RequestProcessor.Task[] taskArray = new RequestProcessor.Task[1];
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (taskArray[0] != null) {
                    return taskArray[0].cancel();
                }
                return true;
            }
        };
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryController.class, (String)"MSG_Opening", (Object[])new Object[]{string}), (Cancellable)cancellable);
        taskArray[0] = Bugzilla.getInstance().getRequestProcessor().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                progressHandle.start();
                try {
                    Issue issue = QueryController.this.repository.getIssue(string);
                    if (issue != null) {
                        issue.open();
                    }
                }
                finally {
                    progressHandle.finish();
                }
            }
        });
        taskArray[0].schedule(0);
    }

    private void onWeb() {
        String string = this.getUrlParameters();
        String string2 = this.repository.getTaskRepository().getRepositoryUrl() + "/query.cgi?format=advanced";
        final String string3 = string2 + (string != null && !string.equals("") ? string : "");
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            public void run() {
                URL uRL;
                try {
                    uRL = new URL(string3);
                }
                catch (MalformedURLException malformedURLException) {
                    Bugzilla.LOG.log(Level.SEVERE, null, malformedURLException);
                    return;
                }
                HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
                if (uRLDisplayer != null) {
                    uRLDisplayer.showURL(uRL);
                } else {
                    Bugzilla.LOG.warning("No URLDisplayer found.");
                }
            }
        });
    }

    private void onProductChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.panel.productList.getSelectedValues();
        String[] stringArray = null;
        if (objectArray != null) {
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = ((QueryParameter.ParameterValue)objectArray[i]).getValue();
            }
        }
        this.populateProductDetails(stringArray);
    }

    private void onDefineAs() {
        this.panel.switchQueryFields(this.panel.urlPanel.isVisible());
    }

    private void onKeywords() {
        String string = BugzillaUtil.getKeywords(NbBundle.getMessage(QueryController.class, (String)"LBL_SelectKeywords"), this.panel.keywordsTextField.getText(), this.repository);
        if (string != null) {
            this.panel.keywordsTextField.setText(string);
        }
    }

    public void autoRefresh() {
        this.onRefresh(true);
    }

    public void onRefresh() {
        this.onRefresh(false);
    }

    private void onRefresh(boolean bl) {
        if (this.refreshTask == null) {
            this.refreshTask = new QueryTask();
        } else {
            this.refreshTask.cancel();
        }
        this.refreshTask.post(bl);
    }

    private void onModify() {
        this.panel.setModifyVisible(true);
    }

    private void onMarkSeen() {
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            public void run() {
                Issue[] issueArray;
                for (Issue issue : issueArray = QueryController.this.query.getIssues()) {
                    try {
                        ((BugzillaIssue)issue).setSeen(true);
                    }
                    catch (IOException iOException) {
                        Bugzilla.LOG.log(Level.SEVERE, null, iOException);
                    }
                }
            }
        });
    }

    private void onRemove() {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(QueryController.class, (String)"MSG_RemoveQuery", (Object[])new Object[]{this.query.getDisplayName()}), NbBundle.getMessage(QueryController.class, (String)"CTL_RemoveQuery"), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION) {
            Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

                public void run() {
                    QueryController.this.remove();
                }
            });
        }
    }

    private void onFindIssues() {
        Query.openNew((Repository)this.repository);
    }

    private void onAutoRefresh() {
        boolean bl = this.panel.refreshCheckBox.isSelected();
        BugzillaConfig.getInstance().setQueryAutoRefresh(this.query.getDisplayName(), bl);
        this.logAutoRefreshEvent(bl);
        if (bl) {
            this.scheduleForRefresh();
        } else {
            this.repository.stopRefreshing(this.query);
        }
    }

    protected void logAutoRefreshEvent(boolean bl) {
        BugtrackingUtil.logAutoRefreshEvent((String)BugzillaConnector.getConnectorName(), (String)this.query.getDisplayName(), (boolean)false, (boolean)bl);
    }

    private void onRefreshConfiguration() {
        this.postPopulate(this.getUrlParameters(), true);
    }

    private void remove() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
        this.query.remove();
    }

    private void populateProductDetails(String ... stringArray) {
        BugzillaConfiguration bugzillaConfiguration = this.repository.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return;
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{null};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String string : stringArray) {
            List<String> list = bugzillaConfiguration.getComponents(string);
            for (String string2 : list) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            List<String> list2 = bugzillaConfiguration.getVersions(string);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (arrayList2.contains(string3)) continue;
                arrayList2.add(string3);
            }
            if (!this.isNetbeans) continue;
            List<String> list3 = bugzillaConfiguration.getTargetMilestones(string);
            for (String string4 : list3) {
                if (arrayList3.contains(string4)) continue;
                arrayList3.add(string4);
            }
        }
        this.componentParameter.setParameterValues(this.toParameterValues(arrayList));
        this.versionParameter.setParameterValues(this.toParameterValues(arrayList2));
        if (this.isNetbeans) {
            this.tmParameter.setParameterValues(this.toParameterValues(arrayList3));
        }
    }

    private List<QueryParameter.ParameterValue> toParameterValues(List<String> list) {
        ArrayList<QueryParameter.ParameterValue> arrayList = new ArrayList<QueryParameter.ParameterValue>(list.size());
        for (String string : list) {
            arrayList.add(new QueryParameter.ParameterValue(string, string));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void setParameters(String string) {
        void var4_6;
        Object object;
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("&");
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        HashMap<Object, ArrayList<QueryParameter.ParameterValue>> hashMap = new HashMap<Object, ArrayList<QueryParameter.ParameterValue>>();
        for (String string2 : stringArray) {
            int n = string2.indexOf("=");
            if (n <= -1) continue;
            object = string2.substring(0, n);
            String string3 = string2.substring(n + 1, string2.length());
            QueryParameter.ParameterValue parameterValue = new QueryParameter.ParameterValue(string3, string3);
            ArrayList<QueryParameter.ParameterValue> arrayList = (ArrayList<QueryParameter.ParameterValue>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<QueryParameter.ParameterValue>();
                hashMap.put(object, arrayList);
            }
            arrayList.add(parameterValue);
        }
        Object var4_5 = null;
        List list = null;
        for (Map.Entry entry : hashMap.entrySet()) {
            QueryParameter queryParameter = this.parameters.get(entry.getKey());
            if (queryParameter == null) continue;
            if (queryParameter == this.componentParameter) {
                List list2 = (List)entry.getValue();
                continue;
            }
            if (queryParameter == this.versionParameter) {
                list = (List)entry.getValue();
                continue;
            }
            object = (List)entry.getValue();
            queryParameter.setValues(object.toArray(new QueryParameter.ParameterValue[object.size()]));
        }
        this.setDependentParameter(this.componentParameter, (List<QueryParameter.ParameterValue>)var4_6);
        this.setDependentParameter(this.versionParameter, list);
    }

    private void setDependentParameter(QueryParameter queryParameter, List<QueryParameter.ParameterValue> list) {
        if (list != null) {
            queryParameter.setValues(list.toArray(new QueryParameter.ParameterValue[list.size()]));
        }
    }

    private void setIssueCount(final int n) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                String string = n == 1 ? NbBundle.getMessage(QueryController.class, (String)"LBL_MatchingIssue", (Object[])new Object[]{n}) : NbBundle.getMessage(QueryController.class, (String)"LBL_MatchingIssues", (Object[])new Object[]{n});
                QueryController.this.panel.tableSummaryLabel.setText(string);
            }
        });
    }

    boolean isUrlDefined() {
        return this.panel.urlPanel.isVisible();
    }

    private class QueryTask
    implements Runnable,
    Cancellable,
    QueryNotifyListener {
        private ProgressHandle handle;
        private RequestProcessor.Task task;
        private int counter;
        private boolean autoRefresh;

        public QueryTask() {
            QueryController.this.query.addNotifyListener(this);
        }

        private void startQuery() {
            QueryController.this.enableFields(false);
            this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryController.class, (String)"MSG_SearchingQuery", (Object[])new Object[]{QueryController.this.query.getDisplayName() != null ? QueryController.this.query.getDisplayName() : QueryController.this.repository.getDisplayName()}), (Cancellable)this);
            QueryController.this.panel.showSearchingProgress(true, NbBundle.getMessage(QueryController.class, (String)"MSG_Searching"));
            this.handle.start();
        }

        private void finnishQuery() {
            this.task = null;
            if (this.handle != null) {
                this.handle.finish();
                this.handle = null;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    QueryController.this.panel.setQueryRunning(false);
                    QueryController.this.panel.setLastRefresh(QueryController.this.getLastRefresh());
                    QueryController.this.panel.showNoContentPanel(false);
                    QueryController.this.enableFields(true);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeQuery() {
            QueryController.this.panel.setQueryRunning(true);
            String string = QueryController.this.panel.changedFromTextField.getText().trim();
            if (string != null && !string.equals("")) {
                BugzillaConfig.getInstance().setLastChangeFrom(string);
            }
            try {
                if (QueryController.this.panel.urlPanel.isVisible()) {
                    QueryController.this.query.refresh(QueryController.this.panel.urlTextField.getText(), this.autoRefresh);
                } else {
                    QueryController.this.query.refresh(QueryController.this.getUrlParameters(), this.autoRefresh);
                }
            }
            finally {
                QueryController.this.panel.setQueryRunning(false);
                this.task = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.startQuery();
            try {
                this.executeQuery();
            }
            finally {
                this.finnishQuery();
            }
        }

        synchronized void post(boolean bl) {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = QueryController.this.rp.create((Runnable)this);
            this.autoRefresh = bl;
            this.task.schedule(0);
        }

        public boolean cancel() {
            if (this.task != null) {
                this.task.cancel();
                this.finnishQuery();
            }
            return true;
        }

        public void notifyData(Issue issue) {
            QueryController.this.setIssueCount(++this.counter);
        }

        public void started() {
            this.counter = 0;
            QueryController.this.setIssueCount(this.counter);
        }

        public void finished() {
        }
    }
}

