/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.output;

import java.io.IOException;
import java.io.PrintWriter;
import org.netbeans.modules.mobility.end2end.codegenerator.ConnectionGenerator;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class OutputLogger {
    private static final String WARNING = "TXT_Warning";
    private static final String JAVON_TAB = "LBL_JavonTab";
    private InputOutput myOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(ConnectionGenerator.class, (String)"LBL_JavonTab"), true);
    private static final OutputLogger INSTANCE = new OutputLogger();

    private OutputLogger() {
        try {
            this.myOutput.getIn().close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void open() {
        this.myOutput.select();
    }

    public static OutputLogger getInstance() {
        return INSTANCE;
    }

    public void log(LogLevel logLevel, String string, boolean bl) {
        if (bl) {
            this.getOutputWriter(logLevel, false).println(string);
        } else {
            this.getOutputWriter(logLevel, false).print(string);
        }
    }

    public void log(Exception exception) {
        exception.printStackTrace((PrintWriter)this.getOutput().getErr());
    }

    public void logAppend(LogLevel logLevel, String string, boolean bl) {
        if (bl) {
            this.getOutputWriter(logLevel, true).println(string);
        } else {
            this.getOutputWriter(logLevel, true).print(string);
        }
    }

    public void log(LogLevel logLevel, String string) {
        this.log(logLevel, string, true);
    }

    public void log(String string) {
        this.log(LogLevel.NOTICE, string, true);
    }

    private InputOutput getOutput() {
        return this.myOutput;
    }

    private OutputWriter getOutputWriter(LogLevel logLevel, boolean bl) {
        if (logLevel == LogLevel.ERROR) {
            return this.getOutput().getErr();
        }
        if (logLevel == LogLevel.WARNING) {
            OutputWriter outputWriter = this.getOutput().getOut();
            if (!bl) {
                String string = NbBundle.getMessage(OutputLogger.class, (String)WARNING);
                outputWriter.append((CharSequence)string);
                outputWriter.append((CharSequence)" ");
            }
            return outputWriter;
        }
        return this.getOutput().getOut();
    }

    public void close() {
        this.getOutput().getOut().close();
        this.getOutput().getErr().close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogLevel {
        NOTICE,
        WARNING,
        ERROR;

    }
}

