/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.VCSSupport;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceSupport {
    private static final Pattern ST_PATTERN = Pattern.compile("([\\p{Alnum}\\.\\$_<>]*?)\\((?:Native Method|Unknown Source|Compiled Code|([\\p{Alnum}\\.\\$_]*?):(\\p{Digit}+?))\\)", 32);
    private static List<String> subs;
    private static final String STACKTRACE_ATTRIBUTE = "stacktrace";
    private static MouseInputAdapter hyperlinkListener;

    private StackTraceSupport() {
    }

    public static void findAndOpen(String string) {
        block0: {
            List<StackTracePosition> list = StackTraceSupport.find(string);
            Iterator<StackTracePosition> iterator = list.iterator();
            if (!iterator.hasNext()) break block0;
            StackTracePosition stackTracePosition = iterator.next();
            StackTraceElement stackTraceElement = stackTracePosition.getStackTraceElements()[0];
            String string2 = StackTraceSupport.getPath(stackTraceElement);
            StackTraceSupport.open(string2, stackTraceElement.getLineNumber());
        }
    }

    public static void findAndShowHistory(String string) {
        block0: {
            List<StackTracePosition> list = StackTraceSupport.find(string);
            Iterator<StackTracePosition> iterator = list.iterator();
            if (!iterator.hasNext()) break block0;
            StackTracePosition stackTracePosition = iterator.next();
            StackTraceElement stackTraceElement = stackTracePosition.getStackTraceElements()[0];
            String string2 = StackTraceSupport.getPath(stackTraceElement);
            StackTraceSupport.openSearchHistory(string2, stackTraceElement.getLineNumber());
        }
    }

    private static String getPath(StackTraceElement stackTraceElement) {
        String string = stackTraceElement.getClassName();
        int n = string.indexOf(36);
        if (n != -1) {
            string = string.substring(0, n);
        }
        string = string.replace(".", "/") + ".java";
        return string;
    }

    public static List<StackTracePosition> find(String string) {
        LinkedList<StackTracePosition> linkedList = new LinkedList<StackTracePosition>();
        if (string == null) {
            return linkedList;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = -1;
        while ((n = string.indexOf("\n", n + 1)) > -1) {
            arrayList.add(n);
        }
        String string2 = StackTraceSupport.removeAll(string, '\n');
        Matcher matcher = ST_PATTERN.matcher(string2);
        ArrayList<StackTraceElement[]> arrayList2 = new ArrayList<StackTraceElement[]>();
        subs = new ArrayList<String>();
        int n2 = -1;
        int n3 = -1;
        while (matcher.find()) {
            StackTraceElement[] stackTraceElementArray;
            if (n3 == -1) {
                n3 = matcher.start();
            }
            if (!StackTraceSupport.isStacktraceContinuation(string2, n2, matcher.start())) {
                stackTraceElementArray = arrayList2.toArray(new StackTraceElement[0]);
                if (stackTraceElementArray.length > 1) {
                    n3 = StackTraceSupport.adjustFirstLinePosition(string, n3);
                    linkedList.add(new StackTracePosition(stackTraceElementArray, n3, n2));
                }
                arrayList2 = new ArrayList();
                n3 = matcher.start();
                subs = new ArrayList<String>();
            }
            if ((stackTraceElementArray = StackTraceSupport.createStackTraceElement(matcher.group(1), matcher.group(2), matcher.group(3))) != null) {
                arrayList2.add(stackTraceElementArray);
            }
            n2 = matcher.end();
        }
        if (!arrayList2.isEmpty()) {
            n3 = StackTraceSupport.adjustFirstLinePosition(string, n3);
            linkedList.add(new StackTracePosition(arrayList2.toArray(new StackTraceElement[arrayList2.size()]), n3, n2));
        }
        return linkedList;
    }

    private static boolean isStacktraceContinuation(String string, int n, int n2) {
        if (n == -1) {
            return true;
        }
        String string2 = string.substring(n, n2);
        subs.add(string2);
        block3: for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '[': 
                case ']': 
                case 'a': 
                case 'c': 
                case 'h': 
                case 't': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static int adjustFirstLinePosition(String string, int n) {
        if (n > 0) {
            int n2;
            for (n2 = n - 1; n2 > 0; --n2) {
                if (string.charAt(n2) != '\n') continue;
                ++n2;
                break;
            }
            if (StackTraceSupport.isStacktraceContinuation(string, n2, n)) {
                return n2;
            }
        }
        return n;
    }

    private static StackTraceElement createStackTraceElement(String string, String string2, String string3) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return new StackTraceElement(string.substring(0, n), string.substring(n + 1), string2, string3 == null ? -1 : Integer.parseInt(string3));
    }

    private static String removeAll(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '\n') {
                if (i > 1 && string.charAt(i - 2) == 'a' && string.charAt(i - 2) == 't') {
                    stringBuilder.append("");
                }
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static void open(String string, final int n) {
        final FileObject fileObject = StackTraceSupport.search(string);
        if (fileObject != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StackTraceSupport.doOpen(fileObject, n);
                }
            });
        }
    }

    public static void openSearchHistory(String string, final int n) {
        FileObject fileObject = StackTraceSupport.search(string);
        if (fileObject != null) {
            final File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) {
                return;
            }
            Collection collection = Lookup.getDefault().lookupAll(VCSSupport.class);
            if (collection == null) {
                return;
            }
            for (final VCSSupport vCSSupport : collection) {
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    public void run() {
                        vCSSupport.searchHistory(file, n);
                    }
                });
            }
        }
    }

    public static boolean doOpen(FileObject fileObject, int n) {
        try {
            Object object;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (editorCookie != null && lineCookie != null && n != -1 && (object = editorCookie.openDocument()) != null && n != -1) {
                Line line = null;
                try {
                    line = lineCookie.getLineSet().getCurrent(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    BugtrackingManager.LOG.log(Level.FINE, null, indexOutOfBoundsException);
                    editorCookie.open();
                    return false;
                }
                if (line != null) {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    return true;
                }
            }
            if ((object = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                object.open();
                return true;
            }
        }
        catch (IOException iOException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
        }
        return false;
    }

    private static FileObject search(String string) {
        return GlobalPathRegistry.getDefault().findResource(string);
    }

    public static void addHyperlinks(JTextPane jTextPane) {
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        String string = jTextPane.getText();
        List<StackTracePosition> list = StackTraceSupport.find(string);
        if (!list.isEmpty()) {
            Style style = StyleContext.getDefaultStyleContext().getStyle("default");
            Style style2 = styledDocument.addStyle("regularBlue", style);
            style2.addAttribute(STACKTRACE_ATTRIBUTE, new StackTraceAction());
            StyleConstants.setForeground(style2, Color.BLUE);
            StyleConstants.setUnderline(style2, true);
            int n = 0;
            jTextPane.setText("");
            for (StackTracePosition stackTracePosition : list) {
                int n2 = stackTracePosition.getStartOffset();
                int n3 = stackTracePosition.getEndOffset();
                if (n < n2) {
                    try {
                        styledDocument.insertString(styledDocument.getLength(), string.substring(n, n2), style);
                    }
                    catch (BadLocationException badLocationException) {
                        BugtrackingManager.LOG.log(Level.SEVERE, null, badLocationException);
                    }
                }
                n = n2;
                boolean bl = string.charAt(n2) > ' ';
                for (int i = n2; i < n3; ++i) {
                    char c = string.charAt(i);
                    if ((!bl || c != '\n') && (bl || c <= ' ')) continue;
                    try {
                        styledDocument.insertString(styledDocument.getLength(), string.substring(n, i), bl ? style2 : style);
                    }
                    catch (BadLocationException badLocationException) {
                        BugtrackingManager.LOG.log(Level.SEVERE, null, badLocationException);
                    }
                    bl = !bl;
                    n = i;
                }
                if (n < n3) {
                    try {
                        styledDocument.insertString(styledDocument.getLength(), string.substring(n, n3), bl ? style2 : style);
                    }
                    catch (BadLocationException badLocationException) {
                        BugtrackingManager.LOG.log(Level.SEVERE, null, badLocationException);
                    }
                }
                n = n3;
            }
            try {
                styledDocument.insertString(styledDocument.getLength(), string.substring(n), style);
            }
            catch (BadLocationException badLocationException) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, badLocationException);
            }
        }
        jTextPane.addMouseListener(StackTraceSupport.getHyperlinkListener());
        jTextPane.addMouseMotionListener(StackTraceSupport.getHyperlinkListener());
    }

    private static MouseInputAdapter getHyperlinkListener() {
        if (hyperlinkListener == null) {
            hyperlinkListener = new MouseInputAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        Element element;
                        AttributeSet attributeSet;
                        StackTraceAction stackTraceAction;
                        if (SwingUtilities.isLeftMouseButton(mouseEvent) && (stackTraceAction = (StackTraceAction)(attributeSet = (element = this.element(mouseEvent)).getAttributes()).getAttribute(StackTraceSupport.STACKTRACE_ATTRIBUTE)) != null) {
                            try {
                                StackTraceAction.openStackTrace(element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()), false);
                            }
                            catch (Exception exception) {
                                BugtrackingManager.LOG.log(Level.SEVERE, null, exception);
                            }
                        }
                    }
                    catch (Exception exception) {
                        BugtrackingManager.LOG.log(Level.SEVERE, null, exception);
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.showMenu(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.showMenu(mouseEvent);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
                    StyledDocument styledDocument = jTextPane.getStyledDocument();
                    Element element = styledDocument.getCharacterElement(jTextPane.viewToModel(mouseEvent.getPoint()));
                    AttributeSet attributeSet = element.getAttributes();
                    if (StyleConstants.isUnderline(attributeSet)) {
                        jTextPane.setCursor(new Cursor(12));
                    } else {
                        jTextPane.setCursor(new Cursor(0));
                    }
                }

                private Element element(MouseEvent mouseEvent) {
                    JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
                    StyledDocument styledDocument = jTextPane.getStyledDocument();
                    return styledDocument.getCharacterElement(jTextPane.viewToModel(mouseEvent.getPoint()));
                }

                private void showMenu(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        try {
                            Element element = this.element(mouseEvent);
                            String string = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                            JPopupMenu jPopupMenu = new JPopupMenu();
                            jPopupMenu.add(new StackTraceAction(string, false));
                            jPopupMenu.add(new StackTraceAction(string, true));
                            jPopupMenu.show((JTextPane)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                        }
                        catch (Exception exception) {
                            BugtrackingManager.LOG.log(Level.SEVERE, null, exception);
                        }
                    }
                }
            };
        }
        return hyperlinkListener;
    }

    static class StackTraceAction
    extends AbstractAction {
        private String stackFrame;
        private boolean showHistory;

        StackTraceAction() {
        }

        StackTraceAction(String string, boolean bl) {
            this.stackFrame = string;
            this.showHistory = bl;
            String string2 = NbBundle.getMessage(StackTraceAction.class, (String)(bl ? "StackTraceSupport.StackTraceAction.showHistory" : "StackTraceSupport.StackTraceAction.open"));
            this.putValue("Name", string2);
        }

        static void openStackTrace(String string, boolean bl) {
            if (bl) {
                StackTraceSupport.findAndShowHistory(string);
            } else {
                StackTraceSupport.findAndOpen(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StackTraceAction.openStackTrace(this.stackFrame, this.showHistory);
        }
    }

    public static class StackTracePosition {
        private final StackTraceElement[] stackTraceElements;
        private int start;
        private int end;

        public StackTracePosition(StackTraceElement[] stackTraceElementArray, int n, int n2) {
            this.stackTraceElements = stackTraceElementArray;
            this.start = n;
            this.end = n2;
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public StackTraceElement[] getStackTraceElements() {
            return this.stackTraceElements;
        }
    }
}

