/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.bugtracking.BugtrackingConfig;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.issuetable.NodeTableModel;
import org.netbeans.modules.bugtracking.issuetable.QueryTableCellRenderer;
import org.netbeans.modules.bugtracking.issuetable.QueryTableHeaderRenderer;
import org.netbeans.modules.bugtracking.issuetable.TableSorter;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.QueryNotifyListener;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IssueTable
implements MouseListener,
AncestorListener,
KeyListener,
PropertyChangeListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private TableSorter sorter;
    private int seenColumnIdx = -1;
    private int recentChangesColumnIdx = -1;
    private Query query;
    private final ColumnDescriptor[] descriptors;
    private Filter filter;
    private Filter[] filters;
    private Set<Issue> issues = new HashSet<Issue>();
    private QueryTableHeaderRenderer queryTableHeaderRenderer;
    private RequestProcessor.Task storeColumnsWidthTask;
    private final StoreColumnWidthsHandler storeColumnsWidthHandler;
    private static final Comparator<IssueNode.IssueProperty> NodeComparator = new Comparator<IssueNode.IssueProperty>(){

        @Override
        public int compare(IssueNode.IssueProperty issueProperty, IssueNode.IssueProperty issueProperty2) {
            Integer n = (Integer)issueProperty.getValue("sortkey");
            if (n != null) {
                Integer n2 = (Integer)issueProperty2.getValue("sortkey");
                return n.compareTo(n2);
            }
            try {
                return issueProperty.compareTo(issueProperty2);
            }
            catch (Exception exception) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, exception);
                return 0;
            }
        }
    };
    private final Map<Cell, Set<CellAction>> cellActions = new HashMap<Cell, Set<CellAction>>();
    private TableColumnModelListener tcml = new TableColumnModelListener(){

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            TableColumnModel tableColumnModel = IssueTable.this.table.getColumnModel();
            int n = tableColumnModel.getColumnCount();
            ((IssueTable)IssueTable.this).storeColumnsWidthHandler.columnWidths = new int[n - 1];
            for (int i = 0; i < ((IssueTable)IssueTable.this).storeColumnsWidthHandler.columnWidths.length; ++i) {
                if (i == IssueTable.this.seenColumnIdx) continue;
                ((IssueTable)IssueTable.this).storeColumnsWidthHandler.columnWidths[i] = tableColumnModel.getColumn(i).getWidth();
            }
            IssueTable.this.storeColumnsWidthTask.schedule(1000);
        }
    };

    public Filter[] getDefinedFilters() {
        if (this.filters == null) {
            this.filters = new Filter[]{Filter.getAllFilter(this.query), Filter.getNotSeenFilter(), Filter.getObsoleteDateFilter(this.query), Filter.getAllButObsoleteDateFilter(this.query)};
        }
        return this.filters;
    }

    public IssueTable(Query query, ColumnDescriptor[] columnDescriptorArray) {
        assert (query != null);
        assert (columnDescriptorArray != null);
        assert (columnDescriptorArray.length > 0);
        this.query = query;
        this.descriptors = columnDescriptorArray;
        query.addNotifyListener(new NotifyListener());
        query.addPropertyChangeListener(this);
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter(this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new JTable(this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color color = UIManager.getColor("scrollpane_border");
        if (color == null) {
            color = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
        this.table.addMouseListener(this);
        this.table.addKeyListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new QueryTableCellRenderer(query));
        this.queryTableHeaderRenderer = new QueryTableHeaderRenderer(this.table.getTableHeader().getDefaultRenderer(), this, query);
        this.table.getTableHeader().setDefaultRenderer(this.queryTableHeaderRenderer);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IssueTable.class, (String)"ACSN_IssueTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssueTable.class, (String)"ACSD_IssueTable"));
        this.initColumns();
        this.table.getTableHeader().addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                IssueTable.this.table.getColumnModel().addColumnModelListener(IssueTable.this.tcml);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                IssueTable.this.table.getColumnModel().removeColumnModelListener(IssueTable.this.tcml);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        BugtrackingUtil.fixFocusTraversalKeys(this.table);
        this.storeColumnsWidthHandler = new StoreColumnWidthsHandler();
        this.storeColumnsWidthTask = BugtrackingManager.getInstance().getRequestProcessor().create((Runnable)this.storeColumnsWidthHandler);
    }

    int getSeenColumnIdx() {
        return this.seenColumnIdx;
    }

    public void setRenderer(TableCellRenderer tableCellRenderer) {
        this.table.setDefaultRenderer(Node.Property.class, tableCellRenderer);
    }

    public TableCellRenderer getRenderer() {
        return this.table.getDefaultRenderer(Node.Property.class);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        ArrayList<IssueNode> arrayList = new ArrayList<IssueNode>(this.issues.size());
        for (Issue issue : this.issues) {
            if (filter != null && !filter.accept(issue)) continue;
            arrayList.add(issue.getNode());
        }
        this.setTableModel(arrayList.toArray(new IssueNode[arrayList.size()]));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("bugtracking.query.saved")) {
            this.initColumns();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellAction(int n, int n2, Rectangle rectangle, ActionListener actionListener) {
        Map<Cell, Set<CellAction>> map = this.cellActions;
        synchronized (map) {
            Cell cell = new Cell(n, n2);
            Set<CellAction> set = this.cellActions.get(cell);
            if (set == null) {
                set = new HashSet<CellAction>(1);
                this.cellActions.put(cell, set);
            }
            set.add(new CellAction(rectangle, actionListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellActions(int n, int n2) {
        Cell cell = new Cell(n, n2);
        Map<Cell, Set<CellAction>> map = this.cellActions;
        synchronized (map) {
            this.cellActions.remove(cell);
        }
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int[] nArray = BugtrackingConfig.getInstance().getColumnWidths(IssueTable.this.getColumnWidthsKey());
                if (nArray != null && nArray.length > 0) {
                    int n = IssueTable.this.table.getColumnModel().getColumnCount();
                    for (int i = 0; i < nArray.length && i < n; ++i) {
                        int n2 = nArray[i];
                        if (n2 <= 0) continue;
                        this.setColumnWidth(i, n2);
                    }
                } else {
                    int n;
                    for (n = 0; n < IssueTable.this.descriptors.length; ++n) {
                        ColumnDescriptor columnDescriptor = IssueTable.this.descriptors[n];
                        int n3 = columnDescriptor.getWidth();
                        if (n3 > 0) {
                            this.setColumnWidth(n, n3);
                            continue;
                        }
                        if (n3 != 0) continue;
                        this.setWidthForFit(n);
                    }
                    if (IssueTable.this.query.isSaved()) {
                        n = BugtrackingUtil.getColumnWidthInPixels(25, (JComponent)IssueTable.this.table);
                        this.setColumnWidth(IssueTable.this.recentChangesColumnIdx, n);
                    }
                }
                if (IssueTable.this.query.isSaved()) {
                    IssueTable.this.table.getColumnModel().getColumn(IssueTable.this.seenColumnIdx).setMaxWidth(28);
                    IssueTable.this.table.getColumnModel().getColumn(IssueTable.this.seenColumnIdx).setPreferredWidth(28);
                }
            }

            private void setColumnWidth(int n, int n2) {
                IssueTable.this.table.getColumnModel().getColumn(n).setMinWidth(10);
                IssueTable.this.table.getColumnModel().getColumn(n).setMaxWidth(10000);
                IssueTable.this.table.getColumnModel().getColumn(n).setPreferredWidth(n2);
            }

            private void setWidthForFit(int n) {
                TableColumn tableColumn = IssueTable.this.table.getColumnModel().getColumn(n);
                Component component = IssueTable.this.queryTableHeaderRenderer.getTableCellRendererComponent(IssueTable.this.table, tableColumn.getHeaderValue(), false, false, 0, n);
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    int n2 = jLabel.getPreferredSize().width;
                    if (n2 > -1) {
                        this.setColumnWidth(n, n2);
                    }
                }
            }
        });
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSizes();
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public JComponent getComponent() {
        return this.component;
    }

    public final void initColumns() {
        this.setModelProperties(this.query);
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
        }
        this.setDefaultColumnSizes();
    }

    private void setModelProperties(Query query) {
        int n;
        ArrayList<ColumnDescriptor> arrayList = new ArrayList<ColumnDescriptor>(this.descriptors.length + (query.isSaved() ? 2 : 0));
        for (n = 0; n < this.descriptors.length; ++n) {
            ColumnDescriptor columnDescriptor = this.descriptors[n];
            arrayList.add(columnDescriptor);
        }
        if (query.isSaved()) {
            arrayList.add(new RecentChangesDescriptor());
            arrayList.add(new SeenDescriptor());
            this.recentChangesColumnIdx = n;
            this.seenColumnIdx = n + 1;
        }
        this.tableModel.setProperties(arrayList.toArray(new Node.Property[arrayList.size()]));
    }

    private void setTableModel(IssueNode[] issueNodeArray) {
        this.tableModel.setNodes((Node[])issueNodeArray);
    }

    void focus() {
        this.table.requestFocus();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.table.columnAtPoint(mouseEvent.getPoint());
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (n == -1) {
                return;
            }
            n = this.sorter.modelIndex(n);
            if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                Action action = this.tableModel.getNodes()[n].getPreferredAction();
                if (action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(this, 0, ""));
                }
            } else {
                IssueNode issueNode;
                if (n2 == this.seenColumnIdx) {
                    issueNode = (IssueNode)this.tableModel.getNodes()[n];
                    final Issue object = (Issue)issueNode.getLookup().lookup(Issue.class);
                    BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                        public void run() {
                            IssueCacheUtils.switchSeen(object);
                        }
                    });
                }
                issueNode = null;
                Map<Cell, Set<CellAction>> map = this.cellActions;
                synchronized (map) {
                    Cell cell = new Cell(n, n2);
                    Set<CellAction> set = this.cellActions.get(cell);
                    issueNode = set != null ? set.toArray(new CellAction[set.size()]) : null;
                }
                if (issueNode != null) {
                    for (IssueNode issueNode2 : issueNode) {
                        ((CellAction)((Object)issueNode2)).actionPerformed(null);
                    }
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n;
        if (keyEvent.getKeyChar() == '\n' && (n = this.table.getSelectedRow()) != -1) {
            n = this.sorter.modelIndex(n);
            Action action = this.tableModel.getNodes()[n].getPreferredAction();
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        if (keyEvent.getKeyChar() == '\n' && (n = this.table.getSelectedRow()) != -1) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private String getColumnWidthsKey() {
        String string = this.query.getDisplayName();
        if (string == null) {
            string = "#find#issues#hitlist#table#";
        }
        return this.query.getRepository().getID() + ":" + string;
    }

    private class StoreColumnWidthsHandler
    implements Runnable {
        int[] columnWidths = null;

        private StoreColumnWidthsHandler() {
        }

        public void run() {
            BugtrackingConfig.getInstance().storeColumnWidths(IssueTable.this.getColumnWidthsKey(), this.columnWidths);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecentChangesDescriptor
    extends ColumnDescriptor<String> {
        public RecentChangesDescriptor() {
            super("issue.recent_changes", String.class, NbBundle.getBundle(Issue.class).getString("CTL_Issue_Recent"), NbBundle.getBundle(Issue.class).getString("CTL_Issue_Recent_Desc"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SeenDescriptor
    extends ColumnDescriptor<Boolean> {
        public SeenDescriptor() {
            super("issue.seen", Boolean.class, "", NbBundle.getBundle(Issue.class).getString("CTL_Issue_Seen_Desc"));
        }
    }

    private class NotifyListener
    implements QueryNotifyListener {
        private NotifyListener() {
        }

        public void notifyData(Issue issue) {
            IssueTable.this.issues.add(issue);
            if (IssueTable.this.filter == null || IssueTable.this.filter.accept(issue)) {
                final IssueNode issueNode = issue.getNode();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IssueTable.this.tableModel.insertNode((Node)issueNode);
                    }
                });
            }
        }

        public void started() {
            IssueTable.this.issues.clear();
            IssueTable.this.setTableModel(new IssueNode[0]);
        }

        public void finished() {
        }
    }

    private class Cell {
        private final int row;
        private final int column;

        public Cell(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Cell cell = (Cell)object;
            if (this.row != cell.row) {
                return false;
            }
            return this.column == cell.column;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append("row=");
            stringBuffer.append(this.row);
            stringBuffer.append(",column=");
            stringBuffer.append(this.column);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private class CellAction
    implements ActionListener {
        private final Rectangle bounds;
        private final ActionListener listener;

        public CellAction(Rectangle rectangle, ActionListener actionListener) {
            this.bounds = rectangle;
            this.listener = actionListener;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CellAction cellAction = (CellAction)object;
            return this.bounds == cellAction.bounds || this.bounds != null && this.bounds.equals(cellAction.bounds);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append("bounds=");
            stringBuffer.append(this.bounds);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.listener.actionPerformed(actionEvent);
        }
    }
}

