/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.api;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionSupport {
    private static ExecutionSupport instance;
    private final GrailsPlatform platform;

    private ExecutionSupport(GrailsPlatform grailsPlatform) {
        this.platform = grailsPlatform;
    }

    public static synchronized ExecutionSupport getInstance() {
        if (instance == null) {
            instance = new ExecutionSupport(GrailsPlatform.getDefault());
        }
        return instance;
    }

    private static ExecutionSupport forRuntime(GrailsPlatform grailsPlatform) {
        if (grailsPlatform == null) {
            throw new NullPointerException("Runtime is null");
        }
        if (!grailsPlatform.isConfigured()) {
            return null;
        }
        return new ExecutionSupport(grailsPlatform);
    }

    public Callable<Process> createCreateApp(final File file) {
        return new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                if (file.exists()) {
                    throw new IOException("Project directory already exists");
                }
                File file2 = file.getAbsoluteFile().getParentFile();
                FileUtil.createFolder((File)file2);
                String string = file.getName();
                String[] stringArray = GrailsPlatform.Version.VERSION_1_1.compareTo(ExecutionSupport.this.platform.getVersion()) <= 0 ? new String[]{"--non-interactive", string} : new String[]{string};
                GrailsPlatform.CommandDescriptor commandDescriptor = GrailsPlatform.CommandDescriptor.forProject("create-app", file2, null, stringArray, null);
                return ExecutionSupport.this.platform.createCommand(commandDescriptor).call();
            }
        };
    }

    public Callable<Process> createRunApp(final GrailsProjectConfig grailsProjectConfig, final boolean bl, final String ... stringArray) {
        return new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                File file = FileUtil.toFile((FileObject)grailsProjectConfig.getProject().getProjectDirectory());
                GrailsPlatform.CommandDescriptor commandDescriptor = GrailsPlatform.CommandDescriptor.forProject("run-app", file, grailsProjectConfig, stringArray, null, bl);
                return ExecutionSupport.this.platform.createCommand(commandDescriptor).call();
            }
        };
    }

    public Callable<Process> createSimpleCommand(final String string, final GrailsProjectConfig grailsProjectConfig, final String ... stringArray) {
        return new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                File file = FileUtil.toFile((FileObject)grailsProjectConfig.getProject().getProjectDirectory());
                GrailsPlatform.CommandDescriptor commandDescriptor = GrailsPlatform.CommandDescriptor.forProject(string, file, grailsProjectConfig, stringArray, null);
                return ExecutionSupport.this.platform.createCommand(commandDescriptor).call();
            }
        };
    }
}

