/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Profile;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyContainer;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.spi.grammar.DialogFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ExclusionGenerator
implements CodeGenerator {
    private POMModel model;
    private JTextComponent component;

    private ExclusionGenerator(POMModel pOMModel, JTextComponent jTextComponent) {
        this.model = pOMModel;
        this.component = jTextComponent;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ExclusionGenerator.class, (String)"NAME_Exclusion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        try {
            this.model.sync();
        }
        catch (IOException iOException) {
            Logger.getLogger(ExclusionGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", iOException);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExclusionGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        FileObject fileObject = (FileObject)this.model.getModelSource().getLookup().lookup(FileObject.class);
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        assert (project != null);
        int n = this.component.getCaretPosition();
        DocumentComponent documentComponent = this.model.findComponent(n);
        Map map = DialogFactory.showDependencyExcludeDialog((Project)project);
        if (map != null) {
            this.model.startTransaction();
            try {
                for (Artifact artifact : map.keySet()) {
                    for (Artifact artifact2 : (List)map.get(artifact)) {
                        Exclusion exclusion;
                        Dependency dependency = this.model.getProject().findDependencyById(artifact2.getGroupId(), artifact2.getArtifactId(), null);
                        if (dependency == null) {
                            Profile profile2;
                            exclusion = new ArrayList();
                            NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
                            for (Profile profile2 : nbMavenProject.getMavenProject().getActiveProfiles()) {
                                exclusion.add(profile2.getId());
                            }
                            profile2 = exclusion.iterator();
                            while (profile2.hasNext()) {
                                String string = (String)profile2.next();
                                org.netbeans.modules.maven.model.pom.Profile profile3 = this.model.getProject().findProfileById(string);
                                if (profile3 == null || (dependency = profile3.findDependencyById(artifact2.getGroupId(), artifact2.getArtifactId(), null)) == null) continue;
                                break;
                            }
                        }
                        if (dependency == null) {
                            dependency = this.model.getFactory().createDependency();
                            dependency.setArtifactId(artifact2.getArtifactId());
                            dependency.setGroupId(artifact2.getGroupId());
                            dependency.setType(artifact2.getType());
                            dependency.setVersion(artifact2.getVersion());
                            this.model.getProject().addDependency(dependency);
                        }
                        if ((exclusion = dependency.findExclusionById(artifact.getGroupId(), artifact.getArtifactId())) != null) continue;
                        exclusion = this.model.getFactory().createExclusion();
                        exclusion.setArtifactId(artifact.getArtifactId());
                        exclusion.setGroupId(artifact.getGroupId());
                        dependency.addExclusion(exclusion);
                    }
                }
            }
            finally {
                this.model.endTransaction();
            }
        }
    }

    private DependencyContainer findContainer(int n, POMModel pOMModel) {
        for (DocumentComponent documentComponent = pOMModel.findComponent(n); documentComponent != null; documentComponent = documentComponent.getParent()) {
            if (!(documentComponent instanceof DependencyContainer)) continue;
            return (DependencyContainer)documentComponent;
        }
        return pOMModel.getProject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<ExclusionGenerator> arrayList = new ArrayList<ExclusionGenerator>();
            POMModel pOMModel = (POMModel)lookup.lookup(POMModel.class);
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            if (pOMModel != null) {
                arrayList.add(new ExclusionGenerator(pOMModel, jTextComponent));
            }
            return arrayList;
        }
    }
}

