/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.Pair;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAnalyser {
    private final Index index;
    private final Map<Pair<String, String>, Object[]> references;
    private final Set<Pair<String, String>> toDelete;
    private static final boolean fullIndex = Boolean.getBoolean(SourceAnalyser.class.getName() + ".fullIndex");

    public SourceAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.references = new HashMap<Pair<String, String>, Object[]>();
        this.toDelete = new HashSet<Pair<String, String>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        if (this.references.size() > 0 || this.toDelete.size() > 0) {
            try {
                this.index.store(this.references, this.toDelete);
            }
            finally {
                this.references.clear();
                this.toDelete.clear();
            }
        }
    }

    public boolean isValid() throws IOException {
        return this.index.isValid(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyse(Iterable<? extends CompilationUnitTree> iterable, JavacTaskImpl javacTaskImpl, JavaFileManager javaFileManager, JavaCustomIndexer.CompileTuple compileTuple, Set<? super ElementHandle<TypeElement>> set, boolean[] blArray) throws IOException {
        Object object;
        HashMap<Pair<String, String>, Data> hashMap = new HashMap<Pair<String, String>, Data>();
        for (CompilationUnitTree object2 : iterable) {
            Object object3;
            Closeable closeable;
            object = new UsagesVisitor(javacTaskImpl, object2, javaFileManager, compileTuple.jfo, set, compileTuple);
            ((UsagesVisitor)object).scan((Tree)object2, (Map<Pair<String, String>, Data>)hashMap);
            blArray[0] = blArray[0] | ((UsagesVisitor)object).mainMethod;
            if (((UsagesVisitor)object).sourceName == null || ((UsagesVisitor)object).rsList == null || ((UsagesVisitor)object).rsList.size() <= 0) continue;
            int n = ((UsagesVisitor)object).sourceName.lastIndexOf(46);
            String string = n == -1 ? "" : ((UsagesVisitor)object).sourceName.substring(0, n);
            String string2 = n == -1 ? ((UsagesVisitor)object).sourceName : ((UsagesVisitor)object).sourceName.substring(n + 1);
            String string3 = compileTuple.virtual ? FileObjects.getExtension(compileTuple.indexable.getURL().getPath()) + '.' + "rx" : "rs";
            String string4 = string2 + '.' + string3;
            FileObject fileObject = javaFileManager.getFileForOutput(StandardLocation.CLASS_OUTPUT, string, string4, compileTuple.jfo);
            assert (fileObject != null);
            try {
                closeable = new BufferedReader(new InputStreamReader(fileObject.openInputStream(), "UTF-8"));
                try {
                    while ((object3 = ((BufferedReader)closeable).readLine()) != null) {
                        ((UsagesVisitor)object).rsList.add(object3);
                    }
                }
                finally {
                    ((BufferedReader)closeable).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            closeable = new PrintWriter(new OutputStreamWriter(fileObject.openOutputStream(), "UTF-8"));
            try {
                object3 = ((UsagesVisitor)object).rsList.iterator();
                while (object3.hasNext()) {
                    String string5 = (String)object3.next();
                    ((PrintWriter)closeable).println(string5);
                }
            }
            finally {
                ((PrintWriter)closeable).close();
            }
        }
        if (compileTuple.index) {
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (Pair)entry.getKey();
                Data data = (Data)entry.getValue();
                this.addClassReferences((Pair<String, String>)object, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyseUnitAndStore(CompilationUnitTree compilationUnitTree, JavacTaskImpl javacTaskImpl, JavaFileManager javaFileManager) throws IOException {
        try {
            HashMap<Pair<String, String>, Data> hashMap = new HashMap<Pair<String, String>, Data>();
            ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
            UsagesVisitor usagesVisitor = new UsagesVisitor(javacTaskImpl, compilationUnitTree, javaFileManager, compilationUnitTree.getSourceFile(), arrayList);
            usagesVisitor.scan((Tree)compilationUnitTree, (Map<Pair<String, String>, Data>)hashMap);
            for (Map.Entry entry : hashMap.entrySet()) {
                Pair pair = (Pair)entry.getKey();
                Data data = (Data)entry.getValue();
                this.addClassReferences(pair, data);
            }
            this.index.store(this.references, arrayList);
        }
        catch (OutputFileManager.InvalidSourcePath invalidSourcePath) {
        }
        finally {
            this.references.clear();
        }
    }

    public void delete(Pair<String, String> pair) throws IOException {
        this.toDelete.add(pair);
    }

    private void addClassReferences(Pair<String, String> pair, Data data) {
        assert (pair != null);
        assert (data != null);
        Object[] objectArray = new Object[3];
        Map<String, Set<ClassIndexImpl.UsageType>> map = data.usages;
        Set<CharSequence> set = data.featuresIdents;
        Set<CharSequence> set2 = data.idents;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, Set<ClassIndexImpl.UsageType>> object2 : map.entrySet()) {
            linkedList.add(DocumentUtil.encodeUsage(object2.getKey(), object2.getValue()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : set) {
            stringBuilder.append(charSequence);
            stringBuilder.append(' ');
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (CharSequence charSequence : set2) {
            stringBuilder2.append(charSequence);
            stringBuilder2.append(' ');
        }
        objectArray[0] = linkedList;
        objectArray[1] = stringBuilder.toString();
        objectArray[2] = stringBuilder2.toString();
        this.references.put(pair, objectArray);
    }

    private static void dumpUsages(Map<Pair<String, String>, Data> map) throws IOException {
        assert (map != null);
        for (Map.Entry<Pair<String, String>, Data> entry : map.entrySet()) {
            System.out.println("Usages in class: " + entry.getKey());
            for (Map.Entry<String, Set<ClassIndexImpl.UsageType>> entry2 : entry.getValue().usages.entrySet()) {
                System.out.println("\t" + entry2.getKey() + "\t: " + entry2.getValue().toString());
            }
            System.out.println("Feature idents in class: " + entry.getKey());
            for (CharSequence charSequence : entry.getValue().featuresIdents) {
                System.out.println("\t" + charSequence);
            }
            System.out.println("All idents in class: " + entry.getKey());
            for (CharSequence charSequence : entry.getValue().idents) {
                System.out.println("\t" + charSequence);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UsagesVisitor
    extends TreeScanner<Void, Map<Pair<String, String>, Data>> {
        private final Stack<Pair<String, String>> activeClass;
        private JavaFileManager manager;
        private final JavacTaskImpl jt;
        private final Name errorName;
        private final CompilationUnitTree cu;
        private final Types types;
        private final TransTypes trans;
        private final URL siblingUrl;
        private final String sourceName;
        private final boolean signatureFiles;
        private final List<? super Pair<String, String>> topLevels;
        private final Set<? super ElementHandle<TypeElement>> newTypes;
        private final Set<String> imports;
        private final Set<String> staticImports;
        private final Set<Pair<String, ClassIndexImpl.UsageType>> packageAnnotations;
        private final Set<CharSequence> importIdents;
        private final Set<CharSequence> packageAnnotationIdents;
        private final boolean virtual;
        private final boolean storeIndex;
        private boolean isStaticImport;
        private State state;
        private Element enclosingElement = null;
        private Set<String> rsList;
        private boolean crossedTopLevel;
        private boolean mainMethod;

        public UsagesVisitor(JavacTaskImpl javacTaskImpl, CompilationUnitTree compilationUnitTree, JavaFileManager javaFileManager, JavaFileObject javaFileObject, Set<? super ElementHandle<TypeElement>> set, JavaCustomIndexer.CompileTuple compileTuple) throws MalformedURLException {
            assert (javacTaskImpl != null);
            assert (compilationUnitTree != null);
            assert (javaFileManager != null);
            assert (javaFileObject != null);
            this.activeClass = new Stack();
            this.imports = new HashSet<String>();
            this.staticImports = new HashSet<String>();
            this.importIdents = new HashSet<CharSequence>();
            this.packageAnnotationIdents = new HashSet<CharSequence>();
            this.packageAnnotations = new HashSet<Pair<String, ClassIndexImpl.UsageType>>();
            this.jt = javacTaskImpl;
            this.errorName = Names.instance((Context)javacTaskImpl.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(javacTaskImpl.getContext());
            this.trans = TransTypes.instance(javacTaskImpl.getContext());
            this.cu = compilationUnitTree;
            this.signatureFiles = true;
            this.manager = javaFileManager;
            this.virtual = compileTuple.virtual;
            this.storeIndex = compileTuple.index;
            this.siblingUrl = this.virtual ? compileTuple.indexable.getURL() : javaFileObject.toUri().toURL();
            this.sourceName = this.manager.inferBinaryName(StandardLocation.SOURCE_PATH, javaFileObject);
            this.topLevels = null;
            this.newTypes = set;
        }

        protected UsagesVisitor(JavacTaskImpl javacTaskImpl, CompilationUnitTree compilationUnitTree, JavaFileManager javaFileManager, JavaFileObject javaFileObject, List<? super Pair<String, String>> list) throws MalformedURLException {
            assert (javacTaskImpl != null);
            assert (compilationUnitTree != null);
            assert (javaFileManager != null);
            assert (javaFileObject != null);
            this.activeClass = new Stack();
            this.imports = new HashSet<String>();
            this.staticImports = new HashSet<String>();
            this.importIdents = new HashSet<CharSequence>();
            this.packageAnnotationIdents = new HashSet<CharSequence>();
            this.packageAnnotations = new HashSet<Pair<String, ClassIndexImpl.UsageType>>();
            this.jt = javacTaskImpl;
            this.errorName = Names.instance((Context)javacTaskImpl.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(javacTaskImpl.getContext());
            this.trans = TransTypes.instance(javacTaskImpl.getContext());
            this.cu = compilationUnitTree;
            this.signatureFiles = false;
            this.manager = javaFileManager;
            this.siblingUrl = javaFileObject.toUri().toURL();
            this.sourceName = this.manager.inferBinaryName(StandardLocation.SOURCE_PATH, javaFileObject);
            this.topLevels = list;
            this.newTypes = null;
            this.virtual = false;
            this.storeIndex = true;
        }

        final Types getTypes() {
            return this.types;
        }

        final TransTypes getTransTypes() {
            return this.trans;
        }

        @Override
        public Void scan(Tree tree, Map<Pair<String, String>, Data> map) {
            if (tree == null) {
                return null;
            }
            super.scan(tree, map);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Map<Pair<String, String>, Data> map) {
            Pair<String, Object> pair;
            String string;
            State state = this.state;
            try {
                this.state = State.PACKAGE_ANN;
                this.scan(compilationUnitTree.getPackageAnnotations(), map);
                this.scan((Tree)compilationUnitTree.getPackageName(), map);
                this.state = State.IMPORT;
                this.scan(compilationUnitTree.getImports(), map);
            }
            finally {
                this.state = state;
            }
            this.scan(compilationUnitTree.getTypeDecls(), map);
            String string2 = null;
            if (!this.imports.isEmpty() || !this.staticImports.isEmpty()) {
                string2 = UsagesVisitor.getResourceName(compilationUnitTree);
                if (string2 != null) {
                    string = string2 + DocumentUtil.encodeKind(ElementKind.CLASS);
                    pair = Pair.of(string, null);
                    for (String object : this.imports) {
                        this.addUsage(pair, object, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                    for (String string3 : this.staticImports) {
                        this.addUsage(pair, string3, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        this.addUsage(pair, string3, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                        this.addUsage(pair, string3, map, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                    }
                    for (CharSequence charSequence : this.importIdents) {
                        this.addIdent(pair, charSequence, map, false);
                    }
                }
                this.imports.clear();
                this.staticImports.clear();
                this.importIdents.clear();
            }
            if (!this.packageAnnotations.isEmpty()) {
                if (string2 == null) {
                    string2 = UsagesVisitor.getResourceName(compilationUnitTree);
                }
                if (string2 != null) {
                    string = string2 + DocumentUtil.encodeKind(ElementKind.CLASS);
                    pair = Pair.of(string, null);
                    for (Pair pair2 : this.packageAnnotations) {
                        this.addUsage(pair, (String)pair2.first, map, (ClassIndexImpl.UsageType)((Object)pair2.second));
                    }
                    for (CharSequence charSequence : this.packageAnnotationIdents) {
                        this.addIdent(pair, charSequence, map, false);
                    }
                }
                this.packageAnnotations.clear();
                this.packageAnnotationIdents.clear();
            }
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Map<Pair<String, String>, Data> map) {
            this.handleVisitIdentSelect(((JCTree.JCFieldAccess)memberSelectTree).sym, memberSelectTree.getIdentifier(), map);
            State state = this.state;
            this.state = this.state == State.IMPORT || this.state == State.PACKAGE_ANN ? this.state : State.OTHER;
            Void void_ = (Void)super.visitMemberSelect(memberSelectTree, map);
            this.state = state;
            return void_;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Map<Pair<String, String>, Data> map) {
            this.handleVisitIdentSelect(((JCTree.JCIdent)identifierTree).sym, identifierTree.getName(), map);
            return (Void)super.visitIdentifier(identifierTree, map);
        }

        @Override
        public Void visitImport(ImportTree importTree, Map<Pair<String, String>, Data> map) {
            this.isStaticImport = importTree.isStatic();
            Void void_ = (Void)super.visitImport(importTree, map);
            this.isStaticImport = false;
            return void_;
        }

        private void handleVisitIdentSelect(Symbol symbol, CharSequence charSequence, Map<Pair<String, String>, Data> map) {
            if (!this.activeClass.empty()) {
                this.addIdent(this.activeClass.peek(), charSequence, map, false);
                if (symbol != null) {
                    String string;
                    Object object;
                    if (symbol.kind == 31 && (((Symbol)(object = symbol.getEnclosingElement())).getKind().isClass() || ((Symbol)object).getKind().isInterface()) && (string = UsagesVisitor.encodeClassName((Symbol)object)) != null) {
                        this.addUsage(this.activeClass.peek(), string, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                    if (symbol.getKind().isClass() || symbol.getKind().isInterface()) {
                        object = UsagesVisitor.encodeClassName(symbol);
                        if (object != null) {
                            switch (this.state) {
                                case EXTENDS: {
                                    this.addUsage(this.activeClass.peek(), (String)object, map, ClassIndexImpl.UsageType.SUPER_CLASS);
                                    break;
                                }
                                case IMPLEMENTS: {
                                    this.addUsage(this.activeClass.peek(), (String)object, map, ClassIndexImpl.UsageType.SUPER_INTERFACE);
                                    break;
                                }
                                case OTHER: 
                                case GT: {
                                    this.addUsage(this.activeClass.peek(), (String)object, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                                }
                            }
                        }
                    } else if (symbol.getKind().isField()) {
                        object = symbol.getEnclosingElement();
                        if ((((Symbol)object).getKind().isClass() || ((Symbol)object).getKind().isInterface()) && (string = UsagesVisitor.encodeClassName((Symbol)object)) != null) {
                            this.addUsage(this.activeClass.peek(), string, map, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                        }
                    } else if ((symbol.getKind() == ElementKind.CONSTRUCTOR || symbol.getKind() == ElementKind.METHOD) && (((Symbol)(object = symbol.getEnclosingElement())).getKind().isClass() || ((Symbol)object).getKind().isInterface()) && (string = UsagesVisitor.encodeClassName((Symbol)object)) != null) {
                        this.addUsage(this.activeClass.peek(), string, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                    }
                }
            } else if (this.state == State.IMPORT) {
                String string;
                this.importIdents.add(charSequence);
                if (symbol != null && (symbol.getKind().isClass() || symbol.getKind().isInterface()) && (string = UsagesVisitor.encodeClassName(symbol)) != null) {
                    if (this.isStaticImport) {
                        this.staticImports.add(string);
                    } else {
                        this.imports.add(string);
                    }
                }
            } else if (this.state == State.PACKAGE_ANN) {
                this.packageAnnotationIdents.add(charSequence);
                if (symbol != null) {
                    String string;
                    Object object;
                    if (symbol.kind == 31 && (((Symbol)(object = symbol.getEnclosingElement())).getKind().isClass() || ((Symbol)object).getKind().isInterface()) && (string = UsagesVisitor.encodeClassName((Symbol)object)) != null) {
                        this.packageAnnotations.add(Pair.of(string, ClassIndexImpl.UsageType.TYPE_REFERENCE));
                    }
                    if (symbol.getKind().isClass() || symbol.getKind().isInterface()) {
                        object = UsagesVisitor.encodeClassName(symbol);
                        if (object != null) {
                            this.packageAnnotations.add(Pair.of(object, ClassIndexImpl.UsageType.TYPE_REFERENCE));
                        }
                    } else if (symbol.getKind().isField()) {
                        object = symbol.getEnclosingElement();
                        if ((((Symbol)object).getKind().isClass() || ((Symbol)object).getKind().isInterface()) && (string = UsagesVisitor.encodeClassName((Symbol)object)) != null) {
                            this.packageAnnotations.add(Pair.of(string, ClassIndexImpl.UsageType.FIELD_REFERENCE));
                        }
                    } else if ((symbol.getKind() == ElementKind.CONSTRUCTOR || symbol.getKind() == ElementKind.METHOD) && (((Symbol)(object = symbol.getEnclosingElement())).getKind().isClass() || ((Symbol)object).getKind().isInterface()) && (string = UsagesVisitor.encodeClassName((Symbol)object)) != null) {
                        this.packageAnnotations.add(Pair.of(string, ClassIndexImpl.UsageType.METHOD_REFERENCE));
                    }
                }
            }
        }

        @Override
        public Void visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Map<Pair<String, String>, Data> map) {
            this.scan(parameterizedTypeTree.getType(), map);
            State state = this.state;
            this.state = State.GT;
            this.scan(parameterizedTypeTree.getTypeArguments(), map);
            this.state = state;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public Void visitClass(ClassTree classTree, Map<Pair<String, String>, Data> map) {
            Object object;
            Symbol.ClassSymbol classSymbol = ((JCTree.JCClassDecl)classTree).sym;
            boolean bl = false;
            boolean bl2 = true;
            String string = null;
            if (classSymbol != null) {
                bl = this.hasErrorName(classSymbol);
                if (bl) {
                    if (this.activeClass.size() > 0) {
                        this.activeClass.push((Pair<String, String>)this.activeClass.get(0));
                        bl2 = false;
                    } else {
                        string = UsagesVisitor.getResourceName(this.cu);
                        if (string != null) {
                            object = string + DocumentUtil.encodeKind(ElementKind.CLASS);
                            Pair<Object, Object> pair = Pair.of(object, null);
                            if (this.activeClass.isEmpty()) {
                                if (this.topLevels != null) {
                                    this.topLevels.add(Pair.of(string, null));
                                }
                                for (String charSequence : this.imports) {
                                    this.addUsage(pair, charSequence, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                                }
                                this.imports.clear();
                                for (String string2 : this.staticImports) {
                                    this.addUsage(pair, string2, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                                    this.addUsage(pair, string2, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                                    this.addUsage(pair, string2, map, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                                }
                                this.staticImports.clear();
                                for (CharSequence charSequence : this.importIdents) {
                                    this.addIdent(pair, charSequence, map, false);
                                }
                                this.importIdents.clear();
                            }
                            this.activeClass.push(pair);
                            bl2 = false;
                            this.addUsage(pair, string, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            this.addIdent(pair, string, map, true);
                            if (this.newTypes != null) {
                                this.newTypes.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, string));
                            }
                        } else {
                            Logger.getLogger(SourceAnalyser.class.getName()).warning(String.format("Cannot resolve %s, ignoring whole subtree.\n", classSymbol.toString()));
                        }
                    }
                } else {
                    void var10_21;
                    Object object2;
                    object = new StringBuilder();
                    ClassFileUtil.encodeClassName(classSymbol, (StringBuilder)object, '.');
                    string = ((StringBuilder)object).toString();
                    ElementKind elementKind = classSymbol.getKind();
                    ((StringBuilder)object).append(DocumentUtil.encodeKind(elementKind));
                    String string2 = ((StringBuilder)object).toString();
                    Object var10_17 = null;
                    if (this.activeClass.isEmpty()) {
                        if (this.virtual || !string.equals(this.sourceName)) {
                            Object object3;
                            if (this.signatureFiles && this.rsList == null) {
                                this.rsList = new HashSet<String>();
                                if (this.crossedTopLevel) {
                                    this.rsList.add(this.sourceName);
                                }
                            }
                            if ((object2 = URLMapper.findFileObject((URL)this.siblingUrl)) != null && (object3 = ClassPath.getClassPath((org.openide.filesystems.FileObject)object2, (String)"classpath/source")) != null) {
                                String string3 = object3.getResourceName(object2, '/', true);
                            }
                        } else {
                            this.crossedTopLevel = true;
                        }
                    } else {
                        String string4 = (String)this.activeClass.peek().second;
                    }
                    object2 = Pair.of(string2, var10_21);
                    if (this.activeClass.isEmpty()) {
                        if (this.topLevels != null) {
                            this.topLevels.add(Pair.of(string, var10_21));
                        }
                        for (String string5 : this.imports) {
                            this.addUsage((Pair<String, String>)object2, string5, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        }
                        this.imports.clear();
                        for (String string6 : this.staticImports) {
                            this.addUsage((Pair<String, String>)object2, string6, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            this.addUsage((Pair<String, String>)object2, string6, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                            this.addUsage((Pair<String, String>)object2, string6, map, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                        }
                        this.staticImports.clear();
                        for (CharSequence charSequence : this.importIdents) {
                            this.addIdent((Pair<String, String>)object2, charSequence, map, false);
                        }
                        this.importIdents.clear();
                    }
                    this.activeClass.push((Pair<String, String>)object2);
                    bl2 = false;
                    this.addUsage((Pair<String, String>)object2, string, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    this.addIdent((Pair<String, String>)object2, classTree.getSimpleName(), map, true);
                    if (this.newTypes != null) {
                        this.newTypes.add(ElementHandleAccessor.INSTANCE.create(elementKind, string));
                    }
                }
            }
            if (!bl2) {
                object = this.enclosingElement;
                try {
                    this.enclosingElement = classSymbol;
                    this.scan((Tree)classTree.getModifiers(), map);
                    this.scan(classTree.getTypeParameters(), map);
                    this.state = bl ? State.OTHER : State.EXTENDS;
                    this.scan(classTree.getExtendsClause(), map);
                    this.state = bl ? State.OTHER : State.IMPLEMENTS;
                    this.scan(classTree.getImplementsClause(), map);
                    this.state = State.OTHER;
                    this.scan(classTree.getMembers(), map);
                    this.activeClass.pop();
                }
                finally {
                    this.enclosingElement = object;
                }
            }
            if (!bl && this.rsList != null) {
                this.rsList.add(string);
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree newClassTree, Map<Pair<String, String>, Data> map) {
            String string;
            Symbol symbol;
            Symbol symbol2 = ((JCTree.JCNewClass)newClassTree).constructor;
            if (symbol2 != null && (symbol = symbol2.getEnclosingElement()) != null && symbol.getKind().isClass() && (string = UsagesVisitor.encodeClassName(symbol)) != null) {
                this.addUsage(this.activeClass.peek(), string, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            return (Void)super.visitNewClass(newClassTree, map);
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Map<Pair<String, String>, Data> map) {
            List<? extends Tree> list = erroneousTree.getErrorTrees();
            for (Tree tree : list) {
                this.scan(tree, map);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitMethod(MethodTree methodTree, Map<Pair<String, String>, Data> map) {
            Element element = this.enclosingElement;
            try {
                this.enclosingElement = ((JCTree.JCMethodDecl)methodTree).sym;
                if (this.enclosingElement != null && this.enclosingElement.getKind() == ElementKind.METHOD) {
                    this.mainMethod |= SourceUtils.isMainMethod((ExecutableElement)this.enclosingElement);
                }
                this.addIdent(this.activeClass.peek(), methodTree.getName(), map, true);
                Void void_ = (Void)super.visitMethod(methodTree, map);
                return void_;
            }
            finally {
                this.enclosingElement = element;
            }
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Map<Pair<String, String>, Data> map) {
            Symbol.VarSymbol varSymbol = ((JCTree.JCVariableDecl)variableTree).sym;
            if (varSymbol != null && varSymbol.owner != null && (varSymbol.owner.getKind().isClass() || varSymbol.owner.getKind().isInterface())) {
                this.addIdent(this.activeClass.peek(), variableTree.getName(), map, true);
            }
            return (Void)super.visitVariable(variableTree, map);
        }

        private void addUsage(Pair<String, String> pair, String string, Map<Pair<String, String>, Data> map, ClassIndexImpl.UsageType usageType) {
            assert (string != null);
            assert (map != null);
            assert (usageType != null);
            Data data = this.getData(pair, map);
            Set<ClassIndexImpl.UsageType> set = data.usages.get(string);
            if (set == null) {
                set = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
                data.usages.put(string, set);
            }
            set.add(usageType);
        }

        private void addIdent(Pair<String, String> pair, CharSequence charSequence, Map<Pair<String, String>, Data> map, boolean bl) {
            assert (pair != null);
            assert (charSequence != null);
            assert (map != null);
            if (bl || fullIndex) {
                Data data = this.getData(pair, map);
                if (fullIndex) {
                    data.idents.add(charSequence);
                }
                if (bl) {
                    data.featuresIdents.add(charSequence);
                }
            }
        }

        private Data getData(Pair<String, String> pair, Map<Pair<String, String>, Data> map) {
            Data data = map.get(pair);
            if (data == null) {
                data = new Data();
                map.put(pair, data);
            }
            return data;
        }

        private boolean hasErrorName(Symbol symbol) {
            while (symbol != null) {
                if (symbol.name == this.errorName) {
                    return true;
                }
                symbol = symbol.getEnclosingElement();
            }
            return false;
        }

        private static String encodeClassName(Symbol symbol) {
            assert (symbol instanceof Symbol.ClassSymbol);
            TypeElement typeElement = null;
            TypeMirror typeMirror = ((Symbol.ClassSymbol)symbol).asType();
            if (symbol.getEnclosingElement().getKind() == ElementKind.TYPE_PARAMETER) {
                TypeMirror typeMirror2;
                if (typeMirror.getKind() == TypeKind.ARRAY && (typeMirror2 = ((ArrayType)typeMirror).getComponentType()).getKind() == TypeKind.DECLARED) {
                    typeElement = (TypeElement)((DeclaredType)typeMirror2).asElement();
                }
            } else {
                typeElement = (TypeElement)((Object)symbol);
            }
            return typeElement == null ? null : ClassFileUtil.encodeClassName(typeElement);
        }

        private static String getResourceName(CompilationUnitTree compilationUnitTree) {
            URI uRI;
            JavaFileObject javaFileObject;
            if (compilationUnitTree instanceof JCTree.JCCompilationUnit && (javaFileObject = ((JCTree.JCCompilationUnit)compilationUnitTree).sourcefile) != null && (uRI = javaFileObject.toUri()) != null && uRI.isAbsolute()) {
                try {
                    ClassPath classPath;
                    org.openide.filesystems.FileObject fileObject = URLMapper.findFileObject((URL)uRI.toURL());
                    if (fileObject != null && (classPath = ClassPath.getClassPath((org.openide.filesystems.FileObject)fileObject, (String)"classpath/source")) != null) {
                        return classPath.getResourceName(fileObject, '.', false);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            EXTENDS,
            IMPLEMENTS,
            GT,
            OTHER,
            IMPORT,
            PACKAGE_ANN;

        }
    }

    static class Data {
        final Map<String, Set<ClassIndexImpl.UsageType>> usages = new HashMap<String, Set<ClassIndexImpl.UsageType>>();
        final Set<CharSequence> featuresIdents = new HashSet<CharSequence>();
        final Set<CharSequence> idents = new HashSet<CharSequence>();

        Data() {
        }
    }
}

