/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommentSetImpl
implements Cloneable,
CommentSet {
    private boolean commentsMapped;
    private final Map<CommentSet.RelativePosition, List<Comment>> commentsMap = new HashMap<CommentSet.RelativePosition, List<Comment>>();

    @Override
    public void addPrecedingComment(String string) {
        this.addPrecedingComment(Comment.create(string));
    }

    @Override
    public void addPrecedingComment(Comment comment) {
        this.addComment(CommentSet.RelativePosition.PRECEDING, comment);
    }

    @Override
    public void addPrecedingComments(List<Comment> list) {
        for (Comment comment : list) {
            this.addComment(CommentSet.RelativePosition.PRECEDING, comment);
        }
    }

    @Override
    public void addTrailingComment(String string) {
        this.addTrailingComment(Comment.create(string));
    }

    @Override
    public void addTrailingComment(Comment comment) {
        this.addComment(CommentSet.RelativePosition.TRAILING, comment);
    }

    @Override
    public void addTrailingComments(List<Comment> list) {
        for (Comment comment : list) {
            this.addComment(CommentSet.RelativePosition.TRAILING, comment);
        }
    }

    @Override
    public List<Comment> getPrecedingComments() {
        return this.getComments(CommentSet.RelativePosition.PRECEDING);
    }

    @Override
    public List<Comment> getTrailingComments() {
        return this.getComments(CommentSet.RelativePosition.TRAILING);
    }

    @Override
    public boolean hasComments() {
        return !this.commentsMap.isEmpty();
    }

    @Override
    public int pos() {
        return this.pos(CommentSet.RelativePosition.PRECEDING);
    }

    @Override
    public int pos(CommentSet.RelativePosition relativePosition) {
        List<Comment> list = this.getComments(relativePosition);
        return list.isEmpty() ? -2 : list.get(0).pos();
    }

    @Override
    public void addComment(CommentSet.RelativePosition relativePosition, Comment comment) {
        List<Object> list;
        if (this.commentsMap.containsKey((Object)relativePosition)) {
            list = this.commentsMap.get((Object)relativePosition);
        } else {
            list = new LinkedList();
            this.commentsMap.put(relativePosition, list);
        }
        list.add(comment);
        this.commentsMapped();
    }

    public void addComments(CommentSet.RelativePosition relativePosition, Iterable<? extends Comment> iterable) {
        for (Comment comment : iterable) {
            this.addComment(relativePosition, comment);
        }
    }

    @Override
    public List<Comment> getComments(CommentSet.RelativePosition relativePosition) {
        if (this.commentsMap.containsKey((Object)relativePosition)) {
            return Collections.unmodifiableList(this.commentsMap.get((Object)relativePosition));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasChanges() {
        if (this.commentsMap.isEmpty()) {
            return false;
        }
        for (List<Comment> list : this.commentsMap.values()) {
            for (Comment comment : list) {
                if (!comment.isNew()) continue;
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Unexpected " + cloneNotSupportedException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        boolean bl = true;
        for (Map.Entry<CommentSet.RelativePosition, List<Comment>> entry : this.commentsMap.entrySet()) {
            if (!bl) {
                stringBuffer.append(", ");
                bl = false;
            }
            stringBuffer.append("[").append((Object)entry.getKey()).append(" -> ");
            for (Comment comment : entry.getValue()) {
                stringBuffer.append(',').append(comment.getText());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean areCommentsMapped() {
        return this.commentsMapped;
    }

    public void commentsMapped() {
        this.commentsMapped = true;
    }
}

