/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.settings.convertors.XMLSettingsSupport;
import org.netbeans.spi.settings.Convertor;
import org.netbeans.spi.settings.Saver;
import org.openide.util.Exceptions;
import org.openide.util.io.ReaderInputStream;

public final class XMLBeanConvertor
extends Convertor
implements PropertyChangeListener {
    private Saver saver;

    public static Convertor create() {
        return new XMLBeanConvertor();
    }

    public Object read(Reader reader) throws IOException, ClassNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(reader, 4096);
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        bufferedReader.mark(charBuffer.capacity());
        bufferedReader.read(charBuffer);
        charBuffer.flip();
        Matcher matcher = Pattern.compile("<java").matcher(charBuffer);
        if (matcher.find()) {
            bufferedReader.reset();
            bufferedReader.skip(matcher.start());
        } else {
            bufferedReader.reset();
        }
        XMLDecoder xMLDecoder = new XMLDecoder((InputStream)new ReaderInputStream((Reader)bufferedReader, "UTF-8"));
        return xMLDecoder.readObject();
    }

    public void write(Writer writer, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLEncoder xMLEncoder = new XMLEncoder(byteArrayOutputStream);
        xMLEncoder.writeObject(object);
        xMLEncoder.close();
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        string = string.replaceFirst("<java", "<!DOCTYPE xmlbeans PUBLIC \"-//NetBeans//DTD XML beans 1.0//EN\" \"http://www.netbeans.org/dtds/xml-beans-1_0.dtd\">\n<java");
        writer.write(string);
    }

    public void registerSaver(Object object, Saver saver) {
        if (this.saver != null) {
            XMLSettingsSupport.err.warning("[Warning] Saver already registered");
            return;
        }
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            method.invoke(object, this);
            this.saver = saver;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            XMLSettingsSupport.err.warning("ObjectChangesNotifier: NoSuchMethodException: " + object.getClass().getName() + ".addPropertyChangeListener");
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
    }

    public void unregisterSaver(Object object, Saver saver) {
        if (this.saver == null) {
            return;
        }
        if (this.saver != saver) {
            XMLSettingsSupport.err.warning("[Warning] trying unregistered unknown Saver");
            return;
        }
        try {
            Method method = object.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            method.invoke(object, this);
            this.saver = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            XMLSettingsSupport.err.fine("ObjectChangesNotifier: NoSuchMethodException: " + object.getClass().getName() + ".removePropertyChangeListener");
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.saver == null) {
            return;
        }
        if (this.acceptSave()) {
            try {
                this.saver.requestSave();
            }
            catch (IOException iOException) {
                Logger.getLogger(XMLBeanConvertor.class.getName()).log(Level.WARNING, null, iOException);
            }
        } else {
            this.saver.markDirty();
        }
    }

    private boolean acceptSave() {
        return true;
    }
}

