/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.game.GameAccessController;
import org.netbeans.modules.vmd.game.GameEditorView;
import org.netbeans.modules.vmd.game.integration.components.GameTypes;
import org.netbeans.modules.vmd.game.model.AnimatedTile;
import org.netbeans.modules.vmd.game.model.AnimatedTileCD;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.ImageResourceCD;
import org.netbeans.modules.vmd.game.model.ImageResourceListener;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneCD;
import org.netbeans.modules.vmd.game.model.SceneItemCD;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceCD;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.SpriteCD;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerCD;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.netbeans.modules.vmd.game.nbdialog.SelectImageForLayerDialog;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameController
implements DesignDocumentAwareness,
GlobalRepositoryListener,
SceneListener,
TiledLayerListener,
SequenceContainerListener,
SequenceListener,
ImageResourceListener,
PropertyChangeListener,
DesignListener {
    private static boolean DEBUG = false;
    private static boolean DEBUG_UNDO = false;
    private final Map<Long, String> changeMap = new HashMap<Long, String>();
    private final Map<Identifiable, DesignComponent> designIdMap = new HashMap<Identifiable, DesignComponent>();
    public static final String PROJECT_TYPE_GAME = "vmd-midp-game";
    private DataObjectContext context;
    private GameEditorView gameEditorView;
    private JComponent loadingPanel;
    private JPanel panel = new JPanel(new BorderLayout());
    private DesignDocument document;

    public GameController(DataObjectContext dataObjectContext, GameEditorView gameEditorView) {
        this.context = dataObjectContext;
        this.gameEditorView = gameEditorView;
        this.loadingPanel = IOUtils.createLoadingPanel();
        this.panel.add(this.loadingPanel);
        this.context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public JComponent getVisualRepresentation() {
        return this.panel;
    }

    public DesignDocument getDesignDocument() {
        return this.document;
    }

    public GlobalRepository getGameDesign() {
        final DesignDocument designDocument = this.getDesignDocument();
        if (designDocument == null) {
            return null;
        }
        final GlobalRepository[] globalRepositoryArray = new GlobalRepository[]{null};
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                GameAccessController gameAccessController = (GameAccessController)designDocument.getListenerManager().getAccessController(GameAccessController.class);
                globalRepositoryArray[0] = gameAccessController.getGameDesign();
            }
        });
        return globalRepositoryArray[0];
    }

    private DesignComponent getImageResourceDC(Set<DesignComponent> set) {
        for (DesignComponent designComponent : set) {
            if (designComponent == null || !designComponent.getType().equals((Object)ImageResourceCD.TYPEID)) continue;
            return designComponent;
        }
        return null;
    }

    public void designChanged(DesignEvent designEvent) {
        DesignComponent designComponent2;
        if (DEBUG_UNDO) {
            System.out.println("GameController.designChanged() : " + designEvent.getEventID());
        }
        for (DesignComponent designComponent2 : designEvent.getCreatedComponents()) {
            this.modelComponent(designComponent2);
        }
        DesignComponent designComponent3 = null;
        designComponent2 = this.document.getRootComponent();
        if (designEvent.getFullyAffectedHierarchies().contains(designComponent2)) {
            this.refreshGameDesign(designComponent2, designEvent);
        } else {
            designComponent3 = this.getImageResourceDC(designEvent.getFullyAffectedHierarchies());
            if (designComponent3 != null) {
                this.refreshImageResource(designComponent3, designEvent);
            } else {
                for (DesignComponent designComponent4 : designEvent.getFullyAffectedComponents()) {
                    TypeID typeID = designComponent4.getType();
                    assert (typeID != null);
                    if (DEBUG_UNDO) {
                        System.out.println("Affected ComponentID: " + designComponent4.getComponentID() + ", type: " + designComponent4.getType().getString());
                    }
                    if (typeID.equals((Object)SceneCD.TYPEID)) {
                        this.refreshScene(designComponent4, designEvent);
                        continue;
                    }
                    if (typeID.equals((Object)TiledLayerCD.TYPEID)) {
                        this.refreshTiledLayer(designComponent4, designEvent);
                        continue;
                    }
                    if (typeID.equals((Object)SpriteCD.TYPEID)) {
                        this.refreshSprite(designComponent4, designEvent);
                        continue;
                    }
                    if (typeID.equals((Object)SequenceCD.TYPEID)) {
                        this.refreshSequence(designComponent4, designEvent);
                        continue;
                    }
                    if (typeID.equals((Object)AnimatedTileCD.TYPEID)) {
                        this.refreshAnimatedTile(designComponent4, designEvent);
                        continue;
                    }
                    if (!DEBUG_UNDO) continue;
                    System.out.println("Currently not handling this in type in GameController.designChanged() typeId: " + typeID.getString());
                }
            }
        }
    }

    private void refreshGameDesign(DesignComponent designComponent, DesignEvent designEvent) {
        boolean bl;
        if (this.changeMap.remove(designComponent.getComponentID()) != null) {
            return;
        }
        this.getGameDesign().removeGlobalRepositoryListener(this);
        this.getGameDesign().removePropertyChangeListener(this);
        GlobalRepository globalRepository = this.getGameDesign();
        Collection collection = designComponent.getComponents();
        HashSet<Identifiable> hashSet = new HashSet<Identifiable>();
        hashSet.addAll(globalRepository.getImageResources());
        hashSet.addAll(globalRepository.getScenes());
        hashSet.addAll(globalRepository.getSprites());
        hashSet.addAll(globalRepository.getTiledLayers());
        for (DesignComponent object : collection) {
            bl = false;
            for (Identifiable identifiable2 : hashSet) {
                if (object.getComponentID() != identifiable2.getId()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.modelComponent(object);
        }
        for (Identifiable identifiable : hashSet) {
            bl = false;
            for (Identifiable identifiable2 : collection) {
                if (identifiable.getId() != identifiable2.getComponentID()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            globalRepository.removeIdentifiable(identifiable.getId());
        }
        this.getGameDesign().addGlobalRepositoryListener(this);
        this.getGameDesign().addPropertyChangeListener(this);
        globalRepository.getMainView().requestEditing(globalRepository);
    }

    private void refreshScene(DesignComponent designComponent, DesignEvent designEvent) {
        Scene scene = this.getGameDesign().getScene(designComponent.getComponentID());
        scene.removePropertyChangeListener(this);
        scene.removeSceneListener(this);
        if (designEvent.isComponentPropertyChanged(designComponent, "scenecd.prop.name")) {
            if ("scenecd.prop.name".equals(this.changeMap.get(designComponent.getComponentID()))) {
                this.changeMap.remove(designComponent.getComponentID());
            } else {
                String string = (String)designComponent.readProperty("scenecd.prop.name").getPrimitiveValue();
                scene.setName(string);
            }
        } else if ("scenecd.prop.sceneitems".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else {
            Object object;
            Object object222;
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            List list = designComponent.readProperty("scenecd.prop.sceneitems").getArray();
            for (Object object222 : list) {
                object = object222.getComponent();
                Point point = (Point)object.readProperty("sceneitemcd.prop.position").getPrimitiveValue();
                Boolean bl = (Boolean)object.readProperty("sceneitemcd.prop.lock").getPrimitiveValue();
                Boolean object3 = (Boolean)object.readProperty("sceneitemcd.prop.visible").getPrimitiveValue();
                DesignComponent designComponent2 = object.readProperty("sceneitemcd.prop.layer").getComponent();
                int n = (Integer)object.readProperty("sceneitemcd.prop.z.order").getPrimitiveValue();
                Layer layer = this.getGameDesign().getLayer(designComponent2.getComponentID());
                arrayList.add(layer);
                if (!scene.contains(layer)) {
                    scene.append(layer);
                }
                scene.setLayerLocked(layer, false);
                scene.move(layer, n);
                scene.setLayerPosition(layer, point, false);
                scene.setLayerVisible(layer, object3);
                scene.setLayerLocked(layer, bl);
            }
            ArrayList<Layer> arrayList2 = new ArrayList<Layer>(scene.getLayers());
            object222 = arrayList2.iterator();
            while (object222.hasNext()) {
                object = (Layer)object222.next();
                boolean bl = false;
                for (Layer layer : arrayList) {
                    if (!((Layer)object).getName().equals(layer.getName())) continue;
                    bl = true;
                }
                if (bl) continue;
                scene.remove((Layer)object);
            }
        }
        scene.addPropertyChangeListener(this);
        scene.addSceneListener(this);
        this.getGameDesign().getMainView().requestEditing(scene);
    }

    private void refreshLayerProperties(DesignComponent designComponent, DesignEvent designEvent) {
        Layer layer = this.getGameDesign().getLayer(designComponent.getComponentID());
        if ("layercd.prop.name".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "layercd.prop.name")) {
            String string = (String)designComponent.readProperty("layercd.prop.name").getPrimitiveValue();
            layer.setName(string);
        }
        if (designEvent.isComponentPropertyChanged(designComponent, "layercd.prop.imageresource")) {
            // empty if block
        }
        if (designEvent.isComponentPropertyChanged(designComponent, "layercd.prop.tile.width")) {
            // empty if block
        }
        if (designEvent.isComponentPropertyChanged(designComponent, "layercd.prop.tile.height")) {
            // empty if block
        }
    }

    private void refreshTiledLayer(DesignComponent designComponent, DesignEvent designEvent) {
        TiledLayer tiledLayer = (TiledLayer)this.getGameDesign().getLayer(designComponent.getComponentID());
        tiledLayer.removePropertyChangeListener(this);
        tiledLayer.removeTiledLayerListener(this);
        this.refreshLayerProperties(designComponent, designEvent);
        if ("tiledlayercd.prop.tiles".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "tiledlayercd.prop.tiles")) {
            int[][] nArray = (int[][])designComponent.readProperty("tiledlayercd.prop.tiles").getPrimitiveValue();
            tiledLayer.setTiles(nArray);
        }
        tiledLayer.addPropertyChangeListener(this);
        tiledLayer.addTiledLayerListener(this);
        this.getGameDesign().getMainView().requestEditing(tiledLayer);
    }

    private void refreshSprite(DesignComponent designComponent, DesignEvent designEvent) {
        Object object;
        List list;
        Sprite sprite = (Sprite)this.getGameDesign().getLayer(designComponent.getComponentID());
        sprite.removePropertyChangeListener(this);
        sprite.removeSequenceContainerListener(this);
        this.refreshLayerProperties(designComponent, designEvent);
        DesignComponent designComponent2 = designComponent.readProperty("layercd.prop.imageresource").getComponent();
        ImageResource imageResource = this.getGameDesign().getImageResource(designComponent2.getComponentID());
        if ("sequencecontainer.prop.sequences".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "sequencecontainer.prop.sequences")) {
            Object object2;
            Object object32;
            list = designComponent.readProperty("sequencecontainer.prop.sequences").getArray();
            object = sprite.getSequences();
            ArrayList<Sequence> arrayList = new ArrayList<Sequence>();
            for (Object object32 : list) {
                object2 = object32.getComponent();
                Sequence sequence = (Sequence)this.findIdentifiable(object2.getComponentID());
                assert (sequence != null);
                arrayList.add(sequence);
                if (object.contains(sequence)) continue;
                sprite.append(sequence);
            }
            ArrayList<Sequence> arrayList2 = new ArrayList<Sequence>(sprite.getSequences());
            object32 = arrayList2.iterator();
            while (object32.hasNext()) {
                object2 = (Sequence)object32.next();
                if (arrayList.contains(object2)) continue;
                if (DEBUG_UNDO) {
                    System.out.println("remove seq: " + object2 + " from sprite: " + sprite);
                }
                sprite.remove((Sequence)object2);
            }
        }
        if ("sequencecontainer.prop.defaultsequence".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "sequencecontainer.prop.defaultsequence")) {
            list = designComponent.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
            object = imageResource.getSequence(list.getComponentID());
            sprite.setDefaultSequence((Sequence)object);
        }
        sprite.addPropertyChangeListener(this);
        sprite.addSequenceContainerListener(this);
        this.getGameDesign().getMainView().requestEditing(sprite);
    }

    private void refreshAnimatedTile(DesignComponent designComponent, DesignEvent designEvent) {
        Object object;
        Object object2;
        DesignComponent designComponent2 = designComponent.readProperty("animatedtilecd.prop.imageresource").getComponent();
        if (designComponent2 == null) {
            return;
        }
        ImageResource imageResource = this.getGameDesign().getImageResource(designComponent2.getComponentID());
        AnimatedTile animatedTile = imageResource.getAnimatedTile(designComponent.getComponentID());
        animatedTile.removePropertyChangeListener(this);
        animatedTile.removeSequenceContainerListener(this);
        if ("animatedtilecd.prop.name".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "animatedtilecd.prop.name")) {
            object2 = (String)designComponent.readProperty("animatedtilecd.prop.name").getPrimitiveValue();
            animatedTile.setName((String)object2);
        }
        if ("sequencecontainer.prop.sequences".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "sequencecontainer.prop.sequences")) {
            Object object3;
            Object object4;
            object2 = designComponent.readProperty("sequencecontainer.prop.sequences").getArray();
            object = animatedTile.getSequences();
            ArrayList<Sequence> arrayList = new ArrayList<Sequence>();
            Object object5 = object2.iterator();
            while (object5.hasNext()) {
                object4 = (PropertyValue)object5.next();
                object3 = object4.getComponent();
                Sequence sequence = imageResource.getSequence(object3.getComponentID());
                arrayList.add(sequence);
                if (object.contains(sequence)) continue;
                animatedTile.append(sequence);
            }
            object5 = new ArrayList<Sequence>(animatedTile.getSequences());
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (Sequence)object4.next();
                if (arrayList.contains(object3)) continue;
                animatedTile.remove((Sequence)object3);
            }
        }
        if ("sequencecontainer.prop.defaultsequence".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "sequencecontainer.prop.defaultsequence")) {
            object2 = designComponent.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
            object = imageResource.getSequence(object2.getComponentID());
            animatedTile.setDefaultSequence((Sequence)object);
        }
        animatedTile.addPropertyChangeListener(this);
        animatedTile.addSequenceContainerListener(this);
        this.getGameDesign().getMainView().requestEditing(animatedTile);
    }

    private Identifiable findIdentifiable(long l) {
        for (Identifiable identifiable : this.designIdMap.keySet()) {
            if (identifiable.getId() != l) continue;
            return identifiable;
        }
        return null;
    }

    private void refreshSequence(DesignComponent designComponent, DesignEvent designEvent) {
        Object object;
        DesignComponent designComponent2 = designComponent.readProperty("sequncecd.prop.imageresource").getComponent();
        if (designComponent2 == null) {
            return;
        }
        Sequence sequence = (Sequence)this.findIdentifiable(designComponent.getComponentID());
        sequence.removePropertyChangeListener(this);
        sequence.removeSequenceListener(this);
        if ("sequncecd.prop.name".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "sequncecd.prop.name")) {
            object = (String)designComponent.readProperty("sequncecd.prop.name").getPrimitiveValue();
            sequence.setName((String)object);
        }
        if ("sequncecd.prop.framems".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "sequncecd.prop.framems")) {
            int n = (Integer)designComponent.readProperty("sequncecd.prop.framems").getPrimitiveValue();
            sequence.setFrameMs(n);
        }
        if ("sequncecd.prop.frames".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (designEvent.isComponentPropertyChanged(designComponent, "sequncecd.prop.frames")) {
            object = (int[])designComponent.readProperty("sequncecd.prop.frames").getPrimitiveValue();
            sequence.setFrames((int[])object);
        }
        if (designEvent.isComponentPropertyChanged(designComponent, "sequncecd.prop.frame.width") || designEvent.isComponentPropertyChanged(designComponent, "sequncecd.prop.frame.height") || designEvent.isComponentPropertyChanged(designComponent, "sequncecd.prop.zero.based.index")) {
            // empty if block
        }
        sequence.addPropertyChangeListener(this);
        sequence.addSequenceListener(this);
    }

    private void refreshImageResource(DesignComponent designComponent, DesignEvent designEvent) {
        boolean bl;
        if (this.changeMap.remove(designComponent.getComponentID()) != null) {
            return;
        }
        ImageResource imageResource = this.getGameDesign().getImageResource(designComponent.getComponentID());
        imageResource.removeImageResourceListener(this);
        Collection collection = designComponent.getComponents();
        HashSet<AnimatedTile> hashSet = new HashSet<AnimatedTile>(imageResource.getAnimatedTiles());
        for (DesignComponent object : collection) {
            bl = false;
            for (AnimatedTile animatedTile2 : hashSet) {
                if (object.getComponentID() != animatedTile2.getId()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.modelComponent(object);
        }
        for (AnimatedTile animatedTile : hashSet) {
            bl = false;
            for (AnimatedTile animatedTile2 : collection) {
                if (animatedTile.getId() != animatedTile2.getComponentID()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            imageResource.removeAnimatedTile(animatedTile.getIndex());
        }
        imageResource.addImageResourceListener(this);
        this.getGameDesign().getMainView().requestEditing(this.getGameDesign());
    }

    public void setDesignDocument(final DesignDocument designDocument) {
        if (DEBUG) {
            System.out.println(">>>> Set design document to: " + designDocument);
        }
        if (designDocument == this.document) {
            return;
        }
        this.panel.removeAll();
        GlobalRepository globalRepository = this.getGameDesign();
        if (this.document != null) {
            this.document.getListenerManager().removeDesignListener((DesignListener)this);
            this.removeListeners(this.designIdMap.keySet().toArray());
            globalRepository.removeGlobalRepositoryListener(this);
            globalRepository.removeAllComponents();
            globalRepository.getMainView().removeEditorManagerListener(this.gameEditorView);
            this.designIdMap.clear();
        }
        JComponent jComponent = null;
        this.document = designDocument;
        GlobalRepository globalRepository2 = this.getGameDesign();
        this.gameEditorView.setGameDesign(globalRepository2);
        if (designDocument == null) {
            jComponent = this.loadingPanel;
        } else {
            designDocument.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent = designDocument.getRootComponent();
                    GameController.this.modelComponent(designComponent);
                    GameController.this.registerListeners(GameController.this.designIdMap.keySet().toArray());
                    DesignEventFilter designEventFilter = new DesignEventFilter(new DesignEventFilter[0]);
                    designEventFilter.setGlobal(true);
                    designEventFilter.addComponentFilter(designComponent, true);
                    designDocument.getListenerManager().addDesignListener((DesignListener)GameController.this, designEventFilter);
                }
            });
            if (!this.validateImages(globalRepository2)) {
                this.context.getCloneableEditorSupport().close();
                return;
            }
            globalRepository2.getMainView().addEditorManagerListener(this.gameEditorView);
            jComponent = globalRepository2.getMainView().getRootComponent();
            globalRepository2.addGlobalRepositoryListener(this);
            globalRepository2.getMainView().requestEditing(globalRepository2);
        }
        this.panel.add(jComponent);
        this.panel.validate();
    }

    private boolean validateImages(GlobalRepository globalRepository) {
        boolean bl = true;
        HashMap<ImageResource, String> hashMap = new HashMap<ImageResource, String>();
        Collection<ImageResource> collection = globalRepository.getImageResources();
        for (ImageResource imageResource : collection) {
            DesignComponent designComponent;
            if (imageResource.getURL() != null || this.validateImageResource(imageResource, designComponent = this.designIdMap.get(imageResource), hashMap)) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.fixUpdatedImagesInDocument(hashMap);
        }
        return bl;
    }

    private void fixUpdatedImagesInDocument(final Map<ImageResource, String> map) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                for (ImageResource imageResource : map.keySet()) {
                    DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(imageResource);
                    String string = (String)map.get(imageResource);
                    GameController.this.changeMap.put(designComponent.getComponentID(), "imageresourcecd.prop.imagepath");
                    designComponent.writeProperty("imageresourcecd.prop.imagepath", MidpTypes.createStringValue((String)string));
                }
            }
        });
    }

    private void removeListeners(Object ... objectArray) {
        for (Object object : objectArray) {
            Identifiable identifiable;
            if (DEBUG_UNDO) {
                System.out.println("removeListeners on: " + object);
            }
            if (object instanceof Scene) {
                identifiable = (Scene)object;
                ((Scene)identifiable).removeSceneListener(this);
                ((Scene)identifiable).removePropertyChangeListener(this);
                continue;
            }
            if (object instanceof TiledLayer) {
                identifiable = (TiledLayer)object;
                ((TiledLayer)identifiable).removeTiledLayerListener(this);
                ((Layer)identifiable).removePropertyChangeListener(this);
                continue;
            }
            if (object instanceof Sprite) {
                identifiable = (Sprite)object;
                ((Sprite)identifiable).removeSequenceContainerListener(this);
                ((Layer)identifiable).removePropertyChangeListener(this);
                continue;
            }
            if (object instanceof Sequence) {
                identifiable = (Sequence)object;
                ((Sequence)identifiable).removeSequenceListener(this);
                ((Sequence)identifiable).removePropertyChangeListener(this);
                continue;
            }
            if (object instanceof AnimatedTile) {
                identifiable = (AnimatedTile)object;
                ((AnimatedTile)identifiable).removeSequenceContainerListener(this);
                ((AnimatedTile)identifiable).removePropertyChangeListener(this);
                continue;
            }
            if (!(object instanceof ImageResource)) continue;
            identifiable = (ImageResource)object;
            ((ImageResource)identifiable).removeImageResourceListener(this);
        }
    }

    private void registerListeners(Object ... objectArray) {
        for (Object object : objectArray) {
            Identifiable identifiable;
            if (DEBUG_UNDO) {
                System.out.println("registerListeners on: " + object);
            }
            if (object instanceof Scene) {
                identifiable = (Scene)object;
                ((Scene)identifiable).addSceneListener(this);
                ((Scene)identifiable).addPropertyChangeListener(this);
                continue;
            }
            if (object instanceof TiledLayer) {
                identifiable = (TiledLayer)object;
                ((TiledLayer)identifiable).addTiledLayerListener(this);
                ((Layer)identifiable).addPropertyChangeListener(this);
                continue;
            }
            if (object instanceof Sprite) {
                identifiable = (Sprite)object;
                ((Sprite)identifiable).addSequenceContainerListener(this);
                ((Layer)identifiable).addPropertyChangeListener(this);
                continue;
            }
            if (object instanceof Sequence) {
                identifiable = (Sequence)object;
                ((Sequence)identifiable).addSequenceListener(this);
                ((Sequence)identifiable).addPropertyChangeListener(this);
                continue;
            }
            if (object instanceof AnimatedTile) {
                identifiable = (AnimatedTile)object;
                ((AnimatedTile)identifiable).addSequenceContainerListener(this);
                ((AnimatedTile)identifiable).addPropertyChangeListener(this);
                continue;
            }
            if (!(object instanceof ImageResource)) continue;
            identifiable = (ImageResource)object;
            ((ImageResource)identifiable).addImageResourceListener(this);
        }
    }

    private void modelComponent(DesignComponent designComponent) {
        Object object2;
        if (designComponent == null) {
            return;
        }
        Collection collection = designComponent.getComponents();
        for (Object object2 : collection) {
            this.modelComponent((DesignComponent)object2);
        }
        TypeID typeID = designComponent.getType();
        assert (typeID != null);
        if (typeID.equals((Object)SceneCD.TYPEID)) {
            object2 = this.constructScene(designComponent);
            this.designIdMap.put((Identifiable)object2, designComponent);
        } else if (typeID.equals((Object)TiledLayerCD.TYPEID)) {
            object2 = this.constructTiledLayer(designComponent);
            this.designIdMap.put((Identifiable)object2, designComponent);
        } else if (typeID.equals((Object)SpriteCD.TYPEID)) {
            object2 = this.constructSprite(designComponent);
            this.designIdMap.put((Identifiable)object2, designComponent);
        } else if (typeID.equals((Object)SequenceCD.TYPEID)) {
            object2 = this.constructSequence(designComponent);
            this.designIdMap.put((Identifiable)object2, designComponent);
        } else if (typeID.equals((Object)ImageResourceCD.TYPEID)) {
            object2 = this.constructImageResource(designComponent);
            this.designIdMap.put((Identifiable)object2, designComponent);
        } else if (typeID.equals((Object)AnimatedTileCD.TYPEID)) {
            object2 = this.constructAnimatedTile(designComponent);
            this.designIdMap.put((Identifiable)object2, designComponent);
        }
    }

    private AnimatedTile constructAnimatedTile(DesignComponent designComponent) {
        int n = (Integer)designComponent.readProperty("animatedtilecd.prop.index").getPrimitiveValue();
        String string = (String)designComponent.readProperty("animatedtilecd.prop.name").getPrimitiveValue();
        DesignComponent designComponent2 = designComponent.readProperty("animatedtilecd.prop.imageresource").getComponent();
        ImageResource imageResource = this.constructImageResource(designComponent2);
        AnimatedTile animatedTile = imageResource.getAnimatedTileByName(string);
        if (animatedTile != null) {
            return animatedTile;
        }
        DesignComponent designComponent3 = designComponent.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
        List list = designComponent.readProperty("sequencecontainer.prop.sequences").getArray();
        Sequence sequence = this.constructSequence(designComponent3);
        animatedTile = imageResource.createAnimatedTile(n, string, sequence);
        animatedTile.setId(designComponent.getComponentID());
        for (PropertyValue propertyValue : list) {
            DesignComponent designComponent4 = propertyValue.getComponent();
            Sequence sequence2 = this.constructSequence(designComponent4);
            if (sequence2 == sequence) continue;
            animatedTile.append(sequence2);
        }
        Identifiable identifiable = this.findIdentifiable(designComponent.getComponentID());
        if (identifiable != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + animatedTile + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(identifiable);
            this.removeListeners(identifiable);
            this.designIdMap.put(animatedTile, designComponent);
            this.registerListeners(animatedTile);
        }
        return animatedTile;
    }

    private Sprite constructSprite(DesignComponent designComponent) {
        String string = (String)designComponent.readProperty("layercd.prop.name").getPrimitiveValue();
        Sprite sprite = (Sprite)this.getGameDesign().getLayerByName(string);
        if (sprite != null) {
            return sprite;
        }
        DesignComponent designComponent2 = designComponent.readProperty("layercd.prop.imageresource").getComponent();
        ImageResource imageResource = this.constructImageResource(designComponent2);
        DesignComponent designComponent3 = designComponent.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
        List list = designComponent.readProperty("sequencecontainer.prop.sequences").getArray();
        Sequence sequence = this.constructSequence(designComponent3);
        sprite = this.getGameDesign().createSprite(string, imageResource, sequence);
        sprite.setId(designComponent.getComponentID());
        for (PropertyValue propertyValue : list) {
            DesignComponent designComponent4 = propertyValue.getComponent();
            Sequence sequence2 = this.constructSequence(designComponent4);
            if (sequence2 == sequence) continue;
            sprite.append(sequence2);
        }
        Identifiable identifiable = this.findIdentifiable(designComponent.getComponentID());
        if (identifiable != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + sprite + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(identifiable);
            this.removeListeners(identifiable);
            this.designIdMap.put(sprite, designComponent);
            this.registerListeners(sprite);
        }
        return sprite;
    }

    private TiledLayer constructTiledLayer(DesignComponent designComponent) {
        String string = (String)designComponent.readProperty("layercd.prop.name").getPrimitiveValue();
        TiledLayer tiledLayer = (TiledLayer)this.getGameDesign().getLayerByName(string);
        if (tiledLayer != null) {
            return tiledLayer;
        }
        DesignComponent designComponent2 = designComponent.readProperty("layercd.prop.imageresource").getComponent();
        ImageResource imageResource = this.constructImageResource(designComponent2);
        int[][] nArray = (int[][])designComponent.readProperty("tiledlayercd.prop.tiles").getPrimitiveValue();
        int n = MidpTypes.getInteger((PropertyValue)designComponent.readProperty("layercd.prop.tile.width"));
        int n2 = MidpTypes.getInteger((PropertyValue)designComponent.readProperty("layercd.prop.tile.height"));
        int[][] nArray2 = TiledLayer.cloneTiles(nArray);
        tiledLayer = this.getGameDesign().createTiledLayer(string, imageResource, nArray2, n, n2);
        tiledLayer.setId(designComponent.getComponentID());
        Identifiable identifiable = this.findIdentifiable(designComponent.getComponentID());
        if (identifiable != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + tiledLayer + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(identifiable);
            this.removeListeners(identifiable);
            this.designIdMap.put(tiledLayer, designComponent);
            this.registerListeners(tiledLayer);
        }
        return tiledLayer;
    }

    private Sequence constructSequence(DesignComponent designComponent) {
        String string = (String)designComponent.readProperty("sequncecd.prop.name").getPrimitiveValue();
        DesignComponent designComponent2 = designComponent.readProperty("sequncecd.prop.imageresource").getComponent();
        ImageResource imageResource = this.constructImageResource(designComponent2);
        Sequence sequence = imageResource.getSequenceByName(string);
        if (sequence != null) {
            return sequence;
        }
        int n = (Integer)designComponent.readProperty("sequncecd.prop.framems").getPrimitiveValue();
        int[] nArray = (int[])designComponent.readProperty("sequncecd.prop.frames").getPrimitiveValue();
        int n2 = (Integer)designComponent.readProperty("sequncecd.prop.frame.width").getPrimitiveValue();
        int n3 = (Integer)designComponent.readProperty("sequncecd.prop.frame.height").getPrimitiveValue();
        boolean bl = (Boolean)designComponent.readProperty("sequncecd.prop.zero.based.index").getPrimitiveValue();
        sequence = imageResource.createSequence(string, nArray.length, n2, n3, bl);
        sequence.setId(designComponent.getComponentID());
        sequence.setFrameMs(n);
        for (int i = 0; i < nArray.length; ++i) {
            sequence.setFrame((StaticTile)imageResource.getTile(nArray[i], n2, n3, bl), i);
        }
        Identifiable identifiable = this.findIdentifiable(designComponent.getComponentID());
        if (identifiable != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + sequence + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(identifiable);
            this.removeListeners(identifiable);
            this.designIdMap.put(sequence, designComponent);
            this.registerListeners(sequence);
        }
        return sequence;
    }

    private ImageResource constructImageResource(DesignComponent designComponent) {
        Object object;
        URL uRL = null;
        String string = (String)designComponent.readProperty("imageresourcecd.prop.imagepath").getPrimitiveValue();
        String string2 = (String)designComponent.readProperty("imageresourcecd.prop.name").getPrimitiveValue();
        ImageResource imageResource = this.getGameDesign().getImageResource(string);
        if (imageResource != null) {
            return imageResource;
        }
        Map map = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)this.document, (String)string);
        if (map.size() == 1) {
            object = (FileObject)map.keySet().iterator().next();
            try {
                uRL = object.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                fileStateInvalidException.printStackTrace();
            }
        }
        object = this.getGameDesign().getImageResource(uRL, string);
        ((ImageResource)object).setName(string2);
        ((ImageResource)object).setId(designComponent.getComponentID());
        return object;
    }

    private boolean validateImageResource(ImageResource imageResource, DesignComponent designComponent, Map<ImageResource, String> map) {
        FileObject fileObject;
        Object object;
        boolean bl = false;
        String string = imageResource.getRelativeResourcePath();
        Map map2 = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)this.document, (String)string);
        if (map2.size() > 1) {
            if (DEBUG) {
                System.out.println("found multiple images matching the relative path:");
                for (Map.Entry entry2 : map2.entrySet()) {
                    System.out.println("root: " + entry2.getValue() + ", path: " + entry2.getKey());
                }
            }
            object = new SelectImageForLayerDialog(NbBundle.getMessage(GameController.class, (String)"GameController.SelectImageDialog.description1_txt", (Object)string), map2.keySet());
            DialogDescriptor selectImageForLayerDialog = new DialogDescriptor(object, NbBundle.getMessage(GameController.class, (String)"GameController.SelectImageDialog.title"));
            selectImageForLayerDialog.setValid(false);
            selectImageForLayerDialog.setButtonListener((ActionListener)object);
            ((SelectImageForLayerDialog)object).setDialogDescriptor(selectImageForLayerDialog);
            Dialog dialogDescriptor = DialogDisplayer.getDefault().createDialog(selectImageForLayerDialog);
            dialogDescriptor.setVisible(true);
            fileObject = ((SelectImageForLayerDialog)object).getValue();
            if (((SelectImageForLayerDialog)object).isCancelled() || fileObject == null) {
                return bl;
            }
            String dialog = "/" + FileUtil.getRelativePath((FileObject)((FileObject)map2.get(fileObject)), (FileObject)fileObject);
            if (DEBUG) {
                System.out.println("Setting new path: " + dialog);
            }
            map.put(imageResource, dialog);
            if (DEBUG_UNDO) {
                System.out.println("Set new path: " + dialog);
            }
        } else if (map2.isEmpty()) {
            fileObject = null;
            if (DEBUG) {
                System.out.println("Image " + string + " doesn't exist, select a replacement.");
            }
            object = MidpProjectSupport.getImagesForProject((DesignDocument)this.document, (boolean)false);
            SelectImageForLayerDialog selectImageForLayerDialog = new SelectImageForLayerDialog(NbBundle.getMessage(GameController.class, (String)"GameController.SelectImageDialog.description2_txt", (Object)string), object.keySet());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectImageForLayerDialog, NbBundle.getMessage(GameController.class, (String)"GameController.SelectImageDialog.title"));
            dialogDescriptor.setValid(false);
            dialogDescriptor.setButtonListener((ActionListener)selectImageForLayerDialog);
            selectImageForLayerDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            fileObject = selectImageForLayerDialog.getValue();
            if (selectImageForLayerDialog.isCancelled() || fileObject == null) {
                return bl;
            }
            String string2 = (String)object.get(fileObject);
            if (DEBUG) {
                System.out.println("Setting new path: " + string2);
            }
            map.put(imageResource, string2);
            if (DEBUG_UNDO) {
                System.out.println("Set new path: " + string2);
            }
        } else {
            fileObject = (FileObject)map2.keySet().iterator().next();
            if (DEBUG) {
                System.out.println("Found single matching image ULR: " + fileObject.getPath());
            }
        }
        try {
            if (fileObject != null) {
                URL uRL = fileObject.getURL();
                imageResource.setURL(uRL);
                bl = true;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new RuntimeException(fileStateInvalidException);
        }
        return bl;
    }

    private Scene constructScene(DesignComponent designComponent) {
        String string = (String)designComponent.readProperty("scenecd.prop.name").getPrimitiveValue();
        Scene scene = this.getGameDesign().getSceneByName(string);
        if (scene != null) {
            return scene;
        }
        scene = this.getGameDesign().createScene(string);
        scene.setId(designComponent.getComponentID());
        List list = designComponent.readProperty("scenecd.prop.sceneitems").getArray();
        for (PropertyValue propertyValue : list) {
            DesignComponent designComponent2 = propertyValue.getComponent();
            Point point = (Point)designComponent2.readProperty("sceneitemcd.prop.position").getPrimitiveValue();
            Boolean bl = (Boolean)designComponent2.readProperty("sceneitemcd.prop.lock").getPrimitiveValue();
            Boolean bl2 = (Boolean)designComponent2.readProperty("sceneitemcd.prop.visible").getPrimitiveValue();
            DesignComponent designComponent3 = designComponent2.readProperty("sceneitemcd.prop.layer").getComponent();
            int n = (Integer)designComponent2.readProperty("sceneitemcd.prop.z.order").getPrimitiveValue();
            Layer layer = null;
            layer = designComponent3.getType().equals((Object)TiledLayerCD.TYPEID) ? this.constructTiledLayer(designComponent3) : this.constructSprite(designComponent3);
            scene.append(layer);
            scene.move(layer, n);
            scene.setLayerPosition(layer, point, false);
            scene.setLayerVisible(layer, bl2);
            scene.setLayerLocked(layer, bl);
        }
        Identifiable identifiable = this.findIdentifiable(designComponent.getComponentID());
        if (identifiable != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + scene + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(identifiable);
            this.removeListeners(identifiable);
            this.designIdMap.put(scene, designComponent);
            this.registerListeners(scene);
        }
        return scene;
    }

    public static DesignComponent createSceneDCFromScene(DesignDocument designDocument, Map<Identifiable, DesignComponent> map, Scene scene) {
        DesignComponent designComponent = map.get(scene);
        if (designComponent != null) {
            return designComponent;
        }
        designComponent = designDocument.createComponent(SceneCD.TYPEID);
        scene.setId(designComponent.getComponentID());
        designComponent.writeProperty("scenecd.prop.name", MidpTypes.createStringValue((String)scene.getName()));
        GameController.writeSceneItemsToSceneDC(designDocument, map, designComponent, scene);
        return designComponent;
    }

    private static void writeSceneItemsToSceneDC(DesignDocument designDocument, Map<Identifiable, DesignComponent> map, DesignComponent designComponent, Scene scene) {
        Object object;
        Object object22;
        List list = designComponent.readProperty("scenecd.prop.sceneitems").getArray();
        for (Object object22 : list) {
            object = object22.getComponent();
            object.removeFromParentComponent();
        }
        designComponent.writeProperty("scenecd.prop.sceneitems", PropertyValue.createEmptyArray((TypeID)SceneItemCD.TYPEID));
        List<Layer> list2 = scene.getLayers();
        object22 = new ArrayList();
        object = list2.iterator();
        while (object.hasNext()) {
            DesignComponent designComponent2 = designDocument.createComponent(SceneItemCD.TYPEID);
            Layer layer = (Layer)object.next();
            DesignComponent designComponent3 = map.get(layer);
            assert (designComponent3 != null);
            designComponent2.writeProperty("sceneitemcd.prop.layer", PropertyValue.createComponentReference((DesignComponent)designComponent3));
            designComponent2.writeProperty("sceneitemcd.prop.lock", MidpTypes.createBooleanValue((boolean)scene.isLayerLocked(layer)));
            designComponent2.writeProperty("sceneitemcd.prop.visible", MidpTypes.createBooleanValue((boolean)scene.isLayerVisible(layer)));
            designComponent2.writeProperty("sceneitemcd.prop.position", GameTypes.createPointProperty(scene.getLayerPosition(layer)));
            designComponent2.writeProperty("sceneitemcd.prop.z.order", MidpTypes.createIntegerValue((int)scene.indexOf(layer)));
            designComponent.addComponent(designComponent2);
            PropertyValue propertyValue = PropertyValue.createComponentReference((DesignComponent)designComponent2);
            object22.add(propertyValue);
        }
        designComponent.writeProperty("scenecd.prop.sceneitems", PropertyValue.createArray((TypeID)SceneItemCD.TYPEID, (List)object22));
    }

    public static DesignComponent createTiledLayerDCFromTiledLayer(DesignDocument designDocument, Map<Identifiable, DesignComponent> map, TiledLayer tiledLayer) {
        DesignComponent designComponent = map.get(tiledLayer);
        if (designComponent != null) {
            return designComponent;
        }
        designComponent = designDocument.createComponent(TiledLayerCD.TYPEID);
        tiledLayer.setId(designComponent.getComponentID());
        designComponent.writeProperty("layercd.prop.name", MidpTypes.createStringValue((String)tiledLayer.getName()));
        DesignComponent designComponent2 = map.get(tiledLayer.getImageResource());
        assert (designComponent2 != null);
        designComponent.writeProperty("layercd.prop.imageresource", PropertyValue.createComponentReference((DesignComponent)designComponent2));
        PropertyValue propertyValue = GameTypes.createTilesProperty(tiledLayer.getTiles());
        designComponent.writeProperty("tiledlayercd.prop.tiles", propertyValue);
        designComponent.writeProperty("layercd.prop.tile.width", MidpTypes.createIntegerValue((int)tiledLayer.getTileWidth()));
        designComponent.writeProperty("layercd.prop.tile.height", MidpTypes.createIntegerValue((int)tiledLayer.getTileHeight()));
        return designComponent;
    }

    public DesignComponent createAnimatedTileDCFromAnimatedTile(AnimatedTile animatedTile) {
        DesignComponent designComponent = this.designIdMap.get(animatedTile);
        if (designComponent != null) {
            return designComponent;
        }
        designComponent = this.document.createComponent(AnimatedTileCD.TYPEID);
        animatedTile.setId(designComponent.getComponentID());
        designComponent.writeProperty("animatedtilecd.prop.name", MidpTypes.createStringValue((String)animatedTile.getName()));
        designComponent.writeProperty("animatedtilecd.prop.index", MidpTypes.createIntegerValue((int)animatedTile.getIndex()));
        designComponent.writeProperty("animatedtilecd.prop.width", MidpTypes.createIntegerValue((int)animatedTile.getWidth()));
        designComponent.writeProperty("animatedtilecd.prop.height", MidpTypes.createIntegerValue((int)animatedTile.getHeight()));
        DesignComponent designComponent2 = this.designIdMap.get(animatedTile.getImageResource());
        assert (designComponent2 != null);
        designComponent.writeProperty("animatedtilecd.prop.imageresource", PropertyValue.createComponentReference((DesignComponent)designComponent2));
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        for (Sequence sequence : animatedTile.getSequences()) {
            DesignComponent designComponent3 = this.designIdMap.get(sequence);
            if (designComponent3 == null) {
                designComponent3 = this.createSequenceDCFromSequence(sequence);
                this.designIdMap.put(sequence, designComponent3);
            }
            if (!designComponent.getComponents().contains(designComponent3)) {
                designComponent.addComponent(designComponent3);
            }
            if (sequence == animatedTile.getDefaultSequence()) {
                designComponent.writeProperty("sequencecontainer.prop.defaultsequence", PropertyValue.createComponentReference((DesignComponent)designComponent3));
            }
            PropertyValue propertyValue = PropertyValue.createComponentReference((DesignComponent)designComponent3);
            arrayList.add(propertyValue);
        }
        designComponent.writeProperty("sequencecontainer.prop.sequences", PropertyValue.createArray((TypeID)SequenceCD.TYPEID, arrayList));
        return designComponent;
    }

    public DesignComponent createSpriteDCFromSprite(Sprite sprite) {
        DesignComponent designComponent = this.designIdMap.get(sprite);
        if (designComponent != null) {
            return designComponent;
        }
        designComponent = this.document.createComponent(SpriteCD.TYPEID);
        sprite.setId(designComponent.getComponentID());
        designComponent.writeProperty("layercd.prop.name", MidpTypes.createStringValue((String)sprite.getName()));
        designComponent.writeProperty("layercd.prop.tile.width", MidpTypes.createIntegerValue((int)sprite.getTileWidth()));
        designComponent.writeProperty("layercd.prop.tile.height", MidpTypes.createIntegerValue((int)sprite.getTileHeight()));
        DesignComponent designComponent2 = this.designIdMap.get(sprite.getImageResource());
        assert (designComponent2 != null);
        designComponent.writeProperty("layercd.prop.imageresource", PropertyValue.createComponentReference((DesignComponent)designComponent2));
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        for (Sequence sequence : sprite.getSequences()) {
            DesignComponent designComponent3 = this.designIdMap.get(sequence);
            if (designComponent3 == null) {
                designComponent3 = this.createSequenceDCFromSequence(sequence);
                this.designIdMap.put(sequence, designComponent3);
            }
            if (!designComponent.getComponents().contains(designComponent3)) {
                designComponent.addComponent(designComponent3);
            }
            if (sequence == sprite.getDefaultSequence()) {
                designComponent.writeProperty("sequencecontainer.prop.defaultsequence", PropertyValue.createComponentReference((DesignComponent)designComponent3));
            }
            PropertyValue propertyValue = PropertyValue.createComponentReference((DesignComponent)designComponent3);
            arrayList.add(propertyValue);
        }
        designComponent.writeProperty("sequencecontainer.prop.sequences", PropertyValue.createArray((TypeID)SequenceCD.TYPEID, arrayList));
        return designComponent;
    }

    public DesignComponent createImageResourceDCFromImageResource(ImageResource imageResource) {
        DesignComponent designComponent = this.designIdMap.get(imageResource);
        if (designComponent != null) {
            return designComponent;
        }
        designComponent = this.document.createComponent(ImageResourceCD.TYPEID);
        imageResource.setId(designComponent.getComponentID());
        designComponent.writeProperty("imageresourcecd.prop.imagepath", MidpTypes.createStringValue((String)imageResource.getRelativeResourcePath()));
        designComponent.writeProperty("imageresourcecd.prop.name", MidpTypes.createStringValue((String)imageResource.getName(true)));
        this.writeAnimatedTilesToImageResourceDC(designComponent, imageResource);
        return designComponent;
    }

    private void writeAnimatedTilesToImageResourceDC(DesignComponent designComponent, ImageResource imageResource) {
        for (AnimatedTile animatedTile : imageResource.getAnimatedTiles()) {
            DesignComponent designComponent2 = this.designIdMap.get(animatedTile);
            if (designComponent2 != null) continue;
            assert (!designComponent.getComponents().contains(designComponent2));
            designComponent2 = this.createAnimatedTileDCFromAnimatedTile(animatedTile);
            designComponent.addComponent(designComponent2);
            this.designIdMap.put(animatedTile, designComponent2);
        }
    }

    public DesignComponent createSequenceDCFromSequence(Sequence sequence) {
        DesignComponent designComponent = this.designIdMap.get(sequence);
        if (designComponent != null) {
            return designComponent;
        }
        designComponent = this.document.createComponent(SequenceCD.TYPEID);
        sequence.setId(designComponent.getComponentID());
        designComponent.writeProperty("sequncecd.prop.name", MidpTypes.createStringValue((String)sequence.getName()));
        DesignComponent designComponent2 = this.designIdMap.get(sequence.getImageResource());
        assert (designComponent2 != null);
        designComponent.writeProperty("sequncecd.prop.imageresource", PropertyValue.createComponentReference((DesignComponent)designComponent2));
        designComponent.writeProperty("sequncecd.prop.frames", GameTypes.createFramesProperty(sequence.getFramesAsArray()));
        designComponent.writeProperty("sequncecd.prop.framems", MidpTypes.createIntegerValue((int)sequence.getFrameMs()));
        designComponent.writeProperty("sequncecd.prop.frame.width", MidpTypes.createIntegerValue((int)sequence.getFrameWidth()));
        designComponent.writeProperty("sequncecd.prop.frame.height", MidpTypes.createIntegerValue((int)sequence.getFrameHeight()));
        designComponent.writeProperty("sequncecd.prop.zero.based.index", MidpTypes.createBooleanValue((boolean)sequence.isZeroBasedIndex()));
        this.registerListeners(sequence);
        return designComponent;
    }

    @Override
    public void sceneAdded(final Scene scene, int n) {
        final DesignDocument designDocument = this.document;
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = GameController.createSceneDCFromScene(designDocument, GameController.this.designIdMap, scene);
                GameController.this.designIdMap.put(scene, designComponent);
                GameController.this.changeMap.put(designDocument.getRootComponent().getComponentID(), scene.getName());
                scene.addSceneListener(GameController.this);
                scene.addPropertyChangeListener(GameController.this);
                designDocument.getRootComponent().addComponent(designComponent);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Scene added " + scene);
        }
    }

    @Override
    public void sceneRemoved(final Scene scene, int n) {
        final DesignDocument designDocument = this.document;
        scene.removeSceneListener(this);
        final DesignComponent designComponent = this.designIdMap.get(scene);
        assert (designComponent != null);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                GameController.this.changeMap.put(designDocument.getRootComponent().getComponentID(), scene.getName());
                GameController.this.document.deleteComponent(designComponent);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Scene removed: " + scene);
        }
    }

    @Override
    public void tiledLayerAdded(final TiledLayer tiledLayer, int n) {
        DesignDocument designDocument = this.document;
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignDocument designDocument = GameController.this.document;
                DesignComponent designComponent = GameController.createTiledLayerDCFromTiledLayer(designDocument, GameController.this.designIdMap, tiledLayer);
                GameController.this.changeMap.put(designDocument.getRootComponent().getComponentID(), tiledLayer.getName());
                tiledLayer.addTiledLayerListener(GameController.this);
                tiledLayer.addPropertyChangeListener(GameController.this);
                designDocument.getRootComponent().addComponent(designComponent);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("TL added: " + tiledLayer);
        }
    }

    @Override
    public void tiledLayerRemoved(final TiledLayer tiledLayer, int n) {
        final DesignDocument designDocument = this.document;
        tiledLayer.removeTiledLayerListener(this);
        final DesignComponent designComponent = this.designIdMap.get(tiledLayer);
        assert (designComponent != null);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                GameController.this.changeMap.put(designDocument.getRootComponent().getComponentID(), tiledLayer.getName());
                GameController.this.document.deleteComponent(designComponent);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("TL removed: " + tiledLayer);
        }
    }

    @Override
    public void spriteAdded(final Sprite sprite, int n) {
        final DesignDocument designDocument = this.document;
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = GameController.this.createSpriteDCFromSprite(sprite);
                GameController.this.designIdMap.put(sprite, designComponent);
                GameController.this.changeMap.put(designDocument.getRootComponent().getComponentID(), sprite.getName());
                sprite.addSequenceContainerListener(GameController.this);
                sprite.addPropertyChangeListener(GameController.this);
                GameController.this.document.getRootComponent().addComponent(designComponent);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Sprite added: " + sprite);
        }
    }

    @Override
    public void spriteRemoved(final Sprite sprite, int n) {
        final DesignDocument designDocument = this.document;
        sprite.removeSequenceContainerListener(this);
        final DesignComponent designComponent = this.designIdMap.get(sprite);
        assert (designComponent != null);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                GameController.this.changeMap.put(designDocument.getRootComponent().getComponentID(), sprite.getName());
                GameController.this.document.deleteComponent(designComponent);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Sprite removed: " + sprite);
        }
    }

    @Override
    public void imageResourceAdded(final ImageResource imageResource) {
        DesignDocument designDocument = this.document;
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignDocument designDocument = GameController.this.document;
                DesignComponent designComponent = GameController.this.createImageResourceDCFromImageResource(imageResource);
                GameController.this.designIdMap.put(imageResource, designComponent);
                GameController.this.changeMap.put(designDocument.getRootComponent().getComponentID(), imageResource.getName());
                imageResource.addImageResourceListener(GameController.this);
                designDocument.getRootComponent().addComponent(designComponent);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("ImgRes added: " + imageResource);
        }
    }

    @Override
    public void layerAdded(final Scene scene, final Layer layer, int n) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(scene);
                assert (designComponent != null);
                DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (designComponent2 != null);
                GameController.this.changeMap.put(designComponent.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, designComponent, scene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer added: " + layer);
        }
    }

    @Override
    public void layerRemoved(final Scene scene, final Layer layer, Scene.LayerInfo layerInfo, int n) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(scene);
                assert (designComponent != null);
                DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (designComponent2 != null);
                GameController.this.changeMap.put(designComponent.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, designComponent, scene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer removed: " + layer);
        }
    }

    @Override
    public void layerMoved(final Scene scene, final Layer layer, int n, int n2) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(scene);
                assert (designComponent != null);
                DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (designComponent2 != null);
                GameController.this.changeMap.put(designComponent.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, designComponent, scene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer moved: " + layer);
        }
    }

    @Override
    public void layerPositionChanged(final Scene scene, final Layer layer, Point point, Point point2, boolean bl) {
        if (bl) {
            return;
        }
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(scene);
                assert (designComponent != null);
                DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (designComponent2 != null);
                GameController.this.changeMap.put(designComponent.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, designComponent, scene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer position changed: " + layer);
        }
    }

    @Override
    public void layerLockChanged(final Scene scene, final Layer layer, boolean bl) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(scene);
                assert (designComponent != null);
                DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (designComponent2 != null);
                GameController.this.changeMap.put(designComponent.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, designComponent, scene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer lock changed: " + layer);
        }
    }

    @Override
    public void layerVisibilityChanged(final Scene scene, final Layer layer, boolean bl) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(scene);
                assert (designComponent != null);
                DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (designComponent2 != null);
                GameController.this.changeMap.put(designComponent.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, designComponent, scene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer visibility changed: " + layer);
        }
    }

    @Override
    public void tileChanged(TiledLayer tiledLayer, int n, int n2) {
        this.updateTiledLayerDCProps(tiledLayer);
    }

    @Override
    public void tilesChanged(TiledLayer tiledLayer, Set set) {
        this.updateTiledLayerDCProps(tiledLayer);
    }

    @Override
    public void tilesStructureChanged(TiledLayer tiledLayer) {
        this.updateTiledLayerDCProps(tiledLayer);
    }

    @Override
    public void columnsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.updateTiledLayerDCProps(tiledLayer);
    }

    @Override
    public void columnsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.updateTiledLayerDCProps(tiledLayer);
    }

    @Override
    public void rowsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.updateTiledLayerDCProps(tiledLayer);
    }

    @Override
    public void rowsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.updateTiledLayerDCProps(tiledLayer);
    }

    private void updateTiledLayerDCProps(final TiledLayer tiledLayer) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(tiledLayer);
                assert (designComponent != null);
                GameController.this.changeMap.put(designComponent.getComponentID(), "tiledlayercd.prop.tiles");
                PropertyValue propertyValue = GameTypes.createTilesProperty(tiledLayer.getTiles());
                designComponent.writeProperty("tiledlayercd.prop.tiles", propertyValue);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer props changed: " + tiledLayer);
        }
    }

    @Override
    public void sequenceAdded(SequenceContainer sequenceContainer, Sequence sequence, int n) {
        this.sequenceContainerChanged(sequenceContainer);
    }

    @Override
    public void sequenceRemoved(SequenceContainer sequenceContainer, Sequence sequence, int n) {
        this.sequenceContainerChanged(sequenceContainer);
    }

    @Override
    public void sequenceMoved(SequenceContainer sequenceContainer, Sequence sequence, int n, int n2) {
        this.sequenceContainerChanged(sequenceContainer);
    }

    private void sequenceContainerChanged(final SequenceContainer sequenceContainer) {
        DesignComponent designComponent = this.designIdMap.get(sequenceContainer);
        assert (designComponent != null);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                GameController.this.writeSequencesToSequenceContainerDC(sequenceContainer);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Seq container changed: " + sequenceContainer);
        }
    }

    private void writeSequencesToSequenceContainerDC(SequenceContainer sequenceContainer) {
        DesignComponent designComponent = this.designIdMap.get(sequenceContainer);
        assert (designComponent != null);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        List<Sequence> list = sequenceContainer.getSequences();
        ArrayList arrayList2 = new ArrayList(designComponent.getComponents());
        for (DesignComponent object : arrayList2) {
            boolean designComponent2 = false;
            for (Sequence sequence : list) {
                if (this.designIdMap.get(sequence) != object) continue;
                designComponent2 = true;
                break;
            }
            if (designComponent2) continue;
            designComponent.removeComponent(object);
        }
        for (Sequence sequence : list) {
            DesignComponent designComponent2 = this.designIdMap.get(sequence);
            if (designComponent2 == null) {
                designComponent2 = this.createSequenceDCFromSequence(sequence);
                this.designIdMap.put(sequence, designComponent2);
            }
            if (!designComponent.getComponents().contains(designComponent2)) {
                designComponent.addComponent(designComponent2);
            }
            PropertyValue propertyValue = PropertyValue.createComponentReference((DesignComponent)designComponent2);
            arrayList.add(propertyValue);
        }
        this.changeMap.put(designComponent.getComponentID(), "sequencecontainer.prop.sequences");
        designComponent.writeProperty("sequencecontainer.prop.sequences", PropertyValue.createArray((TypeID)SequenceCD.TYPEID, arrayList));
    }

    @Override
    public void frameAdded(Sequence sequence, int n) {
        this.updateSequenceFrames(sequence);
    }

    @Override
    public void frameRemoved(Sequence sequence, int n) {
        this.updateSequenceFrames(sequence);
    }

    @Override
    public void frameModified(Sequence sequence, int n) {
        this.updateSequenceFrames(sequence);
    }

    @Override
    public void framesChanged(Sequence sequence) {
        this.updateSequenceFrames(sequence);
    }

    private void updateSequenceFrames(final Sequence sequence) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(sequence);
                assert (designComponent != null);
                GameController.this.changeMap.put(designComponent.getComponentID(), "sequncecd.prop.frames");
                int[] nArray = sequence.getFramesAsArray();
                designComponent.writeProperty("sequncecd.prop.frames", GameTypes.createFramesProperty(nArray));
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Seq frames changed: " + sequence);
        }
    }

    @Override
    public void animatedTileAdded(final ImageResource imageResource, final AnimatedTile animatedTile) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                if (DEBUG) {
                    System.out.println("animatedTileAdded: " + animatedTile);
                }
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(imageResource);
                assert (designComponent != null);
                GameController.this.writeAnimatedTilesToImageResourceDC(designComponent, imageResource);
                DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(animatedTile);
                assert (designComponent2 != null);
                GameController.this.changeMap.put(designComponent.getComponentID(), "imageresourcecd.prop.name");
                animatedTile.addSequenceContainerListener(GameController.this);
                animatedTile.addPropertyChangeListener(GameController.this);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Anim tile added: " + animatedTile);
        }
    }

    @Override
    public void animatedTileRemoved(final ImageResource imageResource, final AnimatedTile animatedTile) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                if (DEBUG) {
                    System.out.println("animatedTileRemoved: " + animatedTile);
                }
                DesignComponent designComponent = (DesignComponent)GameController.this.designIdMap.get(animatedTile);
                assert (designComponent != null);
                DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(imageResource);
                assert (designComponent2 != null);
                designComponent2.removeComponent(designComponent);
                ArrayList arrayList = new ArrayList(designComponent.getComponents());
                for (DesignComponent designComponent3 : arrayList) {
                    GameController.this.changeMap.put(designComponent3.getComponentID(), null);
                    designComponent.removeComponent(designComponent3);
                    GameController.this.document.deleteComponent(designComponent3);
                }
                GameController.this.document.deleteComponent(designComponent);
                GameController.this.changeMap.put(designComponent2.getComponentID(), "imageresourcecd.prop.name");
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Anim tile removed: " + animatedTile);
        }
        this.gameEditorView.discardAllEdits();
    }

    @Override
    public void sequenceAdded(ImageResource imageResource, Sequence sequence) {
        if (DEBUG_UNDO) {
            System.out.println("IGNORE ImageResourceListener Seq added: " + sequence);
        }
    }

    @Override
    public void sequenceRemoved(ImageResource imageResource, Sequence sequence) {
        if (DEBUG_UNDO) {
            System.out.println("IGNORE ImageResourceListener Seq removed: " + sequence);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DesignComponent designComponent = this.designIdMap.get(propertyChangeEvent.getSource());
        assert (designComponent != null);
        if (designComponent.getType() == SceneCD.TYPEID) {
            this.handleScenePropChange(designComponent, propertyChangeEvent);
        } else if (designComponent.getType() == AnimatedTileCD.TYPEID) {
            this.handleAnimatedTilePropChange(designComponent, propertyChangeEvent);
        } else if (designComponent.getType() == ImageResourceCD.TYPEID) {
            this.handleImageResourcePropChange(designComponent, propertyChangeEvent);
        } else if (designComponent.getType() == SequenceCD.TYPEID) {
            this.handleSequencePropChange(designComponent, propertyChangeEvent);
        } else if (designComponent.getType() == SpriteCD.TYPEID) {
            this.handleSpritePropChange(designComponent, propertyChangeEvent);
        } else if (designComponent.getType() == TiledLayerCD.TYPEID) {
            this.handleTiledLayerPropChange(designComponent, propertyChangeEvent);
        }
    }

    private void handleScenePropChange(final DesignComponent designComponent, final PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    String string = (String)propertyChangeEvent.getNewValue();
                    designComponent.writeProperty("scenecd.prop.name", MidpTypes.createStringValue((String)string));
                    GameController.this.changeMap.put(designComponent.getComponentID(), "scenecd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Scene name changed: " + designComponent);
            }
        }
    }

    private void handleAnimatedTilePropChange(final DesignComponent designComponent, final PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    String string = (String)propertyChangeEvent.getNewValue();
                    designComponent.writeProperty("animatedtilecd.prop.name", MidpTypes.createStringValue((String)string));
                    GameController.this.changeMap.put(designComponent.getComponentID(), "animatedtilecd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("AnimatedTile name changed: " + designComponent);
            }
        }
        if (propertyChangeEvent.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    Sequence sequence = (Sequence)propertyChangeEvent.getNewValue();
                    DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(sequence);
                    designComponent.writeProperty("sequencecontainer.prop.defaultsequence", PropertyValue.createComponentReference((DesignComponent)designComponent2));
                    GameController.this.changeMap.put(designComponent.getComponentID(), "sequencecontainer.prop.defaultsequence");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("AnimatedTile def seq changed: " + designComponent);
            }
        }
    }

    private void handleImageResourcePropChange(DesignComponent designComponent, PropertyChangeEvent propertyChangeEvent) {
    }

    private void handleSequencePropChange(final DesignComponent designComponent, final PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("sequence.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    String string = (String)propertyChangeEvent.getNewValue();
                    designComponent.writeProperty("sequncecd.prop.name", MidpTypes.createStringValue((String)string));
                    GameController.this.changeMap.put(designComponent.getComponentID(), "sequncecd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Sequence name changed: " + designComponent);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("sequence.prop.frames.ms")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    designComponent.writeProperty("sequncecd.prop.framems", MidpTypes.createIntegerValue((int)n));
                    GameController.this.changeMap.put(designComponent.getComponentID(), "sequncecd.prop.framems");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Sequence frame ms changed: " + designComponent);
            }
        }
    }

    private void handleSpritePropChange(final DesignComponent designComponent, final PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    String string = (String)propertyChangeEvent.getNewValue();
                    designComponent.writeProperty("layercd.prop.name", MidpTypes.createStringValue((String)string));
                    GameController.this.changeMap.put(designComponent.getComponentID(), "layercd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Sprite name changed: " + designComponent);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    Sequence sequence = (Sequence)propertyChangeEvent.getNewValue();
                    DesignComponent designComponent2 = (DesignComponent)GameController.this.designIdMap.get(sequence);
                    designComponent.writeProperty("sequencecontainer.prop.defaultsequence", PropertyValue.createComponentReference((DesignComponent)designComponent2));
                    GameController.this.changeMap.put(designComponent.getComponentID(), "sequencecontainer.prop.defaultsequence");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Sprite def seq changed: " + designComponent);
            }
        }
    }

    private void handleTiledLayerPropChange(final DesignComponent designComponent, final PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    String string = (String)propertyChangeEvent.getNewValue();
                    designComponent.writeProperty("layercd.prop.name", MidpTypes.createStringValue((String)string));
                    GameController.this.changeMap.put(designComponent.getComponentID(), "layercd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("TiledLayer name changed: " + designComponent);
            }
        }
    }
}

