/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.jpda.ui.options.DisablingCellRenderer;
import org.netbeans.modules.debugger.jpda.ui.options.StorablePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class CategoryPanelStepFilters
extends StorablePanel {
    private JButton filterAddButton;
    private JLabel filterClassesLabel;
    private JScrollPane filterClassesScrollPane;
    private JTable filterClassesTable;
    private JCheckBox filterConstructorsCheckBox;
    private JButton filterRemoveButton;
    private JCheckBox filterStaticInitCheckBox;
    private JCheckBox filterSyntheticCheckBox;
    private JButton filtersCheckAllButton;
    private JButton filtersUncheckAllButton;
    private JCheckBox stepThroughFiltersCheckBox;
    private JCheckBox useStepFiltersCheckBox;

    public CategoryPanelStepFilters() {
        this.initComponents();
        this.initFilterClassesList();
        this.filterClassesTable.getColumnModel().getColumn(0).setPreferredWidth(new JCheckBox().getPreferredSize().width);
        this.filterClassesTable.getColumnModel().getColumn(0).setMaxWidth(new JCheckBox().getPreferredSize().width);
        this.filterClassesTable.getColumnModel().getColumn(0).setResizable(false);
        this.filterClassesTable.getColumnModel().getColumn(1).setResizable(true);
        this.filterClassesTable.setRowHeight(Math.max(new JCheckBox().getPreferredSize().height, new JLabel((String)"W").getPreferredSize().height));
        DisablingCellRenderer.apply(this.filterClassesTable);
        this.useStepFiltersCheckBoxActionPerformed(null);
    }

    private void initComponents() {
        this.useStepFiltersCheckBox = new JCheckBox();
        this.filterSyntheticCheckBox = new JCheckBox();
        this.filterStaticInitCheckBox = new JCheckBox();
        this.filterConstructorsCheckBox = new JCheckBox();
        this.filterClassesLabel = new JLabel();
        this.filterClassesScrollPane = new JScrollPane();
        this.filterClassesTable = new JTable(){

            public boolean getScrollableTracksViewportHeight() {
                return true;
            }
        };
        this.stepThroughFiltersCheckBox = new JCheckBox();
        this.filterAddButton = new JButton();
        this.filterRemoveButton = new JButton();
        this.filtersCheckAllButton = new JButton();
        this.filtersUncheckAllButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.useStepFiltersCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.useStepFiltersCheckBox.text"));
        this.useStepFiltersCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPanelStepFilters.this.useStepFiltersCheckBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filterSyntheticCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterSyntheticCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.filterStaticInitCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterStaticInitCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.filterConstructorsCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterConstructorsCheckBox.text"));
        this.filterClassesLabel.setLabelFor(this.filterClassesTable);
        Mnemonics.setLocalizedText((JLabel)this.filterClassesLabel, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterClassesLabel.text"));
        this.filterClassesTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}){
            Class[] types;
            {
                this.types = new Class[]{Boolean.class, String.class};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }
        });
        this.filterClassesTable.setShowHorizontalLines(false);
        this.filterClassesTable.setShowVerticalLines(false);
        this.filterClassesTable.setTableHeader(null);
        this.filterClassesScrollPane.setViewportView(this.filterClassesTable);
        this.filterClassesTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterClassesLabel.a11y.name"));
        this.filterClassesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterClassesLabel.a11y.description"));
        Mnemonics.setLocalizedText((AbstractButton)this.stepThroughFiltersCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.stepThroughFiltersCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.filterAddButton, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterAddButton.text"));
        this.filterAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPanelStepFilters.this.filterAddButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filterRemoveButton, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterRemoveButton.text"));
        this.filterRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPanelStepFilters.this.filterRemoveButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filtersCheckAllButton, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filtersCheckAllButton.text"));
        this.filtersCheckAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPanelStepFilters.this.filtersCheckAllButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filtersUncheckAllButton, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filtersUncheckAllButton.text"));
        this.filtersUncheckAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryPanelStepFilters.this.filtersUncheckAllButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.useStepFiltersCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.stepThroughFiltersCheckBox, -1, 545, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.filterStaticInitCheckBox).add((Component)this.filterSyntheticCheckBox).add((Component)this.filterConstructorsCheckBox).add((Component)this.filterClassesLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.filterClassesScrollPane, -1, 432, Short.MAX_VALUE).addPreferredGap(0))).add(6, 6, 6).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.filterAddButton).add((Component)this.filterRemoveButton).add((Component)this.filtersCheckAllButton).add((Component)this.filtersUncheckAllButton))))))));
        groupLayout.linkSize(new Component[]{this.filterAddButton, this.filterRemoveButton, this.filtersCheckAllButton, this.filtersUncheckAllButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.useStepFiltersCheckBox).addPreferredGap(0).add((Component)this.filterSyntheticCheckBox).addPreferredGap(0).add((Component)this.filterStaticInitCheckBox).addPreferredGap(0).add((Component)this.filterConstructorsCheckBox).addPreferredGap(0).add((Component)this.filterClassesLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.filterAddButton).addPreferredGap(0).add((Component)this.filterRemoveButton).addPreferredGap(0).add((Component)this.filtersCheckAllButton).addPreferredGap(0).add((Component)this.filtersUncheckAllButton).add(36, 36, 36)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.filterClassesScrollPane, -1, 152, Short.MAX_VALUE).addPreferredGap(0))).addPreferredGap(0).add((Component)this.stepThroughFiltersCheckBox).addContainerGap()));
    }

    private void initFilterClassesList() {
        this.filterClassesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CategoryPanelStepFilters.this.filterRemoveButton.setEnabled(CategoryPanelStepFilters.this.filterClassesTable.getSelectedRow() >= 0);
            }
        });
        this.filterRemoveButton.setEnabled(this.filterClassesTable.getSelectedRow() >= 0);
        this.filterClassesTable.setSelectionMode(0);
    }

    private void useStepFiltersCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.useStepFiltersCheckBox.isSelected();
        this.filterSyntheticCheckBox.setEnabled(bl);
        this.filterStaticInitCheckBox.setEnabled(bl);
        this.filterConstructorsCheckBox.setEnabled(bl);
        this.filterClassesLabel.setEnabled(bl);
        this.filterClassesTable.setEnabled(bl);
        this.filterClassesScrollPane.setEnabled(bl);
        this.filterAddButton.setEnabled(bl);
        this.filterRemoveButton.setEnabled(bl && this.filterClassesTable.getSelectedRow() >= 0);
        this.filtersCheckAllButton.setEnabled(bl);
        this.filtersUncheckAllButton.setEnabled(bl);
        this.stepThroughFiltersCheckBox.setEnabled(bl);
    }

    private void filterAddButtonActionPerformed(ActionEvent actionEvent) {
        final DefaultTableModel defaultTableModel = (DefaultTableModel)this.filterClassesTable.getModel();
        defaultTableModel.addRow(new Object[]{Boolean.TRUE, ""});
        final int n = defaultTableModel.getRowCount() - 1;
        this.filterClassesTable.getSelectionModel().setSelectionInterval(n, n);
        this.filterClassesTable.editCellAt(n, 1);
        this.filterClassesTable.getEditorComponent().requestFocus();
        this.filterRemoveButton.setEnabled(false);
        this.filterAddButton.setEnabled(false);
        this.filterClassesTable.getCellEditor(n, 1).addCellEditorListener(new CellEditorListener(){

            public void editingStopped(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string;
                        if (n < CategoryPanelStepFilters.this.filterClassesTable.getRowCount() && (string = (String)defaultTableModel.getValueAt(n, 1)).trim().length() == 0) {
                            defaultTableModel.removeRow(n);
                        }
                    }
                });
                CategoryPanelStepFilters.this.filterClassesTable.getCellEditor(n, 1).removeCellEditorListener(this);
                CategoryPanelStepFilters.this.filterRemoveButton.setEnabled(true);
                CategoryPanelStepFilters.this.filterAddButton.setEnabled(true);
            }

            public void editingCanceled(ChangeEvent changeEvent) {
                defaultTableModel.removeRow(n);
                CategoryPanelStepFilters.this.filterClassesTable.getCellEditor(n, 1).removeCellEditorListener(this);
                CategoryPanelStepFilters.this.filterRemoveButton.setEnabled(true);
                CategoryPanelStepFilters.this.filterAddButton.setEnabled(true);
            }
        });
    }

    private void filterRemoveButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.filterClassesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.filterClassesTable.getModel();
        defaultTableModel.removeRow(n);
        if (n < this.filterClassesTable.getRowCount() || --n >= 0) {
            this.filterClassesTable.setRowSelectionInterval(n, n);
        }
    }

    private void filtersCheckAllButtonActionPerformed(ActionEvent actionEvent) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.filterClassesTable.getModel();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            defaultTableModel.setValueAt(Boolean.TRUE, i, 0);
        }
        this.filterClassesTable.repaint();
    }

    private void filtersUncheckAllButtonActionPerformed(ActionEvent actionEvent) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.filterClassesTable.getModel();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            defaultTableModel.setValueAt(Boolean.FALSE, i, 0);
        }
        this.filterClassesTable.repaint();
    }

    void load() {
        Properties properties = Properties.getDefault().getProperties("debugger.options.JPDA");
        this.useStepFiltersCheckBox.setSelected(properties.getBoolean("UseStepFilters", true));
        this.filterSyntheticCheckBox.setSelected(properties.getBoolean("FilterSyntheticMethods", true));
        this.filterStaticInitCheckBox.setSelected(properties.getBoolean("FilterStaticInitializers", false));
        this.filterConstructorsCheckBox.setSelected(properties.getBoolean("FilterConstructors", false));
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.filterClassesTable.getModel();
        Set set = (Set)Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET);
        Set set2 = (Set)Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").getCollection("all", (Collection)Collections.EMPTY_SET);
        defaultTableModel.setRowCount(0);
        for (String string : set2) {
            defaultTableModel.addRow(new Object[]{set.contains(string), string});
        }
        this.stepThroughFiltersCheckBox.setSelected(properties.getBoolean("StepThroughFilters", false));
        this.useStepFiltersCheckBoxActionPerformed(null);
    }

    void store() {
        Properties properties = Properties.getDefault().getProperties("debugger.options.JPDA");
        properties.setBoolean("UseStepFilters", this.useStepFiltersCheckBox.isSelected());
        properties.setBoolean("FilterSyntheticMethods", this.filterSyntheticCheckBox.isSelected());
        properties.setBoolean("FilterStaticInitializers", this.filterStaticInitCheckBox.isSelected());
        properties.setBoolean("FilterConstructors", this.filterConstructorsCheckBox.isSelected());
        TableModel tableModel = this.filterClassesTable.getModel();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        int n = tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = (Boolean)tableModel.getValueAt(i, 0);
            String string = (String)tableModel.getValueAt(i, 1);
            linkedHashSet.add(string);
            if (!bl) continue;
            hashSet.add(string);
        }
        Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").setCollection("all", linkedHashSet);
        Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").setCollection("enabled", hashSet);
        properties.setBoolean("StepThroughFilters", this.stepThroughFiltersCheckBox.isSelected());
    }
}

