/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.memory;

import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.util.BytesFormatter;
import org.netbeans.modules.dlight.util.ValueFormatter;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionName;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.openide.util.NbBundle;

public final class MemoryToolConfigurationProvider
implements DLightToolConfigurationProvider {
    private static final int INDICATOR_POSITION = 200;
    private static final String ID = "dlight.tool.mem";
    private static final String TOOL_NAME = MemoryToolConfigurationProvider.loc("MemoryTool.ToolName", new String[0]);
    private static final String TOOL_NAME_DETAILED = MemoryToolConfigurationProvider.loc("MemoryTool.ToolName.Detailed", new String[0]);
    private static final DataTableMetadata.Column totalColumn;
    private static final DataTableMetadata rawTableMetadata;
    private static final String MAX_HEAP_DETAIL_ID = "max-heap";

    public DLightToolConfiguration create() {
        DLightToolConfiguration dLightToolConfiguration = new DLightToolConfiguration(ID, TOOL_NAME);
        dLightToolConfiguration.setLongName(TOOL_NAME_DETAILED);
        dLightToolConfiguration.setIcon("org/netbeans/modules/dlight/memory/resources/memory.png");
        dLightToolConfiguration.setDescription(MemoryToolConfigurationProvider.loc("MemoryTool.Description", new String[0]));
        DataCollectorConfiguration dataCollectorConfiguration = this.initSunStudioDataCollectorConfiguration();
        dLightToolConfiguration.addDataCollectorConfiguration(dataCollectorConfiguration);
        DTDCConfiguration dTDCConfiguration = this.initDtraceDataCollectorConfiguration();
        dLightToolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)dTDCConfiguration);
        dLightToolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)dTDCConfiguration);
        dLightToolConfiguration.addIndicatorDataProviderConfiguration(this.initDtraceIndicatorDataProviderConfiguration());
        dLightToolConfiguration.addIndicatorDataProviderConfiguration(this.initSunStudioIndicatorDataProviderConfiguration());
        LLDataCollectorConfiguration lLDataCollectorConfiguration = this.initLLDataCollectorConfiguration();
        dLightToolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)lLDataCollectorConfiguration);
        dLightToolConfiguration.addIndicatorConfiguration(this.initIndicatorConfiguration());
        return dLightToolConfiguration;
    }

    private DataCollectorConfiguration initSunStudioDataCollectorConfiguration() {
        return new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.MEMORY);
    }

    private DTDCConfiguration initDtraceDataCollectorConfiguration() {
        DTDCConfiguration dTDCConfiguration = new DTDCConfiguration(this.getScriptUrl(), Arrays.asList(rawTableMetadata));
        dTDCConfiguration.setIndicatorFiringFactor(1);
        dTDCConfiguration.setStackSupportEnabled(true);
        dTDCConfiguration.setOutputPrefix("mem:");
        return dTDCConfiguration;
    }

    private IndicatorDataProviderConfiguration initSunStudioIndicatorDataProviderConfiguration() {
        SunStudioDCConfiguration sunStudioDCConfiguration = new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.MEMSUMMARY);
        return sunStudioDCConfiguration;
    }

    private IndicatorDataProviderConfiguration initDtraceIndicatorDataProviderConfiguration() {
        DTDCConfiguration dTDCConfiguration = new DTDCConfiguration(this.getScriptUrl(), Arrays.asList(rawTableMetadata));
        dTDCConfiguration.setIndicatorFiringFactor(1);
        dTDCConfiguration.setScriptArgs(" -DNOSTACK");
        dTDCConfiguration.setStackSupportEnabled(true);
        dTDCConfiguration.setOutputPrefix("mem:");
        return dTDCConfiguration;
    }

    private URL getScriptUrl() {
        return this.getClass().getResource("resources/mem.d");
    }

    private LLDataCollectorConfiguration initLLDataCollectorConfiguration() {
        LLDataCollectorConfiguration lLDataCollectorConfiguration = new LLDataCollectorConfiguration(LLDataCollectorConfiguration.CollectedData.MEM);
        return lLDataCollectorConfiguration;
    }

    private IndicatorConfiguration initIndicatorConfiguration() {
        IndicatorMetadata indicatorMetadata = null;
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>();
        arrayList.add(SunStudioDCConfiguration.c_leakSize);
        arrayList.addAll(LLDataCollectorConfiguration.MEM_TABLE.getColumns());
        arrayList.addAll(Arrays.asList(totalColumn));
        indicatorMetadata = new IndicatorMetadata(arrayList);
        BytesFormatter bytesFormatter = new BytesFormatter();
        TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration = new TimeSeriesIndicatorConfiguration(indicatorMetadata, 200);
        timeSeriesIndicatorConfiguration.setTitle(MemoryToolConfigurationProvider.loc("indicator.title", new String[0]));
        timeSeriesIndicatorConfiguration.setGraphScale(1024);
        timeSeriesIndicatorConfiguration.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{new TimeSeriesDescriptor(new Color(83, 130, 161), MemoryToolConfigurationProvider.loc("graph.description", new String[0]), TimeSeriesDescriptor.Kind.LINE)});
        timeSeriesIndicatorConfiguration.setDataRowHandler((DataRowToTimeSeries)new DataRowToMemory(arrayList, (ValueFormatter)bytesFormatter));
        timeSeriesIndicatorConfiguration.addDetailDescriptors(new DetailDescriptor[]{new DetailDescriptor(MAX_HEAP_DETAIL_ID, MemoryToolConfigurationProvider.loc("MemoryTool.Legend.Max", new String[0]), bytesFormatter.format(0L))});
        timeSeriesIndicatorConfiguration.setActionDisplayName(MemoryToolConfigurationProvider.loc("indicator.action", new String[0]));
        timeSeriesIndicatorConfiguration.setActionTooltip(MemoryToolConfigurationProvider.loc("indicator.action.tooltip", new String[0]));
        timeSeriesIndicatorConfiguration.setLabelFormatter((ValueFormatter)bytesFormatter);
        DataTableMetadata dataTableMetadata = SunStudioDCConfiguration.getMemTableMetadata((DataTableMetadata.Column[])new DataTableMetadata.Column[]{SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_leakSize, SunStudioDCConfiguration.c_leakCount});
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_name.getColumnName(), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.func_name", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.func_name", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_leakSize.getColumnName(), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.leak", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.leak", new String[0]));
        FunctionDatatableDescription functionDatatableDescription = new FunctionDatatableDescription(SunStudioDCConfiguration.c_name.getColumnName(), null, SunStudioDCConfiguration.c_name.getColumnName());
        FunctionsListViewVisualizerConfiguration functionsListViewVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(dataTableMetadata, functionDatatableDescription, Arrays.asList(SunStudioDCConfiguration.c_leakSize, SunStudioDCConfiguration.c_leakCount));
        functionsListViewVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        functionsListViewVisualizerConfiguration.setEmptyAnalyzeMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        functionsListViewVisualizerConfiguration.setEmptyRunningMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        timeSeriesIndicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)functionsListViewVisualizerConfiguration);
        timeSeriesIndicatorConfiguration.addVisualizerConfiguration(this.getDetails(rawTableMetadata));
        return timeSeriesIndicatorConfiguration;
    }

    private VisualizerConfiguration getDetails(DataTableMetadata dataTableMetadata) {
        DataTableMetadata.Column column = new DataTableMetadata.Column("leak", Long.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.leak", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.leak", new String[0]), null);
        List<DataTableMetadata.Column> list = Arrays.asList(new DataTableMetadata.Column("func_name", FunctionName.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.func_name", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.func_name", new String[0]), null), column);
        String string = "SELECT func.func_id AS func_id, func.func_name AS func_name, node.offset AS offset, SUM(leak.size) AS leak FROM (SELECT MAX(timestamp) AS timestamp, address, SUM(kind * size) AS size FROM mem GROUP BY address HAVING SUM(kind * size) > 0) AS leak LEFT JOIN mem ON leak.timestamp = mem.timestamp AND leak.address = mem.address LEFT JOIN node ON mem.stackid = node.node_id LEFT JOIN func ON node.func_id = func.func_id GROUP BY func_id, func_name, offset ORDER BY leak DESC";
        FunctionDatatableDescription functionDatatableDescription = new FunctionDatatableDescription("func_name", "offset", "func_id");
        DataTableMetadata dataTableMetadata2 = new DataTableMetadata("mem", list, string, Arrays.asList(dataTableMetadata));
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setColumnUI("func_name", MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.func_name", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.func_name", new String[0]));
        columnsUIMapping.setColumnUI(column.getColumnName(), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.leak", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.leak", new String[0]));
        FunctionsListViewVisualizerConfiguration functionsListViewVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(dataTableMetadata2, functionDatatableDescription, Arrays.asList(column));
        functionsListViewVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        functionsListViewVisualizerConfiguration.setEmptyAnalyzeMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        functionsListViewVisualizerConfiguration.setEmptyRunningMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        return functionsListViewVisualizerConfiguration;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(MemoryToolConfigurationProvider.class, (String)string, (Object[])stringArray);
    }

    static {
        DataTableMetadata.Column column = new DataTableMetadata.Column("timestamp", Time.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.timestamp", new String[0]), null);
        DataTableMetadata.Column column2 = new DataTableMetadata.Column("kind", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.kind", new String[0]), null);
        DataTableMetadata.Column column3 = new DataTableMetadata.Column("size", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.size", new String[0]), null);
        DataTableMetadata.Column column4 = new DataTableMetadata.Column("address", Long.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.address", new String[0]), null);
        DataTableMetadata.Column column5 = new DataTableMetadata.Column("stackid", Long.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.stackid", new String[0]), null);
        totalColumn = new DataTableMetadata.Column("total", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.total", new String[0]), null);
        List<DataTableMetadata.Column> list = Arrays.asList(column, column2, column3, column4, totalColumn, column5);
        rawTableMetadata = new DataTableMetadata("mem", list, Arrays.asList(column, column4));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DataRowToMemory
    implements DataRowToTimeSeries {
        private final List<DataTableMetadata.Column> columns;
        private final ValueFormatter formatter;
        private int max;

        public DataRowToMemory(List<DataTableMetadata.Column> list, ValueFormatter valueFormatter) {
            this.columns = new ArrayList<DataTableMetadata.Column>(list);
            this.formatter = valueFormatter;
        }

        public float[] getData(DataRow dataRow) {
            float[] fArray = null;
            for (String string : dataRow.getColumnNames()) {
                for (DataTableMetadata.Column column : this.columns) {
                    if (!column.getColumnName().equals(string)) continue;
                    if (fArray == null) {
                        fArray = new float[1];
                    }
                    int n = DataUtil.toInt((Object)dataRow.getData(string));
                    fArray[0] = n;
                    if (this.max >= n) continue;
                    this.max = n;
                }
            }
            return fArray;
        }

        public Map<String, String> getDetails() {
            return Collections.singletonMap(MemoryToolConfigurationProvider.MAX_HEAP_DETAIL_ID, this.formatter.format((long)this.max));
        }
    }
}

