/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.options.NewOptionsIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class OptionsPanel
extends BasicWizardIterator.Panel {
    private final NewOptionsIterator.DataModel data;
    private DocumentListener updateListener;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel lblPrefix;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JComboBox packageName;
    private JLabel packageNameTxt;
    private JLabel projectName;
    private JTextField projectNameValue;
    private JTextField txtPrefix;

    public OptionsPanel(WizardDescriptor wizardDescriptor, NewOptionsIterator.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.initAccessibility();
        if (dataModel.getPackageName() != null) {
            this.packageName.setSelectedItem(dataModel.getPackageName());
        }
        this.putClientProperty("NewFileWizard_Title", OptionsPanel.getMessage("LBL_OptionsWizardTitle"));
    }

    private void addListeners() {
        if (this.updateListener == null) {
            this.updateListener = new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    OptionsPanel.this.updateData();
                }
            };
            this.txtPrefix.getDocument().addDocumentListener(this.updateListener);
            Component component = this.packageName.getEditor().getEditorComponent();
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).getDocument().addDocumentListener(this.updateListener);
            }
        }
    }

    private void removeListeners() {
        if (this.updateListener != null) {
            this.txtPrefix.getDocument().removeDocumentListener(this.updateListener);
            Component component = this.packageName.getEditor().getEditorComponent();
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).getDocument().removeDocumentListener(this.updateListener);
            }
            this.updateListener = null;
        }
    }

    protected void storeToDataModel() {
        this.removeListeners();
        this.updateData();
    }

    protected void readFromDataModel() {
        this.addListeners();
        this.txtPrefix.setText(this.data.getClassNamePrefix());
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
        this.updateData();
    }

    private void updateData() {
        int n = this.data.setPackageAndPrefix(this.packageName.getEditor().getItem().toString(), this.txtPrefix.getText());
        String string = this.data.getMessage(n);
        if (NewOptionsIterator.DataModel.isErrorCode(n)) {
            this.setError(string);
            return;
        }
        if (NewOptionsIterator.DataModel.isWarningCode(n)) {
            this.setWarning(string);
        } else if (NewOptionsIterator.DataModel.isInfoCode(n)) {
            this.setInfo(string, false);
            return;
        }
        this.data.getCreatedModifiedFiles();
        this.createdFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getCreatedPaths()));
        this.modifiedFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getModifiedPaths()));
        String[] stringArray = this.data.getCreatedModifiedFiles().getInvalidPaths();
        if (NewOptionsIterator.DataModel.isErrorCode(n)) {
            this.setError(this.data.getMessage(n));
        } else if (stringArray.length > 0) {
            this.setError(NbBundle.getMessage(OptionsPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)stringArray[0]));
        } else if (NewOptionsIterator.DataModel.isSuccessCode(n)) {
            this.markValid();
        }
    }

    protected String getPanelName() {
        return OptionsPanel.getMessage("LBL_OptionsPanel1_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(OptionsPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(OptionsPanel.class, (String)string);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_OptionsPanel"));
        this.projectNameValue.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL_ProjectName"));
        this.packageName.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL_PackageName"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL_CreatedFilesValue"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL_ModifiedFilesValue"));
        this.txtPrefix.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL__ClassNamePrefix"));
    }

    private void initComponents() {
        this.projectName = new JLabel();
        this.projectNameValue = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.packageName = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.packageNameTxt = new JLabel();
        this.lblPrefix = new JLabel();
        this.txtPrefix = new JTextField();
        this.setLayout(new GridBagLayout());
        this.projectName.setLabelFor(this.projectNameValue);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.projectName, (String)resourceBundle.getString("LBL_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectName.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.projectName.AccessibleContext.accessibleDescription"));
        this.projectNameValue.setEditable(false);
        this.projectNameValue.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.projectNameValue, gridBagConstraints);
        this.projectNameValue.getAccessibleContext().setAccessibleName(OptionsPanel.getMessage("OptionsPanel.projectNameValue.AccessibleContext.accessibleName"));
        this.projectNameValue.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.projectNameValue.AccessibleContext.accessibleDescription"));
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)resourceBundle.getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.createdFiles.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.createdFiles.AccessibleContext.accessibleDescription"));
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)resourceBundle.getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        this.modifiedFiles.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.modifiedFiles.AccessibleContext.accessibleDescription"));
        this.createdFilesValueS.setBorder(null);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        this.createdFilesValue.getAccessibleContext().setAccessibleName(OptionsPanel.getMessage("OptionsPanel.createdFilesValue.AccessibleContext.accessibleName"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.createdFilesValue.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.createdFilesValueS, gridBagConstraints);
        this.createdFilesValueS.getAccessibleContext().setAccessibleName(OptionsPanel.getMessage("OptionsPanel.createdFilesValueS.AccessibleContext.accessibleName"));
        this.createdFilesValueS.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.createdFilesValueS.AccessibleContext.accessibleDescription"));
        this.modifiedFilesValueS.setBorder(null);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        this.modifiedFilesValue.getAccessibleContext().setAccessibleName(OptionsPanel.getMessage("OptionsPanel.modifiedFilesValue.AccessibleContext.accessibleName"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.modifiedFilesValue.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.modifiedFilesValueS, gridBagConstraints);
        this.modifiedFilesValueS.getAccessibleContext().setAccessibleName(OptionsPanel.getMessage("OptionsPanel.modifiedFilesValueS.AccessibleContext.accessibleName"));
        this.modifiedFilesValueS.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.modifiedFilesValueS.AccessibleContext.accessibleDescription"));
        this.packageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.packageName, gridBagConstraints);
        this.packageName.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.packageName.AccessibleContext.accessibleDescription"));
        this.packageNameTxt.setLabelFor(this.packageName);
        Mnemonics.setLocalizedText((JLabel)this.packageNameTxt, (String)NbBundle.getMessage(OptionsPanel.class, (String)"LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.packageNameTxt, gridBagConstraints);
        this.packageNameTxt.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.packageNameTxt.AccessibleContext.accessibleDescription"));
        this.lblPrefix.setLabelFor(this.txtPrefix);
        Mnemonics.setLocalizedText((JLabel)this.lblPrefix, (String)NbBundle.getMessage(OptionsPanel.class, (String)"LBL_Prefix"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 6, 12);
        this.add((Component)this.lblPrefix, gridBagConstraints);
        this.lblPrefix.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.lblPrefix.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add((Component)this.txtPrefix, gridBagConstraints);
        this.txtPrefix.getAccessibleContext().setAccessibleName(OptionsPanel.getMessage("OptionsPanel.txtPrefix.AccessibleContext.accessibleName"));
        this.txtPrefix.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.txtPrefix.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(OptionsPanel.getMessage("OptionsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("OptionsPanel.AccessibleContext.accessibleDescription"));
    }
}

