/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NbModuleProjectGenerator {
    public static final String PLATFORM_PROPERTIES_PATH = "nbproject/platform.properties";
    private static final String loggerName = "org.netbeans.ui.metrics.nbmodule";
    private static final String loggerKey = "USG_PROJECT_CREATE_NBMODULE";

    private NbModuleProjectGenerator() {
    }

    private static void logUsage(String string) {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        logRecord.setParameters(new Object[]{string});
        Logger.getLogger(loggerName).log(logRecord);
    }

    public static void createStandAloneModule(final File file, final String string, final String string2, final String string3, final String string4, final String string5) throws IOException {
        try {
            NbModuleProjectGenerator.logUsage("StandAloneModule");
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject fileObject = FileUtil.createFolder((File)file);
                    if (ProjectManager.getDefault().findProject(fileObject) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject);
                    }
                    NbModuleProjectGenerator.createProjectXML(fileObject, string, NbModuleProvider.STANDALONE);
                    NbModuleProjectGenerator.createPlatformProperties(fileObject, string5);
                    NbModuleProjectGenerator.createManifest(fileObject, string, string3, string4);
                    if (string3 != null) {
                        NbModuleProjectGenerator.createBundle(fileObject, string3, string2);
                    }
                    if (string4 != null) {
                        NbModuleProjectGenerator.createLayerInSrc(fileObject, string4);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(fileObject);
                    NbModuleProjectGenerator.createInitialProperties(fileObject);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void createSuiteComponentModule(final File file, final String string, final String string2, final String string3, final String string4, final File file2) throws IOException {
        try {
            NbModuleProjectGenerator.logUsage("SuiteComponentModule");
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject fileObject = FileUtil.createFolder((File)file);
                    if (ProjectManager.getDefault().findProject(fileObject) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject);
                    }
                    NbModuleProjectGenerator.createProjectXML(fileObject, string, NbModuleProvider.SUITE_COMPONENT);
                    NbModuleProjectGenerator.createSuiteProperties(fileObject, file2);
                    NbModuleProjectGenerator.createManifest(fileObject, string, string3, string4);
                    if (string3 != null) {
                        NbModuleProjectGenerator.createBundle(fileObject, string3, string2);
                    }
                    if (string4 != null) {
                        NbModuleProjectGenerator.createLayerInSrc(fileObject, string4);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(fileObject);
                    NbModuleProjectGenerator.createInitialProperties(fileObject);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    NbModuleProjectGenerator.appendToSuite(string, fileObject, file2);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void createSuiteLibraryModule(final File file, final String string, final String string2, final String string3, final File file2, final File file3, final File[] fileArray) throws IOException {
        try {
            NbModuleProjectGenerator.logUsage("SuiteLibraryModule");
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject fileObject;
                    FileObject fileObject2 = FileUtil.createFolder((File)file);
                    if (ProjectManager.getDefault().findProject(fileObject2) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject2);
                    }
                    EditableProperties editableProperties = new EditableProperties(true);
                    editableProperties.put("is.autoload", "true");
                    TreeSet<String> treeSet = new TreeSet<String>();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (File file4 : fileArray) {
                        try {
                            String[] stringArray = Util.copyClassPathExtensionJar(file, file4);
                            if (stringArray == null) continue;
                            hashMap.put(stringArray[0], stringArray[1]);
                            Util.scanJarForPackageNames(treeSet, file4);
                        }
                        catch (IOException iOException) {
                            Util.err.notify((Throwable)iOException);
                        }
                    }
                    if (file3 != null && file3.exists()) {
                        fileObject = FileUtil.toFileObject((File)file3);
                        try {
                            FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName());
                            editableProperties.put("license.file", "${basedir}/" + fileObject.getNameExt());
                        }
                        catch (IOException iOException) {
                            Util.err.notify((Throwable)iOException);
                        }
                    }
                    ProjectXMLManager.generateLibraryModuleTemplate(NbModuleProjectGenerator.createFileObject(fileObject2, "nbproject/project.xml"), string, NbModuleProvider.SUITE_COMPONENT, treeSet, hashMap);
                    NbModuleProjectGenerator.createSuiteProperties(fileObject2, file2);
                    NbModuleProjectGenerator.createManifest(fileObject2, string, string3, null);
                    NbModuleProjectGenerator.createBundle(fileObject2, string3, string2);
                    fileObject = NbModuleProjectGenerator.createFileObject(fileObject2, "nbproject/project.properties");
                    Util.storeProperties(fileObject, editableProperties);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    NbModuleProjectGenerator.appendToSuite(string, fileObject2, file2);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void createNetBeansOrgModule(final File file, final String string, final String string2, final String string3, final String string4) throws IOException {
        try {
            NbModuleProjectGenerator.logUsage("NetBeansOrgModule");
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    File file2 = ModuleList.findNetBeansOrg(file);
                    if (file2 == null) {
                        throw new IllegalArgumentException(file + " doesn't " + "point to a top-level directory within the netbeans.org main or contrib repositories");
                    }
                    FileObject fileObject = FileUtil.createFolder((File)file);
                    if (ProjectManager.getDefault().findProject(fileObject) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject);
                    }
                    NbModuleProjectGenerator.createNetBeansOrgBuildXML(fileObject, string, file2);
                    NbModuleProjectGenerator.createProjectXML(fileObject, string, NbModuleProvider.NETBEANS_ORG);
                    NbModuleProjectGenerator.createManifest(fileObject, string, string3, string4);
                    NbModuleProjectGenerator.createBundle(fileObject, string3, string2);
                    if (string4 != null) {
                        NbModuleProjectGenerator.createLayerInSrc(fileObject, string4);
                    }
                    NbModuleProjectGenerator.createEmptyTestDir(fileObject);
                    NbModuleProjectGenerator.createInitialProperties(fileObject);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static void createProjectXML(FileObject fileObject, String string, NbModuleProvider.NbModuleType nbModuleType) throws IOException {
        ProjectXMLManager.generateEmptyModuleTemplate(NbModuleProjectGenerator.createFileObject(fileObject, "nbproject/project.xml"), string, nbModuleType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNetBeansOrgBuildXML(FileObject fileObject, String string, File file) throws IOException {
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, "build.xml");
        Document document = XMLUtil.createDocument((String)"project", null, null, null);
        Element element = document.getDocumentElement();
        element.setAttribute("name", PropertyUtils.relativizeFile((File)file, (File)FileUtil.toFile((FileObject)fileObject)));
        element.setAttribute("default", "netbeans");
        element.setAttribute("basedir", ".");
        Element element2 = document.createElement("description");
        element2.appendChild(document.createTextNode("Builds, tests, and runs the project " + string));
        element.appendChild(element2);
        element2 = document.createElement("import");
        element2.setAttribute("file", PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)fileObject), (File)new File(file, "nbbuild/templates/projectized.xml")));
        element.appendChild(element2);
        OutputStream outputStream = fileObject2.getOutputStream();
        try {
            XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
        }
        finally {
            outputStream.close();
        }
    }

    public static void createSuiteProperties(FileObject fileObject, File file) throws IOException {
        String string;
        String string2;
        File file2 = FileUtil.toFile((FileObject)fileObject);
        String string3 = PropertyUtils.relativizeFile((File)file2, (File)file);
        if (string3 != null) {
            string2 = "${basedir}/" + string3;
            string = "nbproject/suite.properties";
        } else {
            string2 = file.getAbsolutePath();
            string = "nbproject/private/suite-private.properties";
        }
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.setProperty("suite.dir", string2);
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, string);
        Util.storeProperties(fileObject2, editableProperties);
    }

    private static void appendToSuite(String string, FileObject fileObject, File file) throws IOException {
        Object object;
        File file2 = FileUtil.toFile((FileObject)fileObject);
        File file3 = new File(file, "nbproject/project.properties");
        FileObject fileObject2 = file3.exists() ? FileUtil.toFileObject((File)file3) : NbModuleProjectGenerator.createFileObject(file3);
        EditableProperties editableProperties = Util.loadProperties(fileObject2);
        String string2 = "project." + string;
        String string3 = PropertyUtils.relativizeFile((File)file, (File)file2);
        if (string3 != null) {
            editableProperties.setProperty(string2, string3);
        } else {
            object = new File(file, "nbproject/private/private.properties");
            FileObject fileObject3 = ((File)object).exists() ? FileUtil.toFileObject((File)object) : NbModuleProjectGenerator.createFileObject((File)object);
            EditableProperties editableProperties2 = Util.loadProperties(fileObject3);
            editableProperties2.setProperty(string2, file2.getAbsolutePath());
            Util.storeProperties(fileObject3, editableProperties2);
        }
        object = editableProperties.getProperty("modules");
        if (object == null) {
            object = "";
        }
        if (((String)object).length() > 0) {
            object = (String)object + ":";
        }
        object = (String)object + "${" + string2 + "}";
        editableProperties.setProperty("modules", ((String)object).split("(?<=:)", -1));
        Util.storeProperties(fileObject2, editableProperties);
    }

    private static void createPlatformProperties(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, PLATFORM_PROPERTIES_PATH);
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.put("nbplatform.active", string);
        NbPlatform nbPlatform = NbPlatform.getPlatformByID(string);
        if (nbPlatform != null && nbPlatform.getHarnessVersion() > 6) {
            File[] fileArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (File file : fileArray = nbPlatform.getDestDir().listFiles()) {
                if (!ClusterUtils.isValidCluster(file)) continue;
                arrayList.add(SuiteProperties.toPlatformClusterEntry(file.getName()));
            }
            editableProperties.setProperty("cluster.path", SuiteUtils.getAntProperty(arrayList));
        }
        Util.storeProperties(fileObject2, editableProperties);
    }

    private static void createManifest(FileObject fileObject, String string, String string2, String string3) throws IOException {
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, "manifest.mf");
        ManifestManager.createManifest(fileObject2, string, "1.0", string2, string3);
    }

    private static void createBundle(FileObject fileObject, String string, String string2) throws IOException {
        String string3 = "src/" + string.replace('\\', '/');
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, string3);
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.put("OpenIDE-Module-Name", string2);
        Util.storeProperties(fileObject2, editableProperties);
    }

    private static void createLayerInSrc(FileObject fileObject, String string) throws IOException {
        NbModuleProjectGenerator.createLayer(fileObject, "src/" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject createLayer(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, string);
        InputStream inputStream = NbModuleProjectGenerator.class.getResourceAsStream("ui/resources/layer_template.xml");
        try {
            OutputStream outputStream = fileObject2.getOutputStream();
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        return fileObject2;
    }

    private static void createEmptyTestDir(FileObject fileObject) throws IOException {
        FileUtil.createFolder((FileObject)fileObject, (String)"test/unit/src");
    }

    private static void createInitialProperties(FileObject fileObject) throws IOException {
        EditableProperties editableProperties = new EditableProperties(false);
        editableProperties.put("javac.source", "1.5");
        editableProperties.put("javac.compilerargs", "-Xlint -Xlint:-serial");
        FileObject fileObject2 = NbModuleProjectGenerator.createFileObject(fileObject, "nbproject/project.properties");
        Util.storeProperties(fileObject2, editableProperties);
    }

    private static FileObject createFileObject(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            throw new IllegalArgumentException("File " + fileObject2 + " already exists.");
        }
        fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        return fileObject2;
    }

    private static FileObject createFileObject(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            throw new IllegalArgumentException("Cannot create: " + file);
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return NbModuleProjectGenerator.createFileObject(FileUtil.toFileObject((File)file2), file.getName());
    }
}

