/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.CodeTemplateCompletionItem;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public final class CodeTemplateCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        return (n & 1) == 0 || CodeTemplateCompletionProvider.isAbbrevDisabled(jTextComponent) ? null : new AsyncCompletionTask((AsyncCompletionQuery)new Query(), jTextComponent);
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return 0;
    }

    private static boolean isAbbrevDisabled(JTextComponent jTextComponent) {
        return Abbrev.isAbbrevDisabled((JTextComponent)jTextComponent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Query
    extends AsyncCompletionQuery
    implements ChangeListener {
        private JTextComponent component;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private List<CodeTemplateCompletionItem> queryResult;
        private String filterPrefix;

        private Query() {
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            int n = jTextComponent.getSelectionStart();
            Document document = jTextComponent.getDocument();
            this.filterPrefix = null;
            if (n >= this.queryCaretOffset && this.queryAnchorOffset < this.queryCaretOffset) {
                try {
                    this.filterPrefix = document.getText(this.queryAnchorOffset, n - this.queryAnchorOffset);
                    if (!this.isJavaIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (this.filterPrefix != null && this.queryResult != null) {
                completionResultSet.addAllItems(this.getFilteredData(this.queryResult, this.filterPrefix));
            }
            completionResultSet.finish();
        }

        private boolean isJavaIdentifierPart(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (Character.isJavaIdentifierPart(charSequence.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection<? extends CompletionItem> getFilteredData(Collection<? extends CompletionItem> collection, String string) {
            ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
            for (CompletionItem completionItem : collection) {
                if (!((Object)completionItem.getInsertPrefix()).toString().startsWith(string)) continue;
                arrayList.add(completionItem);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            List list;
            Object object;
            String string = null;
            String string2 = null;
            if (document instanceof AbstractDocument) {
                object = (AbstractDocument)document;
                ((AbstractDocument)object).readLock();
                try {
                    try {
                        if (object instanceof BaseDocument) {
                            string2 = Utilities.getIdentifierBefore((BaseDocument)((BaseDocument)object), (int)n);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    list = TokenHierarchy.get((Document)document).embeddedTokenSequences(n, true);
                    if (list.size() > 1) {
                        string = ((TokenSequence)list.get(list.size() - 1)).languagePath().mimePath();
                    }
                }
                finally {
                    ((AbstractDocument)object).readUnlock();
                }
            }
            if (string == null) {
                string = NbEditorUtilities.getMimeType((Document)document);
            }
            this.queryCaretOffset = n;
            int n2 = this.queryAnchorOffset = string2 != null ? n - string2.length() : n;
            if (string != null && string2 != null) {
                object = DocumentUtilities.getMimeType((JTextComponent)this.component);
                list = object == null ? MimePath.EMPTY : MimePath.get((String)object);
                Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)list).lookup(Preferences.class);
                boolean bl = preferences.getBoolean("completion-case-sensitive", false);
                CodeTemplateManagerOperation codeTemplateManagerOperation = CodeTemplateManagerOperation.get(MimePath.parse((String)string));
                codeTemplateManagerOperation.waitLoaded();
                Collection<? extends CodeTemplate> collection = codeTemplateManagerOperation.findByParametrizedText(string2, bl);
                Collection<? extends CodeTemplateFilter> collection2 = CodeTemplateManagerOperation.getTemplateFilters(this.component, this.queryAnchorOffset);
                this.queryResult = new ArrayList<CodeTemplateCompletionItem>(collection.size());
                for (CodeTemplate codeTemplate : collection) {
                    if (!Query.accept(codeTemplate, collection2)) continue;
                    this.queryResult.add(new CodeTemplateCompletionItem(codeTemplate));
                }
                completionResultSet.addAllItems(this.queryResult);
            }
            completionResultSet.setAnchorOffset(this.queryAnchorOffset);
            completionResultSet.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Query query = this;
            synchronized (query) {
                this.notify();
            }
        }

        private static boolean accept(CodeTemplate codeTemplate, Collection collection) {
            for (CodeTemplateFilter codeTemplateFilter : collection) {
                if (codeTemplateFilter.accept(codeTemplate)) continue;
                return false;
            }
            return true;
        }
    }
}

