/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.statusbar;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.limewire.core.api.Application;
import org.limewire.i18n.I18nMarker;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.statusbar.Ad;
import org.limewire.ui.swing.statusbar.Banner;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.LanguageUtils;
import org.limewire.ui.swing.util.NativeLaunchUtils;

@Singleton
public class ProStatusPanel
extends HyperlinkButton
implements SettingListener,
ActionListener {
    private final Set<InvisibilityCondition> conditions = new HashSet<InvisibilityCondition>();
    private static final Banner DEFAULT_BANNER = new Banner(I18nMarker.marktr("For Turbo-Charged searches get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&21", "0.111111", I18nMarker.marktr("Want faster downloads?  Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&22", "0.111111", I18nMarker.marktr("Purchase LimeWire PRO to help us make downloads faster."), "http://www.limewire.com/index.jsp/pro&23", "0.111111", I18nMarker.marktr("For Turbo-Charged downloads get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&24", "0.111111", I18nMarker.marktr("For the best BitTorrent downloads, get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&25", "0.111111", I18nMarker.marktr("LimeWire PRO comes with FREE tech support. "), "http://www.limewire.com/index.jsp/pro&26", "0.111111", I18nMarker.marktr("For Turbo-Charged performance get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&27", "0.111111", I18nMarker.marktr("Keep the Internet open. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&28", "0.111111", I18nMarker.marktr("FREE updates and support - LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&29", "0.111111");
    private Banner ads;
    private final Map<Ad, LabelURLPair> labels = Collections.synchronizedMap(new HashMap());
    private LabelURLPair currentLabel;
    private boolean isInitialised = false;
    private final Application application;

    @Inject
    public ProStatusPanel(Application application) {
        this.application = application;
        this.setName("ProStatusPanel");
        if (application.isProVersion()) {
            this.addCondition(InvisibilityCondition.IS_PRO);
        }
    }

    public void addCondition(InvisibilityCondition condition) {
        this.conditions.add(condition);
        this.updateVisibility();
    }

    public void removeCondition(InvisibilityCondition condition) {
        this.conditions.remove((Object)condition);
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (!this.isVisible() && !this.isInitialised && this.conditions.isEmpty()) {
            this.init();
            this.isInitialised = true;
        }
        this.setVisible(this.conditions.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (LanguageUtils.isEnglishLocale(LanguageUtils.getCurrentLocale())) {
            this.loadLabels();
            SwingUiSettings.PRO_ADS.addSettingListener(this);
        }
        Map<Ad, LabelURLPair> map = this.labels;
        synchronized (map) {
            if (this.labels.isEmpty()) {
                this.updateLabels(DEFAULT_BANNER);
            }
            assert (!this.labels.isEmpty()) : "couldn't load any pro banner!";
        }
        this.addActionListener(this);
        if (this.labels.size() > 1) {
            new Timer(30000, new LabelTimerListener()).start();
            this.handleLinkChange();
        }
    }

    @Override
    public void settingChanged(SettingEvent evt) {
        if (evt.getEventType() != SettingEvent.EventType.VALUE_CHANGED) {
            return;
        }
        this.loadLabels();
    }

    private void loadLabels() {
        try {
            Banner b = new Banner(SwingUiSettings.PRO_ADS.get());
            this.updateLabels(b);
        }
        catch (IllegalArgumentException bad) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabels(Banner b) {
        Map<Ad, LabelURLPair> map = this.labels;
        synchronized (map) {
            this.ads = b;
            this.labels.clear();
            for (Ad ad : this.ads.getAllAds()) {
                String text = ad.getText();
                text = I18n.tr(text);
                this.labels.put(ad, new LabelURLPair(text, ad.getURI()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LabelURLPair getNextLabelURLPair() {
        Map<Ad, LabelURLPair> map = this.labels;
        synchronized (map) {
            this.currentLabel = this.labels.get(this.ads.getAd());
        }
        return this.currentLabel;
    }

    private void handleLinkChange() {
        String label = this.getNextLabelURLPair().getLabel();
        this.setText(label);
    }

    private void handleLinkClick() {
        NativeLaunchUtils.openURL(this.application.addClientInfoToUrl(this.currentLabel.getURL()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.handleLinkClick();
    }

    private static final class LabelURLPair {
        private final String LABEL_STRING;
        private final String URL;

        private LabelURLPair(String label, String url) {
            this.LABEL_STRING = label;
            this.URL = url;
        }

        private String getLabel() {
            return this.LABEL_STRING;
        }

        private String getURL() {
            return this.URL;
        }
    }

    private class LabelTimerListener
    implements ActionListener {
        private LabelTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProStatusPanel.this.handleLinkChange();
        }
    }

    public static enum InvisibilityCondition {
        NOT_FULLY_CONNECTED,
        PRO_ADD_SHOWN,
        IS_PRO;

    }
}

